Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "       ",
 StyleBox["xConf",
  FontSize->36],
 StyleBox["    ",
  FontSize->24],
 " "
}], "Title",
 InitializationCell->True,
 FontSize->48,ExpressionUUID->"f99dad05-75f3-4b56-86be-f8a57408dfa6"],

Cell[CellGroupData[{

Cell["\<\
Authors
\
\>", "Subsection",
 InitializationCell->True,
 FontSize->18,ExpressionUUID->"885e8cc1-1e76-4a55-b1fb-4e2e21f66119"],

Cell["\<\
This package is designed for handling formally conformal transformation
        
Version 0.0.1   (04/04/2025)\
\>", "Text",
 InitializationCell->True,
 FontSize->14,ExpressionUUID->"1be3aed0-586e-4a04-bdb6-ef56fd11cc66"],

Cell[TextData[{
 " It is developed by Cyril ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["Pitrou", "1"], TraditionalForm]],ExpressionUUID->
  "52d94b2c-1a28-4e58-916f-dc736e1b4f18"],
 ", Guillaume Faye",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["", "2"], TraditionalForm]],ExpressionUUID->
  "db0d821b-cda2-407e-b179-b85c24a26ef9"],
 "\n \t\n ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["", "1"], TraditionalForm]],ExpressionUUID->
  "19ea2235-580b-4053-88e5-7127fe05f56f"],
 StyleBox["Institute of Astrophysics of Paris (IAP), France",
  FontSize->13],
 "\n",
 StyleBox["Email: pitrou@iap.fr",
  FontSize->13],
 "\n\n",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["", "2"], TraditionalForm]],ExpressionUUID->
  "7fe54190-ef2e-4933-be7f-8f30b4cb73a2"],
 StyleBox[" Institute of Astrophysics of Paris (IAP), France\nEmail: \
faye@iap.fr",
  FontSize->13],
 "\n \t\n \t\nDetails of the general algorithm and methods for perturbations \
about any space-time background can be found on a publication soon to come."
}], "Text",
 InitializationCell->True,
 FontSize->14,ExpressionUUID->"2c40a56e-a120-4f73-98dc-047c26a43f60"],

Cell[TextData[{
 "This algorithm is based runs on top of the xAct/xTensor package developed \
by Jos\[EAcute] M. Mart\[IAcute]n-Garc\[IAcute]a.",
 StyleBox["\n ",
  FontSize->13],
 StyleBox[ButtonBox["http://www.xact.es",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://metric.iem.csic.es/Martin-Garcia/"], None}],
  FontSize->13],
 "\n\t\nIt is tested for xAct_1.1.3 under Mathematica 14.0."
}], "Text",
 InitializationCell->True,
 FontSize->14,ExpressionUUID->"93d3d8b1-260d-4f5f-b6c6-89dd9daf1c39"],

Cell[CellGroupData[{

Cell["Dates and versions", \
"Subsubsection",ExpressionUUID->"c6622465-02d2-407f-920e-9a27634248cb"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Date", "[", "]"}]], "Input",
 CellLabel->"In[1]:=",ExpressionUUID->"861bfeef-ab0c-4674-9fab-2c2f141e6bf8"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "2025", ",", "4", ",", "21", ",", "22", ",", "6", ",", 
   "39.191391`8.345765656466208"}], "}"}]], "Output",
 CellLabel->"Out[1]=",ExpressionUUID->"68fbbf19-5254-4389-ba08-22a3602fbff6"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"xAct`xConf`$Version", "=", 
   RowBox[{"{", 
    RowBox[{"\"\<0.0.1\>\"", ",", 
     RowBox[{"{", 
      RowBox[{"2025", ",", "04", ",", "04"}], "}"}]}], "}"}]}], 
  ";"}]], "Input",
 InitializationCell->True,
 CellLabel->"In[2]:=",ExpressionUUID->"21e32b71-301d-4111-ad5c-76108ff548fa"],

Cell[BoxData[
 RowBox[{
  RowBox[{"xAct`xConf`$xTensorVersionExpected", "=", 
   RowBox[{"{", 
    RowBox[{"\"\<1.2.0\>\"", ",", 
     RowBox[{"{", 
      RowBox[{"2021", ",", "10", ",", "17"}], "}"}]}], "}"}]}], 
  ";"}]], "Input",
 InitializationCell->True,
 CellLabel->"In[3]:=",ExpressionUUID->"4306eea9-2d82-45fd-9036-066941c5b44f"]
}, Open  ]],

Cell[CellGroupData[{

Cell["History", \
"Subsubsection",ExpressionUUID->"aa8f580b-ec4c-4248-8826-c71e75935290"],

Cell["\<\
Future modifications :
-disformal transformations\
\>", "Text",ExpressionUUID->"1c33094c-bb7e-48c9-af10-22fe8e86f5f0"],

Cell["", "Text",ExpressionUUID->"64d1fe2a-23a3-41cd-9480-dd682f4a283d"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["1. Initialization", "Subsection",
 InitializationCell->True,
 FontColor->RGBColor[
  0.20389105058365758`, 0.38530556191348136`, 
   0.9685969329365988],ExpressionUUID->"4da7a881-ffe7-41a4-92fb-61a35a2396e7"],

Cell[CellGroupData[{

Cell["1.1. GPL", \
"Subsubsection",ExpressionUUID->"1bb82931-1361-4231-aaa1-8ea1e0592545"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"xConf", ":", " ", 
    RowBox[{
     RowBox[{
     "Cosmological", " ", "perturbations", " ", "about", " ", "homogeneous", 
      " ", "space"}], "-", "times"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"Copyright", " ", 
      RowBox[{"(", "C", ")"}], " ", "2025"}], "-", 
     RowBox[{"2026", " ", "Cyril", " ", "Pitrou"}]}], ",", " ", 
    RowBox[{"Guillaume", " ", "Faye"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
     "This", " ", "program", " ", "is", " ", "free", " ", "software"}], ";", 
     " ", 
     RowBox[{"you", " ", "can", " ", "redistribute", " ", "it", " ", 
      RowBox[{"and", "/", "or"}], "\[IndentingNewLine]", " ", "modify", " ", 
      "it", " ", "under", " ", "the", " ", "terms", " ", "of", " ", "the", 
      " ", "GNU", " ", "General", " ", "Public", " ", "License", " ", "as", 
      "\[IndentingNewLine]", " ", "published", " ", "by", " ", "the", " ", 
      "Free", " ", "Software", " ", "Foundation"}], ";", " ", 
     RowBox[{
     "either", " ", "version", " ", "2", " ", "of", "\[IndentingNewLine]", 
      " ", "the", " ", "License"}]}], ",", 
    RowBox[{"or", " ", 
     RowBox[{"(", 
      RowBox[{"at", " ", "your", " ", "option"}], ")"}], " ", "any", " ", 
     "later", " ", 
     RowBox[{
     "version", ".", "\[IndentingNewLine]", "\[IndentingNewLine]", "This"}], 
     " ", "program", " ", "is", " ", "distributed", " ", "in", " ", "the", 
     " ", "hope", " ", "that", " ", "it", " ", "will", " ", "be", " ", 
     "useful"}], ",", "\[IndentingNewLine]", "  ", 
    RowBox[{
     RowBox[{"but", " ", "WITHOUT", " ", "ANY", " ", "WARRANTY"}], ";", " ", 
     RowBox[{
     "without", " ", "even", " ", "the", " ", "implied", " ", "warranty", " ",
       "of", "\[IndentingNewLine]", " ", "MERCHANTABILITY", " ", "or", " ", 
      "FITNESS", " ", "FOR", " ", "A", " ", "PARTICULAR", " ", 
      RowBox[{"PURPOSE", ".", " ", "See"}], " ", "the", " ", "GNU", 
      "\[IndentingNewLine]", " ", "General", " ", "Public", " ", "License", 
      " ", "for", " ", "more", " ", 
      RowBox[{
      "details", ".", "\[IndentingNewLine]", "\[IndentingNewLine]", "You"}], 
      " ", "should", " ", "have", " ", "received", " ", "a", " ", "copy", " ",
       "of", " ", "the", " ", "GNU", " ", "General", " ", "Public", " ", 
      "License", "\[IndentingNewLine]", " ", "along", " ", "with", " ", 
      "this", " ", "program"}], ";", " ", 
     RowBox[{"if", " ", "not"}]}], ",", " ", 
    RowBox[{
    "write", " ", "to", " ", "the", " ", "Free", " ", "Software", 
     "\[IndentingNewLine]", " ", "Foundation"}], ",", " ", 
    RowBox[{"Inc", "."}], ",", " ", 
    RowBox[{
     RowBox[{"59", " ", "Temple", " ", "Place"}], "-", 
     RowBox[{"Suite", " ", "330"}]}], ",", " ", "Boston", ",", " ", 
    RowBox[{
     RowBox[{"MA", " ", "02111"}], "-", "1307"}], ",", "\[IndentingNewLine]", 
    "  ", 
    RowBox[{"USA", "."}]}], " ", "\[IndentingNewLine]", "*)"}]}]], "Input",
 InitializationCell->True,
 CellLabel->"In[4]:=",ExpressionUUID->"54e43a27-293d-4e1d-9006-de61d37595bc"],

Cell["", "Text",ExpressionUUID->"732dae2e-5c6c-452b-a956-9fa1d9585755"]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.2. Info package", \
"Subsubsection",ExpressionUUID->"149dd31c-dd6f-4930-bc54-a9067d4d9bd1"],

Cell["\<\
(* :Title: xConf *)

(* :Author: Cyril Pitrou, Guillaume Faye *)

(* :Summary: Computer algebra for conformal transformations *)
 
(* :Context: xAct`xConf` *)

(* :Package Version: 0.0.1 *)

(* :Copyright: Cyril Pitrou, Guillaume Faye (2025-2026) *)

(* :Source: xConf.nb *)

(* :Mathematica Version: 14.0 and later *)

(* :Limitations: *)\
\>", "Input",
 PageWidth->PaperWidth,
 CellMargins->{{60, -272}, {Inherited, Inherited}},
 InitializationCell->True,
 CellLabel->"In[5]:=",ExpressionUUID->"f296bbce-9b83-404c-b253-44efb30ed1c1"],

Cell["", "Text",ExpressionUUID->"101adff0-4664-427d-81e2-b8512e7b9456"]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.3. Begin package", \
"Subsubsection",ExpressionUUID->"f7336276-8334-4924-8f5d-bbe1e572da5f"],

Cell["\<\

Decide what is the last package being read:\
\>", "Text",ExpressionUUID->"861691f8-c3de-4a4d-999d-d4bc7f068474"],

Cell[BoxData[
 RowBox[{
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Unevaluated", "[", "xAct`xCore`Private`$LastPackage", "]"}], "===",
      "xAct`xCore`Private`$LastPackage"}], ",", 
    RowBox[{"xAct`xCore`Private`$LastPackage", "=", "\"\<xAct`xConf`\>\""}]}],
    "]"}], ";"}]], "Input",
 InitializationCell->True,
 CellLabel->"In[4]:=",ExpressionUUID->"f3ff6f56-e684-4050-bdff-c7390e0dbf07"],

Cell[CellGroupData[{

Cell[BoxData["xAct`xCore`Private`$LastPackage"], "Input",
 CellLabel->"In[5]:=",ExpressionUUID->"cfd61365-dfaa-499c-a280-2931b5d5ef4e"],

Cell[BoxData["\<\"xAct`xConf`\"\>"], "Output",
 CellLabel->"Out[5]=",ExpressionUUID->"6ab235c8-8896-429b-85d2-dc32eef67cf4"]
}, Open  ]],

Cell["\<\

Explicit (not hidden) import of other packages:\
\>", "Text",ExpressionUUID->"97017f56-9566-4d83-bab2-1b93b48824c8"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Off", "[", 
  StyleBox[
   RowBox[{"General", "::", "nostdvar"}], "MessageName"], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Off", "[", 
  StyleBox[
   RowBox[{"General", "::", "nostdopt"}], "MessageName"], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"BeginPackage", "[", 
  RowBox[{"\"\<xAct`xConf`\>\"", ",", 
   RowBox[{"{", 
    RowBox[{
    "\"\<xAct`xTensor`\>\"", ",", "\"\<xAct`xPerm`\>\"", ",", 
     "\"\<xAct`xCore`\>\"", ",", "\"\<xAct`ExpressionManipulation`\>\""}], 
    "}"}]}], "]"}]}], "Input",
 InitializationCell->True,
 CellLabel->"In[6]:=",ExpressionUUID->"5203ccfa-df42-4bb6-9101-cbe5326092f2"],

Cell[CellGroupData[{

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[6]:=",ExpressionUUID->"4295d3b6-bbab-4045-b9a2-a5ab75c1e35d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`xPerm`  version \"\>", 
   "\[InvisibleSpace]", "\<\"1.2.3\"\>", "\[InvisibleSpace]", "\<\", \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2015", ",", "8", ",", "23"}], "}"}]}],
  SequenceForm["Package xAct`xPerm`  version ", "1.2.3", ", ", {2015, 8, 23}],
  
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[6]:=",ExpressionUUID->"abacc553-128d-4b52-866f-c97ea80f5727"],

Cell[BoxData["\<\"CopyRight (C) 2003-2020, Jose M. Martin-Garcia, under the \
General Public License.\"\>"], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[6]:=",ExpressionUUID->"21611c78-afff-4460-88b7-8824fa433018"],

Cell[BoxData["\<\"Connecting to external linux executable...\"\>"], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[6]:=",ExpressionUUID->"9b0405e6-7043-4326-ac18-0d25a5bed08e"],

Cell[BoxData["\<\"Connection established.\"\>"], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[6]:=",ExpressionUUID->"37876c0e-d23d-413b-936c-7ac5d65c4d7e"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[6]:=",ExpressionUUID->"49620ed4-55dd-40a2-b93a-1d3b0c75b54c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`xTensor`  version \"\>", 
   "\[InvisibleSpace]", "\<\"1.2.0\"\>", "\[InvisibleSpace]", "\<\", \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2021", ",", "10", ",", "17"}], "}"}]}],
  SequenceForm[
  "Package xAct`xTensor`  version ", "1.2.0", ", ", {2021, 10, 17}],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[6]:=",ExpressionUUID->"41ab50de-3823-45b0-9b6a-3b2a9046d8df"],

Cell[BoxData["\<\"CopyRight (C) 2002-2021, Jose M. Martin-Garcia, under the \
General Public License.\"\>"], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[6]:=",ExpressionUUID->"490360e2-e2e9-4f30-979c-24c34b1106fb"]
}, Open  ]],

Cell[BoxData["\<\"xAct`xConf`\"\>"], "Output",
 CellLabel->"Out[8]=",ExpressionUUID->"a4be0a63-61e5-49a0-927e-9c9ec3c26689"]
}, Open  ]],

Cell[TextData[{
 "\nCheck version of ",
 StyleBox["xTensor",
  FontSlant->"Italic"],
 ". We simply compare dates:"
}], "Text",ExpressionUUID->"500ca1b5-50fa-4aa4-8061-0414417a6eb0"],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{
   RowBox[{"Not", "@", 
    RowBox[{"OrderedQ", "@", 
     RowBox[{"Map", "[", 
      RowBox[{"Last", ",", 
       RowBox[{"{", 
        RowBox[{"$xTensorVersionExpected", ",", "xAct`xTensor`$Version"}], 
        "}"}]}], "]"}]}]}], ",", 
   RowBox[{"Throw", "@", 
    RowBox[{"Message", "[", 
     RowBox[{
      RowBox[{"General", "::", "versions"}], ",", "\"\<xTensor\>\"", ",", 
      "xAct`xTensor`$Version", ",", "$xTensorVersionExpected"}], "]"}]}]}], 
  "]"}]], "Input",
 InitializationCell->True,
 CellLabel->"In[12]:=",ExpressionUUID->"013522d0-bdac-4b89-a9be-b2e645a205d0"],

Cell["\<\

Welcome message:\
\>", "Text",ExpressionUUID->"6752c1a8-46d5-453f-aadb-4454a03de4cc"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Print", "[", "xAct`xCore`Private`bars", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<Package xAct`xConf`  version \>\"", ",", 
    RowBox[{"$Version", "[", 
     RowBox[{"[", "1", "]"}], "]"}], ",", "\"\<, \>\"", ",", 
    RowBox[{"$Version", "[", 
     RowBox[{"[", "2", "]"}], "]"}]}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
  "Print", "[", 
   "\"\<CopyRight (C) 2025-2026, Cyril Pitrou, Guillaume under the General \
Public License.\>\"", "]"}], ";"}]}], "Input",
 InitializationCell->True,
 CellLabel->"In[14]:=",ExpressionUUID->"1e309292-a005-4811-861a-48f429c2168c"],

Cell[CellGroupData[{

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[14]:=",ExpressionUUID->"083a9562-272e-4dc7-b2a5-e5ed3e82a90d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`xConf`  version \"\>", 
   "\[InvisibleSpace]", "\<\"0.0.1\"\>", "\[InvisibleSpace]", "\<\", \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2025", ",", "4", ",", "4"}], "}"}]}],
  SequenceForm["Package xAct`xConf`  version ", "0.0.1", ", ", {2025, 4, 4}],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[14]:=",ExpressionUUID->"72ba5d98-572d-4f80-9d1b-116e7d26e284"],

Cell[BoxData["\<\"CopyRight (C) 2025-2026, Cyril Pitrou, Guillaume under the \
General Public License.\"\>"], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[14]:=",ExpressionUUID->"bb9c90fb-d127-4cc3-9ab4-246aa33178a7"]
}, Open  ]]
}, Open  ]],

Cell["\<\

We specify the context xAct`xConf` to avoid overriding the Disclaimer of the \
other packages. However, we need to turn off the message General:shdw \
temporarily:\
\>", "Text",ExpressionUUID->"53658b89-7537-464b-bc72-9c7eb2e67ebf"],

Cell[BoxData[{
 RowBox[{"Off", "[", 
  RowBox[{"General", "::", "shdw"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"xAct`xConf`Disclaimer", "[", "]"}], ":=", 
  RowBox[{
  "Print", "[", 
   "\"\<These are points 11 and 12 of the General Public \
License:\\n\\nBECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO \
WARRANTY FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW. EXCEPT \
WHEN OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES \
PROVIDE THE PROGRAM `AS IS\.b4 WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED \
OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF \
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE ENTIRE RISK AS TO \
THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU. SHOULD THE PROGRAM \
PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR OR \
CORRECTION.\\n\\nIN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO \
IN WRITING WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY \
AND/OR REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR \
DAMAGES, INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES \
ARISING OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT \
LIMITED TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED \
BY YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER \
PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE \
POSSIBILITY OF SUCH DAMAGES.\>\"", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"On", "[", 
  RowBox[{"General", "::", "shdw"}], "]"}]}], "Input",
 InitializationCell->True,
 CellLabel->"In[17]:=",ExpressionUUID->"cb9a1383-3c82-42cf-bf0c-101cb94a8c0f"],

Cell[TextData[{
 "\nIf this is the last package show the GPL short disclaimer: ",
 StyleBox["Why do we want to do that?",
  FontColor->RGBColor[1, 0, 0]]
}], "Text",ExpressionUUID->"3f64679b-b9b9-4569-84e2-00b155b15b17"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"xAct`xCore`Private`$LastPackage", "===", "\"\<xAct`xConf`\>\""}],
     ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Unset", "[", "xAct`xCore`Private`$LastPackage", "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Print", "[", "xAct`xCore`Private`bars", "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
     "Print", "[", 
      "\"\<These packages come with ABSOLUTELY NO WARRANTY; for details type \
Disclaimer[]. This is free software, and you are welcome to redistribute it \
under certain conditions. See the General Public License for details.\>\"", 
      "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Print", "[", "xAct`xCore`Private`bars", "]"}]}]}], "]"}], 
  ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"aca621f6-6641-4a38-b2af-5a246e0a1800"],

Cell[CellGroupData[{

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[34]:=",ExpressionUUID->"96ddfcf8-30f9-45ff-bc7f-efd5b79d02d4"],

Cell[BoxData["\<\"These packages come with ABSOLUTELY NO WARRANTY; for \
details type Disclaimer[]. This is free software, and you are welcome to \
redistribute it under certain conditions. See the General Public License for \
details.\"\>"], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[34]:=",ExpressionUUID->"62c1df6b-2f26-443a-99b0-6189bb4122a5"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[34]:=",ExpressionUUID->"1cfc1252-b8de-41ea-9ab9-c03ab8450c88"]
}, Open  ]]
}, Open  ]],

Cell["\<\

Note that symbols in the Global` context cannot be accessed while building \
the package:\
\>", "Text",ExpressionUUID->"607981be-0123-4421-96bf-7853b47cbafa"],

Cell[CellGroupData[{

Cell[BoxData["$ContextPath"], "Input",
 CellLabel->"In[22]:=",ExpressionUUID->"3f045a49-5987-4dce-90d7-99293c87a722"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"xAct`xConf`\"\>", ",", "\<\"xAct`xTensor`\"\>", 
   ",", "\<\"xAct`xPerm`\"\>", ",", "\<\"xAct`xCore`\"\>", 
   ",", "\<\"xAct`ExpressionManipulation`\"\>", ",", "\<\"System`\"\>"}], 
  "}"}]], "Output",
 CellLabel->
  "Out[22]=",ExpressionUUID->"e654d751-b094-4a11-969b-a75f4f7a9e06"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["$Context"], "Input",
 CellLabel->"In[23]:=",ExpressionUUID->"73abc100-1448-41a4-95c6-077f65ebeac8"],

Cell[BoxData["\<\"xAct`xConf`\"\>"], "Output",
 CellLabel->
  "Out[23]=",ExpressionUUID->"da042855-7558-4e40-8fec-5dc5189f5a52"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.4. Options", \
"Subsubsection",ExpressionUUID->"283e04ad-23ed-4f86-bcbe-b6989142635c"],

Cell["\<\

Prefix format for derivatives:\
\>", "Text",ExpressionUUID->"c49114ee-5ab2-41f4-b7e9-3fdcfc57e7e7"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"$CovDFormat", "=", "\"\<Prefix\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Message", "[", 
   RowBox[{
    RowBox[{"General", "::", "nostdvar"}], ",", "\"\<$CovDFormat\>\"", ",", 
    "\"\<Prefix\>\""}], "]"}], ";"}]}], "Input",
 InitializationCell->True,
 CellLabel->"In[24]:=",ExpressionUUID->"b1c0ffa2-9198-40b0-b27b-9b3d0d99a561"],

Cell[TextData[{
 "\n",
 StyleBox["I would not set $PrePrint as done below",
  FontColor->RGBColor[1, 0, 0]]
}], "Text",ExpressionUUID->"9db3836d-00b4-4b5a-9268-9501126e2767"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
   RowBox[{"$PrePrint", "=", "ScreenDollarIndices"}], ";"}], " ", 
  "*)"}]], "Input",ExpressionUUID->"f3f5418e-4ac5-4f22-b822-3af85c3d2bd2"],

Cell["\<\

We do not modify the option MathLink of CanonicalPerm:\
\>", "Text",ExpressionUUID->"c1664985-3df9-47ea-bb71-bfe3635e2e95"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Options", "[", "CanonicalPerm", "]"}]], "Input",
 CellLabel->"In[29]:=",ExpressionUUID->"22ce10e9-240b-45ae-86ab-d559897c0cf2"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"MathLink", "\[RuleDelayed]", "$xpermQ"}], ",", 
   RowBox[{"TimeVerbose", "\[Rule]", "False"}], ",", 
   RowBox[{"xPermVerbose", "\[Rule]", "False"}], ",", 
   RowBox[{"OrderedBase", "\[Rule]", "True"}]}], "}"}]], "Output",
 CellLabel->
  "Out[29]=",ExpressionUUID->"68ce4d31-041e-4e3f-a251-fdad52f7a8f3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["$xpermQ"], "Input",
 CellLabel->"In[30]:=",ExpressionUUID->"e9790a3c-bb96-4be8-bbb0-14103eab9fc1"],

Cell[BoxData["True"], "Output",
 CellLabel->
  "Out[30]=",ExpressionUUID->"96d584bb-0250-445d-9e73-2cc5c6f810fb"]
}, Open  ]],

Cell["", "Text",ExpressionUUID->"9371cc0c-a640-4eb3-9ada-3d6fabbf565d"]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.5. Usage and error messages", \
"Subsubsection",ExpressionUUID->"dd26d229-8744-4363-b23f-1a1cbd3e321e"],

Cell["\<\

Versions:\
\>", "Text",ExpressionUUID->"d91c2eee-d6d6-4408-aaf8-6298fb22741d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"**", " ", "VERSIONS"}], " ", "***)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"$Version", "::", "usage"}], "=", 
     "\"\<$Version is a global variable giving the version of the package \
xConf in use.\>\""}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"$xTensorVersionExpected", "::", "usage"}], "=", 
     "\"\<$xTensorVersionExpected is a global variable giving the oldest \
possible version of the package xTensor which is required by the version of \
the package xConf in use.\>\""}], ";"}], "\[IndentingNewLine]"}]}]], "Input",
 InitializationCell->True,
 CellLabel->"In[31]:=",ExpressionUUID->"6de16e3d-93b6-4124-ad52-a84603c9e0c3"],

Cell["\<\

Booleans:\
\>", "Text",ExpressionUUID->"db6d3a1f-dc01-4b7c-9e44-1391e98bb0e7"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{"**", " ", "BOOLEANS"}], " ", "***)"}]], "Input",
 InitializationCell->True,
 CellLabel->"In[43]:=",ExpressionUUID->"64489a51-dcc8-4f3f-ac61-2744066c1702"],

Cell["\<\

Error messages:\
\>", "Text",ExpressionUUID->"7876ae62-81df-4c9c-a1e2-3a3a800165ee"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"**", " ", "ERROR"}], " ", "MESSAGES"}], " ", "***)"}], 
  "\[IndentingNewLine]"}]], "Input",
 InitializationCell->True,
 CellLabel->"In[44]:=",ExpressionUUID->"108fa4a4-2173-4313-b7b2-6657814df237"],

Cell["\<\

Functions:\
\>", "Text",ExpressionUUID->"4a72d40c-58ff-447d-abca-b2d5600d852f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"**", " ", "FUNCTIONS"}], " ", "***)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"AbstractConformal", "::", "usage"}], " ", "=", " ", 
     "\"\<\>\""}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Conformal", "::", "usage"}], " ", "=", " ", 
     "\"\<Conformal[metricfinal][metric1,metric2][expr] performs a conformal \
transformation of 'expr' from 'metric1' to 'metric2' and expresses the result \
in terms of 'metricfinal' (along with its associated covariant derivative and \
curvature tensors). If needed, the function first reformulates 'expr' in \
terms of 'metric1'. The two metrics 'metric1' and 'metric2' have to be \
conformally related by DefConformalMetric. \n\n\
Conformal[metric1,metric2][expr] provides the final result with respect to \
the ambient metric, which is the first metric defined on the manifold.\>\""}],
     ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ConformalWeight", "::", "usage"}], " ", "=", " ", 
     "\"\<ConformalWeight[tensor[inds]] specifies the power of the conformal \
factor applied in the conformal transformation of the tensor 'tensor'. It \
corresponds to the number of down indices, minus the number of up indices, \
plus the quantity ConformalWeight[tensor] (without the indices). The latter \
is set by default to zero. \n\nFor instance, in the setting \
ConformalWeight[tensor] = 0, we have: \
ConformalWeight[tensor[\[Alpha],\[Beta]]] = -2, and ConformalWeight[tensor[-\
\[Alpha],-\[Beta]]] = 2.\>\""}], ";"}], " ", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Is", " ", "it", " ", "the", " ", "most", " ", "natural", " ", "thing", 
     " ", "to", " ", 
     RowBox[{"do", "?"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"DefConformalMetric", "::", "usage"}], " ", "=", " ", 
     "\"\<DefConformalMetric[g,S] defines a metric conformally related to \
'g', with the conformal factor 'S'. The new metric is named 'gS2', and its \
inverse is given by 'Inv[gS2]'. If other metrics are conformally related to \
'g', then 'gS2' is related to them by transitivity of the conformal \
transformation. \>\""}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
      RowBox[{"**", "**", "**", "**"}], "*", " ", "The", " ", "following", 
      " ", "command"}], ",", " ", "ToMetric", ",", " ", 
     RowBox[{
      RowBox[{"will", " ", "have", " ", "to", " ", "be", " ", "re"}], "-", 
      RowBox[{"edited", " ", "after", " ", "its", " ", 
       RowBox[{"modification", ".", " ", 
        RowBox[{"**", "**", "**", "**"}]}], "*"}]}]}], "*)"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ToMetric", "::", "usage"}], " ", "=", " ", 
     "\"\<ToMetric[expr,metric] formulates 'expr' in terms of 'metric', and \
its associated covariant derivative and curvature tensors.\>\""}], ";"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 InitializationCell->True,
 CellLabel->"In[40]:=",ExpressionUUID->"294e3c71-6f75-4027-a2bb-f9906792bb37"],

Cell["\<\

Reserved words and protected names:\
\>", "Text",ExpressionUUID->"f5168c18-b666-467d-9666-6e2fdb1df8d4"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"**", " ", "RESERVED"}], " ", "WORDS", " ", "AND", " ", 
    "PROTECTED", " ", "NAMES"}], " ", "***)"}], 
  "\[IndentingNewLine]"}]], "Input",
 InitializationCell->True,
 CellLabel->
  "In[49]:=",ExpressionUUID->"857a1c6f-72c4-409a-9f05-08bbc4b23946"]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.6. Begin private", \
"Subsubsection",ExpressionUUID->"7cfd2eb0-8b4d-4878-9fab-305d1848987b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Begin", "[", "\"\<xAct`xConf`Private`\>\"", "]"}]], "Input",
 InitializationCell->True,
 CellLabel->"In[45]:=",ExpressionUUID->"234e0925-65da-4301-a72d-3cd4faae3693"],

Cell[BoxData["\<\"xAct`xConf`Private`\"\>"], "Output",
 CellLabel->
  "Out[45]=",ExpressionUUID->"fa4338d0-cfbd-4c87-8c91-4946ebd8354a"]
}, Open  ]],

Cell["", "Text",ExpressionUUID->"0baef6d9-e83f-4c17-8b5a-d4ad5ec68798"]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.7. Extensions of xTensor", \
"Subsubsection",ExpressionUUID->"1010504e-8b96-46f0-a772-99eca7f88426"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "*", " ", "Why", " ", "a", " ", "scalar", " ", "head", " ", "inside", " ", 
    "a", " ", "scalar", " ", 
    RowBox[{"function", "?"}]}], " ", "**)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "*", " ", "We", " ", "choose", " ", "that", " ", "the", " ", "Scalar", " ",
     "head", " ", "should", " ", "be", " ", "removed"}], "**)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Unprotect", "[", "xAct`xTensor`NoScalar", "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"xAct`xTensor`NoScalar", "[", 
     RowBox[{
      RowBox[{"f_", "?", "ScalarFunctionQ"}], "[", "expr_", "]"}], "]"}], ":=", 
    RowBox[{"f", "[", 
     RowBox[{"NoScalar", "@", "expr"}], "]"}]}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Protect", "[", "xAct`xTensor`NoScalar", "]"}], ";"}], " ", 
   RowBox[{"(*", " ", 
    RowBox[{"why", " ", "this", " ", 
     RowBox[{"choice", "?"}]}], " ", "*)"}]}]}]], "Input",
 InitializationCell->True,
 CellLabel->"In[49]:=",ExpressionUUID->"ad087076-fe81-46ba-8b20-953259dac810"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Names", "[", "\"\<xAct`xConf`*\>\"", "]"}]], "Input",
 CellLabel->"In[52]:=",ExpressionUUID->"121cab83-32fd-475e-8b36-57c3484b41fc"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"AbstractConformal\"\>", ",", "\<\"Conformal\"\>", 
   ",", "\<\"ConformalWeight\"\>", ",", "\<\"DefConformalMetric\"\>", 
   ",", "\<\"Disclaimer\"\>", ",", "\<\"ToMetric\"\>", 
   ",", "\<\"$Version\"\>", ",", "\<\"$xTensorVersionExpected\"\>"}], 
  "}"}]], "Output",
 CellLabel->
  "Out[52]=",ExpressionUUID->"3469e8fb-16f8-4ee0-98ce-ddc3897a95bc"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["$ContextPath"], "Input",
 CellLabel->"In[53]:=",ExpressionUUID->"d6eaad6f-3ba3-4c86-adba-81980bbac76e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"xAct`xConf`\"\>", ",", "\<\"xAct`xTensor`\"\>", 
   ",", "\<\"xAct`xPerm`\"\>", ",", "\<\"xAct`xCore`\"\>", 
   ",", "\<\"xAct`ExpressionManipulation`\"\>", ",", "\<\"System`\"\>"}], 
  "}"}]], "Output",
 CellLabel->
  "Out[53]=",ExpressionUUID->"1bebc90a-bbc8-47f3-b1cd-e04701130ac8"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["$Context"], "Input",
 CellLabel->"In[54]:=",ExpressionUUID->"5f4faa86-c51d-404f-b2bc-fe70f87dcc52"],

Cell[BoxData["\<\"xAct`xConf`Private`\"\>"], "Output",
 CellLabel->
  "Out[54]=",ExpressionUUID->"fae28987-f669-4888-8f85-41a704a6358e"]
}, Open  ]],

Cell["", "Text",ExpressionUUID->"42e29b91-1dcf-47e4-bc29-a4efff8290f6"]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.8. Default options and protected names", \
"Subsubsection",ExpressionUUID->"bcbed995-3771-4197-9aab-355068684bbe"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"**", " ", "DEFAULT"}], " ", "OPTIONS", " ", "AND", " ", 
    "PROTECTED", " ", "NAMES"}], " ", "***)"}], 
  "\[IndentingNewLine]"}]], "Input",
 InitializationCell->True,
 CellLabel->
  "In[57]:=",ExpressionUUID->"583892a6-192b-4272-b2c3-f4c9faef2f25"]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.9 Handling expressions:", \
"Subsubsection",ExpressionUUID->"275bfd1c-6932-48e6-9eb5-e7bc392beea2"],

Cell[TextData[{
 "\nInertHead used to replace the scalars. This is to avoid the application \
of the Leibniz rule inside the Scalar Head. ",
 StyleBox["Not used!",
  FontColor->RGBColor[1, 0, 0]]
}], "Text",ExpressionUUID->"5980da9a-92aa-4f25-b9b1-c09986e7a2ac"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Block", "[", 
    RowBox[{
     RowBox[{"{", "Print", "}"}], ",", 
     RowBox[{"DefInertHead", "[", 
      RowBox[{"ProtectMyScalar", ",", 
       RowBox[{"LinearQ", "\[Rule]", "True"}]}], "]"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"FixProtectScalar", ":=", 
  RowBox[{
   RowBox[{"ProtectMyScalar", "[", "expr_", "]"}], "\[RuleDelayed]", 
   RowBox[{"ProtectMyScalar", "[", 
    RowBox[{"xAct`xTensor`Private`MathInputExpand", "[", "expr", "]"}], 
    "]"}]}]}]}], "Input",
 InitializationCell->True,
 CellLabel->"In[59]:=",ExpressionUUID->"5971a214-70be-46bb-86a4-cedef709c419"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"**", " ", "HANDLING"}], " ", "EXPRESSIONS"}], " ", "***)"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"collect", "[", "expr_", "]"}], ":=", 
    RowBox[{"Collect", "[", 
     RowBox[{"expr", ",", "$PerturbationParameter", ",", "Identity"}], 
     "]"}]}], " ", 
   RowBox[{"(*", " ", 
    RowBox[{"Identity", " ", "is", " ", "useless"}], " ", "*)"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"*", " ", "fix", " ", "by", " ", "Jolyon", " ", 
     RowBox[{"Bloomfield", ".", " ", "No"}], " ", "Idea", " ", "if", " ", 
     "this", " ", "works", " ", "or", " ", 
     RowBox[{"not", ".", " ", "This"}], " ", "should", " ", "correct", " ", 
     "the", " ", "bug", " ", "found", " ", "by", " ", "Adam", " ", "Solomon", 
     " ", "in", " ", "August", " ", "2014"}], " ", "**)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"fixScalar", ":=", 
    RowBox[{
     RowBox[{"Scalar", "[", "expr_", "]"}], "\[RuleDelayed]", 
     RowBox[{"Scalar", "[", 
      RowBox[{"xAct`xTensor`Private`MathInputExpand", "[", "expr", "]"}], 
      "]"}]}]}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"org", "[", "expr_", "]"}], ":=", 
    RowBox[{"Collect", "[", 
     RowBox[{
      RowBox[{"ContractMetric", "[", "expr", "]"}], ",", 
      "$PerturbationParameter", ",", 
      RowBox[{
       RowBox[{"ToCanonical", "[", 
        RowBox[{"#", "/.", "fixScalar"}], "]"}], "&"}]}], "]"}]}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Old", " ", "org", " ", "before", " ", "the", " ", "fix"}], 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"org", "[", "expr_", "]"}], ":=", 
     RowBox[{"Collect", "[", 
      RowBox[{
       RowBox[{"ContractMetric", "[", "expr", "]"}], ",", 
       "$PerturbationParameter", ",", 
       RowBox[{
        RowBox[{"ToCanonical", "[", 
         RowBox[{"#", "/.", "fixScalar"}], "]"}], "&"}]}], "]"}]}], "*)"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"TCnoCM", "[", "expr_", "]"}], ":=", 
    RowBox[{"ToCanonical", "[", 
     RowBox[{"expr", ",", 
      RowBox[{"UseMetricOnVBundle", "\[Rule]", "None"}]}], 
     "]"}]}]}]}]], "Input",
 InitializationCell->True,
 CellLabel->"In[65]:=",ExpressionUUID->"fb9f077e-4fec-43a9-b94f-d520bf3bdaea"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"*", " ", "Miscellaneous"}], " ", "**)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"$DefInfoQ", "=", "True"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"If", " ", "set", " ", 
      RowBox[{"to", " ", "'"}], 
      RowBox[{"False", "'"}]}], ",", " ", 
     RowBox[{
     "the", " ", "information", " ", "messages", " ", "are", " ", "not", " ", 
      
      RowBox[{"printed", "."}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"DefTensorQ", "[", "symb_", "]"}], ":=", 
    RowBox[{
     RowBox[{"Cases", "[", 
      RowBox[{"$Tensors", ",", "symb"}], "]"}], "===", 
     RowBox[{"{", "symb", "}"}]}]}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"If", " ", "'"}], 
      RowBox[{"symb", "'"}], " ", "has", " ", "been", " ", "defined", " ", 
      "as", " ", "a", " ", "tensor"}], ",", " ", 
     RowBox[{
      RowBox[{"then", " ", 
       RowBox[{"DefTensorQ", "[", "symb", "]"}], " ", 
       RowBox[{"returns", " ", "'"}], 
       RowBox[{"True", "'"}]}], ";", " ", 
      RowBox[{"otherwise", " ", "it", " ", 
       RowBox[{"returns", " ", "'"}], 
       RowBox[{
        RowBox[{"False", "'"}], "."}]}]}]}], " ", "*)"}], " ", 
   RowBox[{"(*", " ", 
    RowBox[{"Why", " ", "not", " ", "using", " ", 
     RowBox[{"xTensorQ", "?"}]}], " ", "*)"}]}]}]], "Input",
 InitializationCell->True,
 CellLabel->"In[69]:=",ExpressionUUID->"f6e725ba-b645-4d98-8cb0-54a864d82462"],

Cell["", "Text",ExpressionUUID->"c6b435e7-576e-4b17-be22-a81d67c83d14"]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.0 Main functions", \
"Subsubsection",ExpressionUUID->"0d081397-e8a1-4466-96a2-f0a70082060e"],

Cell["Function to explicitely separate the metric", \
"Text",ExpressionUUID->"8cccf8c8-4daa-44cb-9b97-c86a69b46cf2"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"IndicesDown", "[", "expr_", "]"}], ":=", " ", 
  RowBox[{"Fold", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"SeparateMetric", "[", 
       RowBox[{"First", "@", "$Metrics"}], "]"}], "[", 
      RowBox[{"#1", ",", "#2"}], "]"}], "&"}], ",", "expr", ",", 
    RowBox[{"Select", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"IndicesOf", "[", "Up", "]"}], "[", "expr", "]"}], ",", 
      RowBox[{
       RowBox[{"Not", "@", 
        RowBox[{"LIndexQ", "[", "#", "]"}]}], "&"}]}], "]"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"IndicesUp", "[", "expr_", "]"}], ":=", " ", 
   RowBox[{"Fold", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"SeparateMetric", "[", 
        RowBox[{"First", "@", "$Metrics"}], "]"}], "[", 
       RowBox[{"#1", ",", "#2"}], "]"}], "&"}], ",", "expr", ",", 
     RowBox[{"Select", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"IndicesOf", "[", "Down", "]"}], "[", "expr", "]"}], ",", 
       RowBox[{
        RowBox[{"Not", "@", 
         RowBox[{"LIndexQ", "[", "#", "]"}]}], "&"}]}], "]"}]}], "]"}]}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"IndicesDown", "[", "0", "]"}], ":=", "0"}], " ", ";"}], 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"This", " ", "is", " ", "to", " ", "avoid", " ", "bugs"}], 
    "..."}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"IndicesUp", "[", "0", "]"}], ":=", "0"}], " ", ";"}]}], "Input",
 InitializationCell->True,
 CellLabel->"In[73]:=",ExpressionUUID->"2cd64115-094d-40f7-bd3d-abfc0d098119"],

Cell["Function to build the name of the conformally related metric", \
"Text",ExpressionUUID->"4e56ac23-89b4-49d8-b51b-4f0e01c96b98"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"ConformalMetricName", "[", 
    RowBox[{
     RowBox[{"g_", "?", "MetricQ"}], ",", "1"}], "]"}], ":=", "g"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"ConformalMetricName", "[", 
     RowBox[{
      RowBox[{"g_", "?", "MetricQ"}], ",", "conffactor_"}], "]"}], ":=", 
    RowBox[{"SymbolJoin", "[", 
     RowBox[{"g", ",", "conffactor", ",", "2"}], "]"}]}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{"conffactor", " ", "must", " ", "be", " ", "a", " ", "head"}], " ",
    "*)"}]}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"2cbce4e2-e138-4f89-a27c-d1c650fba01b"],

Cell[TextData[{
 "Defnition of conformally related metric . \nIt extends DefMetric of xTensor \
in which a conformal relation is already defined with \
\[OpenCurlyDoubleQuote]ConformalTo -> \[OpenCurlyDoubleQuote] option. ",
 StyleBox["Test on conffactor added",
  FontColor->RGBColor[1, 0, 0]]
}], "Text",ExpressionUUID->"98dd3b21-39d1-44d4-ac6f-039ad8c4392b"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"DefConformalMetric", "[", 
    RowBox[{
     RowBox[{"g_", "?", "MetricQ"}], ",", "conffactor_Symbol"}], "]"}], ":=", 
   
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"n", ",", "q"}], "}"}], ",", 
     RowBox[{"Catch", "@", 
      RowBox[{"With", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"M", "=", 
           RowBox[{"ManifoldOfCovD", "@", 
            RowBox[{"CovDOfMetric", "@", "g"}]}]}], ",", 
          RowBox[{"CD", "=", 
           RowBox[{"CovDOfMetric", "@", "g"}]}]}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"With", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"i1", "=", 
             RowBox[{"DummyIn", "[", 
              RowBox[{"Tangent", "[", "M", "]"}], "]"}]}], ",", 
            RowBox[{"i2", "=", 
             RowBox[{"DummyIn", "[", 
              RowBox[{"Tangent", "[", "M", "]"}], "]"}]}], ",", 
            RowBox[{"sy1", "=", 
             RowBox[{
              RowBox[{"SymbolOfCovD", "[", "CD", "]"}], "[", 
              RowBox[{"[", "1", "]"}], "]"}]}], ",", 
            RowBox[{"sy2", "=", 
             RowBox[{
              RowBox[{"SymbolOfCovD", "[", "CD", "]"}], "[", 
              RowBox[{"[", "2", "]"}], "]"}]}], ",", 
            RowBox[{"metlist", "=", 
             RowBox[{"Select", "[", 
              RowBox[{"$Metrics", ",", 
               RowBox[{
                RowBox[{
                 RowBox[{"InducedFrom", "[", "#", "]"}], "===", "Null"}], 
                "&"}]}], "]"}]}]}], "}"}], ",", "\[IndentingNewLine]", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"Not", "@", 
              RowBox[{"DefTensorQ", "[", "conffactor", "]"}]}], ",", 
             RowBox[{"DefTensor", "[", 
              RowBox[{
               RowBox[{"conffactor", "[", "]"}], ",", 
               RowBox[{"{", "M", "}"}], ",", 
               RowBox[{"PrintAs", "->", 
                RowBox[{"ToString", "[", "conffactor", "]"}]}]}], "]"}]}], 
            "]"}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
           "\[IndentingNewLine]", 
           RowBox[{"Off", "[", 
            StyleBox[
             RowBox[{"DefMetric", "::", "old"}], "MessageName"], "]"}], ";", 
           RowBox[{"(*", " ", 
            RowBox[{"Annoying", " ", "message", " ", "turned", " ", "off"}], 
            "*)"}], "\[IndentingNewLine]", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"Not", "[", 
              RowBox[{"DefTensorQ", "[", 
               RowBox[{"ConformalMetricName", "[", 
                RowBox[{"g", ",", "conffactor"}], "]"}], "]"}], "]"}], ",", 
             "\[IndentingNewLine]", "\[IndentingNewLine]", 
             "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"DefMetric", "[", 
               RowBox[{
                RowBox[{"-", "1"}], ",", 
                RowBox[{
                 RowBox[{"ConformalMetricName", "[", 
                  RowBox[{"g", ",", "conffactor"}], "]"}], "[", 
                 RowBox[{
                  RowBox[{"-", "i1"}], ",", 
                  RowBox[{"-", "i2"}]}], "]"}], ",", 
                RowBox[{"SymbolJoin", "[", 
                 RowBox[{"CD", ",", "conffactor", ",", "2"}], "]"}], ",", 
                RowBox[{"{", 
                 RowBox[{"\"\<:\>\"", ",", 
                  RowBox[{"StringJoin", "[", 
                   RowBox[{"sy2", ",", 
                    RowBox[{"ToString", "[", "conffactor", "]"}], ",", 
                    "\"\<2\>\""}], "]"}]}], "}"}], ",", 
                RowBox[{"PrintAs", "\[Rule]", 
                 RowBox[{"StringJoin", "[", 
                  RowBox[{"\"\<[\>\"", ",", 
                   RowBox[{"PrintAs", "[", "g", "]"}], ",", 
                   RowBox[{"\"\<\\!\\(\>\"", "<>", 
                    RowBox[{"PrintAs", "[", "conffactor", "]"}], "<>", 
                    "\"\<\\^2\\)\>\""}], ",", "\"\<]\>\""}], 
                  RowBox[{"(*", 
                   RowBox[{
                    RowBox[{"ToString", "[", "conffactor", "]"}], ",", 
                    RowBox[{"ToString", "[", "2", "]"}]}], "*)"}], "]"}]}], 
                ",", 
                RowBox[{"ConformalTo", "\[Rule]", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"g", "[", 
                    RowBox[{
                    RowBox[{"-", "i1"}], ",", 
                    RowBox[{"-", "i2"}]}], "]"}], ",", 
                   RowBox[{
                    RowBox[{"conffactor", "[", "]"}], "^", "2"}]}], "}"}]}]}],
                "]"}], ";"}]}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
            "]"}], ";", " ", 
           RowBox[{"(*", " ", 
            RowBox[{
            "the", " ", "sign", " ", "of", " ", "the", " ", "determinant", 
             " ", "must", " ", "be", " ", "the", " ", "same", " ", "as", " ", 
             "the", " ", "original", " ", "metric"}], " ", "*)"}], 
           "\[IndentingNewLine]", 
           RowBox[{"(*", " ", 
            RowBox[{
            "Can", " ", "the", " ", "postfix", " ", "symbol", " ", "be", " ", 
             "made", " ", "of", " ", "more", " ", "than", " ", "one", " ", 
             RowBox[{"characters", "?"}]}], " ", "*)"}], 
           "\[IndentingNewLine]", 
           RowBox[{"On", "[", 
            StyleBox[
             RowBox[{"DefMetric", "::", "old"}], "MessageName"], "]"}], ";", 
           "\[IndentingNewLine]", "\[IndentingNewLine]", 
           RowBox[{"Off", "[", 
            StyleBox[
             RowBox[{"ConformalRules", "::", "unknown"}], "MessageName"], 
            "]"}], ";", "\[IndentingNewLine]", 
           RowBox[{"(*", " ", 
            RowBox[{
            "We", " ", "use", " ", "the", " ", "error", " ", "sent", " ", 
             "by", " ", "ConformalRules", " ", "to", " ", "check", " ", 
             "whether", " ", "or", " ", "not", " ", "the", " ", "metric", " ",
              "in", " ", "the", " ", "list", " ", "metlist", " ", "is", " ", 
             "conformally", " ", "related", " ", "to", " ", "the", " ", 
             "metric", " ", 
             RowBox[{"g", ".", "\[IndentingNewLine]", "If"}], " ", "it", " ", 
             "is", " ", "the", " ", "case", " ", "we", " ", "enforce", " ", 
             "transitivity", " ", "of", " ", "the", " ", "conformal", " ", 
             RowBox[{"relations", "."}]}], "*)"}], "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"Catch", "@", 
                 RowBox[{"ConformalRules", "[", 
                  RowBox[{"g", ",", "#"}], "]"}]}], "=!=", "Null"}], ",", 
               "\[IndentingNewLine]", 
               RowBox[{"SetConformalTo", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"SymbolJoin", "[", 
                   RowBox[{"g", ",", "conffactor", ",", "2"}], "]"}], "[", 
                  RowBox[{
                   RowBox[{"-", "i1"}], ",", 
                   RowBox[{"-", "i2"}]}], "]"}], ",", " ", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"#", "[", 
                    RowBox[{
                    RowBox[{"-", "i1"}], ",", " ", 
                    RowBox[{"-", "i2"}]}], "]"}], ",", 
                   RowBox[{
                    RowBox[{"ConformalFactor", "[", 
                    RowBox[{"g", ",", "#"}], "]"}], "*", " ", 
                    RowBox[{
                    RowBox[{"conffactor", "[", "]"}], "^", "2"}]}]}], "}"}]}],
                 "]"}]}], "]"}], "&"}], "/@", "metlist"}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"On", "[", 
            StyleBox[
             RowBox[{"ConformalRules", "::", "unknown"}], "MessageName"], 
            "]"}], ";"}]}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
         "]"}]}], "\[IndentingNewLine]", "]"}]}]}], "\[IndentingNewLine]", 
    "]"}]}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"SetNumberOfArguments", "[", 
  RowBox[{"DefConformalMetric", ",", "2"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "DefConformalMetric", "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"8910001e-170e-488d-989f-a52384fb5b39"],

Cell["\<\
A formal head to denote the conformal transformation of an expression (active \
transformation of an expression)\
\>", "Text",ExpressionUUID->"803087db-871d-4e59-a385-9ae494771770"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"ConfHead", "[", 
     RowBox[{"_", ",", "_"}], "]"}], "[", 
    RowBox[{"delta", "[", 
     RowBox[{"\[Mu]_", ",", "\[Nu]_"}], "]"}], "]"}], ":=", 
   RowBox[{"delta", "[", 
    RowBox[{"\[Mu]", ",", "\[Nu]"}], "]"}]}], 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "Because", " ", "I", " ", "know", " ", "that", " ", "when", " ", "there", 
     " ", "is", " ", "delta", " ", "function", " ", "in", " ", "an", " ", 
     "expression"}], ",", " ", 
    RowBox[{
     RowBox[{
      RowBox[{
      "it", " ", "is", " ", "always", " ", "with", " ", "one", " ", "index", 
       " ", "up", " ", "and", " ", "one", " ", "down"}], "..."}], "so", " ", 
     "this", " ", "should", " ", "be", " ", 
     RowBox[{"fine", "."}]}]}], "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"ConfHead", "[", 
     RowBox[{
      RowBox[{"metric1_", "?", "MetricQ"}], ",", 
      RowBox[{"metric2_", "?", "MetricQ"}]}], "]"}], "[", 
    RowBox[{
     RowBox[{"ConfHead", "[", 
      RowBox[{
       RowBox[{"metric2_", "?", "MetricQ"}], ",", 
       RowBox[{"metric1_", "?", "MetricQ"}]}], "]"}], "[", "expr_", "]"}], 
    "]"}], ":=", "expr"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{"Not", " ", "necessary"}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ConfHead", "[", 
    RowBox[{
     RowBox[{"metric1_", "?", "MetricQ"}], ",", 
     RowBox[{"metric1_", "?", "MetricQ"}]}], "]"}], "[", "expr_", "]"}], ":=",
   "expr"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"ConfHead", "[", 
     RowBox[{
      RowBox[{"metric2_", "?", "MetricQ"}], ",", 
      RowBox[{"metric3_", "?", "MetricQ"}]}], "]"}], "[", 
    RowBox[{
     RowBox[{"ConfHead", "[", 
      RowBox[{
       RowBox[{"metric1_", "?", "MetricQ"}], ",", 
       RowBox[{"metric2_", "?", "MetricQ"}]}], "]"}], "[", "expr_", "]"}], 
    "]"}], ":=", 
   RowBox[{
    RowBox[{"ConfHead", "[", 
     RowBox[{"metric1", ",", "metric3"}], "]"}], "[", "expr", "]"}]}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "Thanks", " ", "to", " ", "Jolyon", " ", "Bloomfield", " ", "and", " ", 
     "Leo", " ", "Stein"}], ",", " ", 
    RowBox[{
    "the", " ", "definition", " ", "below", " ", "should", " ", "be", " ", 
     "much", " ", "more", " ", 
     RowBox[{"general", "."}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "The", " ", "main", " ", "reason", " ", "is", " ", "that", " ", "the", " ",
     "delta", " ", "tensor", " ", "is", " ", "greedy", " ", "and", " ", 
    "wants", " ", "to", " ", "contract", " ", "through", " ", "expressions", 
    " ", "like", "\n", 
    RowBox[{
     RowBox[{
      RowBox[{"ConfHead", "[", "...", "]"}], "[", 
      RowBox[{"f", "[", 
       RowBox[{"Scalar", "[", 
        RowBox[{"phi", "[", "]"}], "]"}], "]"}], "]"}], "."}]}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ConfHead", "/:", 
   RowBox[{"IsIndexOf", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"ConfHead", "[", 
       RowBox[{"_", ",", "_"}], "]"}], "[", "_", "]"}], ",", "_", ",", 
     "delta"}], "]"}], ":=", "False"}], ";"}]}], "Input",
 InitializationCell->True,
 CellLabel->"In[73]:=",ExpressionUUID->"3961574a-3223-4a77-b012-8add7fdbe5d3"],

Cell["\<\
Each tensor has a conformal weight . This is based on a default weight, and \
then modified by the number of indices up and down. TODO more details.\
\>", "Text",ExpressionUUID->"df016fb5-c28c-4dea-afad-0598be01f2f3"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"$BoolBasicConformalWeight", "=", "True"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"WeightOfIndicesList", "[", "indices_List", "]"}], ":=", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"aindex", "=", 
       RowBox[{"Select", "[", 
        RowBox[{"indices", ",", 
         RowBox[{
          RowBox[{"Not", "[", 
           RowBox[{"LIndexQ", "[", "#", "]"}], "]"}], "&"}]}], "]"}]}], "}"}],
      ",", 
     RowBox[{
      RowBox[{"Length", "@", 
       RowBox[{"Select", "[", 
        RowBox[{"aindex", ",", "DownIndexQ"}], "]"}]}], "-", 
      RowBox[{"Length", "@", 
       RowBox[{"Select", "[", 
        RowBox[{"aindex", ",", "UpIndexQ"}], "]"}]}]}]}], "]"}]}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"Conformal", " ", "weight", " ", "of", " ", "a", " ", "tensor"}], 
   " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ConformalWeight", "[", 
    RowBox[{"tens_", "?", "xTensorQ"}], "]"}], ":=", "0"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ConformalWeight", "[", 
    RowBox[{
     RowBox[{"tens_", "?", "xTensorQ"}], "[", "indices___", "]"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"ConformalWeight", "[", "tens", "]"}], "+", 
    RowBox[{"WeightOfIndicesList", "[", 
     RowBox[{"{", "indices", "}"}], "]"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ConformalWeight", "[", 
    RowBox[{"f_", "?", "ScalarFunctionQ"}], "]"}], ":=", "0"}], 
  ";"}]}], "Input",
 InitializationCell->True,
 CellLabel->"In[78]:=",ExpressionUUID->"fe5b646a-e3f0-467b-9d93-3d8a34f6c2e2"],

Cell["\<\
Relation between Christoffels of conformally related metric is already built \
by xTensor when defining the conformally related metric.\[LineSeparator]We \
build on it.\
\>", "Text",ExpressionUUID->"1a24de34-b39d-48b8-88bf-ed41a179c333"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"MyChangeChristoffel", "[", 
    RowBox[{"expr_", ",", "cd_", ",", "cd_"}], "]"}], ":=", "expr"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MyChangeChristoffel", "[", 
    RowBox[{"expr_", ",", "cd2list_List", ",", "cd1_"}], "]"}], ":=", 
   RowBox[{"Fold", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"MyChangeChristoffel", "[", 
       RowBox[{"#1", ",", "#2", ",", "cd1"}], "]"}], "&"}], ",", "expr", ",", 
     "cd2list"}], "]"}]}], "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"MyChangeChristoffel", "[", 
   RowBox[{"expr_", ",", "cd2_", ",", "cd1_"}], "]"}], ":=", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"vb", "=", 
      RowBox[{"Tangent", "[", 
       RowBox[{"ManifoldOfCovD", "[", "cd1", "]"}], "]"}]}], "}"}], ",", 
    RowBox[{"With", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"chr1", "=", 
         RowBox[{"Head", "[", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"Christoffel", "[", "cd1", "]"}], ")"}], "[", 
           RowBox[{
            RowBox[{"DummyIn", "[", "vb", "]"}], ",", 
            RowBox[{"-", 
             RowBox[{"DummyIn", "[", "vb", "]"}]}], ",", 
            RowBox[{"-", 
             RowBox[{"DummyIn", "[", "vb", "]"}]}]}], "]"}], "]"}]}], ",", 
        RowBox[{"chr2", "=", 
         RowBox[{"Head", "[", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"Christoffel", "[", "cd2", "]"}], ")"}], "[", 
           RowBox[{
            RowBox[{"DummyIn", "[", "vb", "]"}], ",", 
            RowBox[{"-", 
             RowBox[{"DummyIn", "[", "vb", "]"}]}], ",", 
            RowBox[{"-", 
             RowBox[{"DummyIn", "[", "vb", "]"}]}]}], "]"}], "]"}]}], ",", 
        RowBox[{"chr21", "=", 
         RowBox[{"Head", "[", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"Christoffel", "@@", 
             RowBox[{"Sort", "[", 
              RowBox[{"{", 
               RowBox[{"cd2", ",", "cd1"}], "}"}], "]"}]}], ")"}], "[", 
           RowBox[{
            RowBox[{"DummyIn", "[", "vb", "]"}], ",", 
            RowBox[{"-", 
             RowBox[{"DummyIn", "[", "vb", "]"}]}], ",", 
            RowBox[{"-", 
             RowBox[{"DummyIn", "[", "vb", "]"}]}]}], "]"}], "]"}]}], ",", 
        RowBox[{"sign", "=", 
         RowBox[{"Order", "[", 
          RowBox[{"cd2", ",", "cd1"}], "]"}]}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"expr", "/.", 
       RowBox[{
        RowBox[{"chr2", "[", 
         RowBox[{"i1_", ",", "i2_", ",", "i3_"}], "]"}], "\[RuleDelayed]", 
        RowBox[{
         RowBox[{"chr1", "[", 
          RowBox[{"i1", ",", "i2", ",", "i3"}], "]"}], "+", 
         RowBox[{"sign", "*", 
          RowBox[{"chr21", "[", 
           RowBox[{"i1", ",", "i2", ",", "i3"}], "]"}]}]}]}]}]}], 
     "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", "]"}]}]}], "Input",
 InitializationCell->True,
 CellLabel->"In[83]:=",ExpressionUUID->"d742a4a9-8131-47e0-bfed-2ca3d7e2f547"],

Cell["\<\
Rules of conformal transformations:
-metrics
-tensors
-covariant derivatives
-curvature
-scalar functions
-...\
\>", "Text",ExpressionUUID->"b9121361-1de5-4c81-b809-ea85e78ee5b7"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"ExistInertHead", "[", "head_", "]"}], ":=", 
   RowBox[{
    RowBox[{"Length", "@", 
     RowBox[{"Cases", "[", 
      RowBox[{"$InertHeads", ",", "head"}], "]"}]}], ">", "0"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"RulesConf", "[", 
   RowBox[{
    RowBox[{"metric1_", "?", "MetricQ"}], ",", 
    RowBox[{"metric2_", "?", "MetricQ"}]}], "]"}], ":=", 
  RowBox[{"(", "\[IndentingNewLine]", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "cd1", ",", "cd2", ",", "confa2", ",", "confa", ",", "M", ",", "res", 
       ",", "inds"}], "}"}], ",", 
     RowBox[{
      RowBox[{"cd1", "=", 
       RowBox[{"CovDOfMetric", "[", "metric1", "]"}]}], ";", 
      RowBox[{"cd2", "=", 
       RowBox[{"CovDOfMetric", "[", "metric2", "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"confa2", "=", 
       RowBox[{"ConformalFactor", "[", 
        RowBox[{"metric2", ",", "metric1"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"confa", "=", 
       RowBox[{
        RowBox[{"Sqrt", "[", 
         RowBox[{"ConformalFactor", "[", 
          RowBox[{"metric2", ",", "metric1"}], "]"}], "]"}], "/.", 
        RowBox[{
         RowBox[{"Sqrt", "[", 
          RowBox[{"x_", "^", 
           RowBox[{"n_", "?", "EvenQ"}]}], "]"}], ":>", 
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"n", "/", "2"}], ")"}]}]}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{
       "In", " ", "principle", " ", "this", " ", "should", " ", "give", " ", 
        "a", " ", "or", " ", 
        RowBox[{"1", "/", "a"}], " ", "depending", " ", "if", " ", "we", " ", 
        "go", " ", "from", " ", "metric1", " ", "to", " ", "metric2", " ", 
        "or", " ", "metric2", " ", "to", " ", "metric1"}], "*)"}], 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"M", "=", 
       RowBox[{"ManifoldOfCovD", "[", "cd1", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"inds", "=", 
       RowBox[{"DummyIn", "/@", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"Tangent", "[", "M", "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"Range", "[", "4", "]"}], "}"}]}], "]"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"With", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"i1", "=", 
           RowBox[{"inds", "[", 
            RowBox[{"[", "1", "]"}], "]"}]}], ",", 
          RowBox[{"i2", "=", 
           RowBox[{"inds", "[", 
            RowBox[{"[", "2", "]"}], "]"}]}], ",", 
          RowBox[{"i3", "=", 
           RowBox[{"inds", "[", 
            RowBox[{"[", "3", "]"}], "]"}]}], ",", 
          RowBox[{"i4", "=", 
           RowBox[{"inds", "[", 
            RowBox[{"[", "4", "]"}], "]"}]}]}], "}"}], ",", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{
         "Once", " ", "confheads", " ", "are", " ", "put", " ", "on", " ", 
          "expression", " ", 
          RowBox[{"(", 
           RowBox[{
           "as", " ", "a", " ", "result", " ", "of", " ", "a", " ", "formal", 
            " ", "conformal", " ", "transformation"}], ")"}], " ", "then", 
          " ", "we", " ", "remove", " ", "them", " ", "by", " ", "expressing",
           " ", "what", " ", "they", " ", "mean", " ", "in", " ", "function", 
          " ", "of", " ", "the", " ", "original", " ", "tensors", " ", "and", 
          " ", "the", " ", "scale", " ", "factor"}], " ", "*)"}], 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"res", "=", "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"RuleDelayed", "@@", 
             RowBox[{"Hold", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"ConfHead", "[", 
                 RowBox[{"metric1", ",", "metric2"}], "]"}], "[", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"Riemann", "@", "cd1"}], ")"}], "[", 
                 RowBox[{"i1_", ",", "i2_", ",", "i3_", ",", "i4_"}], "]"}], 
                "]"}], ",", 
               RowBox[{
                RowBox[{"confa", "^", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"WeightOfIndicesList", "[", 
                    RowBox[{"{", 
                    RowBox[{"i1", ",", "i2", ",", "i3", ",", "i4"}], "}"}], 
                    "]"}], "-", "2"}], ")"}]}], 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"Riemann", "@", "cd2"}], ")"}], "[", 
                 RowBox[{"i1", ",", "i2", ",", "i3", ",", "i4"}], "]"}]}]}], 
              "]"}]}], ",", "\[IndentingNewLine]", 
            RowBox[{"RuleDelayed", "@@", 
             RowBox[{"Hold", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"ConfHead", "[", 
                 RowBox[{"metric1", ",", "metric2"}], "]"}], "[", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"Ricci", "@", "cd1"}], ")"}], "[", 
                 RowBox[{"i1_", ",", "i2_"}], "]"}], "]"}], ",", 
               RowBox[{
                RowBox[{"confa", "^", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"WeightOfIndicesList", "[", 
                    RowBox[{"{", 
                    RowBox[{"i1", ",", "i2"}], "}"}], "]"}], "-", "2"}], 
                  ")"}]}], 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"Ricci", "@", "cd2"}], ")"}], "[", 
                 RowBox[{"i1", ",", "i2"}], "]"}]}]}], "]"}]}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"RuleDelayed", "@@", 
             RowBox[{"Hold", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"ConfHead", "[", 
                 RowBox[{"metric1", ",", "metric2"}], "]"}], "[", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"RicciScalar", "@", "cd1"}], ")"}], "[", "]"}], 
                "]"}], ",", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"RicciScalar", "@", "cd2"}], ")"}], "[", "]"}]}], 
              "]"}]}], ",", "\[IndentingNewLine]", 
            RowBox[{"RuleDelayed", "@@", 
             RowBox[{"Hold", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"ConfHead", "[", 
                 RowBox[{"metric1", ",", "metric2"}], "]"}], "[", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"Christoffel", "@", "cd1"}], ")"}], "[", 
                 RowBox[{"i1_", ",", "i2_", ",", "i3_"}], "]"}], "]"}], ",", 
               RowBox[{
                RowBox[{"confa", "^", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"WeightOfIndicesList", "[", 
                    RowBox[{"{", 
                    RowBox[{"i1", ",", "i2", ",", "i3"}], "}"}], "]"}], "-", 
                   "1"}], ")"}]}], "*", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"Christoffel", "@", "cd2"}], ")"}], "[", 
                 RowBox[{"i1", ",", "i2", ",", "i3"}], "]"}]}]}], "]"}]}], 
            ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
            "\[IndentingNewLine]", 
            RowBox[{"RuleDelayed", "@@", 
             RowBox[{"Hold", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"ConfHead", "[", 
                 RowBox[{"metric1", ",", "metric2"}], "]"}], "[", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"Determinant", "[", 
                   RowBox[{"metric1", ",", "AIndex"}], "]"}], ")"}], "[", 
                 "]"}], "]"}], ",", 
               RowBox[{"(*", " ", 
                RowBox[{
                "This", " ", "is", " ", "removed", " ", "because", " ", "now",
                  " ", "xTensor", " ", "is", " ", "patched", " ", 
                 RowBox[{
                  RowBox[{"confa2", "^", 
                   RowBox[{"DimOfManifold", "[", "M", "]"}]}], ".", " ", 
                  "Thanks"}], " ", "to", " ", "Leo", " ", 
                 RowBox[{"Stein", "."}]}], "*)"}], "\[IndentingNewLine]", 
               "\[IndentingNewLine]", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"Determinant", "[", 
                  RowBox[{"metric2", ",", "AIndex"}], "]"}], ")"}], "[", 
                "]"}]}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
              "]"}]}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
            RowBox[{"(*", " ", 
             RowBox[{
              RowBox[{
              "This", " ", "line", " ", "below", " ", "is", " ", "not", " ", 
               "working", " ", 
               RowBox[{"well", ".", "  ", "The"}], " ", "problem", " ", 
               "should", " ", "be", " ", "considered", " ", "later", " ", 
               "when", " ", "xTensor", " ", "knows", " ", "how", " ", "to", 
               " ", "handle", " ", "the", " ", "epsilon", " ", "of", " ", "a",
                " ", "frozen", " ", 
               RowBox[{"metric", ".", " ", "So"}], " ", "this", " ", "really",
                " ", "works", " ", "only", " ", "when", " ", "metric1", " ", 
               "is", " ", "the", " ", "ambient", " ", "metric"}], "..."}], 
             " ", "*)"}], "\[IndentingNewLine]", 
            RowBox[{"RuleDelayed", "@@", 
             RowBox[{"Hold", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"ConfHead", "[", 
                 RowBox[{"metric1", ",", "metric2"}], "]"}], "[", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"epsilon", "@", "metric1"}], ")"}], "[", 
                 RowBox[{"inds__", "?", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", 
                    RowBox[{"{", "#", "}"}], "]"}], "===", 
                    RowBox[{"DimOfManifold", "[", "M", "]"}]}], "&"}], 
                   ")"}]}], "]"}], "]"}], ",", 
               RowBox[{"(*", 
                RowBox[{"confa2", "^", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"DimOfManifold", "[", "M", "]"}], "/", "2"}], 
                  ")"}]}], "*)"}], 
               RowBox[{
                RowBox[{"confa", "^", 
                 RowBox[{"(", 
                  RowBox[{"WeightOfIndicesList", "[", 
                   RowBox[{"{", "inds", "}"}], "]"}], ")"}]}], 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"epsilon", "@", "metric1"}], ")"}], "[", "inds", 
                 "]"}]}]}], "]"}]}], ",", "\[IndentingNewLine]", 
            "\[IndentingNewLine]", 
            RowBox[{"(*", " ", 
             RowBox[{
             "Not", " ", "really", " ", "satisfactory", " ", "but", " ", 
              "minimalist", " ", "for", " ", "scalar", " ", "functions"}], 
             " ", "*)"}], "\[IndentingNewLine]", 
            RowBox[{"(*", " ", 
             RowBox[{
              RowBox[{
              "Following", " ", "Leo", " ", "Stein", " ", "suggestion"}], ",",
               " ", 
              RowBox[{
              "we", " ", "allow", " ", "the", " ", "scalar", " ", "function", 
               " ", "to", " ", "have", " ", "several", " ", "arguments"}]}], 
             " ", "*)"}], "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{
              RowBox[{"ConfHead", "[", 
               RowBox[{"metric1", ",", "metric2"}], "]"}], "[", 
              RowBox[{
               RowBox[{"f_", "?", "ScalarFunctionQ"}], "[", "arg___", "]"}], 
              "]"}], ":>", 
             RowBox[{
              RowBox[{"Simplify", "[", 
               RowBox[{
                RowBox[{"confa2", "^", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"ConformalWeight", "[", "f", "]"}], ")"}], "/", 
                   "2"}], ")"}]}], ",", 
                RowBox[{"Assumptions", "\[Rule]", 
                 RowBox[{"confa", ">", "0"}]}]}], "]"}], 
              RowBox[{"f", "[", "arg", "]"}]}]}], ",", "\[IndentingNewLine]", 
            "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{
              RowBox[{"ConfHead", "[", 
               RowBox[{"metric1", ",", "metric2"}], "]"}], "[", 
              RowBox[{
               RowBox[{"tens_", "?", "xTensorQ"}], "[", "indss___", "]"}], 
              "]"}], "\[RuleDelayed]", 
             RowBox[{
              RowBox[{"Simplify", "[", 
               RowBox[{
                RowBox[{"confa2", "^", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"ConformalWeight", "[", 
                    RowBox[{"tens", "[", "indss", "]"}], "]"}], "/", "2"}], 
                  ")"}]}], ",", 
                RowBox[{"Assumptions", "\[Rule]", 
                 RowBox[{"confa", ">", "0"}]}]}], "]"}], 
              RowBox[{"tens", "[", "indss", "]"}]}]}]}], 
           "\[IndentingNewLine]", "}"}]}], ";", "\[IndentingNewLine]", 
         "\[IndentingNewLine]", "res"}]}], "\[IndentingNewLine]", "]"}]}]}], 
    "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]", ")"}]}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"d3a9ce01-0a2c-4a96-8a44-7c386ab8ecad"],

Cell["\<\
We can have a passive transformation an express a given expression with \
another (conformally related) metric\
\>", "Text",ExpressionUUID->"b16f71a8-369f-404f-87e4-fbce19faf1a6"],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"ToMetric", "[", 
      RowBox[{"expr_", ",", 
       RowBox[{"metric1_", "?", "MetricQ"}]}], "]"}], ":=", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"InducedFrom", "@", "metric1"}], "=!=", "Null"}], ",", "expr",
        ",", "\[IndentingNewLine]", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"res", ",", "preexpression"}], "}"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"Off", "[", 
           StyleBox[
            RowBox[{"ConformalRules", "::", "unknown"}], "MessageName"], 
           StyleBox["]", "MessageName"]}], 
          StyleBox[";", "MessageName"], "\[IndentingNewLine]", 
          RowBox[{"With", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"cd1", "=", 
               RowBox[{"CovDOfMetric", "[", "metric1", "]"}]}], ",", 
              RowBox[{"$CovDsNotInduced", "=", 
               RowBox[{"Select", "[", 
                RowBox[{
                 RowBox[{"Rest", "@", "$CovDs"}], ",", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"InducedFrom", "[", 
                    RowBox[{"MetricOfCovD", "[", "#", "]"}], "]"}], "===", 
                   "Null"}], "&"}]}], "]"}]}]}], "}"}], ",", 
            "\[IndentingNewLine]", "\[IndentingNewLine]", 
            RowBox[{"(*", " ", 
             RowBox[{
             "2025", " ", "I", " ", "modify", " ", "this", " ", "as", " ", 
              "it", " ", "does", " ", "not", " ", "select", " ", "correctly", 
              " ", "the", " ", "other", " ", "covariant", " ", 
              RowBox[{"deriavtives", ".", " ", "TODO"}], " ", "a", " ", 
              "revoir"}], " ", "*)"}], "\[IndentingNewLine]", 
            RowBox[{"(*", 
             RowBox[{"With", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"$CovDsNotInducedRelatedTocd1", "=", 
                 RowBox[{"Select", "[", 
                  RowBox[{"$CovDsNotInduced", ",", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"Catch", "@", 
                    RowBox[{"ConformalRules", "[", 
                    RowBox[{"metric1", ",", 
                    RowBox[{"MetricOfCovD", "[", "#", "]"}]}], "]"}]}], "=!=",
                     "Null"}], ")"}], "&"}]}], "]"}]}], "}"}], ","}]}], 
             "*)"}], "\[IndentingNewLine]", 
            RowBox[{"With", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"$CovDsNotInducedRelatedTocd1", "=", 
                RowBox[{"Select", "[", 
                 RowBox[{"$CovDsNotInduced", ",", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"ConformalRules", "[", 
                    RowBox[{"metric1", ",", 
                    RowBox[{"MetricOfCovD", "[", "#", "]"}]}], "]"}], "=!=", 
                    RowBox[{"{", "}"}]}], ")"}], "&"}]}], "]"}]}], "}"}], ",",
               "\[IndentingNewLine]", "\[IndentingNewLine]", 
              RowBox[{"(*", " ", 
               RowBox[{
                RowBox[{
                 RowBox[{
                 "I", " ", "think", " ", "I", " ", "would", " ", "like", " ", 
                  "to", " ", "remove", " ", "the"}], " ", "//", 
                 "ContractMetric"}], "//", 
                RowBox[{
                "ToCanonical", " ", "below", " ", "but", " ", "this", " ", 
                 "introduces", " ", "bugs"}]}], "*)"}], "\[IndentingNewLine]", 
              RowBox[{
               RowBox[{"preexpression", "=", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Identity", "[", "expr", "]"}], "//", 
                    "ProjectorToMetric"}], "//", "EinsteinToRicci"}], "//", 
                    "WeylToRiemann"}], "//", "ContractMetric"}], "//", 
                  "ToCanonical"}], ")"}]}], ";", "\[IndentingNewLine]", 
               RowBox[{"(*", 
                RowBox[{
                 RowBox[{"preexpression", "=", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"SeparateMetric", "[", "]"}], "[", "expr", "]"}], 
                    "//", "ProjectorToMetric"}], "//", "EinsteinToRicci"}], "//",
                     "WeylToRiemann"}], ")"}]}], ";"}], "*)"}], 
               "\[IndentingNewLine]", 
               RowBox[{"(*", 
                RowBox[{
                 RowBox[{"Print", "[", 
                  RowBox[{
                  "\"\<preexpression in Tometric is \>\"", ",", 
                   "preexpression"}], "]"}], ";"}], "*)"}], 
               "\[IndentingNewLine]", "\[IndentingNewLine]", 
               RowBox[{"res", "=", 
                RowBox[{
                 RowBox[{
                  RowBox[{
                   RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"ChangeCovD", "[", 
                    RowBox[{"#", ",", "$CovDsNotInduced", ",", "cd1"}], "]"}],
                     "&"}], "@", "\[IndentingNewLine]", 
                    RowBox[{"ChristoffelToGradConformal", "[", 
                    RowBox[{
                    "#", ",", "$CovDsNotInducedRelatedTocd1", ",", "cd1"}], 
                    "]"}]}], "&"}], "@", "\[IndentingNewLine]", 
                    RowBox[{"MyChangeChristoffel", "[", 
                    RowBox[{
                    "#", ",", "$CovDsNotInducedRelatedTocd1", ",", "cd1"}], 
                    "]"}]}], "&"}], "@", "\[IndentingNewLine]", 
                    RowBox[{"ChangeCovD", "[", 
                    RowBox[{"#", ",", "$CovDsNotInduced", ",", "cd1"}], 
                    "]"}]}], "&"}], "@", "\[IndentingNewLine]", 
                   RowBox[{"ChangeCurvature", "[", 
                    RowBox[{"#", ",", "$CovDsNotInduced", ",", "cd1"}], 
                    "]"}]}], "&"}], "@", "preexpression"}]}], ";", 
               "\[IndentingNewLine]", "\[IndentingNewLine]", 
               RowBox[{"Off", "[", 
                StyleBox[
                 RowBox[{"ConformalRules", "::", "unknown"}], "MessageName"], 
                
                StyleBox["]", "MessageName"]}], 
               StyleBox[";", "MessageName"], 
               StyleBox["\[IndentingNewLine]", "MessageName"], 
               RowBox[{
                StyleBox["Fold", "MessageName"], 
                StyleBox["[", "MessageName"], 
                StyleBox[
                 RowBox[{
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"#1", "/.", 
                    RowBox[{"ConformalRules", "[", 
                    RowBox[{
                    RowBox[{"MetricOfCovD", "[", "#2", "]"}], ",", 
                    "metric1"}], "]"}]}], ")"}], "&"}], ",", "res", ",", 
                  "$CovDsNotInducedRelatedTocd1"}], "MessageName"], "]"}]}]}],
              "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", 
           "]"}]}]}], "\[IndentingNewLine]", "]"}]}], 
      StyleBox["\[IndentingNewLine]", "MessageName"], 
      StyleBox["]", "MessageName"]}]}], 
    StyleBox[";", "MessageName"]}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ToMetric", "[", "expr_", "]"}], ":=", 
     RowBox[{"ToMetric", "[", 
      RowBox[{"expr", ",", 
       RowBox[{"First", "@", "$Metrics"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"SetNumberOfArguments", "[", 
    RowBox[{"ToMetric", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Protect", "[", "ToMetric", "]"}], ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"f3e87513-6d82-40fd-bf39-18640f42ba63"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"InverseMetricQ", "[", 
   RowBox[{"x_", "?", "xTensorQ"}], "]"}], ":=", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"tid", "=", 
      RowBox[{"TensorID", "@", "x"}]}], "}"}], ",", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Length", "@", "tid"}], ">", "0"}], ")"}], "&&", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"tid", "[", 
        RowBox[{"[", "1", "]"}], "]"}], "===", 
       "xAct`xTensor`Private`InvMetric"}], ")"}]}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"InverseMetricQ", "[", "_", "]"}], ":=", "False"}]}], "Input",
 InitializationCell->True,
 CellLabel->"In[92]:=",ExpressionUUID->"f483c148-5889-4fa2-8f23-06f659f5edcb"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"SeparateIndicesDownOfInverseMetric", "[", 
     RowBox[{"invmetric_", "?", "InverseMetricQ"}], "]"}], "[", "expr_", 
    "]"}], ":=", 
   RowBox[{"Fold", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"SeparateMetric", "[", 
        RowBox[{"First", "@", "$Metrics"}], "]"}], "[", 
       RowBox[{"#1", ",", "#2"}], "]"}], "&"}], ",", "expr", ",", 
     RowBox[{
      RowBox[{"IndicesOf", "[", 
       RowBox[{"Down", ",", "invmetric"}], "]"}], "[", "expr", "]"}]}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SeparateIndicesDownOfInverseMetric", "[", "_", "]"}], "[", 
   "expr_", "]"}], ":=", "expr"}]}], "Input",
 InitializationCell->True,
 CellLabel->"In[94]:=",ExpressionUUID->"dbe788be-3d37-4366-b6f3-78f6ef07a7ca"],

Cell["\<\
Main function. Performs the conformal transformation by 
1) applying a formal head,
2) remove the head thanks to the rules of conformal transformation
3) express the results in the final metric desired\
\>", "Text",ExpressionUUID->"059b5f7e-6f68-451a-add2-d26585c16f14"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"AbstractConformal", "[", 
     RowBox[{
      RowBox[{"metric1_", "?", "MetricQ"}], ",", 
      RowBox[{"metric2_", "?", "MetricQ"}]}], "]"}], "[", "expr_", "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"cdb", ",", "cd1", ",", "cd2", ",", "res", ",", "res2", ",", 
       RowBox[{"(*", 
        RowBox[{"oldpre", ","}], "*)"}], "resbis", ",", "exprnoproj", ",", 
       "M", ",", "i1", ",", "i2", ",", "beforeputtingconfheads", ",", 
       "IDInvMetric", ",", "res3", ",", "firstmetric"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
      "The", " ", "conflict", " ", "with", " ", "ScreenDollarIndicea", " ", 
       "has", " ", "now", " ", "been", " ", 
       RowBox[{"solved", ".", " ", "So"}], " ", "there", " ", "is", " ", "no",
        " ", "need", " ", "to", " ", "redefine", " ", "temporarily", " ", 
       "$PrePrint"}], "*)"}], "\[IndentingNewLine]", 
     RowBox[{"(*", 
      RowBox[{
       RowBox[{"oldpre", "=", "$PrePrint"}], ";", 
       RowBox[{"$PrePrint", "=", "Identity"}], ";"}], "*)"}], 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
       RowBox[{
       "we", " ", "define", " ", "the", " ", "Covds", " ", "associated", " ", 
        "with", " ", "the", " ", 
        RowBox[{"metric", ".", " ", "The"}], " ", "starting", " ", "metric", 
        " ", "is", " ", "metric1"}], ",", " ", 
       RowBox[{
       "the", " ", "conformally", " ", "transformed", " ", "metric", " ", 
        "is", " ", "metric2"}], ",", " ", 
       RowBox[{
       "and", " ", "metricbase", " ", "i", " ", "the", " ", "base", " ", 
        "metric", " ", "for", " ", "raising", " ", "and", " ", "lowering", 
        " ", 
        RowBox[{"indiced", ".", " ", "It"}], " ", "might", " ", "be", " ", 
        "one", " ", "of", " ", "the", " ", "other", " ", "two"}], ",", " ", 
       RowBox[{
        RowBox[{"but", " ", "it", " ", "might", " ", "not", " ", "be"}], 
        "..."}]}], "*)"}], "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"cd1", "=", 
       RowBox[{"CovDOfMetric", "[", "metric1", "]"}]}], ";", 
      RowBox[{"Off", "[", 
       RowBox[{"ConformalFactor", "::", "\"\<unknown\>\""}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"cd2", "=", 
       RowBox[{"CovDOfMetric", "[", "metric2", "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
       "TODO", " ", "put", " ", "a", " ", "check", " ", "that", " ", "the", 
        " ", "expression", " ", "has", " ", "no", " ", "projectors"}], " ", 
       "*)"}], "\[IndentingNewLine]", 
      RowBox[{"exprnoproj", "=", "expr"}], 
      RowBox[{"(*", 
       RowBox[{"//", "ProjectorToMetric"}], "*)"}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"M", "=", 
       RowBox[{"ManifoldOfCovD", "[", "cd1", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"i1", "=", 
       RowBox[{"DummyIn", "[", 
        RowBox[{"Tangent", "[", "M", "]"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"i2", "=", 
       RowBox[{"DummyIn", "[", 
        RowBox[{"Tangent", "[", "M", "]"}], "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"Print", "[", "\"\<Stage 1\>\"", "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"beforeputtingconfheads", "=", 
       RowBox[{"ToMetric", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"SeparateMetric", "[", "]"}], "[", "exprnoproj", "]"}], ",",
          "metric1"}], "]"}]}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"Print", "[", 
       RowBox[{
       "\"\<beforeputtingconfheads \>\"", ",", "beforeputtingconfheads"}], 
       "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"Print", "[", "\"\<Stage 2\>\"", "]"}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
       "Then", " ", "we", " ", "place", " ", "the", " ", "ConfHead", " ", 
        "on", " ", "every", " ", "expression", " ", "to", " ", "perform", " ",
         "formally", " ", "the", " ", "conformal", " ", 
        RowBox[{"transformation", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"res", "=", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"beforeputtingconfheads", "\[IndentingNewLine]", 
             RowBox[{"(*", " ", 
              RowBox[{
              "Dirty", " ", "case", " ", "of", " ", "scalar", " ", 
               "functions"}], " ", "*)"}], "\[IndentingNewLine]", "/.", 
             RowBox[{
              RowBox[{
               RowBox[{"f_", "?", "ScalarFunctionQ"}], "[", "ex___", "]"}], 
              "\[RuleDelayed]", 
              RowBox[{
               RowBox[{"ConfHead", "[", 
                RowBox[{"metric1", ",", "metric2"}], "]"}], "[", 
               RowBox[{"f", "[", "ex", "]"}], "]"}]}]}], 
            "\[IndentingNewLine]", 
            RowBox[{"(*", " ", "tensors", " ", "*)"}], "\[IndentingNewLine]", 
            "/.", 
            RowBox[{
             RowBox[{
              RowBox[{"tens_", "?", "xTensorQ"}], "[", "inds___", "]"}], ":>", 
             RowBox[{
              RowBox[{"ConfHead", "[", 
               RowBox[{"metric1", ",", "metric2"}], "]"}], "[", 
              RowBox[{"tens", "[", "inds", "]"}], "]"}]}]}], 
           "\[IndentingNewLine]", 
           RowBox[{"(*", " ", 
            RowBox[{"Covariant", " ", "derivatives"}], " ", "*)"}], 
           "\[IndentingNewLine]", "/.", 
           RowBox[{
            RowBox[{"cd1", "[", 
             RowBox[{"i1_", "?", "DownIndexQ"}], "]"}], ":>", 
            RowBox[{"cd2", "[", "i1", "]"}]}]}], "\[IndentingNewLine]", 
          RowBox[{"(*", " ", 
           RowBox[{
           "Now", " ", "that", " ", "we", " ", "have", " ", "ConfHead", " ", 
            "everywhere", " ", "we", " ", "need", " ", "to", " ", "remove", 
            " ", "the", " ", "head", " ", "by", " ", "specifying", " ", "the",
             " ", "change"}], "*)"}], "\[IndentingNewLine]", 
          RowBox[{"(*", " ", 
           RowBox[{
           "First", " ", "Obvious", " ", "rules", " ", "for", " ", "metric", 
            " ", "and", " ", "inverse", " ", "metric"}], "*)"}], 
          "\[IndentingNewLine]", "/.", 
          RowBox[{
           RowBox[{
            RowBox[{"ConfHead", "[", 
             RowBox[{"metric1", ",", "metric2"}], "]"}], "[", 
            RowBox[{"metric1", "[", 
             RowBox[{
              RowBox[{"i1_", "?", "DownIndexQ"}], ",", 
              RowBox[{"i2_", "?", "DownIndexQ"}]}], "]"}], "]"}], ":>", 
           RowBox[{"metric2", "[", 
            RowBox[{"i1", ",", "i2"}], "]"}]}]}], "\[IndentingNewLine]", "/.", 
         RowBox[{
          RowBox[{
           RowBox[{"ConfHead", "[", 
            RowBox[{"metric1", ",", "metric2"}], "]"}], "[", 
           RowBox[{
            RowBox[{"Inv", "[", "metric1", "]"}], "[", 
            RowBox[{
             RowBox[{"i1_", "?", "UpIndexQ"}], ",", 
             RowBox[{"i2_", "?", "UpIndexQ"}]}], "]"}], "]"}], ":>", 
          RowBox[{
           RowBox[{"Inv", "[", "metric2", "]"}], "[", 
           RowBox[{"i1", ",", "i2"}], "]"}]}]}], ")"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"Print", "[", "\"\<Stage 3\>\"", "]"}], ";", 
      "\[IndentingNewLine]", "res"}]}], "\[IndentingNewLine]", "]"}]}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "In", " ", "case", " ", "the", " ", "base", " ", "metric", " ", "is", " ",
      "unspecified"}], ",", " ", 
    RowBox[{
     RowBox[{
     "it", " ", "is", " ", "the", " ", "base", " ", "metric", " ", "of", " ", 
      "course"}], "..."}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{"AbstractConformal", "[", 
      RowBox[{
       RowBox[{"metric1_", "?", "MetricQ"}], ",", 
       RowBox[{"metric2_", "?", "MetricQ"}]}], "]"}], "[", "expr_", "]"}], ":=", 
    RowBox[{
     RowBox[{"AbstractConformal", "[", 
      RowBox[{"metric1", ",", "metric2"}], "]"}], "[", "expr", "]"}]}], 
   "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"7c68ed1b-015d-4526-b9b4-88a3175237b6"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Conformal", "[", 
      RowBox[{"metricbase_", "?", "MetricQ"}], "]"}], "[", 
     RowBox[{
      RowBox[{"metric1_", "?", "MetricQ"}], ",", 
      RowBox[{"metric2_", "?", "MetricQ"}]}], "]"}], "[", "expr_", "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"cdb", ",", "cd1", ",", "cd2", ",", "res", ",", "res2", ",", 
       RowBox[{"(*", 
        RowBox[{"oldpre", ","}], "*)"}], "resbis", ",", "exprnoproj", ",", 
       "M", ",", "i1", ",", "i2", ",", "beforeputtingconfheads", ",", 
       "IDInvMetric", ",", "res3", ",", "firstmetric"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
      "The", " ", "conflict", " ", "with", " ", "ScreenDollarIndicea", " ", 
       "has", " ", "now", " ", "been", " ", 
       RowBox[{"solved", ".", " ", "So"}], " ", "there", " ", "is", " ", "no",
        " ", "need", " ", "to", " ", "redefine", " ", "temporarily", " ", 
       "$PrePrint"}], "*)"}], "\[IndentingNewLine]", 
     RowBox[{"(*", 
      RowBox[{
       RowBox[{"oldpre", "=", "$PrePrint"}], ";", 
       RowBox[{"$PrePrint", "=", "Identity"}], ";"}], "*)"}], 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
       RowBox[{
       "we", " ", "define", " ", "the", " ", "Covds", " ", "associated", " ", 
        "with", " ", "the", " ", 
        RowBox[{"metric", ".", " ", "The"}], " ", "starting", " ", "metric", 
        " ", "is", " ", "metric1"}], ",", " ", 
       RowBox[{
       "the", " ", "conformally", " ", "transformed", " ", "metric", " ", 
        "is", " ", "metric2"}], ",", " ", 
       RowBox[{
       "and", " ", "metricbase", " ", "i", " ", "the", " ", "base", " ", 
        "metric", " ", "for", " ", "raising", " ", "and", " ", "lowering", 
        " ", 
        RowBox[{"indiced", ".", " ", "It"}], " ", "might", " ", "be", " ", 
        "one", " ", "of", " ", "the", " ", "other", " ", "two"}], ",", " ", 
       RowBox[{
        RowBox[{"but", " ", "it", " ", "might", " ", "not", " ", "be"}], 
        "..."}]}], "*)"}], "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"cdb", "=", 
       RowBox[{"CovDOfMetric", "[", "metricbase", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"cd1", "=", 
       RowBox[{"CovDOfMetric", "[", "metric1", "]"}]}], ";", 
      RowBox[{"Off", "[", 
       RowBox[{"ConformalFactor", "::", "\"\<unknown\>\""}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"cd2", "=", 
       RowBox[{"CovDOfMetric", "[", "metric2", "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"exprnoproj", "=", 
       RowBox[{"expr", "//", "ProjectorToMetric"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"M", "=", 
       RowBox[{"ManifoldOfCovD", "[", "cd1", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"i1", "=", 
       RowBox[{"DummyIn", "[", 
        RowBox[{"Tangent", "[", "M", "]"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"i2", "=", 
       RowBox[{"DummyIn", "[", 
        RowBox[{"Tangent", "[", "M", "]"}], "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"IDInvMetric", "=", 
       RowBox[{"SeparateIndicesDownOfInverseMetric", "[", 
        RowBox[{"Inv", "[", "metric1", "]"}], "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"beforeputtingconfheads", "=", 
       RowBox[{
        RowBox[{
         RowBox[{"IDInvMetric", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"IndicesDown", "@", 
              RowBox[{"ToMetric", "[", 
               RowBox[{"exprnoproj", ",", "metric1"}], "]"}]}], ")"}], "/.", 
            RowBox[{
             RowBox[{"Scalar", "[", "ex_", "]"}], "\[RuleDelayed]", 
             RowBox[{"Scalar", "[", 
              RowBox[{"IndicesDown", "[", "ex", "]"}], "]"}]}]}], "/.", 
           RowBox[{
            RowBox[{
             RowBox[{"sf_", "?", "ScalarFunctionQ"}], "[", "args___", "]"}], 
            "\[RuleDelayed]", 
            RowBox[{"sf", "@@", 
             RowBox[{"IndicesDown", "/@", 
              RowBox[{"{", "args", "}"}]}]}]}]}], "]"}], "/.", 
         RowBox[{
          RowBox[{"Scalar", "[", "ex_", "]"}], "\[RuleDelayed]", 
          RowBox[{"Scalar", "[", 
           RowBox[{"IDInvMetric", "[", "ex", "]"}], "]"}]}]}], "/.", 
        RowBox[{
         RowBox[{
          RowBox[{"sf_", "?", "ScalarFunctionQ"}], "[", "args___", "]"}], 
         "\[RuleDelayed]", 
         RowBox[{"sf", "@@", 
          RowBox[{"IDInvMetric", "/@", 
           RowBox[{"{", "args", "}"}]}]}]}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
       "Above", " ", "we", " ", "make", " ", "sure", " ", "that", " ", 
        "IndicesDown", " ", "and", " ", "SeparateIndicesDownOfInverseMetric", 
        " ", "goes", " ", "inside", " ", "the", " ", "scalar", " ", "Head"}], 
       "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{
       "We", " ", "use", " ", "ToMetric", " ", "to", " ", "have", " ", "only",
         " ", "references", " ", "to", " ", "the", " ", "metric1", " ", "and",
         " ", "its", " ", "associated", " ", "CovD", " ", "and", " ", 
        "curvature", " ", "tensors"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"Print", "[", 
         RowBox[{
         "\"\<beforeputtingconfheads \>\"", ",", "beforeputtingconfheads"}], 
         "]"}], ";"}], "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
       "Then", " ", "we", " ", "place", " ", "the", " ", "ConfHead", " ", 
        "on", " ", "every", " ", "expression", " ", "to", " ", "perform", " ",
         "formally", " ", "the", " ", "conformal", " ", 
        RowBox[{"transformation", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"res", "=", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"beforeputtingconfheads", "\[IndentingNewLine]", 
             RowBox[{"(*", " ", 
              RowBox[{
              "Dirty", " ", "case", " ", "of", " ", "scalar", " ", 
               "functions"}], " ", "*)"}], "\[IndentingNewLine]", "/.", 
             RowBox[{
              RowBox[{
               RowBox[{"f_", "?", "ScalarFunctionQ"}], "[", "ex___", "]"}], 
              "\[RuleDelayed]", 
              RowBox[{
               RowBox[{"ConfHead", "[", 
                RowBox[{"metric1", ",", "metric2"}], "]"}], "[", 
               RowBox[{"f", "[", "ex", "]"}], "]"}]}]}], 
            "\[IndentingNewLine]", 
            RowBox[{"(*", " ", "tensors", " ", "*)"}], "\[IndentingNewLine]", 
            "/.", 
            RowBox[{
             RowBox[{
              RowBox[{"tens_", "?", "xTensorQ"}], "[", "inds___", "]"}], ":>", 
             RowBox[{
              RowBox[{"ConfHead", "[", 
               RowBox[{"metric1", ",", "metric2"}], "]"}], "[", 
              RowBox[{"tens", "[", "inds", "]"}], "]"}]}]}], 
           "\[IndentingNewLine]", 
           RowBox[{"(*", " ", 
            RowBox[{"Covariant", " ", "derivatives"}], " ", "*)"}], 
           "\[IndentingNewLine]", "/.", 
           RowBox[{
            RowBox[{"cd1", "[", 
             RowBox[{"i1_", "?", "DownIndexQ"}], "]"}], ":>", 
            RowBox[{"cd2", "[", "i1", "]"}]}]}], "\[IndentingNewLine]", 
          RowBox[{"(*", " ", 
           RowBox[{
           "Now", " ", "that", " ", "we", " ", "have", " ", "ConfHead", " ", 
            "everywhere", " ", "we", " ", "need", " ", "to", " ", "remove", 
            " ", "the", " ", "head", " ", "by", " ", "specifying", " ", "the",
             " ", "change"}], "*)"}], "\[IndentingNewLine]", 
          RowBox[{"(*", " ", 
           RowBox[{
           "First", " ", "Obvious", " ", "rules", " ", "for", " ", "metric", 
            " ", "and", " ", "inverse", " ", "metric"}], "*)"}], 
          "\[IndentingNewLine]", "/.", 
          RowBox[{
           RowBox[{
            RowBox[{"ConfHead", "[", 
             RowBox[{"metric1", ",", "metric2"}], "]"}], "[", 
            RowBox[{"metric1", "[", 
             RowBox[{
              RowBox[{"i1_", "?", "DownIndexQ"}], ",", 
              RowBox[{"i2_", "?", "DownIndexQ"}]}], "]"}], "]"}], ":>", 
           RowBox[{"metric2", "[", 
            RowBox[{"i1", ",", "i2"}], "]"}]}]}], "\[IndentingNewLine]", "/.", 
         RowBox[{
          RowBox[{
           RowBox[{"ConfHead", "[", 
            RowBox[{"metric1", ",", "metric2"}], "]"}], "[", 
           RowBox[{
            RowBox[{"Inv", "[", "metric1", "]"}], "[", 
            RowBox[{
             RowBox[{"i1_", "?", "UpIndexQ"}], ",", 
             RowBox[{"i2_", "?", "UpIndexQ"}]}], "]"}], "]"}], ":>", 
          RowBox[{
           RowBox[{"Inv", "[", "metric2", "]"}], "[", 
           RowBox[{"i1", ",", "i2"}], "]"}]}]}], ")"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
       "And", " ", "then", " ", "all", " ", "other", " ", "rules", " ", "to", 
        " ", "remove", " ", "the", " ", "ConfHead"}], "*)"}], 
      "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"A", " ", "bug", " ", "with", " ", "Scalar", " ", 
        RowBox[{"expressions", ".", " ", "I"}], " ", "have", " ", "added", 
        " ", "a", " ", 
        RowBox[{"NoSCalar", " ", ".", " ", "Check"}], " ", "if", " ", "this", 
        " ", "works", " ", "fine", " ", "for", " ", "the", " ", 
        RowBox[{"rest", ".", " ", "It"}], " ", "seems", " ", 
        RowBox[{"so", "."}]}], "*)"}], "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
       "It", " ", "seems", " ", "to", " ", "be", " ", "fine", " ", "so", " ", 
        "I", " ", "should", " ", "post", " ", "the", " ", "modification"}], 
       "*)"}], "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
       "This", " ", "avoids", " ", "the", " ", "appearance", " ", "of", " ", 
        "sums", " ", "inside", " ", "SymmetryOf", " ", "which", " ", "were", 
        " ", "resulting", " ", "from", " ", "a", " ", "removed", " ", 
        "Scalar", " ", 
        RowBox[{"head", "."}]}], "*)"}], "\[IndentingNewLine]", 
      RowBox[{"resbis", "=", 
       RowBox[{"NoScalar", "[", 
        RowBox[{"res", "//.", 
         RowBox[{"RulesConf", "[", 
          RowBox[{"metric1", ",", "metric2"}], "]"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{
        "So", " ", "here", " ", "we", " ", "have", " ", "conformally", " ", 
         "transformed", " ", "the", " ", "expression"}], ",", " ", 
        RowBox[{
         RowBox[{
          RowBox[{
          "but", " ", "now", " ", "we", " ", "want", " ", "to", " ", 
           "express", " ", "it", " ", "in", " ", "function", " ", "of", " ", 
           "the", " ", "original", " ", "metric", " ", "and", " ", "orginal", 
           " ", "covD", " ", "etc"}], "..."}], "\[IndentingNewLine]", 
         "Indeed", " ", "at", " ", "that", " ", "point"}], ",", " ", 
        RowBox[{
        "we", " ", "still", " ", "have", " ", "the", " ", "second", " ", 
         "metric"}], ",", " ", 
        RowBox[{
        "and", " ", "the", " ", "Riemann", " ", "of", " ", "the", " ", 
         "second", " ", "metric", " ", "for", " ", 
         RowBox[{"instance", ".", " ", "SO"}], " ", "we", " ", "use", " ", 
         "again", " ", "ToMetric"}]}], "*)"}], "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"$PrePrint", "=", "oldpre"}], ";"}], "*)"}], 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"On", "[", 
       RowBox[{"ConformalFactor", "::", "\"\<unknown\>\""}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Off", "[", 
       RowBox[{"ToCanonical", "::", "\"\<cmods\>\""}], "]"}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"2025", " ", 
        RowBox[{"modification", ".", " ", "See"}], " ", "if", " ", "this", 
        " ", "is", " ", "better", " ", "or", " ", 
        RowBox[{"not", ".", " ", "It"}], " ", "seems", " ", 
        RowBox[{"not", " ", "!"}]}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"res2", "=", 
       RowBox[{"ToCanonical", "@", 
        RowBox[{"ContractMetric", "@", 
         RowBox[{"NoScalar", "[", 
          RowBox[{"ToMetric", "[", 
           RowBox[{"resbis", ",", "metricbase"}], "]"}], "]"}]}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"res2", "=", 
         RowBox[{"NoScalar", "[", 
          RowBox[{"ToMetric", "[", 
           RowBox[{"resbis", ",", "metricbase"}], "]"}], "]"}]}], ";"}], 
       "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"Cyril", " ", 
        RowBox[{"Pitrou", " ", ":", " ", 
         RowBox[{
         "March", " ", "2018.", " ", "I", " ", "have", " ", "added", " ", 
          "an", " ", "attempt", " ", "to", " ", "patch", " ", "the", " ", 
          "problems", " ", "I", " ", "have", " ", "with", " ", "multiples", 
          " ", "frozen", " ", "metrics", " ", "coming", " ", "from", " ", 
          "multiple", " ", "conformal", " ", 
          RowBox[{"transformations", "."}]}]}]}], "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"I", " ", "think", " ", "it", " ", "works"}], "..."}], " ", 
         "The", " ", "idea", " ", "is", " ", "that", " ", "since", " ", "for",
          " ", "frozen", " ", "metrics", " ", "some", " ", "simplifications", 
         " ", "to", " ", "Dirac", " ", "do", " ", "not", " ", "occur", " ", 
         "when", " ", "they", " ", "should"}], ",", " ", 
        RowBox[{"I", " ", "switch", " ", "to", " ", "active", " ", "metric"}],
         ",", " ", 
        RowBox[{"let", " ", "xTensor", " ", "put", " ", "the", " ", "Dirac"}],
         ",", " ", 
        RowBox[{
        "and", " ", "switch", " ", "back", " ", "to", " ", "the", " ", 
         "desired", " ", 
         RowBox[{"metric", "."}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{
        "It", " ", "happened", " ", "that", " ", "some", " ", "definitions", 
         " ", "in", " ", "xTensor", " ", "were", " ", "missing", " ", "for", 
         " ", "frozen", " ", 
         RowBox[{"metrics", ".", " ", "As"}], " ", "of", " ", 
         RowBox[{
          RowBox[{"28", "/", "03"}], "/", "2018"}], " ", "version", " ", "of",
          " ", "xAct", " ", "this", " ", "should", " ", "be", " ", "fixed", 
         " ", "and", " ", "the", " ", "patch", " ", "I", " ", "am", " ", 
         "adding", " ", "below", " ", "should", " ", "not", " ", "be", " ", 
         "necessary"}], "..."}], "*)"}], " ", 
      RowBox[{"(*", " ", 
       RowBox[{
       "But", " ", "I", " ", "find", " ", "it", " ", "is", " ", 
        "necessaryTODO", " ", "investigate", " ", "this", " ", "in", " ", 
        "2025"}], " ", "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"2025", " ", 
        RowBox[{"modification", ":", " ", 
         RowBox[{
         "I", " ", "would", " ", "like", " ", "to", " ", "remove", " ", 
          RowBox[{"this", ".", " ", "But"}], " ", "I", " ", "have", " ", 
          "noticed", " ", "a", " ", "bug", " ", "so", " ", "I", " ", "must", 
          " ", "investigate", " ", "why", " ", 
          RowBox[{"TODO", "."}]}]}]}], "*)"}], "\[IndentingNewLine]", 
      RowBox[{"firstmetric", "=", 
       RowBox[{"First", "@", "$Metrics"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"metricbase", "=!=", "firstmetric"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"res3", "=", 
          RowBox[{"ContractMetric", "[", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"ToCanonical", "@", 
               RowBox[{"NoScalar", "@", 
                RowBox[{"ContractMetric", "[", 
                 RowBox[{"res2", "/.", 
                  RowBox[{"ConformalRules", "[", 
                   RowBox[{"metricbase", ",", "firstmetric"}], "]"}]}], 
                 "]"}]}]}], ")"}], "/.", 
             RowBox[{"ConformalRules", "[", 
              RowBox[{"firstmetric", ",", "metricbase"}], "]"}]}], ")"}], 
           "]"}]}], ";"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"res3", "=", "res2"}], ";"}]}], "]"}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"On", "[", 
       RowBox[{"ToCanonical", "::", "\"\<cmods\>\""}], "]"}], ";", 
      "\[IndentingNewLine]", "res3"}]}], "\[IndentingNewLine]", "]"}]}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "In", " ", "case", " ", "the", " ", "base", " ", "metric", " ", "is", " ",
      "unspecified"}], ",", " ", 
    RowBox[{
     RowBox[{
     "it", " ", "is", " ", "the", " ", "base", " ", "metric", " ", "of", " ", 
      "course"}], "..."}]}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Conformal", "[", 
     RowBox[{
      RowBox[{"metric1_", "?", "MetricQ"}], ",", 
      RowBox[{"metric2_", "?", "MetricQ"}]}], "]"}], "[", "expr_", "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{"Conformal", "[", 
      RowBox[{"First", "@", "$Metrics"}], "]"}], "[", 
     RowBox[{"metric1", ",", "metric2"}], "]"}], "[", "expr", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]"}], "Input",
 InitializationCell->
  True,ExpressionUUID->"57790608-a36c-4d3c-a586-3ae2bd2619bf"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["End private and package",
 FontColor->RGBColor[
  0, 0, 1]]], \
"Subsubsection",ExpressionUUID->"1aeab204-8f8e-4d5c-a6d2-c5dca4cced79"],

Cell[BoxData[
 RowBox[{
  RowBox[{"On", "[", 
   RowBox[{"RuleDelayed", "::", "rhs"}], "]"}], ";"}]], "Input",
 InitializationCell->True,
 CellLabel->"In[98]:=",ExpressionUUID->"752a09fa-24f2-4b4a-8cb8-e493520e326c"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"End", "[", "]"}], "\[IndentingNewLine]", 
 RowBox[{"EndPackage", "[", "]"}]}], "Input",
 InitializationCell->True,
 CellLabel->"In[99]:=",ExpressionUUID->"0db3a7a4-4037-4d76-83ac-d166a8988c4d"],

Cell[BoxData["\<\"xAct`xConf`Private`\"\>"], "Output",
 CellLabel->
  "Out[99]=",ExpressionUUID->"83ca05c0-48bd-40ae-9030-d45fdce3033b"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
AutoGeneratedPackage->Automatic,
WindowSize->{973.5, 528},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrivateNotebookOptions->{"FileOutlineCache"->False},
ShowSelection->True,
TrackCellChangeTimes->False,
Magnification->1,
FrontEndVersion->"13.3 pour Linux x86 (64-bit) (July 24, 2023)",
StyleDefinitions->FrontEnd`FileName[{"Creative"}, "PastelColor.nb", 
  CharacterEncoding -> "UTF-8"],
ExpressionUUID->"809dce3c-6b5c-4b9a-9526-c10240869a00"
]

