(* ::Package:: *)

(************************************************************************)
(* This file was generated automatically by the Mathematica front end.  *)
(* It contains Initialization cells from a Notebook file, which         *)
(* typically will have the same name as this file except ending in      *)
(* ".nb" instead of ".m".                                               *)
(*                                                                      *)
(* This file is intended to be loaded into the Mathematica kernel using *)
(* the package loading commands Get or Needs.  Doing so is equivalent   *)
(* to using the Evaluate Initialization Cells menu command in the front *)
(* end.                                                                 *)
(*                                                                      *)
(* DO NOT EDIT THIS FILE.  This entire file is regenerated              *)
(* automatically each time the parent Notebook file is saved in the     *)
(* Mathematica front end.  Any changes you make to this file will be    *)
(* overwritten.                                                         *)
(************************************************************************)



(* ::Input::Initialization:: *)
xAct`xConf`$Version={"0.0.1",{2025,04,04}};


(* ::Input::Initialization:: *)
xAct`xConf`$xTensorVersionExpected={"1.2.0",{2021,10,17}};


(* ::Input::Initialization:: *)
(* xConf: Cosmological perturbations about homogeneous space-times *)

(* Copyright (C) 2025-2026 Cyril Pitrou, Guillaume Faye *)

(* This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License as
 published by the Free Software Foundation; either version 2 of
 the License,or (at your option) any later version.

This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 General Public License for more details.

You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place-Suite 330, Boston, MA 02111-1307,
  USA. 
*)


(* ::Input::Initialization:: *)
(* :Title: xConf *)

(* :Author: Cyril Pitrou, Guillaume Faye *)

(* :Summary: Computer algebra for conformal transformations *)
 
(* :Context: xAct`xConf` *)

(* :Package Version: 0.0.1 *)

(* :Copyright: Cyril Pitrou, Guillaume Faye (2025-2026) *)

(* :Source: xConf.nb *)

(* :Mathematica Version: 14.0 and later *)

(* :Limitations: *)


(* ::Input::Initialization:: *)
If[Unevaluated[xAct`xCore`Private`$LastPackage]===xAct`xCore`Private`$LastPackage,xAct`xCore`Private`$LastPackage="xAct`xConf`"];


(* ::Input::Initialization:: *)
Off[General::nostdvar]
Off[General::nostdopt]
BeginPackage["xAct`xConf`",{"xAct`xTensor`","xAct`xPerm`","xAct`xCore`","xAct`ExpressionManipulation`"}]


(* ::Input::Initialization:: *)
If[Not@OrderedQ@Map[Last,{$xTensorVersionExpected,xAct`xTensor`$Version}],Throw@Message[General::versions,"xTensor",xAct`xTensor`$Version,$xTensorVersionExpected]]


(* ::Input::Initialization:: *)
Print[xAct`xCore`Private`bars];
Print["Package xAct`xConf`  version ",$Version[[1]],", ",$Version[[2]]];
Print["CopyRight (C) 2025-2026, Cyril Pitrou, Guillaume under the General Public License."];


(* ::Input::Initialization:: *)
Off[General::shdw]
xAct`xConf`Disclaimer[]:=Print["These are points 11 and 12 of the General Public License:\n\nBECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW. EXCEPT WHEN OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES PROVIDE THE PROGRAM `AS IS\.b4 WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU. SHOULD THE PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.\n\nIN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR DAMAGES, INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES."]
On[General::shdw]


(* ::Input::Initialization:: *)
If[xAct`xCore`Private`$LastPackage==="xAct`xConf`",
Unset[xAct`xCore`Private`$LastPackage];
Print[xAct`xCore`Private`bars];
Print["These packages come with ABSOLUTELY NO WARRANTY; for details type Disclaimer[]. This is free software, and you are welcome to redistribute it under certain conditions. See the General Public License for details."];
Print[xAct`xCore`Private`bars]];


(* ::Input::Initialization:: *)
$CovDFormat="Prefix";
Message[General::nostdvar,"$CovDFormat","Prefix"];


(* ::Input::Initialization:: *)
(*** VERSIONS ***)

$Version::usage="$Version is a global variable giving the version of the package xConf in use.";

$xTensorVersionExpected::usage="$xTensorVersionExpected is a global variable giving the oldest possible version of the package xTensor which is required by the version of the package xConf in use.";



(* ::Input::Initialization:: *)
(*** BOOLEANS ***)


(* ::Input::Initialization:: *)
(*** ERROR MESSAGES ***)



(* ::Input::Initialization:: *)
(*** FUNCTIONS ***)

AbstractConformal::usage = "";

Conformal::usage = "Conformal[metricfinal][metric1,metric2][expr] performs a conformal transformation of 'expr' from 'metric1' to 'metric2' and expresses the result in terms of 'metricfinal' (along with its associated covariant derivative and curvature tensors). If needed, the function first reformulates 'expr' in terms of 'metric1'. The two metrics 'metric1' and 'metric2' have to be conformally related by DefConformalMetric. 

Conformal[metric1,metric2][expr] provides the final result with respect to the ambient metric, which is the first metric defined on the manifold.";

ConformalWeight::usage = "ConformalWeight[tensor[inds]] specifies the power of the conformal factor applied in the conformal transformation of the tensor 'tensor'. It corresponds to the number of down indices, minus the number of up indices, plus the quantity ConformalWeight[tensor] (without the indices). The latter is set by default to zero. 

For instance, in the setting ConformalWeight[tensor] = 0, we have: ConformalWeight[tensor[\[Alpha],\[Beta]]] = -2, and ConformalWeight[tensor[-\[Alpha],-\[Beta]]] = 2."; (* Is it the most natural thing to do? *)

DefConformalMetric::usage = "DefConformalMetric[g,S] defines a metric conformally related to 'g', with the conformal factor 'S'. The new metric is named 'gS2', and its inverse is given by 'Inv[gS2]'. If other metrics are conformally related to 'g', then 'gS2' is related to them by transitivity of the conformal transformation. ";

(********** The following command, ToMetric, will have to be re-edited after its modification. **********)

ToMetric::usage = "ToMetric[expr,metric] formulates 'expr' in terms of 'metric', and its associated covariant derivative and curvature tensors.";



(* ::Input::Initialization:: *)
(*** RESERVED WORDS AND PROTECTED NAMES ***)



(* ::Input::Initialization:: *)
Begin["xAct`xConf`Private`"]


(* ::Input::Initialization:: *)
(** Why a scalar head inside a scalar function? **)
(** We choose that the Scalar head should be removed**)
Unprotect[xAct`xTensor`NoScalar];
xAct`xTensor`NoScalar[f_?ScalarFunctionQ[expr_]]:=f[NoScalar@expr]
Protect[xAct`xTensor`NoScalar]; (* why this choice? *)


(* ::Input::Initialization:: *)
(*** DEFAULT OPTIONS AND PROTECTED NAMES ***)



(* ::Input::Initialization:: *)
Block[{Print},DefInertHead[ProtectMyScalar,LinearQ->True]];

FixProtectScalar:=ProtectMyScalar[expr_]:>ProtectMyScalar[xAct`xTensor`Private`MathInputExpand[expr]]


(* ::Input::Initialization:: *)
(*** HANDLING EXPRESSIONS ***)

collect[expr_]:=Collect[expr,$PerturbationParameter,Identity] (* Identity is useless *)

(** fix by Jolyon Bloomfield. No Idea if this works or not. This should correct the bug found by Adam Solomon in August 2014 **)
fixScalar:=Scalar[expr_]:>Scalar[xAct`xTensor`Private`MathInputExpand[expr]]
org[expr_]:=Collect[ContractMetric[expr],$PerturbationParameter,ToCanonical[#/.fixScalar]&]
(* Old org before the fix*)
(* org[expr_]:=Collect[ContractMetric[expr],$PerturbationParameter,ToCanonical[#/.fixScalar]&]*)


TCnoCM[expr_]:=ToCanonical[expr,UseMetricOnVBundle->None]


(* ::Input::Initialization:: *)
(** Miscellaneous **)

$DefInfoQ=True;
(* If set to 'False', the information messages are not printed. *)

DefTensorQ[symb_]:=Cases[$Tensors,symb]==={symb}
(* If 'symb' has been defined as a tensor, then DefTensorQ[symb] returns 'True'; otherwise it returns 'False'. *) (* Why not using xTensorQ? *)


(* ::Input::Initialization:: *)
IndicesDown[expr_]:= Fold[SeparateMetric[First@$Metrics][#1,#2]&,expr,Select[IndicesOf[Up][expr],Not@LIndexQ[#]&]]
IndicesUp[expr_]:= Fold[SeparateMetric[First@$Metrics][#1,#2]&,expr,Select[IndicesOf[Down][expr],Not@LIndexQ[#]&]]


IndicesDown[0]:=0 ;(* This is to avoid bugs...*)
IndicesUp[0]:=0 ;


(* ::Input::Initialization:: *)
ConformalMetricName[g_?MetricQ,1]:=g;
ConformalMetricName[g_?MetricQ,conffactor_]:=SymbolJoin[g,conffactor,2]; (* conffactor must be a head *)


(* ::Input::Initialization:: *)
DefConformalMetric[g_?MetricQ,conffactor_Symbol]:=Module[{n,q},Catch@With[{M=ManifoldOfCovD@CovDOfMetric@g,CD=CovDOfMetric@g},
With[{i1=DummyIn[Tangent[M]],i2=DummyIn[Tangent[M]],sy1=SymbolOfCovD[CD][[1]],sy2=SymbolOfCovD[CD][[2]],metlist=Select[$Metrics,InducedFrom[#]===Null&]},

If[Not@DefTensorQ[conffactor],DefTensor[conffactor[],{M},PrintAs->ToString[conffactor]]];


Off[DefMetric::old];(* Annoying message turned off*)
If[Not[DefTensorQ[ConformalMetricName[g,conffactor]]],


DefMetric[-1,ConformalMetricName[g,conffactor][-i1,-i2],SymbolJoin[CD,conffactor,2],{":",StringJoin[sy2,ToString[conffactor],"2"]},PrintAs->StringJoin["[",PrintAs[g],"\!\("<>PrintAs[conffactor]<>"\^2\)","]"(*ToString[conffactor],ToString[2]*)],ConformalTo->{g[-i1,-i2],conffactor[]^2}];

]; (* the sign of the determinant must be the same as the original metric *)
(* Can the postfix symbol be made of more than one characters? *)
On[DefMetric::old];

Off[ConformalRules::unknown];
(* We use the error sent by ConformalRules to check whether or not the metric in the list metlist is conformally related to the metric g.
If it is the case we enforce transitivity of the conformal relations.*)
If[Catch@ConformalRules[g,#]=!=Null,
SetConformalTo[SymbolJoin[g,conffactor,2][-i1,-i2], {#[-i1, -i2],ConformalFactor[g,#]* conffactor[]^2}]]&/@metlist;
On[ConformalRules::unknown];

]
]
]

SetNumberOfArguments[DefConformalMetric,2]
Protect[DefConformalMetric];


(* ::Input::Initialization:: *)
ConfHead[_,_][delta[\[Mu]_,\[Nu]_]]:=delta[\[Mu],\[Nu]](* Because I know that when there is delta function in an expression, it is always with one index up and one down...so this should be fine.*)

 
ConfHead[metric1_?MetricQ,metric2_?MetricQ][ConfHead[metric2_?MetricQ,metric1_?MetricQ][expr_]]:=expr (* Not necessary *)
ConfHead[metric1_?MetricQ,metric1_?MetricQ][expr_]:=expr
ConfHead[metric2_?MetricQ,metric3_?MetricQ][ConfHead[metric1_?MetricQ,metric2_?MetricQ][expr_]]:=ConfHead[metric1,metric3][expr]


(* Thanks to Jolyon Bloomfield and Leo Stein, the definition below should be much more general. *)
(* The main reason is that the delta tensor is greedy and wants to contract through expressions like
ConfHead[...][f[Scalar[phi[]]]].*)
ConfHead/:IsIndexOf[ConfHead[_,_][_],_,delta]:=False;


(* ::Input::Initialization:: *)
$BoolBasicConformalWeight=True;

WeightOfIndicesList[indices_List]:=With[{aindex=Select[indices,Not[LIndexQ[#]]&]},Length@Select[aindex,DownIndexQ]-Length@Select[aindex,UpIndexQ]]

(* Conformal weight of a tensor *)
ConformalWeight[tens_?xTensorQ]:=0;
ConformalWeight[tens_?xTensorQ[indices___]]:=ConformalWeight[tens]+WeightOfIndicesList[{indices}]

ConformalWeight[f_?ScalarFunctionQ]:=0;


(* ::Input::Initialization:: *)
MyChangeChristoffel[expr_,cd_,cd_]:=expr

MyChangeChristoffel[expr_,cd2list_List,cd1_]:=Fold[MyChangeChristoffel[#1,#2,cd1]&,expr,cd2list]

MyChangeChristoffel[expr_,cd2_,cd1_]:=With[{vb=Tangent[ManifoldOfCovD[cd1]]},With[{chr1=Head[(Christoffel[cd1])[DummyIn[vb],-DummyIn[vb],-DummyIn[vb]]],chr2=Head[(Christoffel[cd2])[DummyIn[vb],-DummyIn[vb],-DummyIn[vb]]],chr21=Head[(Christoffel@@Sort[{cd2,cd1}])[DummyIn[vb],-DummyIn[vb],-DummyIn[vb]]],sign=Order[cd2,cd1]},
expr/.chr2[i1_,i2_,i3_]:>chr1[i1,i2,i3]+sign*chr21[i1,i2,i3]
]
]


(* ::Input::Initialization:: *)
ExistInertHead[head_]:=Length@Cases[$InertHeads,head]>0

RulesConf[metric1_?MetricQ,metric2_?MetricQ]:=(
Module[{cd1,cd2,confa2,confa,M,res,inds},cd1=CovDOfMetric[metric1];cd2=CovDOfMetric[metric2];


confa2=ConformalFactor[metric2,metric1];
confa=Sqrt[ConformalFactor[metric2,metric1]]/.Sqrt[x_^n_?EvenQ]:>x^(n/2);
(*In principle this should give a or 1/a depending if we go from metric1 to metric2 or metric2 to metric1*)

M=ManifoldOfCovD[cd1];
inds=DummyIn/@Table[Tangent[M],{Range[4]}];
With[{i1=inds[[1]],i2=inds[[2]],i3=inds[[3]],i4=inds[[4]]},

(* Once confheads are put on expression (as a result of a formal conformal transformation) then we remove them by expressing what they mean in function of the original tensors and the scale factor *)
res=
{RuleDelayed@@Hold[ConfHead[metric1,metric2][(Riemann@cd1)[i1_,i2_,i3_,i4_]],confa^(WeightOfIndicesList[{i1,i2,i3,i4}]-2)(Riemann@cd2)[i1,i2,i3,i4]],
RuleDelayed@@Hold[ConfHead[metric1,metric2][(Ricci@cd1)[i1_,i2_]],confa^(WeightOfIndicesList[{i1,i2}]-2)(Ricci@cd2)[i1,i2]],
RuleDelayed@@Hold[ConfHead[metric1,metric2][(RicciScalar@cd1)[]],(RicciScalar@cd2)[]],
RuleDelayed@@Hold[ConfHead[metric1,metric2][(Christoffel@cd1)[i1_,i2_,i3_]],confa^(WeightOfIndicesList[{i1,i2,i3}]-1)*(Christoffel@cd2)[i1,i2,i3]],


RuleDelayed@@Hold[ConfHead[metric1,metric2][(Determinant[metric1,AIndex])[]],(* This is removed because now xTensor is patched confa2^DimOfManifold[M]. Thanks to Leo Stein.*)

(Determinant[metric2,AIndex])[]

],

(* This line below is not working well.  The problem should be considered later when xTensor knows how to handle the epsilon of a frozen metric. So this really works only when metric1 is the ambient metric... *)
RuleDelayed@@Hold[ConfHead[metric1,metric2][(epsilon@metric1)[inds__?(Length[{#}]===DimOfManifold[M]&)]],(*confa2^(DimOfManifold[M]/2)*)confa^(WeightOfIndicesList[{inds}])(epsilon@metric1)[inds]],

(* Not really satisfactory but minimalist for scalar functions *)
(* Following Leo Stein suggestion, we allow the scalar function to have several arguments *)
ConfHead[metric1,metric2][f_?ScalarFunctionQ[arg___]]:>Simplify[confa2^((ConformalWeight[f])/2),Assumptions->confa>0]f[arg],

ConfHead[metric1,metric2][tens_?xTensorQ[indss___]]:>Simplify[confa2^(ConformalWeight[tens[indss]]/2),Assumptions->confa>0]tens[indss]
};

res
]
]
)


(* ::Input::Initialization:: *)

ToMetric[expr_,metric1_?MetricQ]:=If[InducedFrom@metric1=!=Null,expr,
Module[{res,preexpression},
Off[ConformalRules::unknown];
With[{cd1=CovDOfMetric[metric1],$CovDsNotInduced=Select[Rest@$CovDs,InducedFrom[MetricOfCovD[#]]===Null&]},

(* 2025 I modify this as it does not select correctly the other covariant deriavtives. TODO a revoir *)
(*With[{$CovDsNotInducedRelatedTocd1=Select[$CovDsNotInduced,(Catch@ConformalRules[metric1,MetricOfCovD[#]]=!=Null)&]},*)
With[{$CovDsNotInducedRelatedTocd1=Select[$CovDsNotInduced,(ConformalRules[metric1,MetricOfCovD[#]]=!={})&]},

(* I think I would like to remove the //ContractMetric//ToCanonical below but this introduces bugs*)
preexpression=(Identity[expr]//ProjectorToMetric//EinsteinToRicci//WeylToRiemann//ContractMetric//ToCanonical);
(*preexpression=(SeparateMetric[][expr]//ProjectorToMetric//EinsteinToRicci//WeylToRiemann);*)
(*Print["preexpression in Tometric is ",preexpression];*)

res=ChangeCovD[#,$CovDsNotInduced,cd1]&@
ChristoffelToGradConformal[#,$CovDsNotInducedRelatedTocd1,cd1]&@
MyChangeChristoffel[#,$CovDsNotInducedRelatedTocd1,cd1]&@
ChangeCovD[#,$CovDsNotInduced,cd1]&@
ChangeCurvature[#,$CovDsNotInduced,cd1]&@preexpression;

Off[ConformalRules::unknown];
Fold[(#1/.ConformalRules[MetricOfCovD[#2],metric1])&,res,$CovDsNotInducedRelatedTocd1]
]
]
]
];

ToMetric[expr_]:=ToMetric[expr,First@$Metrics];

SetNumberOfArguments[ToMetric,{1,2}]
Protect[ToMetric];


(* ::Input::Initialization:: *)
InverseMetricQ[x_?xTensorQ]:=With[{tid=TensorID@x},(Length@tid>0)&&(tid[[1]]===xAct`xTensor`Private`InvMetric)]
InverseMetricQ[_]:=False


(* ::Input::Initialization:: *)
SeparateIndicesDownOfInverseMetric[invmetric_?InverseMetricQ][expr_]:=Fold[SeparateMetric[First@$Metrics][#1,#2]&,expr,IndicesOf[Down,invmetric][expr]];
SeparateIndicesDownOfInverseMetric[_][expr_]:=expr


(* ::Input::Initialization:: *)
AbstractConformal[metric1_?MetricQ,metric2_?MetricQ][expr_]:=Module[{cdb,cd1,cd2,res,res2,(*oldpre,*)resbis,exprnoproj,M,i1,i2,beforeputtingconfheads,IDInvMetric,res3,firstmetric},
(* The conflict with ScreenDollarIndicea has now been solved. So there is no need to redefine temporarily $PrePrint*)
(*oldpre=$PrePrint;$PrePrint=Identity;*)

(* we define the Covds associated with the metric. The starting metric is metric1, the conformally transformed metric is metric2, and metricbase i the base metric for raising and lowering indiced. It might be one of the other two, but it might not be...*)
cd1=CovDOfMetric[metric1];Off[ConformalFactor::"unknown"];
cd2=CovDOfMetric[metric2];

(* TODO put a check that the expression has no projectors *)
exprnoproj=expr(*//ProjectorToMetric*);

M=ManifoldOfCovD[cd1];
i1=DummyIn[Tangent[M]];
i2=DummyIn[Tangent[M]];

Print["Stage 1"];
beforeputtingconfheads=ToMetric[SeparateMetric[][exprnoproj],metric1];

Print["beforeputtingconfheads ",beforeputtingconfheads];
Print["Stage 2"];

(* Then we place the ConfHead on every expression to perform formally the conformal transformation. *)
res=(beforeputtingconfheads
(* Dirty case of scalar functions *)
/.f_?ScalarFunctionQ[ex___]:>ConfHead[metric1,metric2][f[ex]]
(* tensors *)
/.tens_?xTensorQ[inds___]:>ConfHead[metric1,metric2][tens[inds]]
(* Covariant derivatives *)
/.cd1[i1_?DownIndexQ]:>cd2[i1]
(* Now that we have ConfHead everywhere we need to remove the head by specifying the change*)
(* First Obvious rules for metric and inverse metric*)
/.ConfHead[metric1,metric2][metric1[i1_?DownIndexQ,i2_?DownIndexQ]]:>metric2[i1,i2]
/.ConfHead[metric1,metric2][Inv[metric1][i1_?UpIndexQ,i2_?UpIndexQ]]:>Inv[metric2][i1,i2]);

Print["Stage 3"];
res
]

(* In case the base metric is unspecified, it is the base metric of course...*)
(*AbstractConformal[metric1_?MetricQ,metric2_?MetricQ][expr_]:=AbstractConformal[metric1,metric2][expr]*)




(* ::Input::Initialization:: *)
Conformal[metricbase_?MetricQ][metric1_?MetricQ,metric2_?MetricQ][expr_]:=Module[{cdb,cd1,cd2,res,res2,(*oldpre,*)resbis,exprnoproj,M,i1,i2,beforeputtingconfheads,IDInvMetric,res3,firstmetric},
(* The conflict with ScreenDollarIndicea has now been solved. So there is no need to redefine temporarily $PrePrint*)
(*oldpre=$PrePrint;$PrePrint=Identity;*)

(* we define the Covds associated with the metric. The starting metric is metric1, the conformally transformed metric is metric2, and metricbase i the base metric for raising and lowering indiced. It might be one of the other two, but it might not be...*)
cdb=CovDOfMetric[metricbase];
cd1=CovDOfMetric[metric1];Off[ConformalFactor::"unknown"];
cd2=CovDOfMetric[metric2];


exprnoproj=expr//ProjectorToMetric;

M=ManifoldOfCovD[cd1];
i1=DummyIn[Tangent[M]];
i2=DummyIn[Tangent[M]];

IDInvMetric=SeparateIndicesDownOfInverseMetric[Inv[metric1]];

beforeputtingconfheads=IDInvMetric[(IndicesDown@ToMetric[exprnoproj,metric1])/.Scalar[ex_]:>Scalar[IndicesDown[ex]]/.sf_?ScalarFunctionQ[args___]:>sf@@IndicesDown/@{args}]/.Scalar[ex_]:>Scalar[IDInvMetric[ex]]/.sf_?ScalarFunctionQ[args___]:>sf@@IDInvMetric/@{args};
(* Above we make sure that IndicesDown and SeparateIndicesDownOfInverseMetric goes inside the scalar Head*)

(*We use ToMetric to have only references to the metric1 and its associated CovD and curvature tensors *)
(*Print["beforeputtingconfheads ",beforeputtingconfheads];*)

(* Then we place the ConfHead on every expression to perform formally the conformal transformation. *)
res=(beforeputtingconfheads
(* Dirty case of scalar functions *)
/.f_?ScalarFunctionQ[ex___]:>ConfHead[metric1,metric2][f[ex]]
(* tensors *)
/.tens_?xTensorQ[inds___]:>ConfHead[metric1,metric2][tens[inds]]
(* Covariant derivatives *)
/.cd1[i1_?DownIndexQ]:>cd2[i1]
(* Now that we have ConfHead everywhere we need to remove the head by specifying the change*)
(* First Obvious rules for metric and inverse metric*)
/.ConfHead[metric1,metric2][metric1[i1_?DownIndexQ,i2_?DownIndexQ]]:>metric2[i1,i2]
/.ConfHead[metric1,metric2][Inv[metric1][i1_?UpIndexQ,i2_?UpIndexQ]]:>Inv[metric2][i1,i2]);

(* And then all other rules to remove the ConfHead*)


(* A bug with Scalar expressions. I have added a NoSCalar . Check if this works fine for the rest. It seems so.*)
(* It seems to be fine so I should post the modification*)
(* This avoids the appearance of sums inside SymmetryOf which were resulting from a removed Scalar head.*)
resbis=NoScalar[res//.RulesConf[metric1,metric2]];


(* So here we have conformally transformed the expression, but now we want to express it in function of the original metric and orginal covD etc...
Indeed at that point, we still have the second metric, and the Riemann of the second metric for instance. SO we use again ToMetric*)

(*$PrePrint=oldpre;*)

On[ConformalFactor::"unknown"];
Off[ToCanonical::"cmods"];

(* 2025 modification. See if this is better or not. It seems not ! *)
res2=ToCanonical@ContractMetric@NoScalar[ToMetric[resbis,metricbase]];
(*res2=NoScalar[ToMetric[resbis,metricbase]];*)



(* Cyril Pitrou : March 2018. I have added an attempt to patch the problems I have with multiples frozen metrics coming from multiple conformal transformations.*)
(* I think it works... The idea is that since for frozen metrics some simplifications to Dirac do not occur when they should, I switch to active metric, let xTensor put the Dirac, and switch back to the desired metric. *)
(* It happened that some definitions in xTensor were missing for frozen metrics. As of 28/03/2018 version of xAct this should be fixed and the patch I am adding below should not be necessary...*) (* But I find it is necessaryTODO investigate this in 2025 *)

(* 2025 modification: I would like to remove this. But I have noticed a bug so I must investigate why TODO.*)
firstmetric=First@$Metrics;
If[metricbase=!=firstmetric,
res3=ContractMetric[((ToCanonical@NoScalar@ContractMetric[res2/.ConformalRules[metricbase,firstmetric]])/.ConformalRules[firstmetric,metricbase])];,
res3=res2;];

On[ToCanonical::"cmods"];
res3
]

(* In case the base metric is unspecified, it is the base metric of course...*)
Conformal[metric1_?MetricQ,metric2_?MetricQ][expr_]:=Conformal[First@$Metrics][metric1,metric2][expr]




(* ::Input::Initialization:: *)
On[RuleDelayed::rhs];


(* ::Input::Initialization:: *)
End[]
EndPackage[]
