Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "       ",
 StyleBox["xConf",
  FontSize->36],
 StyleBox["    ",
  FontSize->24],
 " "
}], "Title",
 InitializationCell->True,
 FontSize->48,ExpressionUUID->"f99dad05-75f3-4b56-86be-f8a57408dfa6"],

Cell[CellGroupData[{

Cell["\<\
Authors
\
\>", "Subsection",
 InitializationCell->True,
 FontSize->18,ExpressionUUID->"885e8cc1-1e76-4a55-b1fb-4e2e21f66119"],

Cell["\<\
This package is designed for handling formally conformal transformation
https://www2.iap.fr/users/pitrou/xconf.htm
        
Version 0.0.1   (19/04/2025)\
\>", "Text",
 InitializationCell->True,
 FontSize->14,ExpressionUUID->"1be3aed0-586e-4a04-bdb6-ef56fd11cc66"],

Cell[TextData[{
 " It is developed by Cyril ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["Pitrou", "1"], TraditionalForm]],ExpressionUUID->
  "52d94b2c-1a28-4e58-916f-dc736e1b4f18"],
 ", Guillaume Faye",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["", "2"], TraditionalForm]],ExpressionUUID->
  "db0d821b-cda2-407e-b179-b85c24a26ef9"],
 "\n \t\n ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["", "1"], TraditionalForm]],ExpressionUUID->
  "19ea2235-580b-4053-88e5-7127fe05f56f"],
 StyleBox["Institute of Astrophysics of Paris (IAP), France",
  FontSize->13],
 "\n",
 StyleBox["Email: pitrou@iap.fr",
  FontSize->13],
 "\n\n",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["", "2"], TraditionalForm]],ExpressionUUID->
  "7fe54190-ef2e-4933-be7f-8f30b4cb73a2"],
 StyleBox[" Institute of Astrophysics of Paris (IAP), France\nEmail: \
faye@iap.fr",
  FontSize->13],
 "\n \t\n \t\nDetails of the general algorithm and methods for perturbations \
about any space-time background can be found on a publication soon to come."
}], "Text",
 InitializationCell->True,
 FontSize->14,ExpressionUUID->"2c40a56e-a120-4f73-98dc-047c26a43f60"],

Cell[TextData[{
 "This algorithm is based runs on top of the xAct/xTensor package developed \
by Jos\[EAcute] M. Mart\[IAcute]n-Garc\[IAcute]a.",
 StyleBox["\n ",
  FontSize->13],
 StyleBox[ButtonBox["http://www.xact.es",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://metric.iem.csic.es/Martin-Garcia/"], None}],
  FontSize->13],
 "\n\t\nIt is tested for xAct_1.1.3 under Mathematica 14.0."
}], "Text",
 InitializationCell->True,
 FontSize->14,ExpressionUUID->"93d3d8b1-260d-4f5f-b6c6-89dd9daf1c39"],

Cell[CellGroupData[{

Cell["Dates and versions", \
"Subsubsection",ExpressionUUID->"c6622465-02d2-407f-920e-9a27634248cb"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Date", "[", "]"}]], "Input",
 CellLabel->"In[1]:=",ExpressionUUID->"861bfeef-ab0c-4674-9fab-2c2f141e6bf8"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "2025", ",", "4", ",", "4", ",", "6", ",", "37", ",", 
   "40.517624`8.360218948157627"}], "}"}]], "Output",
 CellLabel->"Out[1]=",ExpressionUUID->"26ecc728-59d9-4748-a317-fb04854f88eb"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"xAct`xConf`$Version", "=", 
   RowBox[{"{", 
    RowBox[{"\"\<0.0.1\>\"", ",", 
     RowBox[{"{", 
      RowBox[{"2025", ",", "04", ",", "04"}], "}"}]}], "}"}]}], 
  ";"}]], "Input",
 InitializationCell->True,
 CellLabel->"In[2]:=",ExpressionUUID->"21e32b71-301d-4111-ad5c-76108ff548fa"],

Cell[BoxData[
 RowBox[{
  RowBox[{"xAct`xConf`$xTensorVersionExpected", "=", 
   RowBox[{"{", 
    RowBox[{"\"\<1.2.0\>\"", ",", 
     RowBox[{"{", 
      RowBox[{"2021", ",", "10", ",", "17"}], "}"}]}], "}"}]}], 
  ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"4306eea9-2d82-45fd-9036-066941c5b44f"]
}, Open  ]],

Cell[CellGroupData[{

Cell["History", \
"Subsubsection",ExpressionUUID->"aa8f580b-ec4c-4248-8826-c71e75935290"],

Cell["\<\
Future modifications :
-disformal transformations\
\>", "Text",ExpressionUUID->"1c33094c-bb7e-48c9-af10-22fe8e86f5f0"],

Cell["", "Text",ExpressionUUID->"64d1fe2a-23a3-41cd-9480-dd682f4a283d"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["1. Initialization", "Subsection",
 InitializationCell->True,
 FontColor->RGBColor[
  0.20389105058365758`, 0.38530556191348136`, 
   0.9685969329365988],ExpressionUUID->"4da7a881-ffe7-41a4-92fb-61a35a2396e7"],

Cell[CellGroupData[{

Cell["1.1. GPL", \
"Subsubsection",ExpressionUUID->"1bb82931-1361-4231-aaa1-8ea1e0592545"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"xConf", ":", " ", 
    RowBox[{
     RowBox[{
     "Cosmological", " ", "perturbations", " ", "about", " ", "homogeneous", 
      " ", "space"}], "-", "times"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"Copyright", " ", 
      RowBox[{"(", "C", ")"}], " ", "2025"}], "-", 
     RowBox[{"2026", " ", "Cyril", " ", "Pitrou"}]}], ",", " ", 
    RowBox[{"Guillaume", " ", "Faye"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
     "This", " ", "program", " ", "is", " ", "free", " ", "software"}], ";", 
     " ", 
     RowBox[{"you", " ", "can", " ", "redistribute", " ", "it", " ", 
      RowBox[{"and", "/", "or"}], "\[IndentingNewLine]", " ", "modify", " ", 
      "it", " ", "under", " ", "the", " ", "terms", " ", "of", " ", "the", 
      " ", "GNU", " ", "General", " ", "Public", " ", "License", " ", "as", 
      "\[IndentingNewLine]", " ", "published", " ", "by", " ", "the", " ", 
      "Free", " ", "Software", " ", "Foundation"}], ";", " ", 
     RowBox[{
     "either", " ", "version", " ", "3", " ", "of", "\[IndentingNewLine]", 
      " ", "the", " ", "License"}]}], ",", " ", 
    RowBox[{"or", " ", 
     RowBox[{"(", 
      RowBox[{"at", " ", "your", " ", "option"}], ")"}], " ", "any", " ", 
     "later", " ", 
     RowBox[{
     "version", ".", "\[IndentingNewLine]", "\[IndentingNewLine]", "This"}], 
     " ", "program", " ", "is", " ", "distributed", " ", "in", " ", "the", 
     " ", "hope", " ", "that", " ", "it", " ", "will", " ", "be", " ", 
     "useful"}], ",", "\[IndentingNewLine]", "  ", 
    RowBox[{
     RowBox[{"but", " ", "WITHOUT", " ", "ANY", " ", "WARRANTY"}], ";", " ", 
     RowBox[{
     "without", " ", "even", " ", "the", " ", "implied", " ", "warranty", " ",
       "of", "\[IndentingNewLine]", " ", "MERCHANTABILITY", " ", "or", " ", 
      "FITNESS", " ", "FOR", " ", "A", " ", "PARTICULAR", " ", 
      RowBox[{"PURPOSE", ".", " ", "See"}], " ", "the", " ", "GNU", 
      "\[IndentingNewLine]", " ", "General", " ", "Public", " ", "License", 
      " ", "for", " ", "more", " ", 
      RowBox[{
      "details", ".", "\[IndentingNewLine]", "\[IndentingNewLine]", "You"}], 
      " ", "should", " ", "have", " ", "received", " ", "a", " ", "copy", " ",
       "of", " ", "the", " ", "GNU", " ", "General", " ", "Public", " ", 
      "License", "\[IndentingNewLine]", " ", "along", " ", "with", " ", 
      "this", " ", "program"}], ";", " ", 
     RowBox[{"if", " ", "not"}]}], ",", " ", 
    RowBox[{
    "write", " ", "to", " ", "the", " ", "Free", " ", "Software", 
     "\[IndentingNewLine]", " ", "Foundation"}], ",", " ", 
    RowBox[{"Inc", "."}], ",", " ", 
    RowBox[{
     RowBox[{"59", " ", "Temple", " ", "Place"}], "-", 
     RowBox[{"Suite", " ", "330"}]}], ",", " ", "Boston", ",", " ", 
    RowBox[{
     RowBox[{"MA", " ", "02111"}], "-", "1307"}], ",", "\[IndentingNewLine]", 
    "  ", 
    RowBox[{"USA", "."}]}], " ", "\[IndentingNewLine]", "*)"}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"54e43a27-293d-4e1d-9006-de61d37595bc"],

Cell["", "Text",ExpressionUUID->"732dae2e-5c6c-452b-a956-9fa1d9585755"]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.2. Info package", \
"Subsubsection",ExpressionUUID->"149dd31c-dd6f-4930-bc54-a9067d4d9bd1"],

Cell["\<\
(* :Title: xConf *)

(* :Author: Cyril Pitrou, Guillaume Faye *)

(* :Summary: Computer algebra for conformal transformations *)
 
(* :Context: xAct`xConf` *)

(* :Package Version: 0.0.1 *)

(* :Copyright: Cyril Pitrou, Guillaume Faye (2025-2026) *)

(* :Source: xConf.nb *)

(* :Mathematica Version: 14.0 and later *)

(* :Limitations: *)\
\>", "Input",
 PageWidth->PaperWidth,
 CellMargins->{{60, -272}, {Inherited, Inherited}},
 InitializationCell->True,
 CellLabel->"In[5]:=",ExpressionUUID->"f296bbce-9b83-404c-b253-44efb30ed1c1"],

Cell["", "Text",ExpressionUUID->"101adff0-4664-427d-81e2-b8512e7b9456"]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.3. Begin package", \
"Subsubsection",ExpressionUUID->"f7336276-8334-4924-8f5d-bbe1e572da5f"],

Cell["\<\

Decide what is the last package being read:\
\>", "Text",ExpressionUUID->"861691f8-c3de-4a4d-999d-d4bc7f068474"],

Cell[BoxData[
 RowBox[{
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Unevaluated", "[", "xAct`xCore`Private`$LastPackage", "]"}], "===",
      "xAct`xCore`Private`$LastPackage"}], ",", 
    RowBox[{"xAct`xCore`Private`$LastPackage", "=", "\"\<xAct`xConf`\>\""}]}],
    "]"}], ";"}]], "Input",
 InitializationCell->True,
 CellLabel->"In[22]:=",ExpressionUUID->"f3ff6f56-e684-4050-bdff-c7390e0dbf07"],

Cell[CellGroupData[{

Cell[BoxData["xAct`xCore`Private`$LastPackage"], "Input",
 CellLabel->"In[23]:=",ExpressionUUID->"cfd61365-dfaa-499c-a280-2931b5d5ef4e"],

Cell[BoxData["\<\"xAct`xConf`\"\>"], "Output",
 CellLabel->
  "Out[23]=",ExpressionUUID->"8de7943e-131c-42ef-a2c2-77a9bd4a812d"]
}, Open  ]],

Cell["\<\

Explicit (not hidden) import of other packages:\
\>", "Text",ExpressionUUID->"97017f56-9566-4d83-bab2-1b93b48824c8"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Off", "[", 
  StyleBox[
   RowBox[{"General", "::", "nostdvar"}], "MessageName"], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Off", "[", 
  StyleBox[
   RowBox[{"General", "::", "nostdopt"}], "MessageName"], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"BeginPackage", "[", 
  RowBox[{"\"\<xAct`xConf`\>\"", ",", 
   RowBox[{"{", 
    RowBox[{
    "\"\<xAct`xTensor`\>\"", ",", "\"\<xAct`xPerm`\>\"", ",", 
     "\"\<xAct`xCore`\>\""}], "}"}]}], "]"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"5203ccfa-df42-4bb6-9101-cbe5326092f2"],

Cell[CellGroupData[{

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[24]:=",ExpressionUUID->"6756aa94-1ef3-481e-af4d-08ef1aec29e9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`xPerm`  version \"\>", 
   "\[InvisibleSpace]", "\<\"1.2.3\"\>", "\[InvisibleSpace]", "\<\", \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2015", ",", "8", ",", "23"}], "}"}]}],
  SequenceForm["Package xAct`xPerm`  version ", "1.2.3", ", ", {2015, 8, 23}],
  
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[24]:=",ExpressionUUID->"9f07bb3c-ebfd-4526-b892-0e303e609210"],

Cell[BoxData["\<\"CopyRight (C) 2003-2020, Jose M. Martin-Garcia, under the \
General Public License.\"\>"], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[24]:=",ExpressionUUID->"e2c34106-3a8f-4caf-a4e6-7b04de5298f4"],

Cell[BoxData["\<\"Connecting to external mac executable...\"\>"], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[24]:=",ExpressionUUID->"4c518aca-196a-409c-88f8-8072de6deb58"],

Cell[BoxData["\<\"Connection established.\"\>"], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[24]:=",ExpressionUUID->"349ef375-f8cd-4996-9762-7e32ed117a32"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[24]:=",ExpressionUUID->"828ae508-973a-4b67-bff7-6c9ef4cbfe76"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`xTensor`  version \"\>", 
   "\[InvisibleSpace]", "\<\"1.2.0\"\>", "\[InvisibleSpace]", "\<\", \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2021", ",", "10", ",", "17"}], "}"}]}],
  SequenceForm[
  "Package xAct`xTensor`  version ", "1.2.0", ", ", {2021, 10, 17}],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[24]:=",ExpressionUUID->"d2cef0c4-b7b6-4cf8-8f6b-572f2e85db8d"],

Cell[BoxData["\<\"CopyRight (C) 2002-2021, Jose M. Martin-Garcia, under the \
General Public License.\"\>"], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[24]:=",ExpressionUUID->"fed1bdb6-809c-4827-b074-5bf08482bafb"]
}, Open  ]],

Cell[BoxData["\<\"xAct`xConf`\"\>"], "Output",
 CellLabel->
  "Out[26]=",ExpressionUUID->"0fb1bb9c-00aa-4dd0-aefc-85cdeb68b823"]
}, Open  ]],

Cell[TextData[{
 "\nCheck version of ",
 StyleBox["xTensor",
  FontSlant->"Italic"],
 ". We simply compare dates:"
}], "Text",ExpressionUUID->"500ca1b5-50fa-4aa4-8061-0414417a6eb0"],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{
   RowBox[{"Not", "@", 
    RowBox[{"OrderedQ", "@", 
     RowBox[{"Map", "[", 
      RowBox[{"Last", ",", 
       RowBox[{"{", 
        RowBox[{"$xTensorVersionExpected", ",", "xAct`xTensor`$Version"}], 
        "}"}]}], "]"}]}]}], ",", 
   RowBox[{"Throw", "@", 
    RowBox[{"Message", "[", 
     RowBox[{
      RowBox[{"General", "::", "versions"}], ",", "\"\<xTensor\>\"", ",", 
      "xAct`xTensor`$Version", ",", "$xTensorVersionExpected"}], "]"}]}]}], 
  "]"}]], "Input",
 InitializationCell->True,
 CellLabel->"In[27]:=",ExpressionUUID->"013522d0-bdac-4b89-a9be-b2e645a205d0"],

Cell["\<\

Welcome message:\
\>", "Text",ExpressionUUID->"6752c1a8-46d5-453f-aadb-4454a03de4cc"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Print", "[", "xAct`xCore`Private`bars", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<Package xAct`xConf`  version \>\"", ",", 
    RowBox[{"$Version", "[", 
     RowBox[{"[", "1", "]"}], "]"}], ",", "\"\<, \>\"", ",", 
    RowBox[{"$Version", "[", 
     RowBox[{"[", "2", "]"}], "]"}]}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
  "Print", "[", 
   "\"\<CopyRight (C) 2025-2026, Cyril Pitrou, Guillaume under the General \
Public License.\>\"", "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"1e309292-a005-4811-861a-48f429c2168c"],

Cell[CellGroupData[{

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[28]:=",ExpressionUUID->"d8e6fc4b-1182-4d53-8152-bd834ea42041"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`xCore`  version \"\>", 
   "\[InvisibleSpace]", "\<\"0.0.1\"\>", "\[InvisibleSpace]", "\<\", \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2025", ",", "4", ",", "4"}], "}"}]}],
  SequenceForm["Package xAct`xCore`  version ", "0.0.1", ", ", {2025, 4, 4}],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[28]:=",ExpressionUUID->"719a3a5c-44ac-4855-b07e-3b1a3c82514b"],

Cell[BoxData["\<\"CopyRight (C) 2025-2026, Cyril Pitrou, Guillaume under the \
General Public License.\"\>"], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[28]:=",ExpressionUUID->"8acf066b-f1f8-436c-8873-b0b5c191e5df"]
}, Open  ]]
}, Open  ]],

Cell["\<\

We specify the context xAct`xConf` to avoid overriding the Disclaimer of the \
other packages. However, we need to turn off the message General:shdw \
temporarily:\
\>", "Text",ExpressionUUID->"53658b89-7537-464b-bc72-9c7eb2e67ebf"],

Cell[BoxData[{
 RowBox[{"Off", "[", 
  RowBox[{"General", "::", "shdw"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"xAct`xConf`Disclaimer", "[", "]"}], ":=", 
  RowBox[{
  "Print", "[", 
   "\"\<These are points 11 and 12 of the General Public \
License:\\n\\nBECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO \
WARRANTY FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW. EXCEPT \
WHEN OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES \
PROVIDE THE PROGRAM `AS IS\.b4 WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED \
OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF \
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE ENTIRE RISK AS TO \
THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU. SHOULD THE PROGRAM \
PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR OR \
CORRECTION.\\n\\nIN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO \
IN WRITING WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY \
AND/OR REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR \
DAMAGES, INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES \
ARISING OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT \
LIMITED TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED \
BY YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER \
PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE \
POSSIBILITY OF SUCH DAMAGES.\>\"", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"On", "[", 
  RowBox[{"General", "::", "shdw"}], "]"}]}], "Input",
 InitializationCell->True,
 CellLabel->"In[31]:=",ExpressionUUID->"cb9a1383-3c82-42cf-bf0c-101cb94a8c0f"],

Cell["\<\

If this is the last package show the GPL short disclaimer:\
\>", "Text",ExpressionUUID->"3f64679b-b9b9-4569-84e2-00b155b15b17"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"xAct`xCore`Private`$LastPackage", "===", "\"\<xAct`xConf`\>\""}],
     ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Unset", "[", "xAct`xCore`Private`$LastPackage", "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Print", "[", "xAct`xCore`Private`bars", "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
     "Print", "[", 
      "\"\<These packages come with ABSOLUTELY NO WARRANTY; for details type \
Disclaimer[]. This is free software, and you are welcome to redistribute it \
under certain conditions. See the General Public License for details.\>\"", 
      "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Print", "[", "xAct`xCore`Private`bars", "]"}]}]}], "]"}], 
  ";"}]], "Input",
 InitializationCell->True,
 CellLabel->"In[34]:=",ExpressionUUID->"aca621f6-6641-4a38-b2af-5a246e0a1800"],

Cell[CellGroupData[{

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[34]:=",ExpressionUUID->"96ddfcf8-30f9-45ff-bc7f-efd5b79d02d4"],

Cell[BoxData["\<\"These packages come with ABSOLUTELY NO WARRANTY; for \
details type Disclaimer[]. This is free software, and you are welcome to \
redistribute it under certain conditions. See the General Public License for \
details.\"\>"], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[34]:=",ExpressionUUID->"62c1df6b-2f26-443a-99b0-6189bb4122a5"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[34]:=",ExpressionUUID->"1cfc1252-b8de-41ea-9ab9-c03ab8450c88"]
}, Open  ]]
}, Open  ]],

Cell["\<\

Note that symbols in the Global` context cannot be accessed while building \
the package:\
\>", "Text",ExpressionUUID->"607981be-0123-4421-96bf-7853b47cbafa"],

Cell[CellGroupData[{

Cell[BoxData["$ContextPath"], "Input",
 CellLabel->"In[35]:=",ExpressionUUID->"3f045a49-5987-4dce-90d7-99293c87a722"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"xAct`xConf`\"\>", ",", "\<\"xAct`xTensor`\"\>", 
   ",", "\<\"xAct`xPerm`\"\>", ",", "\<\"xAct`xCore`\"\>", 
   ",", "\<\"xAct`ExpressionManipulation`\"\>", ",", "\<\"System`\"\>"}], 
  "}"}]], "Output",
 CellLabel->
  "Out[35]=",ExpressionUUID->"8141abe3-30ba-4609-b3a9-c7cab6d8746f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["$Context"], "Input",
 CellLabel->"In[36]:=",ExpressionUUID->"73abc100-1448-41a4-95c6-077f65ebeac8"],

Cell[BoxData["\<\"xAct`xConf`\"\>"], "Output",
 CellLabel->
  "Out[36]=",ExpressionUUID->"28a3007f-f9df-41a5-8b10-a3b95206ad78"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.4. Options", \
"Subsubsection",ExpressionUUID->"283e04ad-23ed-4f86-bcbe-b6989142635c"],

Cell["\<\

Prefix format for derivatives:\
\>", "Text",ExpressionUUID->"c49114ee-5ab2-41f4-b7e9-3fdcfc57e7e7"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "This", " ", "is", " ", "needed", " ", "because", " ", "we", " ", "give", 
    " ", "a", " ", "different", " ", "name", " ", "for", " ", "each", " ", 
    "CovD", " ", "associated", " ", "to", " ", "each", " ", "new", " ", 
    "conformally", " ", "related", " ", 
    RowBox[{"metric", ".", " ", "But"}], " ", "we", " ", "cannot", " ", 
    "give", " ", "a", " ", "new", " ", "synbol", " ", "for", " ", "postfix", 
    " ", 
    RowBox[{"notation", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"ReportSet", "[", 
     RowBox[{"$CovDFormat", ",", "\"\<Prefix\>\""}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"Message", "[", 
      RowBox[{
       RowBox[{"General", "::", "nostdvar"}], ",", "\"\<$CovDFormat\>\"", 
       ",", "\"\<Prefix\>\""}], "]"}], ";"}], "*)"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"b1c0ffa2-9198-40b0-b27b-9b3d0d99a561"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{"ReportSet", "[", 
    RowBox[{"$PrePrint", ",", "ScreenDollarIndices"}], "]"}], ";"}], 
  "*)"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"f3f5418e-4ac5-4f22-b822-3af85c3d2bd2"],

Cell["\<\
We shall avoid to use ContractMetric, but when using it we want it to \
contract derivatives\
\>", "Text",ExpressionUUID->"9f275cb5-a407-4a31-9911-3a0da3f45290"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ReportSetOption", "[", 
   RowBox[{"ContractMetric", ",", 
    RowBox[{"AllowUpperDerivatives", "\[Rule]", "True"}]}], "]"}], 
  ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"8c890830-539b-49de-ad6f-5fcb17004fc2"],

Cell["\<\
We do not want ToCanonical to use metric to move indices inside the Head \
which defines a conformal frame. Indeed this is index position dependent and \
consider the conformal transformation of a tensor depends on the positioning \
of indices. So we force the use to use ToCanonical in a way which does not \
use the first metric on the VBundle.\
\>", "Text",ExpressionUUID->"7f4172ae-2562-49fa-a813-f86bda57e85c"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ReportSetOption", "[", 
   RowBox[{"ToCanonical", ",", 
    RowBox[{"UseMetricOnVBundle", "\[Rule]", "None"}]}], "]"}], 
  ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"ee1f3ae2-72ad-4bfa-a231-05cbe9b2f793"],

Cell["\<\

We do not modify the option MathLink of CanonicalPerm:\
\>", "Text",ExpressionUUID->"c1664985-3df9-47ea-bb71-bfe3635e2e95"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Options", "[", "CanonicalPerm", "]"}]], "Input",
 CellLabel->"In[39]:=",ExpressionUUID->"22ce10e9-240b-45ae-86ab-d559897c0cf2"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"MathLink", "\[RuleDelayed]", "$xpermQ"}], ",", 
   RowBox[{"TimeVerbose", "\[Rule]", "False"}], ",", 
   RowBox[{"xPermVerbose", "\[Rule]", "False"}], ",", 
   RowBox[{"OrderedBase", "\[Rule]", "True"}]}], "}"}]], "Output",
 CellLabel->
  "Out[39]=",ExpressionUUID->"6f49d64b-584b-4eab-981f-734747f36f9d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["$xpermQ"], "Input",
 CellLabel->"In[40]:=",ExpressionUUID->"e9790a3c-bb96-4be8-bbb0-14103eab9fc1"],

Cell[BoxData["True"], "Output",
 CellLabel->
  "Out[40]=",ExpressionUUID->"e8844a2c-a738-4199-82c3-47e8a34e6441"]
}, Open  ]],

Cell["", "Text",ExpressionUUID->"9371cc0c-a640-4eb3-9ada-3d6fabbf565d"]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.5. Usage and error messages", \
"Subsubsection",ExpressionUUID->"dd26d229-8744-4363-b23f-1a1cbd3e321e"],

Cell["\<\

Versions:\
\>", "Text",ExpressionUUID->"d91c2eee-d6d6-4408-aaf8-6298fb22741d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"**", " ", "VERSIONS"}], " ", "***)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"$Version", "::", "usage"}], "=", 
     "\"\<$Version is a global variable giving the version of the package \
xConf in use.\>\""}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"$xTensorVersionExpected", "::", "usage"}], "=", 
     "\"\<$xTensorVersionExpected is a global variable giving the oldest \
possible version of the package xTensor which is required by the version of \
the package xConf in use.\>\""}], ";"}], "\[IndentingNewLine]"}]}]], "Input",
 InitializationCell->True,
 CellLabel->"In[41]:=",ExpressionUUID->"6de16e3d-93b6-4124-ad52-a84603c9e0c3"],

Cell["\<\

Booleans:\
\>", "Text",ExpressionUUID->"db6d3a1f-dc01-4b7c-9e44-1391e98bb0e7"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"**", " ", "BOOLEANS"}], " ", "***)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"$Debug", "::", "usage"}], "  ", "=", " ", 
     "\"\<Internal Debugging option.\>\""}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"$FormatConformal", "::", "usage"}], " ", "=", " ", 
     "\"\<Either \\\"Default\\\" for default formatting or \\\"Color\\\" for \
colored formatting of conformal frames\>\""}], ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"64489a51-dcc8-4f3f-ac61-2744066c1702"],

Cell["\<\

Error messages:\
\>", "Text",ExpressionUUID->"7876ae62-81df-4c9c-a1e2-3a3a800165ee"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"**", " ", "ERROR"}], " ", "MESSAGES"}], " ", "***)"}], 
  "\[IndentingNewLine]"}]], "Input",
 InitializationCell->True,
 CellLabel->"In[44]:=",ExpressionUUID->"108fa4a4-2173-4313-b7b2-6657814df237"],

Cell["\<\

Functions:\
\>", "Text",ExpressionUUID->"4a72d40c-58ff-447d-abca-b2d5600d852f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"**", " ", "FUNCTIONS"}], " ", "***)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"ConformalTransformation", "::", "usage"}], " ", "=", " ", 
     "\"\<ConformalTransformation[metric1,metric2][expr] performs a conformal \
transformation. More precisely it is a Weyl transformation, but we call it \
conformal transformation as in appendix D of Wald's book on General \
Relativity (1984)).\n\nThe expression 'expr' is transformed actively from the \
frame 'metric1' to the frame 'metric2'. \nThe two metrics 'metric1' and \
'metric2' have to be conformally related by DefConformalMetric. \n\nThe \
ConformalTransformationption FinalFrame is by default set to 'Automatic' and \
in that case all quantities in the result are expressed in the metric1 frame.\
\nThe use can specifiy FinalFrame->targetframe, where targetframe is a metric \
name, to express the results in terms of quantities in the targetframe \
conformal frame. \n\nThe option ConformalTransformation->function allows to \
define the function used for simplification. By default it is set to \
'SafeArrange' which is a custom function based on ToCanonical, but the user \
can decide to put Identity for instance to avoid loss of time in \
canonicalization.\>\""}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ConformalWeight", "::", "usage"}], " ", "=", " ", 
     "\"\<ConformalWeight[tensor[inds]] specifies the power of the conformal \
factor applied in the conformal transformation of the tensor 'tensor'. It \
corresponds to the number of down indices, minus the number of up indices, \
plus the quantity ConformalWeight[tensor] (without the indices). The latter \
is set by default to zero. \n\nFor instance, with the setting \
ConformalWeight[tensor] = 0, we have: \
ConformalWeight[tensor[\[Alpha],\[Beta]]] = -2, and ConformalWeight[tensor[-\
\[Alpha],-\[Beta]]] = 2.\>\""}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"DefConformalMetric", "::", "usage"}], " ", "=", " ", 
     "\"\<DefConformalMetric[g,S] defines a metric conformally related to \
'g', with the conformal factor 'S'. If other metrics are conformally related \
to 'g', then 'gS2' is related to them by transitivity of the conformal \
transformation. If the scalar field S[] does not exist, it is defined.\n   \
Options are PrintAs->printasform, ConformalMetricName->MetricName, \
FrameColor->somecolor and SymbolOfCovD->{postfixsymbol,prefixsymbol}. If no \
ConformalMetricName is provided the name chosen is the concatenation \
'metric+conformalfactor+2'. If no color is provided, it choses randomly a \
color. If no SymbolOfCovD is provided, the combination {:,\[Del]metricname} \
is chosen.\>\""}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ConformalMetricName", "::", "usage"}], "=", 
     "\"\<Option for DefConformalMetric.\>\""}], ";"}], "\[IndentingNewLine]",
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"FrameColor", "::", "usage"}], " ", "=", " ", 
     "\"\<Option for DefConformalMetric.\>\""}], ";"}], "\[IndentingNewLine]",
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ToMetric", "::", "usage"}], " ", "=", " ", 
     "\"\<ToMetric[metric,SimplificationFunction->function][expr] formulates \
'expr' in terms of conformal frame 'metric', and its associated covariant \
derivative and curvature tensors. It is a passive transformation. The \
optional SimplificationFunction option sets the function which simpmlifies \
the final result. \n\n The option ConformalTransformation->function allows to \
define the function used for simplification. By default it is set to \
'SafeArrange' which is a custom function based on ToCanonical, but the user \
can decide to put Identity for instance to avoid loss of time in \
canonicalization.\>\""}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ConformalFrame", "::", "usage"}], " ", "=", " ", 
     "\"\<Formal scalar head ConformalFrame[metric][expr] which indicates \
that expr (which must be of the form tens[inds]) is in fact the \
transformation of that quantity from the ambient frame to the frame \
associated with metric. Hence if metric is the first metric \
ConformalFrame[firstmetric][expr] = expr. \>\""}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"TensorNotMetricRelated", "::", "usage"}], " ", "=", " ", 
     "\"\<A boolean valued function which tells if a tensor has no link to \
any metric,\>\""}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"SqrtConformalFactor", "::", "usage"}], " ", "=", " ", 
     "\"\<SqrtConformalFactor[metric1,metric2] is the Sqrt of \
ConformalFactor[metric1,metric2].\>\""}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"RulesChangeConformalFrame", "::", "usage"}], " ", "=", " ", 
     "\"\<RulesChangeConformalFrame[metric1,metric2] builds the rules \
corresponding to a ConformalFrame[metric2][ experssion ] where expression is \
a metric related tensor associated with metric1. This function is used \
internally by the function ConformalTransformation and need not be \
used.\>\""}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"FinalFrame", "::", "usage"}], " ", "=", " ", 
     "\"\<Option for ConformalTransformation to specify in which frame (named \
by its metric) the result must be expressed.\>\""}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"SimplificationFunction", "::", "usage"}], " ", "=", " ", 
     "\"\<Option for ToMetric and ConformalTransformation\>\""}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SafeArrange", "::", "usage"}], "  ", "=", " ", 
    "\"\<Custom simplification function for ToMetric.\>\""}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"294e3c71-6f75-4027-a2bb-f9906792bb37"],

Cell["\<\

Reserved words and protected names:\
\>", "Text",ExpressionUUID->"f5168c18-b666-467d-9666-6e2fdb1df8d4"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"**", " ", "RESERVED"}], " ", "WORDS", " ", "AND", " ", 
    "PROTECTED", " ", "NAMES"}], " ", "***)"}], 
  "\[IndentingNewLine]"}]], "Input",
 InitializationCell->True,
 CellLabel->
  "In[49]:=",ExpressionUUID->"857a1c6f-72c4-409a-9f05-08bbc4b23946"]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.6. Begin private", \
"Subsubsection",ExpressionUUID->"7cfd2eb0-8b4d-4878-9fab-305d1848987b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Begin", "[", "\"\<xAct`xConf`Private`\>\"", "]"}]], "Input",
 InitializationCell->True,
 CellLabel->"In[50]:=",ExpressionUUID->"234e0925-65da-4301-a72d-3cd4faae3693"],

Cell[BoxData["\<\"xAct`xConf`Private`\"\>"], "Output",
 CellLabel->
  "Out[50]=",ExpressionUUID->"646ffc2d-b883-42c9-b3c0-217bfca4545b"]
}, Open  ]],

Cell["", "Text",ExpressionUUID->"0baef6d9-e83f-4c17-8b5a-d4ad5ec68798"]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.7. Extensions of xTensor", \
"Subsubsection",ExpressionUUID->"1010504e-8b96-46f0-a772-99eca7f88426"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "*", " ", "Why", " ", "a", " ", "scalar", " ", "head", " ", "inside", " ", 
    "a", " ", "scalar", " ", 
    RowBox[{"function", "?"}]}], " ", "**)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "*", " ", "We", " ", "choose", " ", "that", " ", "the", " ", "Scalar", " ",
     "head", " ", "should", " ", "be", " ", "removed"}], "**)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Unprotect", "[", "xAct`xTensor`NoScalar", "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"xAct`xTensor`NoScalar", "[", 
     RowBox[{
      RowBox[{"f_", "?", "ScalarFunctionQ"}], "[", "expr_", "]"}], "]"}], ":=", 
    RowBox[{"f", "[", 
     RowBox[{"NoScalar", "@", "expr"}], "]"}]}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Protect", "[", "xAct`xTensor`NoScalar", "]"}], 
    ";"}]}]}]], "Input",
 InitializationCell->True,
 CellLabel->"In[51]:=",ExpressionUUID->"ad087076-fe81-46ba-8b20-953259dac810"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Names", "[", "\"\<xAct`xConf`*\>\"", "]"}]], "Input",
 CellLabel->"In[91]:=",ExpressionUUID->"121cab83-32fd-475e-8b36-57c3484b41fc"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"ChangeConformalFrame\"\>", ",", "\<\"ConformalFrame\"\>", 
   ",", "\<\"ConformalMetricName\"\>", ",", "\<\"ConformalTransformation\"\>",
    ",", "\<\"ConformalWeight\"\>", ",", "\<\"DefConformalMetric\"\>", 
   ",", "\<\"Disclaimer\"\>", ",", "\<\"FrameColor\"\>", 
   ",", "\<\"RulesChangeConformalFrame\"\>", 
   ",", "\<\"SqrtConformalFactor\"\>", ",", "\<\"TensorNotMetricRelated\"\>", 
   ",", "\<\"ToMetric\"\>", ",", "\<\"$Debug\"\>", 
   ",", "\<\"$FormatConformal\"\>", ",", "\<\"$Version\"\>", 
   ",", "\<\"$xTensorVersionExpected\"\>"}], "}"}]], "Output",
 CellLabel->
  "Out[91]=",ExpressionUUID->"7925c9db-753e-4626-a81e-cee084c875e2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["$ContextPath"], "Input",
 CellLabel->"In[92]:=",ExpressionUUID->"d6eaad6f-3ba3-4c86-adba-81980bbac76e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"xAct`xConf`\"\>", ",", "\<\"xAct`ExpressionManipulation`\"\>", 
   ",", "\<\"xAct`xTensor`\"\>", ",", "\<\"xAct`xPerm`\"\>", 
   ",", "\<\"xAct`xCore`\"\>", ",", "\<\"System`\"\>", 
   ",", "\<\"Global`\"\>"}], "}"}]], "Output",
 CellLabel->
  "Out[92]=",ExpressionUUID->"eb7af74e-bf95-4b68-8e09-ba39a7bec528"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["$Context"], "Input",
 CellLabel->"In[56]:=",ExpressionUUID->"5f4faa86-c51d-404f-b2bc-fe70f87dcc52"],

Cell[BoxData["\<\"xAct`xConf`Private`\"\>"], "Output",
 CellLabel->
  "Out[56]=",ExpressionUUID->"d685fa9f-17d6-4da2-98cc-b5f60b3af6c0"]
}, Open  ]],

Cell["", "Text",ExpressionUUID->"42e29b91-1dcf-47e4-bc29-a4efff8290f6"]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.8. Default options and protected names", \
"Subsubsection",ExpressionUUID->"bcbed995-3771-4197-9aab-355068684bbe"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"**", " ", "DEFAULT"}], " ", "OPTIONS", " ", "AND", " ", 
    "PROTECTED", " ", "NAMES"}], " ", "***)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"*", " ", "Miscellaneous"}], " ", "**)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"If", " ", "set", " ", 
     RowBox[{"to", " ", "'"}], 
     RowBox[{"False", "'"}]}], ",", " ", 
    RowBox[{
    "the", " ", "information", " ", "messages", " ", "are", " ", "not", " ", 
     RowBox[{"printed", "."}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"$DefInfoQ", "=", "True"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"$Debug", "=", "False"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"$FormatConformal", " ", "=", " ", "\"\<Color\>\""}], 
    ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"f6e725ba-b645-4d98-8cb0-54a864d82462"]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.9 Handling expressions:", \
"Subsubsection",ExpressionUUID->"275bfd1c-6932-48e6-9eb5-e7bc392beea2"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"**", " ", "HANDLING"}], " ", "EXPRESSIONS"}], " ", "***)"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"fixScalar", ":=", 
    RowBox[{
     RowBox[{"Scalar", "[", "expr_", "]"}], "\[RuleDelayed]", 
     RowBox[{"Scalar", "[", 
      RowBox[{"xAct`xTensor`Private`MathInputExpand", "[", "expr", "]"}], 
      "]"}]}]}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"TCnoCM", "[", "expr_", "]"}], ":=", 
    RowBox[{"ToCanonical", "[", 
     RowBox[{
      RowBox[{"expr", "/.", "fixScalar"}], ",", 
      RowBox[{"UseMetricOnVBundle", "\[Rule]", "None"}]}], "]"}]}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SafeArrange", "[", "expr_", "]"}], ":=", 
    RowBox[{"ToCanonical", "[", 
     RowBox[{
      RowBox[{"PutScalar", "[", 
       RowBox[{"Identity", "[", 
        RowBox[{"expr", "/.", 
         RowBox[{
          RowBox[{"Scalar", "[", "arg_", "]"}], ":>", 
          RowBox[{"Scalar", "@", 
           RowBox[{"SafeArrange", "[", "arg", "]"}]}]}]}], "]"}], "]"}], ",", 
      
      RowBox[{"UseMetricOnVBundle", "\[Rule]", "None"}]}], 
     "]"}]}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"fb9f077e-4fec-43a9-b94f-d520bf3bdaea"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["2. Main functions", "Subsection",
 InitializationCell->True,
 FontColor->RGBColor[
  0.20389105058365758`, 0.38530556191348136`, 
   0.9685969329365988],ExpressionUUID->"b995af1a-423b-4a79-af65-ed4edb3e6f29"],

Cell[CellGroupData[{

Cell["2.1 Small functions", \
"Subsubsection",ExpressionUUID->"e5190901-3aa9-4789-a215-8255b3254b34"],

Cell["\<\
Function to build the name of the conformally related metric if it is not \
provided explicitely.\
\>", "Text",ExpressionUUID->"4e56ac23-89b4-49d8-b51b-4f0e01c96b98"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"ConformalMetricName", "[", 
    RowBox[{
     RowBox[{"g_", "?", "MetricQ"}], ",", "1"}], "]"}], ":=", "g"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ConformalMetricName", "[", 
    RowBox[{
     RowBox[{"g_", "?", "MetricQ"}], ",", "conffactor_"}], "]"}], ":=", 
   RowBox[{"SymbolJoin", "[", 
    RowBox[{"g", ",", "conffactor", ",", "2"}], "]"}]}], ";"}]}], "Input",
 InitializationCell->True,
 CellLabel->"In[68]:=",ExpressionUUID->"2cbce4e2-e138-4f89-a27c-d1c650fba01b"],

Cell["\<\
ConformalFactor[metric1, metric2] is already defined when defining a \
conformally related metric . However, we often need the square of it .\
\>", "Text",ExpressionUUID->"397eddeb-e5d5-40e2-bc5b-d2ac263b111c"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{"SqrtConformalFactor", "[", 
      RowBox[{"metric2_", ",", "metric1_"}], "]"}], ":=", 
     RowBox[{
      RowBox[{"Sqrt", "[", 
       RowBox[{"ConformalFactor", "[", 
        RowBox[{"metric2", ",", "metric1"}], "]"}], "]"}], "/.", 
      RowBox[{
       RowBox[{"Sqrt", "[", 
        RowBox[{"x_", "^", 
         RowBox[{"n_", "?", "EvenQ"}]}], "]"}], ":>", 
       RowBox[{"x", "^", 
        RowBox[{"(", 
         RowBox[{"n", "/", "2"}], ")"}]}]}]}]}], ";"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"SqrtConformalFactor", "[", 
      RowBox[{"x_", ",", 
       RowBox[{"x_", "?", "MetricQ"}]}], "]"}], ":=", "1"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"SqrtConformalFactor", "[", 
      RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
     RowBox[{"Switch", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"MetricQ", "[", "x", "]"}], ",", 
         RowBox[{"MetricQ", "[", "y", "]"}]}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"True", ",", "True"}], "}"}], ",", 
       RowBox[{"Throw", "@", 
        RowBox[{"Message", "[", 
         RowBox[{
          RowBox[{"ConformalFactor", "::", "unknown"}], ",", 
          "\"\<conformal relation of metric\>\"", ",", "x"}], "]"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"True", ",", "False"}], "}"}], ",", 
       RowBox[{"Throw", "@", 
        RowBox[{"Message", "[", 
         RowBox[{
          RowBox[{"ConformalFactor", "::", "unknown"}], ",", "\"\<metric\>\"",
           ",", "y"}], "]"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"False", ",", "_"}], "}"}], ",", 
       RowBox[{"Throw", "@", 
        RowBox[{"Message", "[", 
         RowBox[{
          RowBox[{"ConformalFactor", "::", "unknown"}], ",", "\"\<metric\>\"",
           ",", "x"}], "]"}]}]}], "\[IndentingNewLine]", "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SetNumberOfArguments", "[", 
     RowBox[{"SqrtConformalFactor", ",", "2"}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Protect", "[", "SqrtConformalFactor", "]"}], ";"}]}]}]], "Input",
 
 InitializationCell->
  True,ExpressionUUID->"709b9ed9-5f5c-471e-9309-418dfd154e28"],

Cell["\<\
In several places we need to distinguish rules for metric, or metric related \
tensors (Riemann Ricci, determinant, Levi - Civita), and other tensors.
Hence we define this function which checks if a tensor is of the latter kind.
TODO clarify what we do with the Levi-Civita.\
\>", "Text",ExpressionUUID->"93b99d9a-9342-45ff-9e99-e9fd1fb0e03e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Old", " ", "ugly", " ", "implementation"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{"TensorNotMetricRelated", "[", "tens_", "]"}], ":=", 
     RowBox[{"With", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"masters", "=", 
         RowBox[{"MasterOf", "[", "tens", "]"}]}], "}"}], ",", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"masters", "===", "Null"}], ",", 
         RowBox[{
          RowBox[{"xTensorQ", "[", "tens", "]"}], "&&", 
          RowBox[{"Not", "[", 
           RowBox[{"MetricQ", "[", "tens", "]"}], "]"}]}], ",", 
         RowBox[{
          RowBox[{"xTensorQ", "[", "tens", "]"}], "&&", 
          RowBox[{"Not", "[", 
           RowBox[{"MetricQ", "[", "tens", "]"}], "]"}], "&&", 
          RowBox[{"Not", "@", 
           RowBox[{"MemberQ", "[", 
            RowBox[{"$CovDs", ",", "masters"}], "]"}]}], "&&", 
          RowBox[{"Not", "@", 
           RowBox[{"MemberQ", "[", 
            RowBox[{"$Metrics", ",", "masters"}], "]"}]}]}]}], "]"}]}], 
      "]"}]}], ";"}], "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"MetricRelatedQ", "[", 
     RowBox[{"x_", "?", "xTensorQ"}], "]"}], ":=", 
    RowBox[{"With", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"tid", "=", 
        RowBox[{"TensorID", "@", "x"}]}], "}"}], ",", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"Length", "@", "tid"}], ">", "0"}], ")"}], "&&", 
       RowBox[{"MemberQ", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
          "xAct`xTensor`Private`InvMetric", ",", "Riemann", ",", "Ricci", ",",
            "RicciScalar", ",", "epsilon", ",", "Determinant"}], "}"}], ",", 
         RowBox[{"tid", "[", 
          RowBox[{"[", "1", "]"}], "]"}]}], "]"}]}]}], "]"}]}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"MetricRelatedQ", "[", "_", "]"}], ":=", "False"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"TensorNotMetricRelated", "[", "tens_", "]"}], ":=", 
    RowBox[{
     RowBox[{"xTensorQ", "[", "tens", "]"}], "&&", 
     RowBox[{"Not", "[", 
      RowBox[{"MetricQ", "[", "tens", "]"}], "]"}], "&&", 
     RowBox[{"Not", "[", 
      RowBox[{"MetricRelatedQ", "[", "tens", "]"}], "]"}]}]}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"DeterminantQ", "[", "x_", "]"}], ":=", 
     RowBox[{
      RowBox[{
       RowBox[{"xTensorQ", "[", "x", "]"}], "&&", 
       RowBox[{
        RowBox[{"With", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"tid", "=", 
            RowBox[{"TensorID", "@", "x"}]}], "}"}], ",", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"Length", "@", "tid"}], ">", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"Determinant", "===", 
             RowBox[{"tid", "[", 
              RowBox[{"[", "1", "]"}], "]"}]}], ")"}]}]}], "]"}], 
        "\[IndentingNewLine]", 
        RowBox[{"EpsilonQ", "[", "x_", "]"}]}]}], ":=", 
      RowBox[{
       RowBox[{"xTensorQ", "[", "x", "]"}], "&&", 
       RowBox[{"With", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"tid", "=", 
           RowBox[{"TensorID", "@", "x"}]}], "}"}], ",", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"Length", "@", "tid"}], ">", "0"}], ")"}], "&&", 
          RowBox[{"(", 
           RowBox[{"epsilon", "===", 
            RowBox[{"tid", "[", 
             RowBox[{"[", "1", "]"}], "]"}]}], ")"}]}]}], "]"}]}]}]}], 
    "*)"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"7ef16a5c-fe28-438e-8269-fea0fe6d10c7"],

Cell["\<\
Each tensor has a conformal weight . This is based on a default weight, and \
then modified by the number of indices up and down. TODO more details.\
\>", "Text",ExpressionUUID->"df016fb5-c28c-4dea-afad-0598be01f2f3"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"TestDownPrimaryBundle", "[", "index_", "]"}], ":=", 
   RowBox[{
    RowBox[{"DownIndexQ", "[", "index", "]"}], "&&", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"VBundleOfIndex", "[", "index", "]"}], "===", 
      RowBox[{"First", "@", "$VBundles"}]}], ")"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TestUpPrimaryBundle", "[", "index_", "]"}], ":=", 
   RowBox[{
    RowBox[{"UpIndexQ", "[", "index", "]"}], "&&", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"VBundleOfIndex", "[", "index", "]"}], "===", 
      RowBox[{"First", "@", "$VBundles"}]}], ")"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"WeightOfIndicesList", "[", "indices_List", "]"}], ":=", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"aindex", "=", 
       RowBox[{"Select", "[", 
        RowBox[{"indices", ",", 
         RowBox[{
          RowBox[{"Not", "[", 
           RowBox[{"LIndexQ", "[", "#", "]"}], "]"}], "&"}]}], "]"}]}], "}"}],
      ",", 
     RowBox[{
      RowBox[{"Length", "@", 
       RowBox[{"Select", "[", 
        RowBox[{"aindex", ",", "TestDownPrimaryBundle"}], "]"}]}], "-", 
      RowBox[{"Length", "@", 
       RowBox[{"Select", "[", 
        RowBox[{"aindex", ",", "TestUpPrimaryBundle"}], "]"}]}]}]}], "]"}]}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"Conformal", " ", "weight", " ", "of", " ", "a", " ", "tensor"}], 
   " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "TODO", " ", "voir", " ", "modification", " ", "de", " ", "cette", " ", 
    "regle"}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ConformalWeight", "[", 
    RowBox[{"tens_", "?", "xTensorQ"}], "]"}], ":=", "0"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ConformalWeight", "[", 
    RowBox[{
     RowBox[{"tens_", "?", "xTensorQ"}], "[", "indices___", "]"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"ConformalWeight", "[", "tens", "]"}], "+", 
    RowBox[{"WeightOfIndicesList", "[", 
     RowBox[{"{", "indices", "}"}], "]"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ConformalWeight", "[", 
    RowBox[{"f_", "?", "ScalarFunctionQ"}], "]"}], ":=", "0"}], 
  ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"fe5b646a-e3f0-467b-9d93-3d8a34f6c2e2"]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.2 Definition of conformally related metric", \
"Subsubsection",ExpressionUUID->"d42c9a4d-f609-4bac-904e-a97ece20a40e"],

Cell["\<\
DefConformalMetric extends DefMetric of xTensor in which a conformal relation \
is already defined with \[OpenCurlyDoubleQuote]ConformalTo -> \
\[OpenCurlyDoubleQuote] option.
TODO implement UndefConformaMetric.\
\>", "Text",ExpressionUUID->"98dd3b21-39d1-44d4-ac6f-039ad8c4392b"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"DefConformalMetric", "::", "old"}], "=", 
   "\"\<Metric `1` is already defined.\>\""}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"514bca9e-1761-4772-8d5f-a3296e17d52b"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Options", "[", "DefConformalMetric", "]"}], "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"PrintAs", "\[Rule]", "Automatic"}], ",", 
      RowBox[{"ConformalMetricName", "->", "Automatic"}], ",", 
      RowBox[{"FrameColor", "->", "Automatic"}], ",", 
      RowBox[{"SymbolOfCovD", "->", "Automatic"}]}], "}"}]}], ";"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", "Colouring", " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ColorFrame", "[", "_", "]"}], ":=", "Black"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"xTensorFormStop", "[", "InertHead", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MakeBoxes", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"ConformalFrame", "[", 
       RowBox[{"frame_", "?", "MetricQ"}], "]"}], "[", 
      RowBox[{
       RowBox[{"tens_", "?", "xTensorQ"}], "[", "inds___", "]"}], "]"}], ",", 
     "StandardForm"}], "]"}], ":=", "\[IndentingNewLine]", 
   RowBox[{"xAct`xTensor`Private`interpretbox", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"ConformalFrame", "[", "frame", "]"}], "[", 
      RowBox[{"tens", "[", "inds", "]"}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"$FormatConformal", "===", "\"\<Color\>\""}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"RowBox", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"StyleBox", "[", 
           RowBox[{"\"\<[\>\"", ",", 
            RowBox[{"FontColor", "\[Rule]", 
             RowBox[{"ColorFrame", "[", "frame", "]"}]}]}], "]"}], ",", 
          RowBox[{"MakeBoxes", "[", 
           RowBox[{
            RowBox[{"tens", "[", "inds", "]"}], ",", "StandardForm"}], "]"}], 
          ",", 
          RowBox[{"StyleBox", "[", 
           RowBox[{"\"\<]\>\"", ",", 
            RowBox[{"FontColor", "\[Rule]", 
             RowBox[{"ColorFrame", "[", "frame", "]"}]}]}], "]"}]}], "}"}], 
        "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"RowBox", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"StyleBox", "[", 
           RowBox[{
            RowBox[{"OverscriptBox", "[", 
             RowBox[{"\"\<\[Null]\>\"", ",", 
              RowBox[{"PrintAs", "[", "frame", "]"}]}], "]"}], ",", 
            RowBox[{"FontSize", "->", "8"}]}], "]"}], ",", "\"\<[\>\"", ",", 
          RowBox[{"MakeBoxes", "[", 
           RowBox[{
            RowBox[{"tens", "[", "inds", "]"}], ",", "StandardForm"}], "]"}], 
          ",", "\"\<]\>\""}], "}"}], "]"}]}], "\[IndentingNewLine]", "]"}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"xTensorFormStart", "[", "InertHead", "]"}], ";"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"DefConformalMetric", "[", 
    RowBox[{
     RowBox[{"g_", "?", "MetricQ"}], ",", "conffactor_", ",", 
     RowBox[{"options", ":", 
      RowBox[{"OptionsPattern", "[", "]"}]}]}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "nmetlist", ",", "pas", ",", "gconfnameraw", ",", "cdgconf", ",", 
       "metlist", ",", "color", ",", "symbolscovd"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Catch", "@", 
      RowBox[{"With", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"M", "=", 
           RowBox[{"ManifoldOfCovD", "@", 
            RowBox[{"CovDOfMetric", "@", "g"}]}]}], ",", 
          RowBox[{"CD", "=", 
           RowBox[{"CovDOfMetric", "@", "g"}]}]}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"With", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"i1", "=", 
             RowBox[{"DummyIn", "[", 
              RowBox[{"Tangent", "[", "M", "]"}], "]"}]}], ",", 
            RowBox[{"i2", "=", 
             RowBox[{"DummyIn", "[", 
              RowBox[{"Tangent", "[", "M", "]"}], "]"}]}], ",", 
            RowBox[{"sy1", "=", 
             RowBox[{
              RowBox[{"SymbolOfCovD", "[", "CD", "]"}], "[", 
              RowBox[{"[", "1", "]"}], "]"}]}], ",", 
            RowBox[{"sy2", "=", 
             RowBox[{
              RowBox[{"SymbolOfCovD", "[", "CD", "]"}], "[", 
              RowBox[{"[", "2", "]"}], "]"}]}]}], "}"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"metlist", "=", "$Metrics"}], ";", "\[IndentingNewLine]", 
           RowBox[{"(*", " ", 
            RowBox[{"We", " ", "recover", " ", "the", " ", "options"}], " ", 
            "*)"}], "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
             "pas", ",", "gconfnameraw", ",", "color", ",", "symbolscovd"}], 
             "}"}], "=", 
            RowBox[{"OptionValue", "[", 
             RowBox[{"{", 
              RowBox[{
              "PrintAs", ",", "ConformalMetricName", ",", "FrameColor", ",", 
               "SymbolOfCovD"}], "}"}], "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"(*", 
            RowBox[{
             RowBox[{"Print", "[", 
              RowBox[{"\"\<pas\>\"", ",", "pas"}], "]"}], ";", 
             "\[IndentingNewLine]", 
             RowBox[{"Print", "[", 
              RowBox[{"\"\<gconfname\>\"", ",", "gconfname"}], "]"}], ";"}], 
            "*)"}], "\[IndentingNewLine]", 
           RowBox[{"(*", " ", 
            RowBox[{
            "If", " ", "the", " ", "name", " ", "is", " ", "automatic", " ", 
             "we", " ", "build", " ", "it", " ", "with", " ", "the", " ", 
             "scalar", " ", "conformal", " ", "factor"}], " ", "*)"}], 
           "\[IndentingNewLine]", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"gconfnameraw", "===", "Automatic"}], ",", 
             RowBox[{"gconfnameraw", "=", 
              RowBox[{"ConformalMetricName", "[", 
               RowBox[{"g", ",", "conffactor"}], "]"}]}]}], "]"}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"With", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"gconfname", "=", "gconfnameraw"}], "}"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"cdgconf", "=", " ", 
               RowBox[{"SymbolJoin", "[", 
                RowBox[{"CD", ",", "gconfname"}], "]"}]}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"(*", " ", 
               RowBox[{
                RowBox[{
                "If", " ", "the", " ", "PrintAs", " ", "is", " ", "Automatic",
                  " ", "we", " ", "build", " ", "a", " ", "custom", " ", 
                 "name"}], ",", " ", 
                RowBox[{
                "otherwise", " ", "we", " ", "use", " ", "the", " ", 
                 "PrintAs", " ", "provided", " ", "by", " ", "the", " ", 
                 "option"}]}], " ", "*)"}], "\[IndentingNewLine]", 
              "\[IndentingNewLine]", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"MetricQ", "[", "gconfname", "]"}], ",", 
                RowBox[{"Message", "[", 
                 RowBox[{
                  RowBox[{"DefConformalMetric", "::", "old"}], ",", 
                  "gconfname"}], "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"symbolscovd", "==", "Automatic"}], ",", 
                RowBox[{"symbolscovd", "=", 
                 RowBox[{"{", 
                  RowBox[{"\"\<:\>\"", ",", 
                   RowBox[{"StringJoin", "[", 
                    RowBox[{"\"\<\[Del]\>\"", ",", 
                    RowBox[{"ToString", "[", "gconfname", "]"}]}], "]"}]}], 
                  "}"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
              "\[IndentingNewLine]", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"Not", "[", 
                 RowBox[{"xTensorQ", "[", "gconfname", "]"}], "]"}], ",", 
                "\[IndentingNewLine]", "\[IndentingNewLine]", 
                RowBox[{
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{"pas", " ", "===", "Automatic"}], ",", 
                   RowBox[{"pas", "=", 
                    RowBox[{"StringJoin", "[", 
                    RowBox[{"\"\<[\>\"", ",", 
                    RowBox[{"PrintAs", "[", "g", "]"}], ",", 
                    RowBox[{"\"\<\\!\\(\>\"", "<>", 
                    RowBox[{"PrintAs", "[", "conffactor", "]"}], "<>", 
                    "\"\<\\^2\\)\>\""}], ",", "\"\<]\>\""}], "]"}]}]}], "]"}],
                  ";", "\[IndentingNewLine]", 
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{"color", "===", "Automatic"}], ",", 
                   RowBox[{"color", "=", 
                    RowBox[{"RandomColor", "[", "]"}]}]}], "]"}], ";", 
                 "\[IndentingNewLine]", 
                 RowBox[{"Print", "[", 
                  RowBox[{
                  "\"\<Choosing color \>\"", ",", "color", ",", 
                   "\"\< for this conformal frame.\>\""}], "]"}], ";", 
                 "\[IndentingNewLine]", 
                 RowBox[{
                  RowBox[{"ColorFrame", "[", "gconfname", "]"}], "=", 
                  "color"}], ";", "\[IndentingNewLine]", 
                 "\[IndentingNewLine]", 
                 RowBox[{"(*", 
                  RowBox[{
                  "If", " ", "the", " ", "conformal", " ", "factor", " ", 
                   "does", " ", "not", " ", "exist", " ", "we", " ", "define",
                    " ", 
                   RowBox[{"it", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
                 
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{"Not", "@", 
                    RowBox[{"xTensorQ", "[", "conffactor", "]"}]}], ",", 
                   RowBox[{"DefTensor", "[", 
                    RowBox[{
                    RowBox[{"conffactor", "[", "]"}], ",", 
                    RowBox[{"{", "M", "}"}], ",", 
                    RowBox[{"PrintAs", "->", 
                    RowBox[{"ToString", "[", "conffactor", "]"}]}]}], "]"}]}],
                   "]"}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
                 RowBox[{"(*", " ", 
                  RowBox[{
                   RowBox[{
                   "If", " ", "this", " ", "is", " ", "the", " ", "first", 
                    " ", "conformal", " ", "relation", " ", "defined"}], ",", 
                   " ", 
                   RowBox[{
                   "then", " ", "we", " ", "must", " ", "also", " ", "define",
                     " ", "the", " ", "conformal", " ", "head", " ", "for", 
                    " ", "the", " ", "ambient", " ", "initial", " ", 
                    RowBox[{"frame", " ", ":"}]}]}], "*)"}], 
                 "\[IndentingNewLine]", "\[IndentingNewLine]", 
                 RowBox[{"Off", "[", 
                  RowBox[{"DefMetric", "::", "old"}], "]"}], ";", 
                 "\[IndentingNewLine]", 
                 RowBox[{"DefMetric", "[", 
                  RowBox[{
                   RowBox[{"SignDetOfMetric", "[", "g", "]"}], ",", 
                   RowBox[{"gconfname", "[", 
                    RowBox[{
                    RowBox[{"-", "i1"}], ",", 
                    RowBox[{"-", "i2"}]}], "]"}], ",", "cdgconf", ",", 
                   "symbolscovd", ",", 
                   RowBox[{"PrintAs", "\[Rule]", "pas"}], ",", 
                   RowBox[{"ConformalTo", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"g", "[", 
                    RowBox[{
                    RowBox[{"-", "i1"}], ",", 
                    RowBox[{"-", "i2"}]}], "]"}], ",", 
                    RowBox[{
                    RowBox[{"conffactor", "[", "]"}], "^", "2"}]}], "}"}]}]}],
                   "]"}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
                 RowBox[{"(*", 
                  RowBox[{
                  "We", " ", "define", " ", "the", " ", "conformal", " ", 
                   "head", " ", "associated", " ", "with", " ", "the", " ", 
                   "new", " ", "metric"}], " ", "*)"}], "\[IndentingNewLine]", 
                 RowBox[{"DefInertHead", "[", 
                  RowBox[{
                   RowBox[{"ConformalFrame", "[", "gconfname", "]"}], ",", 
                   RowBox[{"ContractThrough", "\[Rule]", 
                    RowBox[{"{", "delta", "}"}]}]}], "]"}], ";", 
                 "\[IndentingNewLine]", 
                 RowBox[{"(*", " ", 
                  RowBox[{
                  "If", " ", "this", " ", "does", " ", "not", " ", "exist", 
                   " ", "for", " ", "the", " ", "ambient", " ", "metric", " ",
                    "we", " ", "also", " ", "define", " ", "it"}], " ", 
                  "*)"}], "\[IndentingNewLine]", 
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{"Not", "[", 
                    RowBox[{"InertHeadQ", "[", 
                    RowBox[{"ConformalFrame", "[", "g", "]"}], "]"}], "]"}], 
                   ",", 
                   RowBox[{
                    RowBox[{"DefInertHead", "[", 
                    RowBox[{
                    RowBox[{"ConformalFrame", "[", "g", "]"}], ",", 
                    RowBox[{"ContractThrough", "\[Rule]", 
                    RowBox[{"{", "delta", "}"}]}]}], "]"}], ";"}]}], "]"}], 
                 ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
                 RowBox[{"(*", " ", 
                  RowBox[{
                  "We", " ", "also", " ", "define", " ", "the", " ", "Sqrt", 
                   " ", "of", " ", "the", " ", "conformal", " ", "factors"}], 
                  " ", "*)"}], "\[IndentingNewLine]", 
                 RowBox[{"gconfname", "/:", 
                  RowBox[{"SqrtConformalFactor", "[", 
                   RowBox[{"gconfname", ",", "g"}], "]"}], "=", 
                  RowBox[{"conffactor", "[", "]"}]}], ";", 
                 "\[IndentingNewLine]", 
                 RowBox[{"gconfname", "/:", 
                  RowBox[{"SqrtConformalFactor", "[", 
                   RowBox[{"g", ",", "gconfname"}], "]"}], "=", 
                  RowBox[{"1", "/", 
                   RowBox[{"conffactor", "[", "]"}]}]}], ";", 
                 "\[IndentingNewLine]", "\[IndentingNewLine]", 
                 RowBox[{"(*", " ", 
                  RowBox[{
                  "We", " ", "explicitely", " ", "say", " ", "that", " ", 
                   "the", " ", "inert", " ", "heads", " ", 
                   "ChangeConformalFrame", " ", "and", " ", "ConformalFrame", 
                   " ", "have", " ", "no", " ", "effect", " ", "on", " ", 
                   "the", " ", "conformal", " ", 
                   RowBox[{"factors", "."}]}], "*)"}], "\[IndentingNewLine]", 
                 
                 RowBox[{"(*", 
                  RowBox[{
                   RowBox[{
                    RowBox[{
                    RowBox[{"ChangeConformalFrame", "[", 
                    RowBox[{"_", ",", "_"}], "]"}], "[", 
                    RowBox[{"conffactor", "[", "]"}], "]"}], ":=", 
                    RowBox[{"conffactor", "[", "]"}]}], ";"}], "*)"}], 
                 "\[IndentingNewLine]", 
                 RowBox[{
                  StyleBox[
                   RowBox[{
                    RowBox[{"ConformalFrame", "[", "_", "]"}], "[", 
                    RowBox[{"conffactor", "[", "]"}], "]"}],
                   ShowAutoStyles->False,
                   AutoSpacing->False], 
                  StyleBox[":=",
                   ShowAutoStyles->False,
                   AutoSpacing->False], 
                  RowBox[{"conffactor", "[", "]"}]}], 
                 StyleBox[";",
                  ShowAutoStyles->False,
                  AutoSpacing->False], "\[IndentingNewLine]", 
                 StyleBox["\[IndentingNewLine]",
                  ShowAutoStyles->False,
                  AutoSpacing->False], 
                 RowBox[{"RulesChangeConformalFrame", "[", 
                  RowBox[{"g", ",", "gconfname"}], "]"}], ";", 
                 "\[IndentingNewLine]", 
                 RowBox[{"RulesChangeConformalFrame", "[", 
                  RowBox[{"gconfname", ",", "g"}], "]"}], ";", 
                 "\[IndentingNewLine]", "\[IndentingNewLine]", 
                 "\[IndentingNewLine]", 
                 RowBox[{"(*", " ", 
                  RowBox[{
                  "We", " ", "also", " ", "define", " ", "the", " ", 
                   "conformal", " ", "relations", " ", "to", " ", "the", " ", 
                   "previously", " ", "existing", " ", "metrics", " ", "by", 
                   " ", "using", " ", "transitivity", " ", "of", " ", 
                   "conformal", " ", "relations"}], "*)"}], 
                 "\[IndentingNewLine]", 
                 RowBox[{"Off", "[", 
                  StyleBox[
                   RowBox[{"ConformalRules", "::", "unknown"}], "MessageName"],
                   "]"}], ";", "\[IndentingNewLine]", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Catch", "@", 
                    RowBox[{"ConformalRules", "[", 
                    RowBox[{"g", ",", "#"}], "]"}]}], "=!=", "Null"}], ",", 
                    "\[IndentingNewLine]", 
                    RowBox[{
                    RowBox[{"SetConformalTo", "[", 
                    RowBox[{
                    RowBox[{"gconfname", "[", 
                    RowBox[{
                    RowBox[{"-", "i1"}], ",", 
                    RowBox[{"-", "i2"}]}], "]"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"#", "[", 
                    RowBox[{
                    RowBox[{"-", "i1"}], ",", " ", 
                    RowBox[{"-", "i2"}]}], "]"}], ",", 
                    RowBox[{
                    RowBox[{"ConformalFactor", "[", 
                    RowBox[{"g", ",", "#"}], "]"}], "*", " ", 
                    RowBox[{
                    RowBox[{"conffactor", "[", "]"}], "^", "2"}]}]}], "}"}]}],
                     "]"}], ";", "\[IndentingNewLine]", 
                    RowBox[{"gconfname", "/:", 
                    RowBox[{"SqrtConformalFactor", "[", 
                    RowBox[{"gconfname", ",", "#"}], "]"}], "=", 
                    RowBox[{
                    RowBox[{"SqrtConformalFactor", "[", 
                    RowBox[{"g", ",", "#"}], "]"}], "*", 
                    RowBox[{"conffactor", "[", "]"}]}]}], ";", 
                    "\[IndentingNewLine]", 
                    RowBox[{"gconfname", "/:", 
                    RowBox[{"SqrtConformalFactor", "[", 
                    RowBox[{"#", ",", "gconfname"}], "]"}], "=", 
                    RowBox[{"1", "/", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"SqrtConformalFactor", "[", 
                    RowBox[{"g", ",", "#"}], "]"}], "*", 
                    RowBox[{"conffactor", "[", "]"}]}], ")"}]}]}], ";", 
                    "\[IndentingNewLine]", "\[IndentingNewLine]", 
                    RowBox[{"RulesChangeConformalFrame", "[", 
                    RowBox[{"#", ",", "gconfname"}], "]"}], ";", 
                    "\[IndentingNewLine]", 
                    RowBox[{"RulesChangeConformalFrame", "[", 
                    RowBox[{"gconfname", ",", "#"}], "]"}], ";"}]}], 
                    "\[IndentingNewLine]", "]"}], "&"}], "/@", "metlist"}], 
                 ";", "\[IndentingNewLine]", 
                 RowBox[{"On", "[", 
                  StyleBox[
                   RowBox[{"ConformalRules", "::", "unknown"}], "MessageName"],
                   "]"}], ";"}]}], "\[IndentingNewLine]", 
               "\[IndentingNewLine]", "]"}], ";"}]}], "\[IndentingNewLine]", 
            "\[IndentingNewLine]", "]"}]}]}], "\[IndentingNewLine]", "]"}]}], 
       "\[IndentingNewLine]", "]"}]}]}], "\[IndentingNewLine]", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"SetNumberOfArguments", "[", 
  RowBox[{"DefConformalMetric", ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "Infinity"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "DefConformalMetric", "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"8910001e-170e-488d-989f-a52384fb5b39"]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.3 Formal Head for conformally related frames", \
"Subsubsection",ExpressionUUID->"18328f44-5f15-44d7-9e11-2001666f961b"],

Cell["\<\
A formal head to denote the conformal transformation of an expression (active \
transformation of an expression)\
\>", "Text",ExpressionUUID->"803087db-871d-4e59-a385-9ae494771770"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{"ChangeConformalFrame", "[", 
      RowBox[{"_", ",", "_"}], "]"}], "[", 
     RowBox[{"delta", "[", 
      RowBox[{"\[Mu]_", ",", "\[Nu]_"}], "]"}], "]"}], ":=", 
    RowBox[{"delta", "[", 
     RowBox[{"\[Mu]", ",", "\[Nu]"}], "]"}]}], "*)"}], "\[IndentingNewLine]", 
  
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "Because", " ", "I", " ", "know", " ", "that", " ", "when", " ", "there", 
     " ", "is", " ", "delta", " ", "function", " ", "in", " ", "an", " ", 
     "expression"}], ",", " ", 
    RowBox[{
     RowBox[{
      RowBox[{
      "it", " ", "is", " ", "always", " ", "with", " ", "one", " ", "index", 
       " ", "up", " ", "and", " ", "one", " ", "down"}], "..."}], "so", " ", 
     "this", " ", "should", " ", "be", " ", 
     RowBox[{"fine", "."}]}]}], "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ChangeConformalFrame", "[", 
       RowBox[{"metric_", ",", "metric_"}], "]"}], "[", "expr_", "]"}], ":=", 
     "expr"}], ";"}], "*)"}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"46c67def-3ead-43cb-a188-3745e63b3862"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "This", " ", "is", " ", "safe", " ", "because", " ", "delta", " ", "will", 
    " ", "always", " ", "be", " ", "with", " ", "one", " ", "index", " ", 
    "up", " ", "and", " ", "one", " ", 
    RowBox[{"down", "."}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"ConformalFrame", "[", "_", "]"}], "[", 
     RowBox[{"delta", "[", 
      RowBox[{"\[Mu]_", ",", "\[Nu]_"}], "]"}], "]"}], ":=", 
    RowBox[{"delta", "[", 
     RowBox[{"\[Mu]", ",", "\[Nu]"}], "]"}]}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"ConformalFrame", "[", 
        RowBox[{"g1_", "?", "MetricQ"}], "]"}], "[", 
       RowBox[{"val_", "?", "NumericQ"}], "]"}], ":=", "val"}], ";"}], "*)"}],
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ConformalFrame", "[", 
       RowBox[{"g1_", "?", "MetricQ"}], "]"}], "[", 
      RowBox[{"val_", "?", "NumberQ"}], "]"}], ":=", "val"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ConformalFrame", "[", 
       RowBox[{"g1_", "?", "MetricQ"}], "]"}], "[", 
      RowBox[{"val_", "?", "ConstantSymbolQ"}], "]"}], ":=", "val"}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ConformalFrame", "[", 
       RowBox[{"g1_", "?", "MetricQ"}], "]"}], "[", 
      RowBox[{"Power", "[", 
       RowBox[{
        RowBox[{"S_", "?", "ScalarQ"}], ",", "n_"}], "]"}], "]"}], ":=", 
     RowBox[{"Power", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"ConformalFrame", "[", "g1", "]"}], "[", "S", "]"}], ",", 
       "n"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ConformalFrame", "[", 
       RowBox[{"g1_", "?", "MetricQ"}], "]"}], "[", "product_Times", "]"}], ":=", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"ConformalFrame", "[", "g1", "]"}], "[", "#", "]"}], "&"}], "/@",
       "product"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ConformalFrame", "[", 
       RowBox[{"g1_", "?", "MetricQ"}], "]"}], "[", "sum_Plus", "]"}], ":=", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"ConformalFrame", "[", "g1", "]"}], "[", "#", "]"}], "&"}], "/@",
       "sum"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ConformalFrame", "[", 
       RowBox[{"g1_", "?", "MetricQ"}], "]"}], "[", 
      RowBox[{"Scalar", "[", "expr_", "]"}], "]"}], ":=", 
     RowBox[{"Scalar", "[", 
      RowBox[{
       RowBox[{"ConformalFrame", "[", "g1", "]"}], "[", "expr", "]"}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ConformalFrame", "[", 
       RowBox[{"g1_", "?", "MetricQ"}], "]"}], "[", 
      RowBox[{
       RowBox[{"f_", "?", "ScalarFunctionQ"}], "[", "expr_", "]"}], "]"}], ":=", 
     RowBox[{"f", "[", 
      RowBox[{
       RowBox[{"ConformalFrame", "[", "g1", "]"}], "[", "expr", "]"}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ConformalFrame", "[", 
       RowBox[{"g1_", "?", "MetricQ"}], "]"}], "[", 
      RowBox[{
       RowBox[{"S_", "?", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"ScalarQ", "[", "#", "]"}], "&&", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"ConformalWeight", "[", "#", "]"}], "===", "0"}], 
             ")"}]}], ")"}], "&"}], ")"}]}], "[", "]"}], "]"}], ":=", 
     RowBox[{"S", "[", "]"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Not", " ", "sure", " ", "this", " ", "is", " ", "needed", " ", "so", " ",
      "I", " ", "remove", " ", "it"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"ConformalFrame", "/:", 
      RowBox[{"IsIndexOf", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"ConformalFrame", "[", "_", "]"}], "[", "_", "]"}], ",", "_",
         ",", "delta"}], "]"}], ":=", "False"}], ";"}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ConformalFrame", "[", 
       RowBox[{"g1_", "?", "MetricQ"}], "]"}], "[", 
      RowBox[{
       RowBox[{"ConformalFrame", "[", 
        RowBox[{"g2_", "?", "MetricQ"}], "]"}], "[", "expr_", "]"}], "]"}], ":=", 
     RowBox[{
      RowBox[{"ConformalFrame", "[", "g1", "]"}], "[", "expr", "]"}]}], ";"}],
    "\[IndentingNewLine]"}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"4417a934-2a3e-461f-995c-8dd7d9a13f32"]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.4 Rules for an active conformal transformation ", \
"Subsubsection",ExpressionUUID->"eca1f719-0a59-43bf-8073-e5b76d1c9bd3"],

Cell[TextData[{
 "The function RulesChangeConformalFrame builds the automatic rules for \
handling ConformalFrame[newframe].\n\nFor normal (i.e. not metric related) \
tensors, it just says that changing  from frame1 to frame2 a tensor in \
frame1, gives the tensor in frame2.\nHowever for Riemann and Ricci this is \
more subtle because we have different tensor names associated to each metric. \
The Riemann is with indices ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    SubscriptBox["R", "\[Alpha]\[Beta]\[Mu]"], "\[Nu]"], TraditionalForm]],
  ExpressionUUID->"640e6154-6979-4f7b-8aaf-5c967419ebd6"],
 ", and it is implied that when an index is moved it is with the ambient (= \
first metric) metric. Hence in a change of frame we do not just replace \
R[metric1] by R[metric2] but we must take into account the extra change of \
index positions because the ambient metric needs to be transformed as well. \
For the Ricci the normal positioning is ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["R", "\[Mu]\[Nu]"], TraditionalForm]],ExpressionUUID->
  "5ddfaf93-1913-4fb4-9db7-4a182e388e08"],
 ". \n\nTODO what about Levi-Civita ?\nTODO what about scalar functions ?\n\
TODO what about inner bundles ?\nTODO is it a nice way to put these rules not \
automatic or is it too heavy for the user ?"
}], "Text",ExpressionUUID->"a8808486-8b22-45c0-ab9a-f0d229ce3e8a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"RulesChangeConformalFrame", "[", 
   RowBox[{
    RowBox[{"metric1_", "?", "MetricQ"}], ",", 
    RowBox[{"metric2_", "?", "MetricQ"}]}], "]"}], ":=", 
  "\[IndentingNewLine]", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"cd1", "=", 
       RowBox[{"CovDOfMetric", "[", "metric1", "]"}]}], ",", 
      RowBox[{"cd2", "=", 
       RowBox[{"CovDOfMetric", "[", "metric2", "]"}]}], ",", 
      RowBox[{"M", "=", 
       RowBox[{"ManifoldOfCovD", "[", 
        RowBox[{"CovDOfMetric", "[", "metric1", "]"}], "]"}]}]}], "}"}], ",", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"(*", 
     RowBox[{
      RowBox[{"Print", "[", 
       RowBox[{
       "\"\<Building the rules for ChangeConformalFrame[\>\"", ",", "metric1",
         ",", "\"\<,\>\"", ",", " ", "metric2", ",", "\"\<].\>\""}], "]"}], 
      ";"}], "*)"}], "\[IndentingNewLine]", 
    RowBox[{"With", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"firstmetric", "=", 
         RowBox[{"First", "@", "$Metrics"}]}], ",", 
        RowBox[{"Riemann1", "=", 
         RowBox[{"Riemann", "@", "cd1"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{"Riemann2", "=", 
         RowBox[{"Riemann", "@", "cd2"}]}], ",", 
        RowBox[{"Ricci1", "=", 
         RowBox[{"Ricci", "@", "cd1"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{"Ricci2", "=", 
         RowBox[{"Ricci", "@", "cd2"}]}], ",", 
        RowBox[{"RS1", "=", 
         RowBox[{"RicciScalar", "@", "cd1"}]}], ",", 
        RowBox[{"RS2", "=", 
         RowBox[{"RicciScalar", "@", "cd2"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{"det1", "=", 
         RowBox[{"(", 
          RowBox[{"Determinant", "[", 
           RowBox[{"metric1", ",", "AIndex"}], "]"}], ")"}]}], ",", 
        RowBox[{"det2", "=", 
         RowBox[{"(", 
          RowBox[{"Determinant", "[", 
           RowBox[{"metric2", ",", "AIndex"}], "]"}], ")"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"epsilon1", "=", 
         RowBox[{"epsilon", "@", "metric1"}]}], ",", 
        RowBox[{"epsilon2", "=", 
         RowBox[{"epsilon", "@", "metric2"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{"confa", "=", 
         RowBox[{"SqrtConformalFactor", "[", 
          RowBox[{"metric2", ",", "metric1"}], "]"}]}]}], "}"}], ",", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{
       "TODO", " ", "I", " ", "do", " ", "not", " ", "manage", " ", "to", " ",
         "attach", " ", "these", " ", "rules", " ", "to", " ", "metric2", " ",
         "or", " ", "metric1", " ", "so", " ", "as", " ", "to", " ", "be", 
        " ", "able", " ", "to", " ", "remove", " ", "them", " ", "when", " ", 
        "using", " ", "UndefMetric"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"ConformalFrame", "[", "metric2", "]"}], "[", 
         RowBox[{"metric1", "[", 
          RowBox[{
           RowBox[{"i1_", "?", "DownIndexQ"}], ",", 
           RowBox[{"i2_", "?", "DownIndexQ"}]}], "]"}], "]"}], ":=", 
        RowBox[{"metric2", "[", 
         RowBox[{"i1", ",", "i2"}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"ConformalFrame", "[", "metric2", "]"}], "[", 
         RowBox[{
          RowBox[{"Inv", "[", "metric1", "]"}], "[", 
          RowBox[{
           RowBox[{"i1_", "?", "UpIndexQ"}], ",", 
           RowBox[{"i2_", "?", "UpIndexQ"}]}], "]"}], "]"}], ":=", 
        RowBox[{
         RowBox[{"Inv", "[", "metric2", "]"}], "[", 
         RowBox[{"i1", ",", "i2"}], "]"}]}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"ConformalFrame", "[", "metric2", "]"}], "[", 
         RowBox[{"Riemann1", "[", 
          RowBox[{
           RowBox[{"i1_", "?", "DownIndexQ"}], ",", 
           RowBox[{"i2_", "?", "DownIndexQ"}], ",", 
           RowBox[{"i3_", "?", "DownIndexQ"}], ",", 
           RowBox[{"i4_", "?", "UpIndexQ"}]}], "]"}], "]"}], ":=", 
        RowBox[{"Riemann2", "[", 
         RowBox[{"i1", ",", "i2", ",", "i3", ",", "i4"}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"ConformalFrame", "[", "metric2", "]"}], "[", 
         RowBox[{"Riemann1", "[", 
          RowBox[{"i1_", ",", "i2_", ",", "i3_", ",", "i4_"}], "]"}], "]"}], ":=", 
        RowBox[{
         RowBox[{"confa", "^", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"WeightOfIndicesList", "[", 
             RowBox[{"{", 
              RowBox[{"i1", ",", "i2", ",", "i3", ",", "i4"}], "}"}], "]"}], 
            "-", "2"}], ")"}]}], 
         RowBox[{"Riemann2", "[", 
          RowBox[{"i1", ",", "i2", ",", "i3", ",", "i4"}], "]"}]}]}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"ConformalFrame", "[", "metric2", "]"}], "[", 
         RowBox[{"Ricci1", "[", 
          RowBox[{
           RowBox[{"i1_", "?", "DownIndexQ"}], ",", 
           RowBox[{"i2_", "?", "DownIndexQ"}]}], "]"}], "]"}], ":=", 
        RowBox[{"Ricci2", "[", 
         RowBox[{"i1", ",", "i2"}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"ConformalFrame", "[", "metric2", "]"}], "[", 
         RowBox[{"Ricci1", "[", 
          RowBox[{"i1_", ",", "i2_"}], "]"}], "]"}], ":=", 
        RowBox[{
         RowBox[{"confa", "^", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"WeightOfIndicesList", "[", 
             RowBox[{"{", 
              RowBox[{"i1", ",", "i2"}], "}"}], "]"}], "-", "2"}], ")"}]}], 
         RowBox[{"Ricci2", "[", 
          RowBox[{"i1", ",", "i2"}], "]"}]}]}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"ConformalFrame", "[", "metric2", "]"}], "[", 
         RowBox[{"RS1", "[", "]"}], "]"}], ":=", 
        RowBox[{"RS2", "[", "]"}]}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"ConformalFrame", "[", "metric2", "]"}], "[", 
         RowBox[{
          RowBox[{"cd1", "[", "i1_", "]"}], "[", "ex_", "]"}], "]"}], ":=", 
        RowBox[{
         RowBox[{"confa", "^", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"WeightOfIndicesList", "[", 
             RowBox[{"{", "i1", "}"}], "]"}], "-", "1"}], ")"}]}], 
         RowBox[{
          RowBox[{"cd2", "[", "i1", "]"}], "[", 
          RowBox[{
           RowBox[{"ConformalFrame", "[", "metric2", "]"}], "[", "ex", "]"}], 
          "]"}]}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{
        "Determinants", " ", "are", " ", "OK", " ", "because", " ", "their", 
         " ", "rules", " ", "have", " ", "been", " ", "put", " ", "in", " ", 
         RowBox[{"ConformalRules", "."}]}], "*)"}], "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"ConformalFrame", "[", "metric2", "]"}], "[", 
         RowBox[{"det1", "[", "]"}], "]"}], ":=", 
        RowBox[{"det2", "[", "]"}]}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{
        "TODO", " ", "this", " ", "needs", " ", "some", " ", "checks", " ", 
         "especially", " ", "with", " ", "unspecified", " ", "Manifold", " ", 
         
         RowBox[{"dimensions", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"ConformalFrame", "[", "metric2", "]"}], "[", 
           RowBox[{"epsilon1", "[", 
            RowBox[{"inds__", "?", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"And", "@", 
                 RowBox[{"DownIndexQ", "[", "#", "]"}]}], ")"}], "&"}], 
              ")"}]}], "]"}], "]"}], ":=", 
          RowBox[{"epsilon2", "[", "inds", "]"}]}], ";"}], "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"ConformalFrame", "[", "metric2", "]"}], "[", 
         RowBox[{"epsilon1", "[", "inds__", "]"}], "]"}], ":=", 
        RowBox[{
         RowBox[{"confa", "^", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"WeightOfIndicesList", "[", 
             RowBox[{"{", "inds", "}"}], "]"}], "-", 
            RowBox[{"Length", "[", 
             RowBox[{"{", "inds", "}"}], "]"}]}], ")"}]}], 
         RowBox[{"epsilon2", "[", "inds", "]"}]}]}], ";"}]}], 
     "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", "]"}]}]], "Input",
 
 InitializationCell->
  True,ExpressionUUID->"9bccfa2a-3880-418b-9bf1-178a8b18f85e"],

Cell["\<\
Here is an alternative version (not used for the moment) where the rules are \
built but they are not automatic.\
\>", "Text",ExpressionUUID->"e3b3c755-d98c-498f-b358-e5925a371074"],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"RulesChangeConformalFrame", "[", 
     RowBox[{
      RowBox[{"metric1_", "?", "MetricQ"}], ",", 
      RowBox[{"metric2_", "?", "MetricQ"}]}], "]"}], ":=", 
    "\[IndentingNewLine]", 
    RowBox[{"With", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"cd1", "=", 
         RowBox[{"CovDOfMetric", "[", "metric1", "]"}]}], ",", 
        RowBox[{"cd2", "=", 
         RowBox[{"CovDOfMetric", "[", "metric2", "]"}]}], ",", 
        RowBox[{"M", "=", 
         RowBox[{"ManifoldOfCovD", "[", 
          RowBox[{"CovDOfMetric", "[", "metric1", "]"}], "]"}]}]}], "}"}], 
      ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"Print", "[", 
         RowBox[{
         "\"\<Building the rules for ChangeConformalFrame[\>\"", ",", 
          "metric1", ",", "\"\<,\>\"", ",", " ", "metric2", ",", 
          "\"\<].\>\""}], "]"}], ";"}], "*)"}], "\[IndentingNewLine]", 
      RowBox[{"With", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"firstmetric", "=", 
           RowBox[{"First", "@", "$Metrics"}]}], ",", 
          RowBox[{"Riemann1", "=", 
           RowBox[{"Riemann", "@", "cd1"}]}], ",", "\[IndentingNewLine]", 
          RowBox[{"Riemann2", "=", 
           RowBox[{"Riemann", "@", "cd2"}]}], ",", 
          RowBox[{"Ricci1", "=", 
           RowBox[{"Ricci", "@", "cd1"}]}], ",", "\[IndentingNewLine]", 
          RowBox[{"Ricci2", "=", 
           RowBox[{"Ricci", "@", "cd2"}]}], ",", 
          RowBox[{"RS1", "=", 
           RowBox[{"RicciScalar", "@", "cd1"}]}], ",", 
          RowBox[{"RS2", "=", 
           RowBox[{"RicciScalar", "@", "cd2"}]}], ",", "\[IndentingNewLine]", 
          
          RowBox[{"det1", "=", 
           RowBox[{"(", 
            RowBox[{"Determinant", "[", 
             RowBox[{"metric1", ",", "AIndex"}], "]"}], ")"}]}], ",", 
          RowBox[{"det2", "=", 
           RowBox[{"(", 
            RowBox[{"Determinant", "[", 
             RowBox[{"metric2", ",", "AIndex"}], "]"}], ")"}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"confa2", "=", 
           RowBox[{"ConformalFactor", "[", 
            RowBox[{"metric2", ",", "metric1"}], "]"}]}], ",", 
          RowBox[{"epsilon1", "=", 
           RowBox[{"epsilon", "@", "metric1"}]}], ",", 
          RowBox[{"epsilon2", "=", 
           RowBox[{"epsilon", "@", "metric2"}]}], ",", "\[IndentingNewLine]", 
          
          RowBox[{"confa", "=", 
           RowBox[{"SqrtConformalFactor", "[", 
            RowBox[{"metric2", ",", "metric1"}], "]"}]}]}], 
         RowBox[{"(*", 
          RowBox[{",", "\[IndentingNewLine]", 
           RowBox[{"i1", "=", 
            RowBox[{"DummyIn", "[", 
             RowBox[{"Tangent", "[", "M", "]"}], "]"}]}], ",", 
           RowBox[{"i2", "=", 
            RowBox[{"DummyIn", "[", 
             RowBox[{"Tangent", "[", "M", "]"}], "]"}]}], ",", 
           RowBox[{"i3", "=", 
            RowBox[{"DummyIn", "[", 
             RowBox[{"Tangent", "[", "M", "]"}], "]"}]}], ",", 
           RowBox[{"i4", "=", 
            RowBox[{"DummyIn", "[", 
             RowBox[{"Tangent", "[", "M", "]"}], "]"}]}]}], "*)"}], "}"}], 
        ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"IndexRuleDelayed", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"ConformalFrame", "[", "metric2", "]"}], "[", 
             RowBox[{"metric1", "[", 
              RowBox[{
               RowBox[{"i1_", "?", "DownIndexQ"}], ",", 
               RowBox[{"i2_", "?", "DownIndexQ"}]}], "]"}], "]"}], ",", 
            RowBox[{"metric2", "[", 
             RowBox[{"i1", ",", "i2"}], "]"}]}], "]"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"IndexRuleDelayed", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"ConformalFrame", "[", "metric2", "]"}], "[", 
             RowBox[{
              RowBox[{"Inv", "[", "metric1", "]"}], "[", 
              RowBox[{
               RowBox[{"i1_", "?", "UpIndexQ"}], ",", 
               RowBox[{"i2_", "?", "UpIndexQ"}]}], "]"}], "]"}], ",", 
            RowBox[{
             RowBox[{"Inv", "[", "metric2", "]"}], "[", 
             RowBox[{"i1", ",", "i2"}], "]"}]}], "]"}], ",", 
          "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{"IndexRuleDelayed", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"ConformalFrame", "[", "metric2", "]"}], "[", 
             RowBox[{"Riemann1", "[", 
              RowBox[{
               RowBox[{"i1_", "?", "DownIndexQ"}], ",", 
               RowBox[{"i2_", "?", "DownIndexQ"}], ",", 
               RowBox[{"i3_", "?", "DownIndexQ"}], ",", 
               RowBox[{"i4_", "?", "UpIndexQ"}]}], "]"}], "]"}], ",", 
            RowBox[{"Riemann2", "[", 
             RowBox[{"i1", ",", "i2", ",", "i3", ",", "i4"}], "]"}]}], "]"}], 
          ",", "\[IndentingNewLine]", 
          RowBox[{"IndexRuleDelayed", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"ConformalFrame", "[", "metric2", "]"}], "[", 
             RowBox[{"Riemann1", "[", 
              RowBox[{"i1_", ",", "i2_", ",", "i3_", ",", "i4_"}], "]"}], 
             "]"}], ",", 
            RowBox[{
             RowBox[{"confa", "^", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"WeightOfIndicesList", "[", 
                 RowBox[{"{", 
                  RowBox[{"i1", ",", "i2", ",", "i3", ",", "i4"}], "}"}], 
                 "]"}], "-", "2"}], ")"}]}], 
             RowBox[{"Riemann2", "[", 
              RowBox[{"i1", ",", "i2", ",", "i3", ",", "i4"}], "]"}]}]}], 
           "]"}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{"IndexRuleDelayed", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"ConformalFrame", "[", "metric2", "]"}], "[", 
             RowBox[{"Ricci1", "[", 
              RowBox[{
               RowBox[{"i1_", "?", "DownIndexQ"}], ",", 
               RowBox[{"i2_", "?", "DownIndexQ"}]}], "]"}], "]"}], ",", 
            RowBox[{"Ricci2", "[", 
             RowBox[{"i1", ",", "i2"}], "]"}]}], "]"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"IndexRuleDelayed", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"ConformalFrame", "[", "metric2", "]"}], "[", 
             RowBox[{"Ricci1", "[", 
              RowBox[{"i1_", ",", "i2_"}], "]"}], "]"}], ",", 
            RowBox[{
             RowBox[{"confa", "^", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"WeightOfIndicesList", "[", 
                 RowBox[{"{", 
                  RowBox[{"i1", ",", "i2"}], "}"}], "]"}], "-", "2"}], 
               ")"}]}], 
             RowBox[{"Ricci2", "[", 
              RowBox[{"i1", ",", "i2"}], "]"}]}]}], "]"}], ",", 
          "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{"IndexRuleDelayed", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"ConformalFrame", "[", "metric2", "]"}], "[", 
             RowBox[{"RS1", "[", "]"}], "]"}], ",", 
            RowBox[{"RS2", "[", "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
          "\[IndentingNewLine]", 
          RowBox[{"IndexRuleDelayed", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"ConformalFrame", "[", "metric2", "]"}], "[", 
             RowBox[{
              RowBox[{"cd1", "[", "i1_", "]"}], "[", "ex_", "]"}], "]"}], ",", 
            RowBox[{
             RowBox[{"confa", "^", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"WeightOfIndicesList", "[", 
                 RowBox[{"{", "i1", "}"}], "]"}], "-", "1"}], ")"}]}], 
             RowBox[{
              RowBox[{"cd2", "[", "i1", "]"}], "[", 
              RowBox[{
               RowBox[{"ConformalFrame", "[", "metric2", "]"}], "[", "ex", 
               "]"}], "]"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
          "\[IndentingNewLine]", 
          RowBox[{"(*", " ", 
           RowBox[{
           "Determinants", " ", "are", " ", "OK", " ", "because", " ", 
            "their", " ", "rules", " ", "have", " ", "been", " ", "put", " ", 
            "in", " ", 
            RowBox[{"ConformalRules", "."}]}], "*)"}], "\[IndentingNewLine]", 
          
          RowBox[{"IndexRuleDelayed", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"ConformalFrame", "[", "metric2", "]"}], "[", 
             RowBox[{"det1", "[", "]"}], "]"}], ",", 
            RowBox[{"det2", "[", "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
          "\[IndentingNewLine]", 
          RowBox[{"(*", " ", 
           RowBox[{
           "TODO", " ", "this", " ", "needs", " ", "some", " ", "checks", " ",
             "especially", " ", "with", " ", "unspecified", " ", "Manifold", 
            " ", 
            RowBox[{"dimensions", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
          RowBox[{"IndexRuleDelayed", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"ConformalFrame", "[", "metric2", "]"}], "[", 
             RowBox[{"epsilon1", "[", 
              RowBox[{"inds__", "?", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"And", "@", 
                   RowBox[{"DownIndexQ", "[", "#", "]"}]}], ")"}], "&"}], 
                ")"}]}], "]"}], "]"}], ",", 
            RowBox[{"epsilon2", "[", "inds", "]"}]}], "]"}]}], 
         "\[IndentingNewLine]", "}"}]}], "\[IndentingNewLine]", "]"}]}], 
     "\[IndentingNewLine]", "]"}]}], "*)"}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"6cdb86da-2e83-46af-b391-3f8c3e9d9a8b"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
2.5 Transform passively an expression into a given conformal frame\
\>", "Subsubsection",ExpressionUUID->"d674ba0a-0ccc-4c17-a7ce-422cc8f935ef"],

Cell["\<\
This is not an active change of frame where tensors and metrics are replaced \
by conformally related tensors and metrics .
 Instead it expresses a given expression in terms of  tensors and metrics of \
a different conformal frame. 
 Hence it amounts to a passive transformation.
 
 TODO treat determinant and epsilon.\
\>", "Text",ExpressionUUID->"d1a19c8f-8b9b-4eb2-83bd-0ef4e16ef7fa"],

Cell[CellGroupData[{

Cell[BoxData["$Metrics"], "Input",
 CellLabel->"In[89]:=",ExpressionUUID->"42abef79-5497-49f4-9771-07273c56d428"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"g", ",", "gS2", ",", "gs2"}], "}"}]], "Output",
 CellLabel->
  "Out[89]=",ExpressionUUID->"938296fb-e8a1-4189-8cb9-d5a55d2c7798"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Options", "[", "ToMetric", "]"}], "=", 
     RowBox[{"{", 
      RowBox[{"SimplificationFunction", "\[Rule]", "SafeArrange"}], "}"}]}], 
    ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ToMetric", "[", 
      RowBox[{
       RowBox[{"metric1_", "?", "MetricQ"}], ",", 
       RowBox[{"OptionsPattern", "[", "]"}]}], "]"}], "[", "expr_", "]"}], ":=",
     "\[IndentingNewLine]", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "res1", ",", "res2", ",", "res3", ",", "res4", ",", "res5", ",", 
        "res6", ",", "res7", ",", "res8", ",", "res9", ",", "res10", ",", 
        "res11", ",", "$CovDsRelatedTocd1"}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Off", "[", 
        StyleBox[
         RowBox[{"ConformalRules", "::", "unknown"}], "MessageName"], "]"}], 
       ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"With", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"cd1", "=", 
            RowBox[{"CovDOfMetric", "[", "metric1", "]"}]}], ",", 
           RowBox[{"M", "=", 
            RowBox[{"ManifoldOfCovD", "@", 
             RowBox[{"CovDOfMetric", "[", "metric1", "]"}]}]}], ",", 
           RowBox[{"metricsrelatedtocd1", "=", 
            RowBox[{"Select", "[", 
             RowBox[{"$Metrics", ",", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"Catch", "@", 
                  RowBox[{"ConformalRules", "[", 
                   RowBox[{"metric1", ",", "#"}], "]"}]}], "=!=", "Null"}], 
                ")"}], "&"}]}], "]"}]}], ",", 
           RowBox[{"firstmetric", "=", 
            RowBox[{"First", "@", "$Metrics"}]}]}], "}"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"On", "[", 
           StyleBox[
            RowBox[{"ConformalRules", "::", "unknown"}], "MessageName"], 
           "]"}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{"$CovDsRelatedTocd1", "=", 
           RowBox[{"CovDOfMetric", "/@", "metricsrelatedtocd1"}]}], ";", 
          "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{"res1", "=", 
           RowBox[{
            RowBox[{"SeparateMetric", "[", "]"}], "[", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"expr", "//", "EinsteinToRicci"}], "//", 
              "WeylToRiemann"}], ")"}], "]"}]}], ";", "\[IndentingNewLine]", 
          "\[IndentingNewLine]", 
          RowBox[{"If", "[", 
           RowBox[{"$Debug", ",", 
            RowBox[{
             RowBox[{"Print", "[", 
              RowBox[{"\"\<res1 = \>\"", ",", "res1"}], "]"}], ";"}]}], "]"}],
           ";", "\[IndentingNewLine]", 
          RowBox[{"(*", " ", 
           RowBox[{
            RowBox[{
            "For", " ", "tensors", " ", "which", " ", "are", " ", "naturally",
              " ", "in", " ", "the", " ", "ambient", " ", 
             RowBox[{"(", 
              RowBox[{"=", 
               RowBox[{"first", " ", "metric"}]}], ")"}], " ", "conformal", 
             " ", "frame"}], ",", " ", 
            RowBox[{
            "we", " ", "force", " ", "the", " ", "appearce", " ", "of", " ", 
             "the", " ", 
             RowBox[{"Conformal", "[", "firstmetric", "]"}], " ", "inert", 
             " ", 
             RowBox[{"head", "."}]}]}], "*)"}], "\[IndentingNewLine]", 
          RowBox[{"res2", "=", 
           RowBox[{"res1", "/.", 
            RowBox[{
             RowBox[{
              RowBox[{"tens_", "?", "TensorNotMetricRelated"}], "[", 
              "inds___", "]"}], ":>", 
             RowBox[{
              RowBox[{"ConformalFrame", "[", "firstmetric", "]"}], "[", 
              RowBox[{"tens", "[", "inds", "]"}], "]"}]}]}]}], ";", 
          RowBox[{"If", "[", 
           RowBox[{"$Debug", ",", 
            RowBox[{
             RowBox[{"Print", "[", 
              RowBox[{"\"\<res2  = \>\"", ",", "res2"}], "]"}], ";"}]}], 
           "]"}], ";", "\[IndentingNewLine]", 
          RowBox[{"(*", " ", 
           RowBox[{
            RowBox[{
            "This", " ", "is", " ", "the", " ", "main", " ", "replacement", 
             " ", "rule", " ", "for", " ", "tensors"}], ",", " ", 
            RowBox[{
            "to", " ", "express", " ", "a", " ", "tensor", " ", "in", " ", 
             "a", " ", "given", " ", "conformal", " ", "frame", " ", "in", 
             " ", "terms", " ", "of", " ", "its", " ", "expression", " ", 
             "in", " ", "another", " ", "conformal", " ", 
             RowBox[{"frame", "."}]}]}], "*)"}], "\[IndentingNewLine]", 
          RowBox[{"res3", "=", 
           RowBox[{"res2", "/.", 
            RowBox[{
             RowBox[{
              RowBox[{"ConformalFrame", "[", 
               RowBox[{"frame_", "?", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"#", "=!=", "metric1"}], ")"}], "&&", 
                    RowBox[{"MetricQ", "[", "#", "]"}]}], ")"}], "&"}], 
                 ")"}]}], "]"}], "[", 
              RowBox[{
               RowBox[{"tens_", "?", "xTensorQ"}], "[", "inds___", "]"}], 
              "]"}], ":>", 
             RowBox[{
              RowBox[{
               RowBox[{"SqrtConformalFactor", "[", 
                RowBox[{"frame", ",", "metric1"}], "]"}], "^", 
               RowBox[{"(", 
                RowBox[{"ConformalWeight", "[", 
                 RowBox[{"tens", "[", "inds", "]"}], "]"}], ")"}]}], 
              RowBox[{
               RowBox[{"ConformalFrame", "[", "metric1", "]"}], "[", 
               RowBox[{"tens", "[", "inds", "]"}], "]"}]}]}]}]}], ";", 
          "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{"(*", " ", 
           RowBox[{
           "We", " ", "do", " ", "not", " ", "need", " ", "the", " ", "inert",
             " ", "heads", " ", 
            RowBox[{"ConformalFrame", "[", "firstmetric", "]"}], " ", 
            "anymore"}], "*)"}], "\[IndentingNewLine]", 
          RowBox[{"res4", "=", 
           RowBox[{"res3", "/.", 
            RowBox[{
             RowBox[{
              RowBox[{"ConformalFrame", "[", "firstmetric", "]"}], "[", 
              RowBox[{
               RowBox[{"tens_", "?", "xTensorQ"}], "[", "inds___", "]"}], 
              "]"}], ":>", 
             RowBox[{"tens", "[", "inds", "]"}]}]}]}], ";", 
          "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{"(*", " ", 
           RowBox[{
           "The", " ", "case", " ", "of", " ", "espilon", " ", "night", " ", 
            "not", " ", "be", " ", "handled", " ", 
            RowBox[{"correctly", ".", " ", "TODO"}], " ", "one", " ", 
            RowBox[{"day", " ", "?"}]}], " ", "*)"}], "\[IndentingNewLine]", 
          "\[IndentingNewLine]", 
          RowBox[{"(*", " ", 
           RowBox[{
            RowBox[{
            "We", " ", "now", " ", "handle", " ", "the", " ", "curvature"}], 
            ",", " ", 
            RowBox[{"covariant", " ", "deriavtives"}], ",", " ", 
            RowBox[{
            "and", " ", "whenever", " ", "a", " ", "change", " ", "of", " ", 
             "connection", " ", "is", " ", "needed", " ", "we", " ", "can", 
             " ", "use", " ", "ChangeChristoffel"}]}], " ", "*)"}], 
          "\[IndentingNewLine]", 
          RowBox[{"res5", "=", 
           RowBox[{
            RowBox[{
             RowBox[{"ChangeCurvature", "[", 
              RowBox[{"#", ",", "$CovDs", ",", "cd1"}], "]"}], "&"}], "@", 
            "res4"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"If", "[", 
           RowBox[{"$Debug", ",", 
            RowBox[{
             RowBox[{"Print", "[", 
              RowBox[{"\"\<res5 = \>\"", ",", "res5"}], "]"}], ";"}]}], "]"}],
           ";", "\[IndentingNewLine]", 
          RowBox[{"res6", "=", 
           RowBox[{
            RowBox[{
             RowBox[{"ChangeCovD", "[", 
              RowBox[{"#", ",", "$CovDs", ",", "cd1"}], "]"}], "&"}], "@", 
            "res5"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"If", "[", 
           RowBox[{"$Debug", ",", 
            RowBox[{
             RowBox[{"Print", "[", 
              RowBox[{"\"\<res6 = \>\"", ",", "res6"}], "]"}], ";"}]}], "]"}],
           ";", "\[IndentingNewLine]", 
          RowBox[{"res7", "=", 
           RowBox[{
            RowBox[{
             RowBox[{"ChangeChristoffel", "[", 
              RowBox[{"#", ",", "$CovDsRelatedTocd1", ",", "cd1"}], "]"}], 
             "&"}], "@", "res6"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"If", "[", 
           RowBox[{"$Debug", ",", 
            RowBox[{
             RowBox[{"Print", "[", 
              RowBox[{"\"\<res7 = \>\"", ",", "res7"}], "]"}], ";"}]}], "]"}],
           ";", "\[IndentingNewLine]", 
          RowBox[{"res8", "=", 
           RowBox[{
            RowBox[{
             RowBox[{"ChristoffelToGradConformal", "[", 
              RowBox[{"#", ",", "$CovDsRelatedTocd1", ",", "cd1"}], "]"}], 
             "&"}], "@", "res7"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"If", "[", 
           RowBox[{"$Debug", ",", 
            RowBox[{
             RowBox[{"Print", "[", 
              RowBox[{"\"\<res8 = \>\"", ",", "res8"}], "]"}], ";"}]}], "]"}],
           ";", "\[IndentingNewLine]", 
          RowBox[{"res9", "=", 
           RowBox[{
            RowBox[{
             RowBox[{"ChangeCovD", "[", 
              RowBox[{"#", ",", "$CovDs", ",", "cd1"}], "]"}], "&"}], "@", 
            "res8"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"If", "[", 
           RowBox[{"$Debug", ",", 
            RowBox[{
             RowBox[{"Print", "[", 
              RowBox[{"\"\<res9 = \>\"", ",", "res9"}], "]"}], ";"}]}], "]"}],
           ";", "\[IndentingNewLine]", 
          RowBox[{"(*", " ", 
           RowBox[{"Finally", " ", "all", " ", "metrics", " ", 
            RowBox[{"(", 
             RowBox[{"up", " ", "and", " ", "down"}], ")"}], " ", "are", " ", 
            "expressed", " ", "in", " ", "terms", " ", "of", " ", "the", " ", 
            "metruc", " ", "in", " ", "the", " ", "target", " ", 
            RowBox[{"frame", "."}]}], "*)"}], "\[IndentingNewLine]", 
          RowBox[{"res10", "=", 
           RowBox[{"Fold", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{"#1", "/.", 
                RowBox[{"ConformalRules", "[", 
                 RowBox[{"#2", ",", "metric1"}], "]"}]}], ")"}], "&"}], ",", 
             "res9", ",", "metricsrelatedtocd1"}], "]"}]}], ";", 
          "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{"(*", " ", 
           RowBox[{
           "Experimental", " ", "change", " ", "for", " ", "epsilon", " ", 
            RowBox[{
             RowBox[{"tensors", " ", "!!"}], "!"}], " ", "TODO", " ", 
            "check"}], "*)"}], "\[IndentingNewLine]", 
          RowBox[{"res11", "=", 
           RowBox[{"Fold", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{"#1", "/.", 
                RowBox[{
                 RowBox[{
                  RowBox[{"epsilon", "[", "#2", "]"}], "[", "inds__", "]"}], ":>",
                  " ", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"SqrtConformalFactor", "[", 
                    RowBox[{"#2", ",", "metric1"}], "]"}], "^", 
                   RowBox[{"(", 
                    RowBox[{"WeightOfIndicesList", "[", 
                    RowBox[{"{", "inds", "}"}], "]"}], ")"}]}], " ", 
                  RowBox[{
                   RowBox[{"epsilon", "[", "metric1", "]"}], "[", "inds", 
                   "]"}]}]}]}], ")"}], "&"}], ",", "res10", ",", 
             "metricsrelatedtocd1"}], "]"}]}], ";", "\[IndentingNewLine]", 
          "\[IndentingNewLine]", 
          RowBox[{"res11", "//", 
           RowBox[{"OptionValue", "[", "SimplificationFunction", "]"}]}]}]}], 
        "\[IndentingNewLine]", "]"}]}]}], "\[IndentingNewLine]", "]"}]}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ToMetric", "[", "]"}], "[", "expr_", "]"}], ":=", 
     RowBox[{
      RowBox[{"ToMetric", "[", 
       RowBox[{"First", "@", "$Metrics"}], "]"}], "[", "expr", "]"}]}], ";"}],
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Protect", "[", "ToMetric", "]"}], ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"224760a6-732e-49d9-919d-afa0dae96816"],

Cell["\<\
Relation between Christoffels of conformally related metric is already built \
by xTensor when defining the conformally related metric.\[LineSeparator]We \
build on it.\
\>", "Text",ExpressionUUID->"1a24de34-b39d-48b8-88bf-ed41a179c333"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"ChangeChristoffel", "[", 
    RowBox[{"expr_", ",", "cd_", ",", "cd_"}], "]"}], ":=", "expr"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ChangeChristoffel", "[", 
    RowBox[{"expr_", ",", "cd2list_List", ",", "cd1_"}], "]"}], ":=", 
   RowBox[{"Fold", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"ChangeChristoffel", "[", 
       RowBox[{"#1", ",", "#2", ",", "cd1"}], "]"}], "&"}], ",", "expr", ",", 
     "cd2list"}], "]"}]}], "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ChangeChristoffel", "[", 
   RowBox[{"expr_", ",", "cd2_", ",", "cd1_"}], "]"}], ":=", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"vb", "=", 
      RowBox[{"Tangent", "[", 
       RowBox[{"ManifoldOfCovD", "[", "cd1", "]"}], "]"}]}], "}"}], ",", 
    RowBox[{"With", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"chr1", "=", 
         RowBox[{"Head", "[", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"Christoffel", "[", "cd1", "]"}], ")"}], "[", 
           RowBox[{
            RowBox[{"DummyIn", "[", "vb", "]"}], ",", 
            RowBox[{"-", 
             RowBox[{"DummyIn", "[", "vb", "]"}]}], ",", 
            RowBox[{"-", 
             RowBox[{"DummyIn", "[", "vb", "]"}]}]}], "]"}], "]"}]}], ",", 
        RowBox[{"chr2", "=", 
         RowBox[{"Head", "[", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"Christoffel", "[", "cd2", "]"}], ")"}], "[", 
           RowBox[{
            RowBox[{"DummyIn", "[", "vb", "]"}], ",", 
            RowBox[{"-", 
             RowBox[{"DummyIn", "[", "vb", "]"}]}], ",", 
            RowBox[{"-", 
             RowBox[{"DummyIn", "[", "vb", "]"}]}]}], "]"}], "]"}]}], ",", 
        RowBox[{"chr21", "=", 
         RowBox[{"Head", "[", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"Christoffel", "@@", 
             RowBox[{"Sort", "[", 
              RowBox[{"{", 
               RowBox[{"cd2", ",", "cd1"}], "}"}], "]"}]}], ")"}], "[", 
           RowBox[{
            RowBox[{"DummyIn", "[", "vb", "]"}], ",", 
            RowBox[{"-", 
             RowBox[{"DummyIn", "[", "vb", "]"}]}], ",", 
            RowBox[{"-", 
             RowBox[{"DummyIn", "[", "vb", "]"}]}]}], "]"}], "]"}]}], ",", 
        RowBox[{"sign", "=", 
         RowBox[{"Order", "[", 
          RowBox[{"cd2", ",", "cd1"}], "]"}]}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"expr", "/.", 
       RowBox[{
        RowBox[{"chr2", "[", 
         RowBox[{"i1_", ",", "i2_", ",", "i3_"}], "]"}], "\[RuleDelayed]", 
        RowBox[{
         RowBox[{"chr1", "[", 
          RowBox[{"i1", ",", "i2", ",", "i3"}], "]"}], "+", 
         RowBox[{"sign", "*", 
          RowBox[{"chr21", "[", 
           RowBox[{"i1", ",", "i2", ",", "i3"}], "]"}]}]}]}]}]}], 
     "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", "]"}]}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"d742a4a9-8131-47e0-bfed-2ca3d7e2f547"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["3. Active change of conformal frame", "Subsection",
 InitializationCell->True,
 FontColor->RGBColor[
  0.20389105058365758`, 0.38530556191348136`, 
   0.9685969329365988],ExpressionUUID->"6df7d73e-6f11-4a44-b2db-78c74cd58a92"],

Cell["\<\
Main function. Performs the conformal transformation from frame1 (metric1) to \
frame2 (metric2) by :

1) Express an expression in the initial frame1 (associated to metric1) using \
ToMetric[metric][  ]. When the initial frame is the ambient frame (associated \
to first metric) we force the ConformalFrame[firstmetric][] inert head. \
ToMetric has used SeparateBasis[][expr] hence all indices are in their \
natural position (defined at definition of tensors).

2) We then apply the formal head ConformalFrame[targetframe] on the \
expression, and this goes over the sums products etc.. to end up wrapping the \
individual tensors. 

3) The rules to treat the change of conformal frame are defined by \
RulesChangeConformalFrame[metric1,metric2] and are applied to the resulting \
expression (but these rules are automatic in the current implementation).

4) The result is correct, but we must choose in which frame we want it \
expressed. 
If it is in the frame metric2 (which is a bit trivial and not very \
informative), then there is nothing to do, otherwide we need to apply \
ToMetric[finalframe][]. By default finalframe=metric1 but it can be specified \
with the option FinalFrame->finalframe.\
\>", "Text",ExpressionUUID->"059b5f7e-6f68-451a-add2-d26585c16f14"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ConformalTransformation", "[", 
       RowBox[{"finalframe_", "?", "MetricQ"}], "]"}], "[", 
      RowBox[{
       RowBox[{"metricbase_", "?", "MetricQ"}], ",", 
       RowBox[{"metrictarget_", "?", "MetricQ"}]}], "]"}], "[", "expr_", 
     "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "cdtarget", ",", "cdbase", ",", "res", ",", "res2", ",", "res3", ",", 
        "firstmetric", ",", "beforeputtingconfheads"}], "}"}], ",", 
      "\[IndentingNewLine]", "  ", 
      RowBox[{
       RowBox[{"cdbase", "=", 
        RowBox[{"CovDOfMetric", "[", "metricbase", "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"cdtarget", "=", 
        RowBox[{"CovDOfMetric", "[", "metrictarget", "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"Off", "[", 
        RowBox[{"ConformalFactor", "::", "\"\<unknown\>\""}], "]"}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"firstmetric", "=", 
        RowBox[{"First", "@", "$Metrics"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"beforeputtingconfheads", "=", 
        RowBox[{
         RowBox[{
          RowBox[{"ToMetric", "[", "metricbase", "]"}], "[", "expr", "]"}], "/.", 
         RowBox[{
          RowBox[{
           RowBox[{"tens_", "?", "TensorNotMetricRelated"}], "[", "inds___", 
           "]"}], ":>", 
          RowBox[{
           RowBox[{"ConformalFrame", "[", "firstmetric", "]"}], "[", 
           RowBox[{"tens", "[", "inds", "]"}], "]"}]}]}]}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{
        "Then", " ", "we", " ", "place", " ", "the", " ", 
         "ChangeConformalFrame", " ", "on", " ", "every", " ", "expression", 
         " ", "to", " ", "perform", " ", "formally", " ", "the", " ", 
         "conformal", " ", 
         RowBox[{"transformation", "."}]}], " ", "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"res", "=", 
        RowBox[{"beforeputtingconfheads", "/.", 
         RowBox[{
          RowBox[{
           RowBox[{"tens_", "?", "xTensorQ"}], "[", "inds___", "]"}], ":>", 
          RowBox[{
           RowBox[{"ChangeConformalFrame", "[", 
            RowBox[{"metricbase", ",", "metrictarget"}], "]"}], "[", 
           RowBox[{"tens", "[", "inds", "]"}], "]"}]}]}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"(*", 
        RowBox[{
        "We", " ", "need", " ", "to", " ", "treat", " ", "the", " ", 
         "covariant", " ", "derivatives", " ", "as", " ", 
         RowBox[{"well", ".", " ", "The"}], " ", "rule", " ", "needs", " ", 
         "several", " ", "applications", " ", "if", " ", "nested", " ", 
         RowBox[{"derivatives", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
       RowBox[{"res2", "=", 
        RowBox[{"res", "//.", 
         RowBox[{
          RowBox[{
           RowBox[{"cdbase", "[", "i1_", "]"}], "[", "ex_", "]"}], ":>", 
          RowBox[{
           RowBox[{"ChangeConformalFrame", "[", 
            RowBox[{"metricbase", ",", "metrictarget"}], "]"}], "[", 
           RowBox[{
            RowBox[{"cdbase", "[", "i1", "]"}], "[", "ex", "]"}], "]"}]}]}]}],
        ";", "\[IndentingNewLine]", 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{"Print", "[", 
          RowBox[{"\"\<res2 = \>\"", ",", "res2"}], "]"}], ";"}], "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"ToMetric", "[", "finalframe", "]"}], "[", "res2", "]"}]}]}], 
     "\[IndentingNewLine]", "]"}]}], "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Options", "[", "ConformalTransformation", "]"}], "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"FinalFrame", "\[Rule]", "Automatic"}], ",", 
       RowBox[{"SimplificationFunction", "\[Rule]", "SafeArrange"}]}], 
      "}"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ConformalTransformation", "[", 
      RowBox[{
       RowBox[{"metricbase_", "?", "MetricQ"}], ",", 
       RowBox[{"metrictarget_", "?", "MetricQ"}], ",", 
       RowBox[{"options", ":", 
        RowBox[{"OptionsPattern", "[", "]"}]}]}], "]"}], "[", "expr_", "]"}], 
    ":=", "\[IndentingNewLine]", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "Tometricinitialexpression", ",", "transformedexpression", ",", 
        "finalframe", ",", "simplification"}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"finalframe", ",", "simplification"}], "}"}], "=", 
        RowBox[{"OptionValue", "[", 
         RowBox[{"{", 
          RowBox[{"FinalFrame", ",", "SimplificationFunction"}], "}"}], 
         "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"finalframe", "===", "Automatic"}], ",", 
         RowBox[{
          RowBox[{"finalframe", " ", "=", " ", "metricbase"}], ";"}]}], "]"}],
        ";", "\[IndentingNewLine]", 
       RowBox[{"With", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"firstmetric", "=", 
           RowBox[{"First", "@", "$Metrics"}]}], "}"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"Tometricinitialexpression", "=", 
           RowBox[{
            RowBox[{"ToMetric", "[", 
             RowBox[{"metricbase", ",", 
              RowBox[{"SimplificationFunction", "->", "simplification"}]}], 
             "]"}], "[", "expr", "]"}]}], 
          RowBox[{"(*", 
           RowBox[{"/.", 
            RowBox[{
             RowBox[{
              RowBox[{"tens_", "?", "TensorNotMetricRelated"}], "[", 
              "inds___", "]"}], ":>", 
             RowBox[{
              RowBox[{"ConformalFrame", "[", "firstmetric", "]"}], "[", 
              RowBox[{"tens", "[", "inds", "]"}], "]"}]}]}], "*)"}], ";", 
          "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{"transformedexpression", "=", 
           RowBox[{
            RowBox[{"ConformalFrame", "[", "metrictarget", "]"}], "[", 
            "Tometricinitialexpression", "]"}]}], 
          RowBox[{"(*", 
           RowBox[{"/.", 
            RowBox[{"RulesChangeConformalFrame", "[", 
             RowBox[{"metricbase", ",", "metrictarget"}], "]"}]}], "*)"}], 
          ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"ToMetric", "[", 
            RowBox[{"finalframe", ",", 
             RowBox[{"SimplificationFunction", "->", "simplification"}]}], 
            "]"}], "[", "transformedexpression", "]"}]}]}], 
        "\[IndentingNewLine]", "]"}]}]}], "\[IndentingNewLine]", "]"}]}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ConformalTransformation", "[", 
      RowBox[{"metrictarget_", "?", "MetricQ"}], "]"}], "[", "expr_", "]"}], ":=", 
    RowBox[{
     RowBox[{"ConformalTransformation", "[", 
      RowBox[{
       RowBox[{"First", "@", "$Metrics"}], ",", "metrictarget"}], "]"}], "[", 
     "expr", "]"}]}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"2772d0b3-9bae-4a23-9851-2a6bc4c39da4"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["End private and package",
 FontColor->RGBColor[
  0, 0, 1]]], \
"Subsubsection",ExpressionUUID->"1aeab204-8f8e-4d5c-a6d2-c5dca4cced79"],

Cell[BoxData[
 RowBox[{
  RowBox[{"On", "[", 
   RowBox[{"RuleDelayed", "::", "rhs"}], "]"}], ";"}]], "Input",
 InitializationCell->True,
 CellLabel->"In[98]:=",ExpressionUUID->"752a09fa-24f2-4b4a-8cb8-e493520e326c"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"End", "[", "]"}], "\[IndentingNewLine]", 
 RowBox[{"EndPackage", "[", "]"}]}], "Input",
 InitializationCell->True,
 CellLabel->"In[99]:=",ExpressionUUID->"0db3a7a4-4037-4d76-83ac-d166a8988c4d"],

Cell[BoxData["\<\"xAct`xConf`Private`\"\>"], "Output",
 CellLabel->
  "Out[99]=",ExpressionUUID->"83ca05c0-48bd-40ae-9030-d45fdce3033b"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
AutoGeneratedPackage->Automatic,
WindowSize->{1380, 832},
WindowMargins->{{Automatic, 5}, {Automatic, 0}},
PrivateNotebookOptions->{"FileOutlineCache"->False},
ShowSelection->True,
TrackCellChangeTimes->False,
Magnification->1,
FrontEndVersion->"14.1 pour Mac OS X ARM (64-bit) (July 16, 2024)",
StyleDefinitions->FrontEnd`FileName[{"Creative"}, "PastelColor.nb", 
  CharacterEncoding -> "UTF-8"],
ExpressionUUID->"809dce3c-6b5c-4b9a-9526-c10240869a00"
]

