(* ::Package:: *)

(************************************************************************)
(* This file was generated automatically by the Mathematica front end.  *)
(* It contains Initialization cells from a Notebook file, which         *)
(* typically will have the same name as this file except ending in      *)
(* ".nb" instead of ".m".                                               *)
(*                                                                      *)
(* This file is intended to be loaded into the Mathematica kernel using *)
(* the package loading commands Get or Needs.  Doing so is equivalent   *)
(* to using the Evaluate Initialization Cells menu command in the front *)
(* end.                                                                 *)
(*                                                                      *)
(* DO NOT EDIT THIS FILE.  This entire file is regenerated              *)
(* automatically each time the parent Notebook file is saved in the     *)
(* Mathematica front end.  Any changes you make to this file will be    *)
(* overwritten.                                                         *)
(************************************************************************)



(* ::Input::Initialization:: *)
xAct`xConf`$Version={"0.0.1",{2025,04,04}};


(* ::Input::Initialization:: *)
xAct`xConf`$xTensorVersionExpected={"1.2.0",{2021,10,17}};


(* ::Input::Initialization:: *)
(* xConf: Cosmological perturbations about homogeneous space-times *)

(* Copyright (C) 2025-2026 Cyril Pitrou, Guillaume Faye *)

(* This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License as
 published by the Free Software Foundation; either version 3 of
 the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 General Public License for more details.

You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place-Suite 330, Boston, MA 02111-1307,
  USA. 
*)


(* ::Input::Initialization:: *)
(* :Title: xConf *)

(* :Author: Cyril Pitrou, Guillaume Faye *)

(* :Summary: Computer algebra for conformal transformations *)
 
(* :Context: xAct`xConf` *)

(* :Package Version: 0.0.1 *)

(* :Copyright: Cyril Pitrou, Guillaume Faye (2025-2026) *)

(* :Source: xConf.nb *)

(* :Mathematica Version: 14.0 and later *)

(* :Limitations: *)


(* ::Input::Initialization:: *)
If[Unevaluated[xAct`xCore`Private`$LastPackage]===xAct`xCore`Private`$LastPackage,xAct`xCore`Private`$LastPackage="xAct`xConf`"];


(* ::Input::Initialization:: *)
Off[General::nostdvar]
Off[General::nostdopt]
BeginPackage["xAct`xConf`",{"xAct`xTensor`","xAct`xPerm`","xAct`xCore`"}]


(* ::Input::Initialization:: *)
If[Not@OrderedQ@Map[Last,{$xTensorVersionExpected,xAct`xTensor`$Version}],Throw@Message[General::versions,"xTensor",xAct`xTensor`$Version,$xTensorVersionExpected]]


(* ::Input::Initialization:: *)
Print[xAct`xCore`Private`bars];
Print["Package xAct`xConf`  version ",$Version[[1]],", ",$Version[[2]]];
Print["CopyRight (C) 2025-2026, Cyril Pitrou, Guillaume under the General Public License."];


(* ::Input::Initialization:: *)
Off[General::shdw]
xAct`xConf`Disclaimer[]:=Print["These are points 11 and 12 of the General Public License:\n\nBECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW. EXCEPT WHEN OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES PROVIDE THE PROGRAM `AS IS\.b4 WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU. SHOULD THE PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.\n\nIN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR DAMAGES, INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES."]
On[General::shdw]


(* ::Input::Initialization:: *)
If[xAct`xCore`Private`$LastPackage==="xAct`xConf`",
Unset[xAct`xCore`Private`$LastPackage];
Print[xAct`xCore`Private`bars];
Print["These packages come with ABSOLUTELY NO WARRANTY; for details type Disclaimer[]. This is free software, and you are welcome to redistribute it under certain conditions. See the General Public License for details."];
Print[xAct`xCore`Private`bars]];


(* ::Input::Initialization:: *)
(* This is needed because we give a different name for each CovD associated to each new conformally related metric. But we cannot give a new synbol for postfix notation. *)
ReportSet[$CovDFormat,"Prefix"];
(*Message[General::nostdvar,"$CovDFormat","Prefix"];*)


(* ::Input::Initialization:: *)
(*ReportSet[$PrePrint,ScreenDollarIndices];*)


(* ::Input::Initialization:: *)
ReportSetOption[ContractMetric,AllowUpperDerivatives->True];


(* ::Input::Initialization:: *)
ReportSetOption[ToCanonical,UseMetricOnVBundle->None];


(* ::Input::Initialization:: *)
(*** VERSIONS ***)

$Version::usage="$Version is a global variable giving the version of the package xConf in use.";

$xTensorVersionExpected::usage="$xTensorVersionExpected is a global variable giving the oldest possible version of the package xTensor which is required by the version of the package xConf in use.";



(* ::Input::Initialization:: *)
(*** BOOLEANS ***)
$Debug::usage  = "Internal Debugging option.";

$FormatConformal::usage = "Either \"Default\" for default formatting or \"Color\" for colored formatting of conformal frames";


(* ::Input::Initialization:: *)
(*** ERROR MESSAGES ***)



(* ::Input::Initialization:: *)
(*** FUNCTIONS ***)

ConformalTransformation::usage = "ConformalTransformation[metric1,metric2][expr] performs a conformal transformation. More precisely it is a Weyl transformation, but we call it conformal transformation as in appendix D of Wald's book on General Relativity (1984)).

The expression 'expr' is transformed actively from the frame 'metric1' to the frame 'metric2'. 
The two metrics 'metric1' and 'metric2' have to be conformally related by DefConformalMetric. 

The ConformalTransformationption FinalFrame is by default set to 'Automatic' and in that case all quantities in the result are expressed in the metric1 frame.
The use can specifiy FinalFrame->targetframe, where targetframe is a metric name, to express the results in terms of quantities in the targetframe conformal frame. 

The option ConformalTransformation->function allows to define the function used for simplification. By default it is set to 'SafeArrange' which is a custom function based on ToCanonical, but the user can decide to put Identity for instance to avoid loss of time in canonicalization.";

ConformalWeight::usage = "ConformalWeight[tensor[inds]] specifies the power of the conformal factor applied in the conformal transformation of the tensor 'tensor'. It corresponds to the number of down indices, minus the number of up indices, plus the quantity ConformalWeight[tensor] (without the indices). The latter is set by default to zero. 

For instance, with the setting ConformalWeight[tensor] = 0, we have: ConformalWeight[tensor[\[Alpha],\[Beta]]] = -2, and ConformalWeight[tensor[-\[Alpha],-\[Beta]]] = 2.";

DefConformalMetric::usage = "DefConformalMetric[g,S] defines a metric conformally related to 'g', with the conformal factor 'S'. If other metrics are conformally related to 'g', then 'gS2' is related to them by transitivity of the conformal transformation. If the scalar field S[] does not exist, it is defined.
   Options are PrintAs->printasform, ConformalMetricName->MetricName, FrameColor->somecolor and SymbolOfCovD->{postfixsymbol,prefixsymbol}. If no ConformalMetricName is provided the name chosen is the concatenation 'metric+conformalfactor+2'. If no color is provided, it choses randomly a color. If no SymbolOfCovD is provided, the combination {:,\[Del]metricname} is chosen.";

ConformalMetricName::usage="Option for DefConformalMetric.";

FrameColor::usage = "Option for DefConformalMetric.";

ToMetric::usage = "ToMetric[metric,SimplificationFunction->function][expr] formulates 'expr' in terms of conformal frame 'metric', and its associated covariant derivative and curvature tensors. It is a passive transformation. The optional SimplificationFunction option sets the function which simpmlifies the final result. 

 The option ConformalTransformation->function allows to define the function used for simplification. By default it is set to 'SafeArrange' which is a custom function based on ToCanonical, but the user can decide to put Identity for instance to avoid loss of time in canonicalization.";

ConformalFrame::usage = "Formal scalar head ConformalFrame[metric][expr] which indicates that expr (which must be of the form tens[inds]) is in fact the transformation of that quantity from the ambient frame to the frame associated with metric. Hence if metric is the first metric ConformalFrame[firstmetric][expr] = expr. ";

TensorNotMetricRelated::usage = "A boolean valued function which tells if a tensor has no link to any metric,";

SqrtConformalFactor::usage = "SqrtConformalFactor[metric1,metric2] is the Sqrt of ConformalFactor[metric1,metric2].";

RulesChangeConformalFrame::usage = "RulesChangeConformalFrame[metric1,metric2] builds the rules corresponding to a ConformalFrame[metric2][ experssion ] where expression is a metric related tensor associated with metric1. This function is used internally by the function ConformalTransformation and need not be used.";

FinalFrame::usage = "Option for ConformalTransformation to specify in which frame (named by its metric) the result must be expressed.";

SimplificationFunction::usage = "Option for ToMetric and ConformalTransformation";

SafeArrange::usage  = "Custom simplification function for ToMetric."


(* ::Input::Initialization:: *)
(*** RESERVED WORDS AND PROTECTED NAMES ***)



(* ::Input::Initialization:: *)
Begin["xAct`xConf`Private`"]


(* ::Input::Initialization:: *)
(** Why a scalar head inside a scalar function? **)
(** We choose that the Scalar head should be removed**)
Unprotect[xAct`xTensor`NoScalar];
xAct`xTensor`NoScalar[f_?ScalarFunctionQ[expr_]]:=f[NoScalar@expr]
Protect[xAct`xTensor`NoScalar];


(* ::Input::Initialization:: *)
(*** DEFAULT OPTIONS AND PROTECTED NAMES ***)

(** Miscellaneous **)

(* If set to 'False', the information messages are not printed. *)
$DefInfoQ=True;
$Debug=False;
$FormatConformal = "Color";


(* ::Input::Initialization:: *)
(*** HANDLING EXPRESSIONS ***)

fixScalar:=Scalar[expr_]:>Scalar[xAct`xTensor`Private`MathInputExpand[expr]]

TCnoCM[expr_]:=ToCanonical[expr/.fixScalar,UseMetricOnVBundle->None]
SafeArrange[expr_]:=ToCanonical[PutScalar[Identity[expr/.Scalar[arg_]:>Scalar@SafeArrange[arg]]],UseMetricOnVBundle->None]


(* ::Input::Initialization:: *)
ConformalMetricName[g_?MetricQ,1]:=g;
ConformalMetricName[g_?MetricQ,conffactor_]:=SymbolJoin[g,conffactor,2];


(* ::Input::Initialization:: *)
(*SqrtConformalFactor[metric2_,metric1_]:=Sqrt[ConformalFactor[metric2,metric1]]/.Sqrt[x_^n_?EvenQ]:>x^(n/2);*)
SqrtConformalFactor[x_,x_?MetricQ]:=1;
SqrtConformalFactor[x_,y_]:=Switch[{MetricQ[x],MetricQ[y]},
{True,True},Throw@Message[ConformalFactor::unknown,"conformal relation of metric",x],
{True,False},Throw@Message[ConformalFactor::unknown,"metric",y],
{False,_},Throw@Message[ConformalFactor::unknown,"metric",x]
];

SetNumberOfArguments[SqrtConformalFactor,2];
Protect[SqrtConformalFactor];


(* ::Input::Initialization:: *)
(* Old ugly implementation *)
(*TensorNotMetricRelated[tens_]:=With[{masters=MasterOf[tens]},If[masters===Null,xTensorQ[tens]&&Not[MetricQ[tens]],xTensorQ[tens]&&Not[MetricQ[tens]]&&Not@MemberQ[$CovDs,masters]&&Not@MemberQ[$Metrics,masters]]];*)


MetricRelatedQ[x_?xTensorQ]:=With[{tid=TensorID@x},(Length@tid>0)&&MemberQ[{xAct`xTensor`Private`InvMetric,Riemann,Ricci,RicciScalar,epsilon,Determinant},tid[[1]]]]
MetricRelatedQ[_]:=False;
TensorNotMetricRelated[tens_]:=xTensorQ[tens]&&Not[MetricQ[tens]]&&Not[MetricRelatedQ[tens]]

(*DeterminantQ[x_]:=xTensorQ[x]&&With[{tid=TensorID@x},(Length@tid>0)&&(Determinant===tid[[1]])]
EpsilonQ[x_]:=xTensorQ[x]&&With[{tid=TensorID@x},(Length@tid>0)&&(epsilon===tid[[1]])]*)


(* ::Input::Initialization:: *)
TestDownPrimaryBundle[index_]:=DownIndexQ[index]&&(VBundleOfIndex[index]===First@$VBundles);
TestUpPrimaryBundle[index_]:=UpIndexQ[index]&&(VBundleOfIndex[index]===First@$VBundles);
WeightOfIndicesList[indices_List]:=With[{aindex=Select[indices,Not[LIndexQ[#]]&]},Length@Select[aindex,TestDownPrimaryBundle]-Length@Select[aindex,TestUpPrimaryBundle]]
(* Conformal weight of a tensor *)
(* TODO voir modification de cette regle *)
ConformalWeight[tens_?xTensorQ]:=0;
ConformalWeight[tens_?xTensorQ[indices___]]:=ConformalWeight[tens]+WeightOfIndicesList[{indices}]

ConformalWeight[f_?ScalarFunctionQ]:=0;


(* ::Input::Initialization:: *)
DefConformalMetric::old="Metric `1` is already defined.";


(* ::Input::Initialization:: *)
Options[DefConformalMetric]={PrintAs->Automatic,ConformalMetricName->Automatic,FrameColor->Automatic,SymbolOfCovD->Automatic};

(* Colouring *)
ColorFrame[_]:=Black;
xTensorFormStop[InertHead];

MakeBoxes[ConformalFrame[frame_?MetricQ][tens_?xTensorQ[inds___]],StandardForm]:=
xAct`xTensor`Private`interpretbox[ConformalFrame[frame][tens[inds]],
If[$FormatConformal==="Color",
RowBox[{StyleBox["[",FontColor->ColorFrame[frame]],MakeBoxes[tens[inds],StandardForm],StyleBox["]",FontColor->ColorFrame[frame]]}],
RowBox[{StyleBox[OverscriptBox["\[Null]",PrintAs[frame]],FontSize->8],"[",MakeBoxes[tens[inds],StandardForm],"]"}]
]
];
xTensorFormStart[InertHead];



DefConformalMetric[g_?MetricQ,conffactor_,options:OptionsPattern[]]:=Module[{nmetlist,pas,gconfnameraw,cdgconf,metlist,color,symbolscovd},
Catch@With[{M=ManifoldOfCovD@CovDOfMetric@g,CD=CovDOfMetric@g},
With[{i1=DummyIn[Tangent[M]],i2=DummyIn[Tangent[M]],sy1=SymbolOfCovD[CD][[1]],sy2=SymbolOfCovD[CD][[2]]},
metlist=$Metrics;
(* We recover the options *)
{pas,gconfnameraw,color,symbolscovd}=OptionValue[{PrintAs,ConformalMetricName,FrameColor,SymbolOfCovD}];
(*Print["pas",pas];
Print["gconfname",gconfname];*)
(* If the name is automatic we build it with the scalar conformal factor *)
If[gconfnameraw===Automatic,gconfnameraw=ConformalMetricName[g,conffactor]];
With[{gconfname=gconfnameraw},
cdgconf= SymbolJoin[CD,gconfname];
(* If the PrintAs is Automatic we build a custom name, otherwise we use the PrintAs provided by the option *)

If[MetricQ[gconfname],Message[DefConformalMetric::old,gconfname]];
If[symbolscovd==Automatic,symbolscovd={":",StringJoin["\[Del]",ToString[gconfname]]}];

If[Not[xTensorQ[gconfname]],

If[pas ===Automatic,pas=StringJoin["[",PrintAs[g],"\!\("<>PrintAs[conffactor]<>"\^2\)","]"]];
If[color===Automatic,color=RandomColor[]];
Print["Choosing color ",color," for this conformal frame."];
ColorFrame[gconfname]=color;

(*If the conformal factor does not exist we define it. *)
If[Not@xTensorQ[conffactor],DefTensor[conffactor[],{M},PrintAs->ToString[conffactor]]];

(* If this is the first conformal relation defined, then we must also define the conformal head for the ambient initial frame :*)

Off[DefMetric::old];
DefMetric[SignDetOfMetric[g],gconfname[-i1,-i2],cdgconf,symbolscovd,PrintAs->pas,ConformalTo->{g[-i1,-i2],conffactor[]^2}];

(*We define the conformal head associated with the new metric *)
DefInertHead[ConformalFrame[gconfname],ContractThrough->{delta}];
(* If this does not exist for the ambient metric we also define it *)
If[Not[InertHeadQ[ConformalFrame[g]]],DefInertHead[ConformalFrame[g],ContractThrough->{delta}];];

(* We also define the Sqrt of the conformal factors *)
gconfname/:SqrtConformalFactor[gconfname,g]=conffactor[];
gconfname/:SqrtConformalFactor[g,gconfname]=1/conffactor[];

(* We explicitely say that the inert heads ChangeConformalFrame and ConformalFrame have no effect on the conformal factors.*)
(*ChangeConformalFrame[_,_][conffactor[]]:=conffactor[];*)
ConformalFrame[_][conffactor[]]:=conffactor[];

RulesChangeConformalFrame[g,gconfname];
RulesChangeConformalFrame[gconfname,g];


(* We also define the conformal relations to the previously existing metrics by using transitivity of conformal relations*)
Off[ConformalRules::unknown];
If[Catch@ConformalRules[g,#]=!=Null,
SetConformalTo[gconfname[-i1,-i2], {#[-i1, -i2],ConformalFactor[g,#]* conffactor[]^2}];
gconfname/:SqrtConformalFactor[gconfname,#]=SqrtConformalFactor[g,#]*conffactor[];
gconfname/:SqrtConformalFactor[#,gconfname]=1/(SqrtConformalFactor[g,#]*conffactor[]);

RulesChangeConformalFrame[#,gconfname];
RulesChangeConformalFrame[gconfname,#];
]&/@metlist;
On[ConformalRules::unknown];

];

]
]
]
]

SetNumberOfArguments[DefConformalMetric,{2,Infinity}]
Protect[DefConformalMetric];


(* ::Input::Initialization:: *)
(*ChangeConformalFrame[_,_][delta[\[Mu]_,\[Nu]_]]:=delta[\[Mu],\[Nu]]*)
(* Because I know that when there is delta function in an expression, it is always with one index up and one down...so this should be fine.*)

(*ChangeConformalFrame[metric_,metric_][expr_]:=expr;*)


(* ::Input::Initialization:: *)
(* This is safe because delta will always be with one index up and one down.*)
ConformalFrame[_][delta[\[Mu]_,\[Nu]_]]:=delta[\[Mu],\[Nu]]

(*ConformalFrame[g1_?MetricQ][val_?NumericQ]:=val;*)
ConformalFrame[g1_?MetricQ][val_?NumberQ]:=val;
ConformalFrame[g1_?MetricQ][val_?ConstantSymbolQ]:=val;

ConformalFrame[g1_?MetricQ][Power[S_?ScalarQ,n_]]:=Power[ConformalFrame[g1][S],n];
ConformalFrame[g1_?MetricQ][product_Times]:=ConformalFrame[g1][#]&/@product;
ConformalFrame[g1_?MetricQ][sum_Plus]:=ConformalFrame[g1][#]&/@sum;
ConformalFrame[g1_?MetricQ][Scalar[expr_]]:=Scalar[ConformalFrame[g1][expr]];

ConformalFrame[g1_?MetricQ][f_?ScalarFunctionQ[expr_]]:=f[ConformalFrame[g1][expr]];

ConformalFrame[g1_?MetricQ][S_?((ScalarQ[#]&&(ConformalWeight[#]===0))&)[]]:=S[];

(* Not sure this is needed so I remove it *)
(*ConformalFrame/:IsIndexOf[ConformalFrame[_][_],_,delta]:=False;*)
ConformalFrame[g1_?MetricQ][ConformalFrame[g2_?MetricQ][expr_]]:=ConformalFrame[g1][expr];



(* ::Input::Initialization:: *)
RulesChangeConformalFrame[metric1_?MetricQ,metric2_?MetricQ]:=
With[{cd1=CovDOfMetric[metric1],cd2=CovDOfMetric[metric2],M=ManifoldOfCovD[CovDOfMetric[metric1]]},

(*Print["Building the rules for ChangeConformalFrame[",metric1,",", metric2,"]."];*)
With[{firstmetric=First@$Metrics,Riemann1=Riemann@cd1,
Riemann2=Riemann@cd2,Ricci1=Ricci@cd1,
Ricci2=Ricci@cd2,RS1=RicciScalar@cd1,RS2=RicciScalar@cd2,
det1=(Determinant[metric1,AIndex]),det2=(Determinant[metric2,AIndex]),
epsilon1=epsilon@metric1,epsilon2=epsilon@metric2,
confa=SqrtConformalFactor[metric2,metric1]},

(*TODO I do not manage to attach these rules to metric2 or metric1 so as to be able to remove them when using UndefMetric *)
ConformalFrame[metric2][metric1[i1_?DownIndexQ,i2_?DownIndexQ]]:=metric2[i1,i2];
ConformalFrame[metric2][Inv[metric1][i1_?UpIndexQ,i2_?UpIndexQ]]:=Inv[metric2][i1,i2];

ConformalFrame[metric2][Riemann1[i1_?DownIndexQ,i2_?DownIndexQ,i3_?DownIndexQ,i4_?UpIndexQ]]:=Riemann2[i1,i2,i3,i4];
ConformalFrame[metric2][Riemann1[i1_,i2_,i3_,i4_]]:=confa^(WeightOfIndicesList[{i1,i2,i3,i4}]-2)Riemann2[i1,i2,i3,i4];

ConformalFrame[metric2][Ricci1[i1_?DownIndexQ,i2_?DownIndexQ]]:=Ricci2[i1,i2];
ConformalFrame[metric2][Ricci1[i1_,i2_]]:=confa^(WeightOfIndicesList[{i1,i2}]-2)Ricci2[i1,i2];

ConformalFrame[metric2][RS1[]]:=RS2[];

ConformalFrame[metric2][cd1[i1_][ex_]]:=confa^(WeightOfIndicesList[{i1}]-1)cd2[i1][ConformalFrame[metric2][ex]];

(* Determinants are OK because their rules have been put in ConformalRules.*)
ConformalFrame[metric2][det1[]]:=det2[];

(* TODO this needs some checks especially with unspecified Manifold dimensions. *)
(*ConformalFrame[metric2][epsilon1[inds__?((And@DownIndexQ[#])&)]]:=epsilon2[inds];*)
ConformalFrame[metric2][epsilon1[inds__]]:=confa^(WeightOfIndicesList[{inds}]-Length[{inds}])epsilon2[inds];
]
]


(* ::Input::Initialization:: *)

(*RulesChangeConformalFrame[metric1_?MetricQ,metric2_?MetricQ]:=
With[{cd1=CovDOfMetric[metric1],cd2=CovDOfMetric[metric2],M=ManifoldOfCovD[CovDOfMetric[metric1]]},

(*Print["Building the rules for ChangeConformalFrame[",metric1,",", metric2,"]."];*)
With[{firstmetric=First@$Metrics,Riemann1=Riemann@cd1,
Riemann2=Riemann@cd2,Ricci1=Ricci@cd1,
Ricci2=Ricci@cd2,RS1=RicciScalar@cd1,RS2=RicciScalar@cd2,
det1=(Determinant[metric1,AIndex]),det2=(Determinant[metric2,AIndex]),
confa2=ConformalFactor[metric2,metric1],epsilon1=epsilon@metric1,epsilon2=epsilon@metric2,
confa=SqrtConformalFactor[metric2,metric1](*,
i1=DummyIn[Tangent[M]],i2=DummyIn[Tangent[M]],i3=DummyIn[Tangent[M]],i4=DummyIn[Tangent[M]]*)},

{IndexRuleDelayed[ConformalFrame[metric2][metric1[i1_?DownIndexQ,i2_?DownIndexQ]],metric2[i1,i2]],
IndexRuleDelayed[ConformalFrame[metric2][Inv[metric1][i1_?UpIndexQ,i2_?UpIndexQ]],Inv[metric2][i1,i2]],

IndexRuleDelayed[ConformalFrame[metric2][Riemann1[i1_?DownIndexQ,i2_?DownIndexQ,i3_?DownIndexQ,i4_?UpIndexQ]],Riemann2[i1,i2,i3,i4]],
IndexRuleDelayed[ConformalFrame[metric2][Riemann1[i1_,i2_,i3_,i4_]],confa^(WeightOfIndicesList[{i1,i2,i3,i4}]-2)Riemann2[i1,i2,i3,i4]],

IndexRuleDelayed[ConformalFrame[metric2][Ricci1[i1_?DownIndexQ,i2_?DownIndexQ]],Ricci2[i1,i2]],
IndexRuleDelayed[ConformalFrame[metric2][Ricci1[i1_,i2_]],confa^(WeightOfIndicesList[{i1,i2}]-2)Ricci2[i1,i2]],

IndexRuleDelayed[ConformalFrame[metric2][RS1[]],RS2[]],

IndexRuleDelayed[ConformalFrame[metric2][cd1[i1_][ex_]],confa^(WeightOfIndicesList[{i1}]-1)cd2[i1][ConformalFrame[metric2][ex]]],

(* Determinants are OK because their rules have been put in ConformalRules.*)
IndexRuleDelayed[ConformalFrame[metric2][det1[]],det2[]],

(* TODO this needs some checks especially with unspecified Manifold dimensions. *)
IndexRuleDelayed[ConformalFrame[metric2][epsilon1[inds__?((And@DownIndexQ[#])&)]],epsilon2[inds]]
}
]
]*)


(* ::Input::Initialization:: *)

Options[ToMetric]={SimplificationFunction->SafeArrange};

ToMetric[metric1_?MetricQ,OptionsPattern[]][expr_]:=
Module[{res1,res2,res3,res4,res5,res6,res7,res8,res9,res10,res11,$CovDsRelatedTocd1},
Off[ConformalRules::unknown];

With[{cd1=CovDOfMetric[metric1],M=ManifoldOfCovD@CovDOfMetric[metric1],metricsrelatedtocd1=Select[$Metrics,(Catch@ConformalRules[metric1,#]=!=Null)&],firstmetric=First@$Metrics},
On[ConformalRules::unknown];

$CovDsRelatedTocd1=CovDOfMetric/@metricsrelatedtocd1;

res1=SeparateMetric[][(expr//EinsteinToRicci//WeylToRiemann)];

If[$Debug,Print["res1 = ",res1];];
(* For tensors which are naturally in the ambient (=first metric) conformal frame, we force the appearce of the Conformal[firstmetric] inert head.*)
res2=res1/.tens_?TensorNotMetricRelated[inds___]:>ConformalFrame[firstmetric][tens[inds]];If[$Debug,Print["res2  = ",res2];];
(* This is the main replacement rule for tensors, to express a tensor in a given conformal frame in terms of its expression in another conformal frame.*)
res3=res2/.ConformalFrame[frame_?(((#=!=metric1)&&MetricQ[#])&)][tens_?xTensorQ[inds___]]:>SqrtConformalFactor[frame,metric1]^(ConformalWeight[tens[inds]])ConformalFrame[metric1][tens[inds]];

(* We do not need the inert heads ConformalFrame[firstmetric] anymore*)
res4=res3/.ConformalFrame[firstmetric][tens_?xTensorQ[inds___]]:>tens[inds];

(* The case of espilon night not be handled correctly. TODO one day ? *)

(* We now handle the curvature, covariant deriavtives, and whenever a change of connection is needed we can use ChangeChristoffel *)
res5=ChangeCurvature[#,$CovDs,cd1]&@res4;
If[$Debug,Print["res5 = ",res5];];
res6=ChangeCovD[#,$CovDs,cd1]&@res5;
If[$Debug,Print["res6 = ",res6];];
res7=ChangeChristoffel[#,$CovDsRelatedTocd1,cd1]&@res6;
If[$Debug,Print["res7 = ",res7];];
res8=ChristoffelToGradConformal[#,$CovDsRelatedTocd1,cd1]&@res7;
If[$Debug,Print["res8 = ",res8];];
res9=ChangeCovD[#,$CovDs,cd1]&@res8;
If[$Debug,Print["res9 = ",res9];];
(* Finally all metrics (up and down) are expressed in terms of the metruc in the target frame.*)
res10=Fold[(#1/.ConformalRules[#2,metric1])&,res9,metricsrelatedtocd1];

(* Experimental change for epsilon tensors !!! TODO check*)
res11=Fold[(#1/.epsilon[#2][inds__]:> SqrtConformalFactor[#2,metric1]^(WeightOfIndicesList[{inds}]) epsilon[metric1][inds])&,res10,metricsrelatedtocd1];

res11//OptionValue[SimplificationFunction]
]
]

ToMetric[][expr_]:=ToMetric[First@$Metrics][expr];
Protect[ToMetric];


(* ::Input::Initialization:: *)
ChangeChristoffel[expr_,cd_,cd_]:=expr

ChangeChristoffel[expr_,cd2list_List,cd1_]:=Fold[ChangeChristoffel[#1,#2,cd1]&,expr,cd2list]

ChangeChristoffel[expr_,cd2_,cd1_]:=With[{vb=Tangent[ManifoldOfCovD[cd1]]},With[{chr1=Head[(Christoffel[cd1])[DummyIn[vb],-DummyIn[vb],-DummyIn[vb]]],chr2=Head[(Christoffel[cd2])[DummyIn[vb],-DummyIn[vb],-DummyIn[vb]]],chr21=Head[(Christoffel@@Sort[{cd2,cd1}])[DummyIn[vb],-DummyIn[vb],-DummyIn[vb]]],sign=Order[cd2,cd1]},
expr/.chr2[i1_,i2_,i3_]:>chr1[i1,i2,i3]+sign*chr21[i1,i2,i3]
]
]


(* ::Input::Initialization:: *)
(*ConformalTransformation[finalframe_?MetricQ][metricbase_?MetricQ,metrictarget_?MetricQ][expr_]:=Module[{cdtarget,cdbase,res,res2,res3,firstmetric,beforeputtingconfheads},
  cdbase=CovDOfMetric[metricbase];
cdtarget=CovDOfMetric[metrictarget];
Off[ConformalFactor::"unknown"];

firstmetric=First@$Metrics;
beforeputtingconfheads=ToMetric[metricbase][expr]/.tens_?TensorNotMetricRelated[inds___]:>ConformalFrame[firstmetric][tens[inds]];

(* Then we place the ChangeConformalFrame on every expression to perform formally the conformal transformation. *)
res=beforeputtingconfheads/.tens_?xTensorQ[inds___]:>ChangeConformalFrame[metricbase,metrictarget][tens[inds]];
(*We need to treat the covariant derivatives as well. The rule needs several applications if nested derivatives. *)
res2=res//.cdbase[i1_][ex_]:>ChangeConformalFrame[metricbase,metrictarget][cdbase[i1][ex]];
(*Print["res2 = ",res2];*)
ToMetric[finalframe][res2]
]*)

Options[ConformalTransformation]={FinalFrame->Automatic,SimplificationFunction->SafeArrange};

ConformalTransformation[metricbase_?MetricQ,metrictarget_?MetricQ,options:OptionsPattern[]][expr_]:=
Module[{Tometricinitialexpression,transformedexpression,finalframe,simplification},
{finalframe,simplification}=OptionValue[{FinalFrame,SimplificationFunction}];
If[finalframe===Automatic,finalframe = metricbase;];
With[{firstmetric=First@$Metrics},
Tometricinitialexpression=ToMetric[metricbase,SimplificationFunction->simplification][expr](*/.tens_?TensorNotMetricRelated[inds___]:>ConformalFrame[firstmetric][tens[inds]]*);

transformedexpression=ConformalFrame[metrictarget][Tometricinitialexpression](*/.RulesChangeConformalFrame[metricbase,metrictarget]*);

ToMetric[finalframe,SimplificationFunction->simplification][transformedexpression]
]
]

ConformalTransformation[metrictarget_?MetricQ][expr_]:=ConformalTransformation[First@$Metrics,metrictarget][expr]


(* ::Input::Initialization:: *)
On[RuleDelayed::rhs];


(* ::Input::Initialization:: *)
End[]
EndPackage[]
