(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     32097,        851]
NotebookOptionsPosition[     27496,        777]
NotebookOutlinePosition[     27896,        793]
CellTagsIndexPosition[     27853,        790]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<xAct`xTensor`\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.954469187001341*^9, 3.954469194500986*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"084d4c49-7d3c-4234-b6c2-2887d6af824a"],

Cell[CellGroupData[{

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellChangeTimes->{3.954469195372302*^9, 3.954469420530497*^9, 
  3.954470338435137*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"a1f81f64-d7ca-4657-b155-bd1ca3b7cdd2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`xPerm`  version \"\>", 
   "\[InvisibleSpace]", "\<\"1.2.3\"\>", "\[InvisibleSpace]", "\<\", \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2015", ",", "8", ",", "23"}], "}"}]}],
  SequenceForm["Package xAct`xPerm`  version ", "1.2.3", ", ", {2015, 8, 23}],
  
  Editable->False]], "Print",
 CellChangeTimes->{3.954469195372302*^9, 3.954469420530497*^9, 
  3.9544703384369783`*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"1a1fa20c-7036-4e9a-91ef-bf1af1e23b4e"],

Cell[BoxData["\<\"CopyRight (C) 2003-2020, Jose M. Martin-Garcia, under the \
General Public License.\"\>"], "Print",
 CellChangeTimes->{3.954469195372302*^9, 3.954469420530497*^9, 
  3.9544703384379177`*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"755550b3-683c-4743-9c4b-bb2c0e261a2a"],

Cell[BoxData["\<\"Connecting to external linux executable...\"\>"], "Print",
 CellChangeTimes->{3.954469195372302*^9, 3.954469420530497*^9, 
  3.954470338479594*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"bf95b643-c054-42ac-afa7-dc7fb37057a6"],

Cell[BoxData["\<\"Connection established.\"\>"], "Print",
 CellChangeTimes->{3.954469195372302*^9, 3.954469420530497*^9, 
  3.9544703385047903`*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"a9cecbc9-1ff2-45dc-a264-58f81416da16"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellChangeTimes->{3.954469195372302*^9, 3.954469420530497*^9, 
  3.954470338505559*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"5c7f8f7b-f42c-42cc-af55-db07cafc9617"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`xTensor`  version \"\>", 
   "\[InvisibleSpace]", "\<\"1.2.0\"\>", "\[InvisibleSpace]", "\<\", \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2021", ",", "10", ",", "17"}], "}"}]}],
  SequenceForm[
  "Package xAct`xTensor`  version ", "1.2.0", ", ", {2021, 10, 17}],
  Editable->False]], "Print",
 CellChangeTimes->{3.954469195372302*^9, 3.954469420530497*^9, 
  3.954470338506296*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"4247286c-d23f-448b-8b74-5ff971be2be0"],

Cell[BoxData["\<\"CopyRight (C) 2002-2021, Jose M. Martin-Garcia, under the \
General Public License.\"\>"], "Print",
 CellChangeTimes->{3.954469195372302*^9, 3.954469420530497*^9, 
  3.954470338506682*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"53a59ebd-81e5-45ad-ba4e-4b1a949db739"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellChangeTimes->{3.954469195372302*^9, 3.954469420530497*^9, 
  3.954470338507009*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"3c33c664-8534-4c85-a545-aa60ffc5fa5d"],

Cell[BoxData["\<\"These packages come with ABSOLUTELY NO WARRANTY; for \
details type Disclaimer[]. This is free software, and you are welcome to \
redistribute it under certain conditions. See the General Public License for \
details.\"\>"], "Print",
 CellChangeTimes->{3.954469195372302*^9, 3.954469420530497*^9, 
  3.9544703385073*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"a0d0bb11-b598-4e75-9305-819328429dbf"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellChangeTimes->{3.954469195372302*^9, 3.954469420530497*^9, 
  3.954470338507653*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"15511dd6-63f5-4c89-b802-81ff159c3a0e"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"DefManifold", "[", 
  RowBox[{"E3", ",", "3", ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "j"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"DefMetric", "[", 
  RowBox[{"1", ",", 
   RowBox[{"g", "[", 
    RowBox[{
     RowBox[{"-", "i"}], ",", 
     RowBox[{"-", "j"}]}], "]"}], ",", "CD", ",", 
   RowBox[{"{", 
    RowBox[{"\"\<;\>\"", ",", "\"\<\[Del]\>\""}], "}"}]}], 
  "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.9544692085962143`*^9, 3.954469274084681*^9}},
 CellLabel->"In[2]:=",ExpressionUUID->"daa9a283-370f-46e5-8afb-f0bb63d805a5"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefManifold", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"manifold \"\>", "\[InvisibleSpace]", "E3", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefManifold, ": Defining ", 
   "manifold ", $CellContext`E3, ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.954469279516581*^9, 3.954469422203299*^9, 
  3.954470339836688*^9},
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"3bc5e26c-363d-4b21-98d3-1877dd352497"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefVBundle", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vbundle \"\>", "\[InvisibleSpace]", "TangentE3", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefVBundle, ": Defining ", 
   "vbundle ", $CellContext`TangentE3, ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.954469279516581*^9, 3.954469422203299*^9, 
  3.954470339838542*^9},
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"34f4a1d0-caa5-44d1-a05b-b0003532c2aa"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric metric tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"g", "[", 
    RowBox[{
     RowBox[{"-", "i"}], ",", 
     RowBox[{"-", "j"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "symmetric metric tensor ", 
   $CellContext`g[-$CellContext`i, -$CellContext`j], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.954469279516581*^9, 3.954469422203299*^9, 
  3.9544703398389473`*^9},
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"0ce9eb58-91ea-4a89-a6f5-6c5ec86c73da"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"antisymmetric tensor \"\>", "\[InvisibleSpace]", 
   
   RowBox[{"epsilong", "[", 
    RowBox[{
     RowBox[{"-", "i"}], ",", 
     RowBox[{"-", "j"}], ",", 
     RowBox[{"-", "j1"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "antisymmetric tensor ", 
   $CellContext`epsilong[-$CellContext`i, -$CellContext`j, -$CellContext`j1], 
   ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.954469279516581*^9, 3.954469422203299*^9, 
  3.954470339839279*^9},
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"da884a1c-104b-4279-9cfc-33a9f9a88dc8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefCovD", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"covariant derivative \"\>", "\[InvisibleSpace]", 
   
   RowBox[{"CD", "[", 
    RowBox[{"-", "i"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefCovD, ": Defining ", "covariant derivative ", 
   $CellContext`CD[-$CellContext`i], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.954469279516581*^9, 3.954469422203299*^9, 
  3.954470339839583*^9},
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"2638fc14-a181-4b8e-91c3-e21a66ab0ffd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing torsion tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"TorsionCD", "[", 
    RowBox[{"i", ",", 
     RowBox[{"-", "j"}], ",", 
     RowBox[{"-", "j1"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "vanishing torsion tensor ", 
   $CellContext`TorsionCD[$CellContext`i, -$CellContext`j, -$CellContext`j1], 
   ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.954469279516581*^9, 3.954469422203299*^9, 
  3.95447033986158*^9},
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"45e5c6b1-ab4b-4d23-afa3-eb380d920395"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Christoffel tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"ChristoffelCD", "[", 
    RowBox[{"i", ",", 
     RowBox[{"-", "j"}], ",", 
     RowBox[{"-", "j1"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "symmetric Christoffel tensor ", 
   $CellContext`ChristoffelCD[$CellContext`i, -$CellContext`j, \
-$CellContext`j1], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.954469279516581*^9, 3.954469422203299*^9, 
  3.954470339893291*^9},
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"04eac041-767a-4112-8bd7-0910aea2a815"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Riemann tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"RiemannCD", "[", 
    RowBox[{
     RowBox[{"-", "i"}], ",", 
     RowBox[{"-", "j"}], ",", 
     RowBox[{"-", "j1"}], ",", 
     RowBox[{"-", "j2"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Riemann tensor ", 
   $CellContext`RiemannCD[-$CellContext`i, -$CellContext`j, -$CellContext`j1, \
-$CellContext`j2], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.954469279516581*^9, 3.954469422203299*^9, 
  3.954470339893889*^9},
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"ac60f8bd-a9a4-4af8-aa08-6f341871eabf"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Ricci tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"RicciCD", "[", 
    RowBox[{
     RowBox[{"-", "i"}], ",", 
     RowBox[{"-", "j"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "symmetric Ricci tensor ", 
   $CellContext`RicciCD[-$CellContext`i, -$CellContext`j], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.954469279516581*^9, 3.954469422203299*^9, 
  3.954470339894289*^9},
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"5b9b19c2-1171-4421-bba2-2c43a5672a7f"],

Cell[BoxData["\<\"** DefCovD:  Contractions of Riemann automatically replaced \
by Ricci.\"\>"], "Print",
 CellChangeTimes->{3.954469279516581*^9, 3.954469422203299*^9, 
  3.9544703398946037`*^9},
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"13e13a4d-4cee-4467-a390-a431a7836f18"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Ricci scalar \"\>", "\[InvisibleSpace]", 
   RowBox[{"RicciScalarCD", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Ricci scalar ", 
   $CellContext`RicciScalarCD[], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.954469279516581*^9, 3.954469422203299*^9, 
  3.9544703398949127`*^9},
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"ed817edd-c9d6-4463-9eae-8206b320730f"],

Cell[BoxData["\<\"** DefCovD:  Contractions of Ricci automatically replaced \
by RicciScalar.\"\>"], "Print",
 CellChangeTimes->{3.954469279516581*^9, 3.954469422203299*^9, 
  3.9544703398952227`*^9},
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"851ed0c1-2f35-4a35-92fa-250c9a7862f2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Einstein tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"EinsteinCD", "[", 
    RowBox[{
     RowBox[{"-", "i"}], ",", 
     RowBox[{"-", "j"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "symmetric Einstein tensor ", 
   $CellContext`EinsteinCD[-$CellContext`i, -$CellContext`j], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.954469279516581*^9, 3.954469422203299*^9, 
  3.9544703398955107`*^9},
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"ca919b2d-2b98-4901-8621-4b5c0727a491"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing Weyl tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"WeylCD", "[", 
    RowBox[{
     RowBox[{"-", "i"}], ",", 
     RowBox[{"-", "j"}], ",", 
     RowBox[{"-", "j1"}], ",", 
     RowBox[{"-", "j2"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "vanishing Weyl tensor ", 
   $CellContext`WeylCD[-$CellContext`i, -$CellContext`j, -$CellContext`j1, \
-$CellContext`j2], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.954469279516581*^9, 3.954469422203299*^9, 
  3.954470339895823*^9},
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"a5730226-8522-4764-8848-4babdf3746fc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric TFRicci tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"TFRicciCD", "[", 
    RowBox[{
     RowBox[{"-", "i"}], ",", 
     RowBox[{"-", "j"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "symmetric TFRicci tensor ", 
   $CellContext`TFRicciCD[-$CellContext`i, -$CellContext`j], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.954469279516581*^9, 3.954469422203299*^9, 
  3.954470339896126*^9},
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"47f96526-ce8c-4fe0-8eed-904e4561b254"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Kretschmann scalar \"\>", "\[InvisibleSpace]", 
   RowBox[{"KretschmannCD", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Kretschmann scalar ", 
   $CellContext`KretschmannCD[], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.954469279516581*^9, 3.954469422203299*^9, 
  3.954470339896426*^9},
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"79ce9fc1-4558-47ca-b47f-411b9b585a58"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** DefCovD:  Computing RiemannToWeylRules for dim \"\>", 
   "\[InvisibleSpace]", "3"}],
  SequenceForm["** DefCovD:  Computing RiemannToWeylRules for dim ", 3],
  Editable->False]], "Print",
 CellChangeTimes->{3.954469279516581*^9, 3.954469422203299*^9, 
  3.954470339896693*^9},
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"62853049-7306-4c17-83b4-87845ec11bbb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** DefCovD:  Computing RicciToTFRicci for dim \"\>", 
   "\[InvisibleSpace]", "3"}],
  SequenceForm["** DefCovD:  Computing RicciToTFRicci for dim ", 3],
  Editable->False]], "Print",
 CellChangeTimes->{3.954469279516581*^9, 3.954469422203299*^9, 
  3.954470339896946*^9},
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"36faf3eb-3bdc-4dfc-9087-026b0877784d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** DefCovD:  Computing RicciToEinsteinRules for dim \"\>", 
   "\[InvisibleSpace]", "3"}],
  SequenceForm["** DefCovD:  Computing RicciToEinsteinRules for dim ", 3],
  Editable->False]], "Print",
 CellChangeTimes->{3.954469279516581*^9, 3.954469422203299*^9, 
  3.954470339897183*^9},
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"bce8e53e-a6c3-46c7-9fbb-3482ae06ddbb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"weight +2 density \"\>", "\[InvisibleSpace]", 
   RowBox[{"Detg", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Determinant.\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "weight +2 density ", 
   $CellContext`Detg[], ". ", "Determinant."],
  Editable->False]], "Print",
 CellChangeTimes->{3.954469279516581*^9, 3.954469422203299*^9, 
  3.954470339911665*^9},
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"598f2a3e-4937-4f0f-9cbc-c1c2e1f50ca5"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"v", "[", "i", "]"}], ",", "E3"}], "]"}]], "Input",
 CellChangeTimes->{{3.954469290340166*^9, 3.954469301182283*^9}, {
  3.954469403958907*^9, 3.954469407293729*^9}},
 CellLabel->"In[4]:=",ExpressionUUID->"4a3e06f3-c173-4451-8aea-4729b070e79c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"v", "[", "i", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`v[$CellContext`i], ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.9544693036719112`*^9, 3.9544694244842873`*^9, 
  3.954470343119712*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"cb118546-f2d1-4b55-a6fe-3bf2247a0172"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefInertHead", "[", 
  RowBox[{"encap", ",", 
   RowBox[{"ContractThrough", "\[Rule]", 
    RowBox[{"{", "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.954469304436204*^9, 3.9544693503103447`*^9}, {
  3.9544703648516083`*^9, 
  3.954470374577853*^9}},ExpressionUUID->"290479b7-c1e2-46ae-8b3e-\
c4b0688b81d1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefInertHead", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"inert head \"\>", "\[InvisibleSpace]", "encap", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefInertHead, ": Defining ", 
   "inert head ", $CellContext`encap, ". ", ""],
  Editable->False]], "Print",
 CellChangeTimes->{3.9544693560647697`*^9, 3.9544694260203037`*^9, 
  3.9544703441296043`*^9},
 CellLabel->
  "During evaluation of \
In[5]:=",ExpressionUUID->"a4fd5d76-c2d0-4883-81bf-bf051b8b4c5d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToCanonical", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"g", "[", 
     RowBox[{"i", ",", "j"}], "]"}], 
    RowBox[{"v", "[", 
     RowBox[{"-", "j"}], "]"}]}], ",", 
   RowBox[{"UseMetricOnVBundle", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.954470431619027*^9, 3.9544704349694567`*^9}},
 CellLabel->"In[8]:=",ExpressionUUID->"1d5e1e4e-6053-47d9-b779-76b02f1a93c8"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"v", 
      StyleBox[GridBox[{
         {"i"},
         {" "}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "Rows" -> {{
             Offset[0.]}}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`v[$CellContext`i],
  Editable->False]], "Output",
 CellChangeTimes->{3.9544704355700417`*^9},
 CellLabel->"Out[8]=",ExpressionUUID->"8775a785-b435-4b22-a70b-bd346c33953d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToCanonical", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"g", "[", 
     RowBox[{"i", ",", "j"}], "]"}], 
    RowBox[{"encap", "[", 
     RowBox[{"v", "[", 
      RowBox[{"-", "j"}], "]"}], "]"}]}], ",", 
   RowBox[{"UseMetricOnVBundle", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.954469390014325*^9, 3.9544694520456953`*^9}, {
  3.954469483478635*^9, 3.954469491716134*^9}},
 CellLabel->"In[7]:=",ExpressionUUID->"1bbc3ed8-046d-40a6-b98e-9900258cf5dc"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Delta]", 
       StyleBox[GridBox[{
          {" ", "i"},
          {"j", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTensor`delta[-$CellContext`j, $CellContext`i],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[
    RowBox[{"encap", "[", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"v", 
          StyleBox[GridBox[{
             {"j"},
             {" "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`v[$CellContext`j],
      Editable->False], "]"}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`encap[
    $CellContext`v[$CellContext`j]],
   Editable->False]}]], "Output",
 CellChangeTimes->{{3.954469438934259*^9, 3.954469452357442*^9}, 
   3.9544694920476513`*^9, 3.954470304922617*^9, 3.9544703479032717`*^9},
 CellLabel->"Out[7]=",ExpressionUUID->"78a25a8b-00c2-4bce-ae15-1772bf8f6bee"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToCanonical", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"g", "[", 
     RowBox[{"i", ",", "j"}], "]"}], " ", 
    RowBox[{"encap", "[", 
     RowBox[{"v", "[", 
      RowBox[{"-", "j"}], "]"}], "]"}]}], ",", 
   RowBox[{"UseMetricOnVBundle", "\[Rule]", 
    RowBox[{"{", "g", "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.9544710862161922`*^9, 3.954471096742325*^9}},
 CellLabel->"In[10]:=",ExpressionUUID->"0ede2775-deb4-4e80-b7ee-9286c8a8aa93"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[
    RowBox[{"encap", "[", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"v", 
          StyleBox[GridBox[{
             {" "},
             {"j"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`v[-$CellContext`j],
      Editable->False], "]"}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`encap[
    $CellContext`v[-$CellContext`j]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"g", 
       StyleBox[GridBox[{
          {"i", "j"},
          {" ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`g[$CellContext`i, $CellContext`j],
   Editable->False]}]], "Output",
 CellChangeTimes->{{3.954471087598051*^9, 3.9544710974962883`*^9}},
 CellLabel->"Out[10]=",ExpressionUUID->"a7aa3cd7-6e57-4d23-8815-144795f46473"]
}, Open  ]]
},
WindowSize->{808.5, 665.25},
WindowMargins->{{Automatic, 172.5}, {Automatic, 40.5}},
FrontEndVersion->"13.3 for Linux x86 (64-bit) (July 24, 2023)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"a0d2c57e-4de7-46c0-9735-29e4038df917"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 222, 3, 28, "Input",ExpressionUUID->"084d4c49-7d3c-4234-b6c2-2887d6af824a"],
Cell[CellGroupData[{
Cell[827, 29, 289, 6, 22, "Print",ExpressionUUID->"a1f81f64-d7ca-4657-b155-bd1ca3b7cdd2"],
Cell[1119, 37, 563, 14, 22, "Print",ExpressionUUID->"1a1fa20c-7036-4e9a-91ef-bf1af1e23b4e"],
Cell[1685, 53, 312, 6, 22, "Print",ExpressionUUID->"755550b3-683c-4743-9c4b-bb2c0e261a2a"],
Cell[2000, 61, 269, 5, 22, "Print",ExpressionUUID->"bf95b643-c054-42ac-afa7-dc7fb37057a6"],
Cell[2272, 68, 252, 5, 22, "Print",ExpressionUUID->"a9cecbc9-1ff2-45dc-a264-58f81416da16"],
Cell[2527, 75, 289, 6, 22, "Print",ExpressionUUID->"5c7f8f7b-f42c-42cc-af55-db07cafc9617"],
Cell[2819, 83, 567, 14, 22, "Print",ExpressionUUID->"4247286c-d23f-448b-8b74-5ff971be2be0"],
Cell[3389, 99, 310, 6, 22, "Print",ExpressionUUID->"53a59ebd-81e5-45ad-ba4e-4b1a949db739"],
Cell[3702, 107, 289, 6, 22, "Print",ExpressionUUID->"3c33c664-8534-4c85-a545-aa60ffc5fa5d"],
Cell[3994, 115, 442, 8, 58, "Print",ExpressionUUID->"a0d0bb11-b598-4e75-9305-819328429dbf"],
Cell[4439, 125, 289, 6, 22, "Print",ExpressionUUID->"15511dd6-63f5-4c89-b802-81ff159c3a0e"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[4777, 137, 594, 15, 66, "Input",ExpressionUUID->"daa9a283-370f-46e5-8afb-f0bb63d805a5"],
Cell[CellGroupData[{
Cell[5396, 156, 623, 14, 22, "Print",ExpressionUUID->"3bc5e26c-363d-4b21-98d3-1877dd352497"],
Cell[6022, 172, 633, 14, 22, "Print",ExpressionUUID->"34f4a1d0-caa5-44d1-a05b-b0003532c2aa"],
Cell[6658, 188, 783, 19, 22, "Print",ExpressionUUID->"0ce9eb58-91ea-4a89-a6f5-6c5ec86c73da"],
Cell[7444, 209, 843, 21, 22, "Print",ExpressionUUID->"da884a1c-104b-4279-9cfc-33a9f9a88dc8"],
Cell[8290, 232, 709, 17, 22, "Print",ExpressionUUID->"2638fc14-a181-4b8e-91c3-e21a66ab0ffd"],
Cell[9002, 251, 830, 20, 22, "Print",ExpressionUUID->"45e5c6b1-ab4b-4d23-afa3-eb380d920395"],
Cell[9835, 273, 849, 21, 22, "Print",ExpressionUUID->"04eac041-767a-4112-8bd7-0910aea2a815"],
Cell[10687, 296, 877, 21, 22, "Print",ExpressionUUID->"ac60f8bd-a9a4-4af8-aa08-6f341871eabf"],
Cell[11567, 319, 791, 19, 22, "Print",ExpressionUUID->"5b9b19c2-1171-4421-bba2-2c43a5672a7f"],
Cell[12361, 340, 300, 6, 22, "Print",ExpressionUUID->"13e13a4d-4cee-4467-a390-a431a7836f18"],
Cell[12664, 348, 677, 15, 22, "Print",ExpressionUUID->"ed817edd-c9d6-4463-9eae-8206b320730f"],
Cell[13344, 365, 304, 6, 22, "Print",ExpressionUUID->"851ed0c1-2f35-4a35-92fa-250c9a7862f2"],
Cell[13651, 373, 809, 20, 22, "Print",ExpressionUUID->"ca919b2d-2b98-4901-8621-4b5c0727a491"],
Cell[14463, 395, 885, 21, 22, "Print",ExpressionUUID->"a5730226-8522-4764-8848-4babdf3746fc"],
Cell[15351, 418, 799, 19, 22, "Print",ExpressionUUID->"47f96526-ce8c-4fe0-8eed-904e4561b254"],
Cell[16153, 439, 687, 15, 22, "Print",ExpressionUUID->"79ce9fc1-4558-47ca-b47f-411b9b585a58"],
Cell[16843, 456, 433, 10, 22, "Print",ExpressionUUID->"62853049-7306-4c17-83b4-87845ec11bbb"],
Cell[17279, 468, 425, 10, 22, "Print",ExpressionUUID->"36faf3eb-3bdc-4dfc-9087-026b0877784d"],
Cell[17707, 480, 437, 10, 22, "Print",ExpressionUUID->"bce8e53e-a6c3-46c7-9fbb-3482ae06ddbb"],
Cell[18147, 492, 691, 15, 22, "Print",ExpressionUUID->"598f2a3e-4937-4f0f-9cbc-c1c2e1f50ca5"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[18887, 513, 308, 6, 28, "Input",ExpressionUUID->"4a3e06f3-c173-4451-8aea-4729b070e79c"],
Cell[19198, 521, 659, 14, 22, "Print",ExpressionUUID->"cb118546-f2d1-4b55-a6fe-3bf2247a0172"]
}, Open  ]],
Cell[CellGroupData[{
Cell[19894, 540, 335, 8, 28, "Input",ExpressionUUID->"290479b7-c1e2-46ae-8b3e-c4b0688b81d1"],
Cell[20232, 550, 641, 14, 22, "Print",ExpressionUUID->"a4fd5d76-c2d0-4883-81bf-bf051b8b4c5d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[20910, 569, 408, 10, 28, "Input",ExpressionUUID->"1d5e1e4e-6053-47d9-b779-76b02f1a93c8"],
Cell[21321, 581, 904, 28, 38, "Output",ExpressionUUID->"8775a785-b435-4b22-a70b-bd346c33953d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[22262, 614, 493, 12, 28, "Input",ExpressionUUID->"1bbc3ed8-046d-40a6-b98e-9900258cf5dc"],
Cell[22758, 628, 2145, 64, 41, "Output",ExpressionUUID->"78a25a8b-00c2-4bce-ae15-1772bf8f6bee"]
}, Open  ]],
Cell[CellGroupData[{
Cell[24940, 697, 473, 12, 28, "Input",ExpressionUUID->"0ede2775-deb4-4e80-b7ee-9286c8a8aa93"],
Cell[25416, 711, 2064, 63, 38, "Output",ExpressionUUID->"a7aa3cd7-6e57-4d23-8815-144795f46473"]
}, Open  ]]
}
]
*)

