Notebook[{

Cell[CellGroupData[{
Cell["xConf. Documentation", "Chapter",
 FontSize->36,ExpressionUUID->"0b2e2b07-3319-4e03-bd69-a9abfb94fd76"],

Cell["\<\
This is the doc file xConfDoc.nb of version 0.0.1 of xAct/xConf`. Last update \
on 04 April 2025.\
\>", "Text",ExpressionUUID->"5e9244e0-dbc8-4140-baa3-6e2366f43568"],

Cell[CellGroupData[{

Cell["Preamble", \
"Subsection",ExpressionUUID->"5ee25e85-654e-49d5-a4bb-acf84104e23a"],

Cell[CellGroupData[{

Cell["Author", "SubsubsectionIcon",
 CellFrame->{{0, 0}, {
   0, 0.5}},ExpressionUUID->"f0f9771a-0057-4834-b1cf-06061b6df66c"],

Cell["\<\
\[Copyright] 2025-2026, under the GNU General Public License (GPL)
     Authors: Cyril Pitrou, Guillaume Faye\
\>", "Text",ExpressionUUID->"e906b077-e71f-4cef-95d6-89fca18c4721"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Intro", "SubsubsectionIcon",
 CellFrame->{{0, 0}, {
   0, 0.5}},ExpressionUUID->"52c38469-d2e7-4ffb-aa97-d8a9619c3fc1"],

Cell["\<\
xAct`xConf` is a Mathematica Package which provides tools to compute formally \
the conformal transformations.\
\>", "Text",
 CellTags->{
  "S5.18.1", "1.2"},ExpressionUUID->"f515dbb0-1702-478d-b136-6709a92df92a"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Loading the package", "SubsubsectionIcon",
 CellFrame->{{0, 0}, {
   0, 0.5}},ExpressionUUID->"430c7d0d-17a8-4fea-80f5-489c3c9465f1"],

Cell["\<\
Loading the package is straightforward once it has been appropriately \
installed:
You just have to evaluate: '<< xAct`xConf.m;'
This loads all the definitions, but does not start any computation. 
We can also check how much memory space it takes to store all the \
definitions, and the time it takes to load them\
\>", "Text",ExpressionUUID->"0ef8ff4a-17d8-4d16-a92e-3eeb92535375"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"MemBefore", "=", 
   RowBox[{"MemoryInUse", "[", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Needs", "[", "\"\<xAct`xConf`\>\"", "]"}], ";"}], "//", 
   "Timing"}], "//", "First"}]}], "Input",
 CellLabel->"In[1]:=",ExpressionUUID->"e5302618-bd43-4323-96b0-128d950349af"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[1]:=",ExpressionUUID->"b3df56f7-0ad4-404c-8c2d-1ef771068536"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`xPerm`  version \"\>", 
   "\[InvisibleSpace]", "\<\"1.2.3\"\>", "\[InvisibleSpace]", "\<\", \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2015", ",", "8", ",", "23"}], "}"}]}],
  SequenceForm["Package xAct`xPerm`  version ", "1.2.3", ", ", {2015, 8, 23}],
  
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[1]:=",ExpressionUUID->"6703196e-64a9-42f9-b315-e6a66d603e96"],

Cell[BoxData["\<\"CopyRight (C) 2003-2020, Jose M. Martin-Garcia, under the \
General Public License.\"\>"], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[1]:=",ExpressionUUID->"0aa5861d-0f20-480e-9eed-c1b4c5cd11db"],

Cell[BoxData["\<\"Connecting to external mac executable...\"\>"], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[1]:=",ExpressionUUID->"1952a476-fbc1-4c2e-92e8-5838d034e099"],

Cell[BoxData["\<\"Connection established.\"\>"], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[1]:=",ExpressionUUID->"a1d5b568-33ee-4ea2-b9bf-99cd834787f4"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[1]:=",ExpressionUUID->"f0ca3fb3-9166-4610-83f8-a48b71103432"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`xTensor`  version \"\>", 
   "\[InvisibleSpace]", "\<\"1.2.0\"\>", "\[InvisibleSpace]", "\<\", \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2021", ",", "10", ",", "17"}], "}"}]}],
  SequenceForm[
  "Package xAct`xTensor`  version ", "1.2.0", ", ", {2021, 10, 17}],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[1]:=",ExpressionUUID->"9651fdc4-45df-4d60-b202-f9595b22fc03"],

Cell[BoxData["\<\"CopyRight (C) 2002-2021, Jose M. Martin-Garcia, under the \
General Public License.\"\>"], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[1]:=",ExpressionUUID->"4f27bcee-b90b-4e18-a665-47fcf4de9064"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[1]:=",ExpressionUUID->"c0595c89-3450-4331-881d-236092770516"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`xConf`  version \"\>", 
   "\[InvisibleSpace]", "\<\"0.0.1\"\>", "\[InvisibleSpace]", "\<\", \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2025", ",", "4", ",", "4"}], "}"}]}],
  SequenceForm["Package xAct`xConf`  version ", "0.0.1", ", ", {2025, 4, 4}],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[1]:=",ExpressionUUID->"1b5374f1-a85c-4684-a659-aed5b1cb8040"],

Cell[BoxData["\<\"CopyRight (C) 2025-2026, Cyril Pitrou, Guillaume under the \
General Public License.\"\>"], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[1]:=",ExpressionUUID->"860de08e-3a91-4a7e-96ab-8619d12842ad"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[1]:=",ExpressionUUID->"bc7f7a0f-69cc-486b-ae7d-76f5abc6571b"],

Cell[BoxData["\<\"These packages come with ABSOLUTELY NO WARRANTY; for \
details type Disclaimer[]. This is free software, and you are welcome to \
redistribute it under certain conditions. See the General Public License for \
details.\"\>"], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[1]:=",ExpressionUUID->"c75b7fb8-4a3a-4123-af51-dfb230e9ccd5"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[1]:=",ExpressionUUID->"3f9e7c1e-3b09-49a3-9909-ebf53efcb37d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** Variable \"\>", "\[InvisibleSpace]", "$PrePrint", 
   "\[InvisibleSpace]", "\<\" assigned value \"\>", "\[InvisibleSpace]", 
   "ScreenDollarIndices"}],
  SequenceForm[
  "** Variable ", $PrePrint, " assigned value ", 
   xAct`xTensor`ScreenDollarIndices],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[1]:=",ExpressionUUID->"04fb0969-6738-4487-89d8-fe36519ec327"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** Option \"\>", "\[InvisibleSpace]", "AllowUpperDerivatives", 
   "\[InvisibleSpace]", "\<\" of \"\>", "\[InvisibleSpace]", "ContractMetric",
    "\[InvisibleSpace]", "\<\" changed from \"\>", "\[InvisibleSpace]", 
   "False", "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", "True"}],
  SequenceForm[
  "** Option ", xAct`xTensor`AllowUpperDerivatives, " of ", 
   xAct`xTensor`ContractMetric, " changed from ", False, " to ", True],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[1]:=",ExpressionUUID->"b0aa45e6-d133-4685-b200-a8c6a6a98d27"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** Option \"\>", "\[InvisibleSpace]", "UseMetricOnVBundle", 
   "\[InvisibleSpace]", "\<\" of \"\>", "\[InvisibleSpace]", "ToCanonical", 
   "\[InvisibleSpace]", "\<\" changed from \"\>", "\[InvisibleSpace]", "All", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", "None"}],
  SequenceForm[
  "** Option ", xAct`xTensor`UseMetricOnVBundle, " of ", 
   xAct`xTensor`ToCanonical, " changed from ", All, " to ", None],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[1]:=",ExpressionUUID->"62cead7f-f10d-4e2c-8a33-758d7c31ee68"],

Cell[BoxData["0.248054`"], "Output",
 CellLabel->"Out[2]=",ExpressionUUID->"51106cb3-8469-4160-ad36-cffcc989e1da"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"MemoryInUse", "[", "]"}], "-", "MemBefore"}]], "Input",
 CellLabel->"In[3]:=",ExpressionUUID->"0faae2a8-bc35-4eb7-a036-881a7326a04e"],

Cell[BoxData["15164752"], "Output",
 CellLabel->"Out[3]=",ExpressionUUID->"1e624729-0089-42df-ab66-93096e4457b4"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["GPL", "SubsubsectionIcon",
 CellFrame->{{0, 0}, {
   0, 0.5}},ExpressionUUID->"68275b90-1fb0-4ad1-8ade-c7dfaa1e7223"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Disclaimer", "[", "]"}]], "Input",
 CellLabel->"In[4]:=",ExpressionUUID->"a6acfc6b-7d40-48eb-b766-89a4a7d26e81"],

Cell[BoxData["\<\"These are points 11 and 12 of the General Public \
License:\\n\\nBECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO \
WARRANTY FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW. EXCEPT \
WHEN OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES \
PROVIDE THE PROGRAM `AS IS\.b4 WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED \
OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF \
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE ENTIRE RISK AS TO \
THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU. SHOULD THE PROGRAM \
PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR OR \
CORRECTION.\\n\\nIN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO \
IN WRITING WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY \
AND/OR REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR \
DAMAGES, INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES \
ARISING OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT \
LIMITED TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED \
BY YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER \
PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE \
POSSIBILITY OF SUCH DAMAGES.\"\>"], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[4]:=",ExpressionUUID->"f6448987-e369-4d7d-937a-5eee6849c7ba"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Overview", "Chapter",
 CellFrame->{{0, 0}, {2, 
  0}},ExpressionUUID->"1429214f-9547-49f8-9c4c-0b478046673f"],

Cell[CellGroupData[{

Cell["Defining Manifold and fields", \
"Subsection",ExpressionUUID->"4a948fe2-1548-47d1-b3dc-e2e35a4ba86a"],

Cell["We define a Manifold and a base metric g", "Text",
 CellTags->{
  "S5.18.1", "1.2"},ExpressionUUID->"f5c32027-8f0a-4295-94c2-fdcb191bc630"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"DefManifold", "[", 
  RowBox[{"M", ",", "4", ",", 
   RowBox[{"{", 
    RowBox[{
    "\[Alpha]", ",", "\[Beta]", ",", "\[Gamma]", ",", "\[Mu]", ",", "\[Nu]", 
     ",", "\[Lambda]", ",", "\[Sigma]"}], "}"}]}], "]"}], "\n", 
 RowBox[{
  RowBox[{"DefMetric", "[", 
   RowBox[{
    RowBox[{"-", "1"}], ",", 
    RowBox[{"g", "[", 
     RowBox[{
      RowBox[{"-", "\[Alpha]"}], ",", 
      RowBox[{"-", "\[Beta]"}]}], "]"}], ",", "CD", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<;\>\"", ",", "\"\<\[Del]\>\""}], "}"}], ",", 
    RowBox[{"PrintAs", "\[Rule]", "\"\<g\>\""}]}], "]"}], ";"}]}], "Input",
 CellLabel->"In[5]:=",ExpressionUUID->"d21485ee-dd59-4719-bef4-58ede0eac4f6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefManifold", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"manifold \"\>", "\[InvisibleSpace]", "M", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefManifold, ": Defining ", "manifold ", $CellContext`M,
    ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"9a0ad337-1755-4667-ade9-ff79c5e634a5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefVBundle", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vbundle \"\>", "\[InvisibleSpace]", "TangentM", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefVBundle, ": Defining ", 
   "vbundle ", $CellContext`TangentM, ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"9e393a97-da27-41e3-b07c-b946d802ff87"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric metric tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"g", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "symmetric metric tensor ", 
   $CellContext`g[-$CellContext`\[Alpha], -$CellContext`\[Beta]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"0ff30bd6-b0f1-4649-8571-97ce79acd94b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"antisymmetric tensor \"\>", "\[InvisibleSpace]", 
   
   RowBox[{"epsilong", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}], ",", 
     RowBox[{"-", "\[Lambda]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "antisymmetric tensor ", 
   $CellContext`epsilong[-$CellContext`\[Alpha], -$CellContext`\[Beta], \
-$CellContext`\[Gamma], -$CellContext`\[Lambda]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"0fa7eca1-648d-486c-9f1c-8e27c72ffe26"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tetrametric \"\>", "\[InvisibleSpace]", 
   RowBox[{"Tetrag", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}], ",", 
     RowBox[{"-", "\[Lambda]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tetrametric ", 
   $CellContext`Tetrag[-$CellContext`\[Alpha], -$CellContext`\[Beta], \
-$CellContext`\[Gamma], -$CellContext`\[Lambda]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"d191bb0e-e77f-4205-982f-08d539241cdc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tetrametric \"\>", "\[InvisibleSpace]", 
   RowBox[{"Tetrag\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}], ",", 
     RowBox[{"-", "\[Lambda]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tetrametric ", 
   $CellContext`Tetrag\[Dagger][-$CellContext`\[Alpha], \
-$CellContext`\[Beta], -$CellContext`\[Gamma], -$CellContext`\[Lambda]], ". ",
    ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"a85ff73c-669b-4653-9764-ac340899120c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefCovD", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"covariant derivative \"\>", "\[InvisibleSpace]", 
   
   RowBox[{"CD", "[", 
    RowBox[{"-", "\[Alpha]"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefCovD, ": Defining ", "covariant derivative ", 
   $CellContext`CD[-$CellContext`\[Alpha]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"03517d19-35fd-4cf7-a8f6-a8a035b78a41"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing torsion tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"TorsionCD", "[", 
    RowBox[{"\[Alpha]", ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "vanishing torsion tensor ", 
   $CellContext`TorsionCD[$CellContext`\[Alpha], -$CellContext`\[Beta], \
-$CellContext`\[Gamma]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"8275b272-ab8f-4431-9232-5243a93a6a01"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Christoffel tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"ChristoffelCD", "[", 
    RowBox[{"\[Alpha]", ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "symmetric Christoffel tensor ", 
   $CellContext`ChristoffelCD[$CellContext`\[Alpha], -$CellContext`\[Beta], \
-$CellContext`\[Gamma]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"d118f9d6-8ada-4aa8-ba9f-1ad4872c0147"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Riemann tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"RiemannCD", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}], ",", 
     RowBox[{"-", "\[Lambda]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Riemann tensor ", 
   $CellContext`RiemannCD[-$CellContext`\[Alpha], -$CellContext`\[Beta], \
-$CellContext`\[Gamma], -$CellContext`\[Lambda]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"aff4074a-80e7-4339-bc64-b8696ad4b591"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Ricci tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"RicciCD", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "symmetric Ricci tensor ", 
   $CellContext`RicciCD[-$CellContext`\[Alpha], -$CellContext`\[Beta]], ". ", 
   ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"12c2b55e-ee1f-40dc-a935-886eb3f8423a"],

Cell[BoxData["\<\"** DefCovD:  Contractions of Riemann automatically replaced \
by Ricci.\"\>"], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"833fbf92-fccd-4182-8d32-d3a0d83e150d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Ricci scalar \"\>", "\[InvisibleSpace]", 
   RowBox[{"RicciScalarCD", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Ricci scalar ", 
   $CellContext`RicciScalarCD[], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"c8af6a39-b440-4ee5-ab3f-e0b598e33deb"],

Cell[BoxData["\<\"** DefCovD:  Contractions of Ricci automatically replaced \
by RicciScalar.\"\>"], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"b126f8b2-e6c8-446d-8f17-578f8e5ddc45"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Einstein tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"EinsteinCD", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "symmetric Einstein tensor ", 
   $CellContext`EinsteinCD[-$CellContext`\[Alpha], -$CellContext`\[Beta]], 
   ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"44edd4f0-5a21-41b0-83c7-dca8bbfbacbc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Weyl tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"WeylCD", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}], ",", 
     RowBox[{"-", "\[Lambda]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "Weyl tensor ", 
   $CellContext`WeylCD[-$CellContext`\[Alpha], -$CellContext`\[Beta], \
-$CellContext`\[Gamma], -$CellContext`\[Lambda]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"21812d88-dced-49a0-b312-100e5180d8c4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric TFRicci tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"TFRicciCD", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "symmetric TFRicci tensor ", 
   $CellContext`TFRicciCD[-$CellContext`\[Alpha], -$CellContext`\[Beta]], 
   ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"89f7723b-96ed-40cd-8fb3-9dcf072e9922"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Kretschmann scalar \"\>", "\[InvisibleSpace]", 
   RowBox[{"KretschmannCD", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Kretschmann scalar ", 
   $CellContext`KretschmannCD[], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"67d0432a-13e5-42ed-bb3d-9fa5cda50224"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** DefCovD:  Computing RiemannToWeylRules for dim \"\>", 
   "\[InvisibleSpace]", "4"}],
  SequenceForm["** DefCovD:  Computing RiemannToWeylRules for dim ", 4],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"850573a9-a084-493e-ac69-6aef6db7d25f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** DefCovD:  Computing RicciToTFRicci for dim \"\>", 
   "\[InvisibleSpace]", "4"}],
  SequenceForm["** DefCovD:  Computing RicciToTFRicci for dim ", 4],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"433b4912-07d3-4a93-9886-815f2d7e2d94"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** DefCovD:  Computing RicciToEinsteinRules for dim \"\>", 
   "\[InvisibleSpace]", "4"}],
  SequenceForm["** DefCovD:  Computing RicciToEinsteinRules for dim ", 4],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"089c2a90-c7d2-465f-b8ac-5e1ded437ff5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"weight +2 density \"\>", "\[InvisibleSpace]", 
   RowBox[{"Detg", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Determinant.\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "weight +2 density ", 
   $CellContext`Detg[], ". ", "Determinant."],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"c5d97cf2-0802-4adf-bf5d-31084dce5cbb"]
}, Open  ]],

Cell["We define a a few tensors on that manifold", "Text",
 CellTags->{
  "S5.18.1", "1.2"},ExpressionUUID->"116e20fa-c9cd-4e1d-af90-bf76e1da55d3"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"k", "[", 
    RowBox[{"-", "\[Alpha]"}], "]"}], ",", 
   RowBox[{"{", "M", "}"}], ",", 
   RowBox[{"PrintAs", "\[Rule]", "\"\<k\>\""}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"MT2", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}]}], "]"}], ",", 
   RowBox[{"{", "M", "}"}], ",", 
   RowBox[{"PrintAs", "\[Rule]", "\"\<M\>\""}]}], "]"}]}], "Input",
 CellLabel->"In[7]:=",ExpressionUUID->"19f9ddd6-b8a2-4103-bb0a-1ac74cf0c033"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"k", "[", 
    RowBox[{"-", "\[Alpha]"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`k[-$CellContext`\[Alpha]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[7]:=",ExpressionUUID->"5de15d6d-9715-4a4d-8078-5e4e35208eb0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"MT2", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`MT2[-$CellContext`\[Alpha], -$CellContext`\[Beta]], ". ", ""],
  
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[7]:=",ExpressionUUID->"bf3f902d-ad89-44c6-b54a-61da40a37b93"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Conformal Weights of tensors", \
"Subsection",ExpressionUUID->"0bcfeb3d-4ed3-42e1-ac5e-03178e257626"],

Cell["Each tensor has a default conformal weight", "Text",
 CellTags->{
  "S5.18.1", "1.2"},ExpressionUUID->"5edbe4c5-5e48-41f5-8182-4baa66c7b118"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "ConformalWeight"}]], "Input",
 CellLabel->"In[9]:=",ExpressionUUID->"0f418874-94d0-40ed-9f03-92bba49c2720"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = False, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox[
             TagBox[
              TooltipBox[
               StyleBox["\<\" Symbol\"\>", "InformationRowLabel",
                StripOnInput->False],
               "\"Symbol\"",
               TooltipStyle->"TextStyling"],
              Annotation[#, "Symbol", "Tooltip"]& ], "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"ConformalWeight[tensor[inds]] specifies the power \
of the conformal factor applied in the conformal transformation of the tensor \
'tensor'. It corresponds to the number of down indices, minus the number of \
up indices, plus the quantity ConformalWeight[tensor] (without the indices). \
The latter is set by default to zero. \\n\\nFor instance, with the setting \
ConformalWeight[tensor] = 0, we have: \
ConformalWeight[tensor[\[Alpha],\[Beta]]] = -2, and ConformalWeight[tensor[-\
\[Alpha],-\[Beta]]] = 2.\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[
           TagBox[GridBox[{
              {
               StyleBox[
                TagBox[
                 TooltipBox[
                  StyleBox["\<\" Definitions\"\>", "InformationRowLabel",
                   StripOnInput->False],
                  "\"Definitions\"",
                  TooltipStyle->"TextStyling"],
                 Annotation[#, "Definitions", "Tooltip"]& ], "DialogStyle",
                StripOnInput->False]},
              {
               TemplateBox[{"\"\[ThinSpace]\"", 
                 GridBox[{{
                    RowBox[{
                    RowBox[{"ConformalWeight", "[", 
                    RowBox[{"xAct`xConf`Private`tens_", "?", "xTensorQ"}], 
                    "]"}], ":=", "0"}]}, {" "}, {
                    RowBox[{
                    RowBox[{"ConformalWeight", "[", 
                    RowBox[{
                    RowBox[{"xAct`xConf`Private`tens_", "?", "xTensorQ"}], 
                    "[", "xAct`xConf`Private`indices___", "]"}], "]"}], ":=", 
                    
                    RowBox[{
                    
                    RowBox[{
                    "ConformalWeight", "[", "xAct`xConf`Private`tens", "]"}], 
                    "+", 
                    RowBox[{"xAct`xConf`Private`WeightOfIndicesList", "[", 
                    RowBox[{"{", "xAct`xConf`Private`indices", "}"}], 
                    "]"}]}]}]}, {" "}, {
                    RowBox[{
                    RowBox[{"ConformalWeight", "[", 
                    RowBox[{"xAct`xConf`Private`f_", "?", "ScalarFunctionQ"}],
                     "]"}], ":=", "0"}]}, {" "}}, 
                  GridBoxAlignment -> {"Columns" -> {{Left}}}, 
                  DefaultBaseStyle -> "Column", 
                  GridBoxItemSize -> {
                   "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}]},
                "RowDefault"]}
             },
             DefaultBaseStyle->"Column",
             GridBoxAlignment->{"Columns" -> {{Left}}},
             
             GridBoxItemSize->{
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
            "Column"],
           FrameMargins->{{6, 0}, {3, 6}}], "\<\"\"\>"},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"xAct`xConf`ConformalWeight\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->{{6, 6}, {6, 3}}], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox[
             TagBox[
              TooltipBox[
               StyleBox["\<\" Symbol\"\>", "InformationRowLabel",
                StripOnInput->False],
               "\"Symbol\"",
               TooltipStyle->"TextStyling"],
              Annotation[#, "Symbol", "Tooltip"]& ], "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"ConformalWeight[tensor[inds]] specifies the power \
of the conformal factor applied in the conformal transformation of the tensor \
'tensor'. It corresponds to the number of down indices, minus the number of \
up indices, plus the quantity ConformalWeight[tensor] (without the indices). \
The latter is set by default to zero. \\n\\nFor instance, with the setting \
ConformalWeight[tensor] = 0, we have: \
ConformalWeight[tensor[\[Alpha],\[Beta]]] = -2, and ConformalWeight[tensor[-\
\[Alpha],-\[Beta]]] = 2.\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"],
               ImageSizeCache->{10., {3., 7.}}], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"],
               ImageSizeCache->{10., {3., 7.}}]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[<|
   "ObjectType" -> "Symbol", "Usage" -> 
    "ConformalWeight[tensor[inds]] specifies the power of the conformal \
factor applied in the conformal transformation of the tensor 'tensor'. It \
corresponds to the number of down indices, minus the number of up indices, \
plus the quantity ConformalWeight[tensor] (without the indices). The latter \
is set by default to zero. \n\nFor instance, with the setting \
ConformalWeight[tensor] = 0, we have: \
ConformalWeight[tensor[\[Alpha],\[Beta]]] = -2, and ConformalWeight[tensor[-\
\[Alpha],-\[Beta]]] = 2.", "Documentation" -> None, "OwnValues" -> None, 
    "UpValues" -> None, "DownValues" -> 
    Information`InformationValueForm[
     DownValues, xAct`xConf`ConformalWeight, {xAct`xConf`ConformalWeight[
         PatternTest[
          Pattern[xAct`xConf`Private`tens, 
           Blank[]], xAct`xTensor`xTensorQ]] :> 0, 
       xAct`xConf`ConformalWeight[
         PatternTest[
          Pattern[xAct`xConf`Private`tens, 
           Blank[]], xAct`xTensor`xTensorQ][
          Pattern[xAct`xConf`Private`indices, 
           BlankNullSequence[]]]] :> 
       xAct`xConf`ConformalWeight[xAct`xConf`Private`tens] + 
        xAct`xConf`Private`WeightOfIndicesList[{xAct`xConf`Private`indices}], 
       xAct`xConf`ConformalWeight[
         PatternTest[
          Pattern[xAct`xConf`Private`f, 
           Blank[]], xAct`xTensor`ScalarFunctionQ]] :> 0}], "SubValues" -> 
    None, "DefaultValues" -> None, "NValues" -> None, "FormatValues" -> None, 
    "Options" -> None, "Attributes" -> {}, "FullName" -> 
    "xAct`xConf`ConformalWeight"|>, False]]], "Output",
 CellLabel->"Out[9]=",ExpressionUUID->"8123dbe9-fabf-4e27-9488-cc23fbc72378"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"ConformalWeight", "[", "k", "]"}], "\[IndentingNewLine]", 
 RowBox[{"ConformalWeight", "[", "MT2", "]"}]}], "Input",
 CellLabel->"In[10]:=",ExpressionUUID->"fa46add7-019c-405f-9cc3-d6c8b659062a"],

Cell[BoxData["0"], "Output",
 CellLabel->"Out[10]=",ExpressionUUID->"18df2dfc-23c5-41b4-91da-cdece859536b"],

Cell[BoxData["0"], "Output",
 CellLabel->
  "Out[11]=",ExpressionUUID->"d74e8cf3-8330-4c45-b459-8a9d35e69a86"]
}, Open  ]],

Cell["It can be modified", "Text",
 CellTags->{
  "S5.18.1", "1.2"},ExpressionUUID->"eed6645d-0bd5-4322-b849-3e2d6d22d55b"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"ConformalWeight", "[", "k", "]"}], "=", 
   RowBox[{"-", "1"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"ConformalWeight", "[", "k", "]"}]}], "Input",
 CellLabel->"In[12]:=",ExpressionUUID->"0204f3d5-179d-4f2c-9877-70d11f7bafd7"],

Cell[BoxData[
 RowBox[{"-", "1"}]], "Output",
 CellLabel->
  "Out[13]=",ExpressionUUID->"09d02d2a-4cb4-4720-8e50-0e4599311543"]
}, Open  ]],

Cell["\<\
The weight of the tensor with indices then depends on the positioning of \
indices\
\>", "Text",
 CellTags->{
  "S5.18.1", "1.2"},ExpressionUUID->"9cb32c33-28e6-43a4-9832-6f5073d5f462"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"ConformalWeight", "[", 
  RowBox[{"k", "[", 
   RowBox[{"-", "\[Mu]"}], "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"ConformalWeight", "[", 
  RowBox[{"k", "[", "\[Mu]", "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"ConformalWeight", "[", 
  RowBox[{"MT2", "[", 
   RowBox[{
    RowBox[{"-", "\[Alpha]"}], ",", 
    RowBox[{"-", "\[Beta]"}]}], "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"ConformalWeight", "[", 
  RowBox[{"MT2", "[", 
   RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"ConformalWeight", "[", 
  RowBox[{"MT2", "[", 
   RowBox[{"\[Alpha]", ",", 
    RowBox[{"-", "\[Beta]"}]}], "]"}], "]"}]}], "Input",
 CellLabel->"In[14]:=",ExpressionUUID->"9f47c426-999d-4fb0-9ed5-e8601a19e1cd"],

Cell[BoxData["0"], "Output",
 CellLabel->"Out[14]=",ExpressionUUID->"b6714c95-4900-4f80-972a-3e122fc509e2"],

Cell[BoxData[
 RowBox[{"-", "2"}]], "Output",
 CellLabel->"Out[15]=",ExpressionUUID->"58a2cb8a-97b1-450e-be47-55e30566318c"],

Cell[BoxData["2"], "Output",
 CellLabel->"Out[16]=",ExpressionUUID->"f4d66194-4951-4487-98ce-5cc2cfcf0dcd"],

Cell[BoxData[
 RowBox[{"-", "2"}]], "Output",
 CellLabel->"Out[17]=",ExpressionUUID->"931cb38b-679e-453b-a5ed-8c145e16ae73"],

Cell[BoxData["0"], "Output",
 CellLabel->
  "Out[18]=",ExpressionUUID->"8cc38eb7-7099-4dca-811f-73ad9d9c7cd9"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Conformally related metrics", \
"Subsubsection",ExpressionUUID->"2da890fa-6736-48ba-82f5-a50a095c6232"],

Cell["\<\
We can define metrics which are conformally related to previous metrics\
\>", "Text",
 CellTags->{
  "S5.18.1", "1.2"},ExpressionUUID->"0fba88dc-14b6-4515-90bd-cd8abfb185c6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "DefConformalMetric"}]], "Input",
 CellLabel->"In[19]:=",ExpressionUUID->"c0513b6f-3e92-4c49-9f1a-48d971206ec5"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = False, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox[
             TagBox[
              TooltipBox[
               StyleBox["\<\" Symbol\"\>", "InformationRowLabel",
                StripOnInput->False],
               "\"Symbol\"",
               TooltipStyle->"TextStyling"],
              Annotation[#, "Symbol", "Tooltip"]& ], "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"DefConformalMetric[g,S] defines a metric \
conformally related to 'g', with the conformal factor 'S'. If other metrics \
are conformally related to 'g', then 'gS2' is related to them by transitivity \
of the conformal transformation. If the scalar field S[] does not exist, it \
is defined.\\n   Options are PrintAs->printasform, \
ConformalMetricName->MetricName, FrameColor->somecolor and \
SymbolOfCovD->{postfixsymbol,prefixsymbol}. If no ConformalMetricName is \
provided the name chosen is the concatenation 'metric+conformalfactor+2'. If \
no color is provided, it choses randomly a color. If no SymbolOfCovD is \
provided, the combination {:,\[Del]metricname} is chosen.\"\>", 
             "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[
           TagBox[GridBox[{
              {
               StyleBox[
                TagBox[
                 TooltipBox[
                  StyleBox["\<\" Definitions\"\>", "InformationRowLabel",
                   StripOnInput->False],
                  "\"Definitions\"",
                  TooltipStyle->"TextStyling"],
                 Annotation[#, "Definitions", "Tooltip"]& ], "DialogStyle",
                StripOnInput->False]},
              {
               TemplateBox[{"\"\[ThinSpace]\"", 
                 GridBox[{{
                    RowBox[{
                    RowBox[{"DefConformalMetric", "[", "]"}], ":=", 
                    RowBox[{"Message", "[", 
                    RowBox[{
                    StyleBox[
                    RowBox[{"DefConformalMetric", "::", "argm"}], 
                    "MessageName"], ",", "DefConformalMetric", ",", "0", ",", 
                    "2"}], "]"}]}]}, {" "}, {
                    RowBox[{
                    RowBox[{"DefConformalMetric", "[", 
                    RowBox[{
                    RowBox[{"xAct`xConf`Private`g_", "?", "MetricQ"}], ",", 
                    "xAct`xConf`Private`conffactor_", ",", 
                    RowBox[{"xAct`xConf`Private`options", ":", 
                    RowBox[{"OptionsPattern", "[", "]"}]}]}], "]"}], ":=", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"xAct`xConf`Private`nmetlist", ",", 
                    "xAct`xConf`Private`pas", ",", 
                    "xAct`xConf`Private`gconfnameraw", ",", 
                    "xAct`xConf`Private`cdgconf", ",", 
                    "xAct`xConf`Private`metlist", ",", 
                    "xAct`xConf`Private`color", ",", 
                    "xAct`xConf`Private`symbolscovd"}], "}"}], ",", 
                    RowBox[{"Catch", "[", 
                    RowBox[{"With", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"xAct`xConf`Private`M", "=", 
                    RowBox[{"ManifoldOfCovD", "[", 
                    
                    RowBox[{"CovDOfMetric", "[", "xAct`xConf`Private`g", 
                    "]"}], "]"}]}], ",", 
                    RowBox[{"xAct`xConf`Private`CD", "=", 
                    
                    RowBox[{"CovDOfMetric", "[", "xAct`xConf`Private`g", 
                    "]"}]}]}], "}"}], ",", 
                    RowBox[{"With", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"xAct`xConf`Private`i1", "=", 
                    RowBox[{"DummyIn", "[", 
                    RowBox[{"Tangent", "[", "xAct`xConf`Private`M", "]"}], 
                    "]"}]}], ",", 
                    RowBox[{"xAct`xConf`Private`i2", "=", 
                    RowBox[{"DummyIn", "[", 
                    RowBox[{"Tangent", "[", "xAct`xConf`Private`M", "]"}], 
                    "]"}]}], ",", 
                    RowBox[{"xAct`xConf`Private`sy1", "=", 
                    RowBox[{
                    
                    RowBox[{"SymbolOfCovD", "[", "xAct`xConf`Private`CD", 
                    "]"}], "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}]}], ",", 
                    RowBox[{"xAct`xConf`Private`sy2", "=", 
                    RowBox[{
                    
                    RowBox[{"SymbolOfCovD", "[", "xAct`xConf`Private`CD", 
                    "]"}], "\[LeftDoubleBracket]", "2", 
                    "\[RightDoubleBracket]"}]}]}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"xAct`xConf`Private`metlist", "=", "$Metrics"}], 
                    ";", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"xAct`xConf`Private`pas", ",", 
                    "xAct`xConf`Private`gconfnameraw", ",", 
                    "xAct`xConf`Private`color", ",", 
                    "xAct`xConf`Private`symbolscovd"}], "}"}], "=", 
                    RowBox[{"OptionValue", "[", 
                    RowBox[{"{", 
                    
                    RowBox[{"PrintAs", ",", "ConformalMetricName", ",", 
                    "FrameColor", ",", "SymbolOfCovD"}], "}"}], "]"}]}], ";", 
                    
                    RowBox[{"If", "[", 
                    RowBox[{
                    
                    RowBox[{"xAct`xConf`Private`gconfnameraw", "===", 
                    "Automatic"}], ",", 
                    RowBox[{"xAct`xConf`Private`gconfnameraw", "=", 
                    RowBox[{"ConformalMetricName", "[", 
                    
                    RowBox[{"xAct`xConf`Private`g", ",", 
                    "xAct`xConf`Private`conffactor"}], "]"}]}]}], "]"}], ";", 
                    
                    RowBox[{"With", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"xAct`xConf`Private`gconfname", "=", 
                    "xAct`xConf`Private`gconfnameraw"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"xAct`xConf`Private`cdgconf", "=", 
                    RowBox[{"SymbolJoin", "[", 
                    
                    RowBox[{"xAct`xConf`Private`CD", ",", 
                    "xAct`xConf`Private`gconfname"}], "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    
                    RowBox[{"MetricQ", "[", "xAct`xConf`Private`gconfname", 
                    "]"}], ",", 
                    RowBox[{"Message", "[", 
                    RowBox[{
                    StyleBox[
                    RowBox[{"DefConformalMetric", "::", "old"}], 
                    "MessageName"], ",", "xAct`xConf`Private`gconfname"}], 
                    "]"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    
                    RowBox[{"xAct`xConf`Private`symbolscovd", "\[Equal]", 
                    "Automatic"}], ",", 
                    RowBox[{"xAct`xConf`Private`symbolscovd", "=", 
                    RowBox[{"{", 
                    RowBox[{"\":\"", ",", 
                    RowBox[{"\"\[Del]\"", "<>", 
                    
                    RowBox[{"ToString", "[", "xAct`xConf`Private`gconfname", 
                    "]"}]}]}], "}"}]}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", 
                    
                    RowBox[{"xAct`xConf`Private`DefTensorQ", "[", 
                    "xAct`xConf`Private`gconfname", "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"xAct`xConf`Private`pas", "===", "Automatic"}], 
                    ",", 
                    RowBox[{"xAct`xConf`Private`pas", "=", 
                    RowBox[{"\"[\"", "<>", 
                    RowBox[{"PrintAs", "[", "xAct`xConf`Private`g", "]"}], 
                    "<>", 
                    RowBox[{"(", 
                    RowBox[{"\"\\!\\(\"", "<>", 
                    
                    RowBox[{"PrintAs", "[", "xAct`xConf`Private`conffactor", 
                    "]"}], "<>", "\"\\^2\\)\""}], ")"}], "<>", "\"]\""}]}]}], 
                    "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"xAct`xConf`Private`color", "===", "Automatic"}], 
                    ",", 
                    RowBox[{"xAct`xConf`Private`color", "=", 
                    RowBox[{"RandomColor", "[", "]"}]}]}], "]"}], ";", 
                    RowBox[{"Print", "[", 
                    
                    RowBox[{"\"Choosing color \"", ",", 
                    "xAct`xConf`Private`color", ",", 
                    "\" for this conformal frame.\""}], "]"}], ";", 
                    RowBox[{
                    
                    RowBox[{"xAct`xConf`Private`ColorFrame", "[", 
                    "xAct`xConf`Private`gconfname", "]"}], "=", 
                    "xAct`xConf`Private`color"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", 
                    
                    RowBox[{"xAct`xConf`Private`DefTensorQ", "[", 
                    "xAct`xConf`Private`conffactor", "]"}]}], ",", 
                    RowBox[{"DefTensor", "[", 
                    RowBox[{
                    RowBox[{"xAct`xConf`Private`conffactor", "[", "]"}], ",", 
                    
                    RowBox[{"{", "xAct`xConf`Private`M", "}"}], ",", 
                    RowBox[{"PrintAs", "\[Rule]", 
                    
                    RowBox[{"ToString", "[", "xAct`xConf`Private`conffactor", 
                    "]"}]}]}], "]"}]}], "]"}], ";", 
                    RowBox[{"Off", "[", 
                    StyleBox[
                    RowBox[{"DefMetric", "::", "old"}], "MessageName"], "]"}],
                     ";", 
                    RowBox[{"DefMetric", "[", 
                    RowBox[{
                    
                    RowBox[{"SignDetOfMetric", "[", "xAct`xConf`Private`g", 
                    "]"}], ",", 
                    RowBox[{"xAct`xConf`Private`gconfname", "[", 
                    RowBox[{
                    RowBox[{"-", "xAct`xConf`Private`i1"}], ",", 
                    RowBox[{"-", "xAct`xConf`Private`i2"}]}], "]"}], ",", 
                    "xAct`xConf`Private`cdgconf", ",", 
                    "xAct`xConf`Private`symbolscovd", ",", 
                    RowBox[{"PrintAs", "\[Rule]", "xAct`xConf`Private`pas"}], 
                    ",", 
                    RowBox[{"ConformalTo", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"xAct`xConf`Private`g", "[", 
                    RowBox[{
                    RowBox[{"-", "xAct`xConf`Private`i1"}], ",", 
                    RowBox[{"-", "xAct`xConf`Private`i2"}]}], "]"}], ",", 
                    SuperscriptBox[
                    RowBox[{"xAct`xConf`Private`conffactor", "[", "]"}], 
                    "2"]}], "}"}]}]}], "]"}], ";", 
                    RowBox[{"DefInertHead", "[", 
                    RowBox[{
                    
                    RowBox[{"ConformalFrame", "[", 
                    "xAct`xConf`Private`gconfname", "]"}], ",", 
                    RowBox[{"ContractThrough", "\[Rule]", 
                    RowBox[{"{", "delta", "}"}]}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"InertHeadQ", "[", 
                    
                    RowBox[{"ConformalFrame", "[", "xAct`xConf`Private`g", 
                    "]"}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"DefInertHead", "[", 
                    RowBox[{
                    
                    RowBox[{"ConformalFrame", "[", "xAct`xConf`Private`g", 
                    "]"}], ",", 
                    RowBox[{"ContractThrough", "\[Rule]", 
                    RowBox[{"{", "delta", "}"}]}]}], "]"}], ";"}]}], "]"}], 
                    ";", 
                    RowBox[{"xAct`xConf`Private`gconfname", "/:", 
                    RowBox[{"SqrtConformalFactor", "[", 
                    
                    RowBox[{"xAct`xConf`Private`gconfname", ",", 
                    "xAct`xConf`Private`g"}], "]"}], "=", 
                    RowBox[{"xAct`xConf`Private`conffactor", "[", "]"}]}], 
                    ";", 
                    RowBox[{"xAct`xConf`Private`gconfname", "/:", 
                    RowBox[{"SqrtConformalFactor", "[", 
                    
                    RowBox[{"xAct`xConf`Private`g", ",", 
                    "xAct`xConf`Private`gconfname"}], "]"}], "=", 
                    FractionBox["1", 
                    RowBox[{"xAct`xConf`Private`conffactor", "[", "]"}]]}], 
                    ";", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ConformalFrame", "[", "_", "]"}], "[", 
                    RowBox[{"xAct`xConf`Private`conffactor", "[", "]"}], 
                    "]"}], ":=", 
                    RowBox[{"xAct`xConf`Private`conffactor", "[", "]"}]}], 
                    ";", 
                    RowBox[{"RulesChangeConformalFrame", "[", 
                    
                    RowBox[{"xAct`xConf`Private`g", ",", 
                    "xAct`xConf`Private`gconfname"}], "]"}], ";", 
                    RowBox[{"RulesChangeConformalFrame", "[", 
                    
                    RowBox[{"xAct`xConf`Private`gconfname", ",", 
                    "xAct`xConf`Private`g"}], "]"}], ";", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Catch", "[", 
                    RowBox[{"ConformalRules", "[", 
                    RowBox[{"xAct`xConf`Private`g", ",", "#1"}], "]"}], "]"}],
                     "=!=", 
                    RowBox[{"{", "}"}]}], ",", 
                    RowBox[{
                    RowBox[{"SetConformalTo", "[", 
                    RowBox[{
                    RowBox[{"xAct`xConf`Private`gconfname", "[", 
                    RowBox[{
                    RowBox[{"-", "xAct`xConf`Private`i1"}], ",", 
                    RowBox[{"-", "xAct`xConf`Private`i2"}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"#1", "[", 
                    RowBox[{
                    RowBox[{"-", "xAct`xConf`Private`i1"}], ",", 
                    RowBox[{"-", "xAct`xConf`Private`i2"}]}], "]"}], ",", 
                    RowBox[{
                    RowBox[{"ConformalFactor", "[", 
                    RowBox[{"xAct`xConf`Private`g", ",", "#1"}], "]"}], " ", 
                    SuperscriptBox[
                    RowBox[{"xAct`xConf`Private`conffactor", "[", "]"}], 
                    "2"]}]}], "}"}]}], "]"}], ";", 
                    RowBox[{"xAct`xConf`Private`gconfname", "/:", 
                    RowBox[{"SqrtConformalFactor", "[", 
                    RowBox[{"xAct`xConf`Private`gconfname", ",", "#1"}], 
                    "]"}], "=", 
                    RowBox[{
                    RowBox[{"SqrtConformalFactor", "[", 
                    RowBox[{"xAct`xConf`Private`g", ",", "#1"}], "]"}], " ", 
                    RowBox[{"xAct`xConf`Private`conffactor", "[", "]"}]}]}], 
                    ";", 
                    RowBox[{"xAct`xConf`Private`gconfname", "/:", 
                    RowBox[{"SqrtConformalFactor", "[", 
                    RowBox[{"#1", ",", "xAct`xConf`Private`gconfname"}], 
                    "]"}], "=", 
                    FractionBox["1", 
                    RowBox[{
                    RowBox[{"SqrtConformalFactor", "[", 
                    RowBox[{"xAct`xConf`Private`g", ",", "#1"}], "]"}], " ", 
                    RowBox[{"xAct`xConf`Private`conffactor", "[", "]"}]}]]}], 
                    ";", 
                    RowBox[{"RulesChangeConformalFrame", "[", 
                    RowBox[{"#1", ",", "xAct`xConf`Private`gconfname"}], 
                    "]"}], ";", 
                    RowBox[{"RulesChangeConformalFrame", "[", 
                    RowBox[{"xAct`xConf`Private`gconfname", ",", "#1"}], 
                    "]"}], ";"}]}], "]"}], "&"}], ")"}], "/@", 
                    "xAct`xConf`Private`metlist"}], ";"}]}], "]"}], ";"}]}], 
                    "]"}]}]}], "]"}]}], "]"}], "]"}]}], "]"}]}]}, {" "}, {
                    RowBox[{
                    RowBox[{"DefConformalMetric", "[", "_", "]"}], ":=", 
                    RowBox[{"Message", "[", 
                    RowBox[{
                    StyleBox[
                    RowBox[{"DefConformalMetric", "::", "argr"}], 
                    "MessageName"], ",", "DefConformalMetric", ",", 
                    RowBox[{"{", 
                    RowBox[{"2", ",", "\[Infinity]"}], "}"}]}], "]"}]}]}, {
                   " "}}, GridBoxAlignment -> {"Columns" -> {{Left}}}, 
                  DefaultBaseStyle -> "Column", 
                  GridBoxItemSize -> {
                   "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}]},
                "RowDefault"]}
             },
             DefaultBaseStyle->"Column",
             GridBoxAlignment->{"Columns" -> {{Left}}},
             
             GridBoxItemSize->{
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
            "Column"],
           FrameMargins->{{6, 0}, {3, 6}}], "\<\"\"\>"},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   PaneSelectorBox[{True->
                    ButtonBox[
                    PaneSelectorBox[{False->
                    TemplateBox[{"\[ThickSpace]", "\"\[ThickSpace]\"", 
                    StyleBox[
                    "\"Options\"", "InformationRowLabel", StripOnInput -> 
                    False], 
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "DownPointerOpener"]]},
                    "RowWithSeparators"], True->
                    TemplateBox[{"\[ThickSpace]", "\"\[ThickSpace]\"", 
                    StyleBox[
                    "\"Options\"", "InformationRowLabel", StripOnInput -> 
                    False], 
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "DownPointerOpenerHot"]]},
                    "RowWithSeparators"]}, Dynamic[
                    CurrentValue["MouseOver"]],
                    FrameMargins->0,
                    ImageSize->Automatic],
                    Appearance->None,
                    BaseStyle->None,
                    
                    ButtonFunction:>(Part[System`InformationDump`open$$, 3] = 
                    False),
                    Evaluator->Automatic,
                    FrameMargins->0,
                    ImageMargins->0,
                    Method->"Preemptive"], False->
                    ButtonBox[
                    PaneSelectorBox[{False->
                    TemplateBox[{"\[ThickSpace]", "\"\[ThickSpace]\"", 
                    StyleBox[
                    "\"Options\"", "InformationRowLabel", StripOnInput -> 
                    False], 
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "RightPointerOpener"]]},
                    "RowWithSeparators"], True->
                    TemplateBox[{"\[ThickSpace]", "\"\[ThickSpace]\"", 
                    StyleBox[
                    "\"Options\"", "InformationRowLabel", StripOnInput -> 
                    False], 
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "RightPointerOpenerHot"]]},
                    "RowWithSeparators"]}, Dynamic[
                    CurrentValue["MouseOver"]],
                    FrameMargins->0,
                    ImageSize->Automatic],
                    Appearance->None,
                    BaseStyle->None,
                    
                    ButtonFunction:>(Part[System`InformationDump`open$$, 3] = 
                    True),
                    Evaluator->Automatic,
                    FrameMargins->0,
                    ImageMargins->0,
                    Method->"Preemptive"]}, Dynamic[
                    FEPrivate`Part[System`InformationDump`open$$, 3]]], 
                   PaneSelectorBox[{True->GridBox[{
                    {
                    RowBox[{"PrintAs", "\[Rule]", "Automatic"}]},
                    {
                    RowBox[{"ConformalMetricName", "\[Rule]", "Automatic"}]},
                    {
                    RowBox[{"FrameColor", "\[Rule]", "Automatic"}]},
                    {
                    RowBox[{"SymbolOfCovD", "\[Rule]", "Automatic"}]},
                    {
                    StyleBox[
                    
                    TemplateBox[{
                    "\"(\"", "\"\[InvisibleSpace]\"", "4", "\" total)\""},
                    "RowDefault"], "InformationRowOpener",
                    StripOnInput->False]}
                    },
                    BaselinePosition->{Baseline, {1, 1}},
                    DefaultBaseStyle->"Column",
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{1.}}}], False->
                    RowBox[{
                    RowBox[{"PrintAs", "\[Rule]", "Automatic"}], 
                    "\[ThinSpace]", 
                    StyleBox["\<\"\[Ellipsis]\"\>", "InformationRowOpener",
                    StripOnInput->False], "\[ThinSpace]", 
                    StyleBox[
                    
                    TemplateBox[{
                    "\"(\"", "\"\[InvisibleSpace]\"", "4", "\" total)\""},
                    "RowDefault"], "InformationRowOpener",
                    StripOnInput->False]}]}, Dynamic[
                    FEPrivate`Part[System`InformationDump`open$$, 3]],
                    BaselinePosition->Baseline,
                    ImageSize->Automatic]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Attributes\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"Attributes\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "Attributes", "Tooltip"]& ], 
                   RowBox[{"{", "Protected", "}"}]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"xAct`xConf`DefConformalMetric\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->{{6, 6}, {6, 3}}], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox[
             TagBox[
              TooltipBox[
               StyleBox["\<\" Symbol\"\>", "InformationRowLabel",
                StripOnInput->False],
               "\"Symbol\"",
               TooltipStyle->"TextStyling"],
              Annotation[#, "Symbol", "Tooltip"]& ], "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"DefConformalMetric[g,S] defines a metric \
conformally related to 'g', with the conformal factor 'S'. If other metrics \
are conformally related to 'g', then 'gS2' is related to them by transitivity \
of the conformal transformation. If the scalar field S[] does not exist, it \
is defined.\\n   Options are PrintAs->printasform, \
ConformalMetricName->MetricName, FrameColor->somecolor and \
SymbolOfCovD->{postfixsymbol,prefixsymbol}. If no ConformalMetricName is \
provided the name chosen is the concatenation 'metric+conformalfactor+2'. If \
no color is provided, it choses randomly a color. If no SymbolOfCovD is \
provided, the combination {:,\[Del]metricname} is chosen.\"\>", 
             "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"],
               ImageSizeCache->{10., {3., 7.}}], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"],
               ImageSizeCache->{10., {3., 7.}}]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[<|
   "ObjectType" -> "Symbol", "Usage" -> 
    "DefConformalMetric[g,S] defines a metric conformally related to 'g', \
with the conformal factor 'S'. If other metrics are conformally related to \
'g', then 'gS2' is related to them by transitivity of the conformal \
transformation. If the scalar field S[] does not exist, it is defined.\n   \
Options are PrintAs->printasform, ConformalMetricName->MetricName, \
FrameColor->somecolor and SymbolOfCovD->{postfixsymbol,prefixsymbol}. If no \
ConformalMetricName is provided the name chosen is the concatenation \
'metric+conformalfactor+2'. If no color is provided, it choses randomly a \
color. If no SymbolOfCovD is provided, the combination {:,\[Del]metricname} \
is chosen.", "Documentation" -> None, "OwnValues" -> None, "UpValues" -> None,
     "DownValues" -> 
    Information`InformationValueForm[
     DownValues, xAct`xConf`DefConformalMetric, {
      xAct`xConf`DefConformalMetric[] :> Message[
         MessageName[xAct`xConf`DefConformalMetric, "argm"], 
         xAct`xConf`DefConformalMetric, 0, 2], xAct`xConf`DefConformalMetric[
         PatternTest[
          Pattern[xAct`xConf`Private`g, 
           Blank[]], xAct`xTensor`MetricQ], 
         Pattern[xAct`xConf`Private`conffactor, 
          Blank[]], 
         Pattern[xAct`xConf`Private`options, 
          OptionsPattern[]]] :> 
       Module[{xAct`xConf`Private`nmetlist, xAct`xConf`Private`pas, 
          xAct`xConf`Private`gconfnameraw, xAct`xConf`Private`cdgconf, 
          xAct`xConf`Private`metlist, xAct`xConf`Private`color, 
          xAct`xConf`Private`symbolscovd}, 
         Catch[
          With[{xAct`xConf`Private`M = xAct`xTensor`ManifoldOfCovD[
              xAct`xTensor`CovDOfMetric[xAct`xConf`Private`g]], 
            xAct`xConf`Private`CD = 
            xAct`xTensor`CovDOfMetric[xAct`xConf`Private`g]}, 
           With[{xAct`xConf`Private`i1 = xAct`xTensor`DummyIn[
               xAct`xTensor`Tangent[xAct`xConf`Private`M]], 
             xAct`xConf`Private`i2 = xAct`xTensor`DummyIn[
               xAct`xTensor`Tangent[xAct`xConf`Private`M]], 
             xAct`xConf`Private`sy1 = Part[
               xAct`xTensor`SymbolOfCovD[xAct`xConf`Private`CD], 1], 
             xAct`xConf`Private`sy2 = Part[
               xAct`xTensor`SymbolOfCovD[xAct`xConf`Private`CD], 2]}, 
            xAct`xConf`Private`metlist = 
             xAct`xTensor`$Metrics; {
              xAct`xConf`Private`pas, xAct`xConf`Private`gconfnameraw, 
               xAct`xConf`Private`color, xAct`xConf`Private`symbolscovd} = 
             OptionValue[{
               xAct`xTensor`PrintAs, xAct`xConf`ConformalMetricName, 
                xAct`xConf`FrameColor, xAct`xTensor`SymbolOfCovD}]; 
            If[xAct`xConf`Private`gconfnameraw === Automatic, 
              xAct`xConf`Private`gconfnameraw = 
              xAct`xConf`ConformalMetricName[
               xAct`xConf`Private`g, xAct`xConf`Private`conffactor]]; 
            With[{xAct`xConf`Private`gconfname = 
               xAct`xConf`Private`gconfnameraw}, 
              xAct`xConf`Private`cdgconf = 
               xAct`xCore`SymbolJoin[
                xAct`xConf`Private`CD, xAct`xConf`Private`gconfname]; If[
                xAct`xTensor`MetricQ[xAct`xConf`Private`gconfname], 
                Message[
                 MessageName[xAct`xConf`DefConformalMetric, "old"], 
                 xAct`xConf`Private`gconfname]]; 
              If[xAct`xConf`Private`symbolscovd == Automatic, 
                xAct`xConf`Private`symbolscovd = {
                 ":", "\[Del]" <> ToString[xAct`xConf`Private`gconfname]}]; If[
                Not[
                 xAct`xConf`Private`DefTensorQ[xAct`xConf`Private`gconfname]],
                 If[xAct`xConf`Private`pas === Automatic, 
                  xAct`xConf`Private`pas = (("[" <> 
                    xAct`xTensor`PrintAs[xAct`xConf`Private`g]) <> (("\!\(" <> 
                    xAct`xTensor`PrintAs[xAct`xConf`Private`conffactor]) <> 
                    "\^2\)")) <> "]"]; 
                If[xAct`xConf`Private`color === Automatic, 
                  xAct`xConf`Private`color = RandomColor[]]; 
                Print["Choosing color ", xAct`xConf`Private`color, 
                  " for this conformal frame."]; 
                xAct`xConf`Private`ColorFrame[xAct`xConf`Private`gconfname] = 
                 xAct`xConf`Private`color; If[
                  Not[
                   xAct`xConf`Private`DefTensorQ[
                   xAct`xConf`Private`conffactor]], 
                  xAct`xTensor`DefTensor[
                   xAct`xConf`Private`conffactor[], {xAct`xConf`Private`M}, 
                   xAct`xTensor`PrintAs -> 
                   ToString[xAct`xConf`Private`conffactor]]]; Off[
                  MessageName[xAct`xTensor`DefMetric, "old"]]; 
                xAct`xTensor`DefMetric[
                  xAct`xTensor`SignDetOfMetric[xAct`xConf`Private`g], 
                  
                  xAct`xConf`Private`gconfname[-xAct`xConf`Private`i1, -
                   xAct`xConf`Private`i2], xAct`xConf`Private`cdgconf, 
                  xAct`xConf`Private`symbolscovd, xAct`xTensor`PrintAs -> 
                  xAct`xConf`Private`pas, xAct`xTensor`ConformalTo -> {
                    
                    xAct`xConf`Private`g[-xAct`xConf`Private`i1, -
                    xAct`xConf`Private`i2], 
                    xAct`xConf`Private`conffactor[]^2}]; 
                xAct`xTensor`DefInertHead[
                  xAct`xConf`ConformalFrame[xAct`xConf`Private`gconfname], 
                  xAct`xTensor`ContractThrough -> {xAct`xTensor`delta}]; If[
                  Not[
                   xAct`xTensor`InertHeadQ[
                    xAct`xConf`ConformalFrame[xAct`xConf`Private`g]]], 
                  xAct`xTensor`DefInertHead[
                    xAct`xConf`ConformalFrame[xAct`xConf`Private`g], 
                    xAct`xTensor`ContractThrough -> {xAct`xTensor`delta}]; 
                  Null]; TagSet[xAct`xConf`Private`gconfname, 
                  xAct`xConf`SqrtConformalFactor[
                  xAct`xConf`Private`gconfname, xAct`xConf`Private`g], 
                  xAct`xConf`Private`conffactor[]]; 
                TagSet[xAct`xConf`Private`gconfname, 
                  xAct`xConf`SqrtConformalFactor[
                  xAct`xConf`Private`g, xAct`xConf`Private`gconfname], 1/
                  xAct`xConf`Private`conffactor[]]; 
                xAct`xConf`ConformalFrame[
                   Blank[]][
                   xAct`xConf`Private`conffactor[]] := 
                 xAct`xConf`Private`conffactor[]; 
                xAct`xConf`RulesChangeConformalFrame[
                 xAct`xConf`Private`g, xAct`xConf`Private`gconfname]; 
                xAct`xConf`RulesChangeConformalFrame[
                 xAct`xConf`Private`gconfname, xAct`xConf`Private`g]; 
                Map[If[Catch[
                    xAct`xTensor`ConformalRules[
                    xAct`xConf`Private`g, #]] =!= {}, 
                   xAct`xTensor`SetConformalTo[
                    
                    xAct`xConf`Private`gconfname[-xAct`xConf`Private`i1, -
                    xAct`xConf`Private`i2], {
                    #[-xAct`xConf`Private`i1, -xAct`xConf`Private`i2], 
                    xAct`xTensor`ConformalFactor[xAct`xConf`Private`g, #] 
                    xAct`xConf`Private`conffactor[]^2}]; 
                   TagSet[xAct`xConf`Private`gconfname, 
                    xAct`xConf`SqrtConformalFactor[
                    xAct`xConf`Private`gconfname, #], 
                    xAct`xConf`SqrtConformalFactor[xAct`xConf`Private`g, #] 
                    xAct`xConf`Private`conffactor[]]; 
                   TagSet[xAct`xConf`Private`gconfname, 
                    
                    xAct`xConf`SqrtConformalFactor[#, 
                    xAct`xConf`Private`gconfname], 1/(
                    xAct`xConf`SqrtConformalFactor[xAct`xConf`Private`g, #] 
                    xAct`xConf`Private`conffactor[])]; 
                   xAct`xConf`RulesChangeConformalFrame[#, 
                    xAct`xConf`Private`gconfname]; 
                   xAct`xConf`RulesChangeConformalFrame[
                    xAct`xConf`Private`gconfname, #]; Null]& , 
                  xAct`xConf`Private`metlist]; Null]; Null]]]]], 
       xAct`xConf`DefConformalMetric[
         Blank[]] :> Message[
         MessageName[xAct`xConf`DefConformalMetric, "argr"], 
         xAct`xConf`DefConformalMetric, {2, 
          DirectedInfinity[1]}]}], "SubValues" -> None, "DefaultValues" -> 
    None, "NValues" -> None, "FormatValues" -> None, 
    "Options" -> {
     xAct`xTensor`PrintAs -> Automatic, xAct`xConf`ConformalMetricName -> 
      Automatic, xAct`xConf`FrameColor -> Automatic, 
      xAct`xTensor`SymbolOfCovD -> Automatic}, "Attributes" -> {Protected}, 
    "FullName" -> "xAct`xConf`DefConformalMetric"|>, False]]], "Output",
 CellLabel->
  "Out[19]=",ExpressionUUID->"20b5a0c2-02ec-40ce-af35-c024d2211012"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"DefConformalMetric", "[", 
  RowBox[{"g", ",", "S", ",", 
   RowBox[{"PrintAs", "->", "\"\<gS2\>\""}], ",", 
   RowBox[{"ConformalMetricName", "->", "gS2"}], ",", " ", 
   RowBox[{"FrameColor", "->", "Red"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"DefConformalMetric", "[", 
  RowBox[{"g", ",", "s", ",", 
   RowBox[{"FrameColor", "->", "Blue"}]}], "]"}]}], "Input",
 CellLabel->"In[20]:=",ExpressionUUID->"adcb0cd8-6f8d-47f1-8b17-1651cf00ebd6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Choosing color \"\>", "\[InvisibleSpace]", 
   TemplateBox[<|"color" -> RGBColor[1, 0, 0]|>,
    "RGBColorSwatchTemplate"], 
   "\[InvisibleSpace]", "\<\" for this conformal frame.\"\>"}],
  SequenceForm["Choosing color ", 
   RGBColor[1, 0, 0], " for this conformal frame."],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[20]:=",ExpressionUUID->"5d54c45e-89fe-48ad-b13c-f20b97187d3d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"S", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`S[], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[20]:=",ExpressionUUID->"08d7f25a-5878-47d7-8d4e-471abcad9475"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric metric tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"gS2", "[", 
    RowBox[{
     RowBox[{"-", "\[Sigma]$8221"}], ",", 
     RowBox[{"-", "\[Sigma]$8222"}]}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "symmetric metric tensor ", 
   $CellContext`gS2[-$CellContext`\[Sigma]$8221, -$CellContext`\[Sigma]$8222],
    ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[20]:=",ExpressionUUID->"f68b6e64-8c36-47f0-b3ca-0ddcce14d9dc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"inverse metric tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"InvgS2", "[", 
    RowBox[{"\[Sigma]$8221", ",", "\[Sigma]$8222"}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Metric is frozen!\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "inverse metric tensor ", 
   $CellContext`InvgS2[$CellContext`\[Sigma]$8221, \
$CellContext`\[Sigma]$8222], ". ", "Metric is frozen!"],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[20]:=",ExpressionUUID->"62ebce52-b6c1-44ed-b564-86b062a3643f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"antisymmetric tensor \"\>", "\[InvisibleSpace]", 
   
   RowBox[{"epsilongS2", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}], ",", 
     RowBox[{"-", "\[Lambda]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "antisymmetric tensor ", 
   $CellContext`epsilongS2[-$CellContext`\[Alpha], -$CellContext`\[Beta], \
-$CellContext`\[Gamma], -$CellContext`\[Lambda]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[20]:=",ExpressionUUID->"48b39c88-9361-4433-aedc-a4c931930fe1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tetrametric \"\>", "\[InvisibleSpace]", 
   RowBox[{"TetragS2", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}], ",", 
     RowBox[{"-", "\[Lambda]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tetrametric ", 
   $CellContext`TetragS2[-$CellContext`\[Alpha], -$CellContext`\[Beta], \
-$CellContext`\[Gamma], -$CellContext`\[Lambda]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[20]:=",ExpressionUUID->"f21b1c7a-6e88-46b4-b11f-5c52bc6d28d2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tetrametric \"\>", "\[InvisibleSpace]", 
   RowBox[{"TetragS2\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}], ",", 
     RowBox[{"-", "\[Lambda]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tetrametric ", 
   $CellContext`TetragS2\[Dagger][-$CellContext`\[Alpha], -$CellContext`\
\[Beta], -$CellContext`\[Gamma], -$CellContext`\[Lambda]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[20]:=",ExpressionUUID->"43ab5f22-894d-4112-935a-6e6abe1b6e90"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefCovD", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"covariant derivative \"\>", "\[InvisibleSpace]", 
   
   RowBox[{"CDgS2", "[", 
    RowBox[{"-", "\[Sigma]$8221"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefCovD, ": Defining ", "covariant derivative ", 
   $CellContext`CDgS2[-$CellContext`\[Sigma]$8221], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[20]:=",ExpressionUUID->"bcc766ab-bfc4-4798-9a1f-e34144b9c510"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing torsion tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"TorsionCDgS2", "[", 
    RowBox[{"\[Alpha]", ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "vanishing torsion tensor ", 
   $CellContext`TorsionCDgS2[$CellContext`\[Alpha], -$CellContext`\[Beta], \
-$CellContext`\[Gamma]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[20]:=",ExpressionUUID->"c4c95168-c04a-4d4b-bd9c-561d8542accb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Christoffel tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"ChristoffelCDgS2", "[", 
    RowBox[{"\[Alpha]", ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "symmetric Christoffel tensor ", 
   $CellContext`ChristoffelCDgS2[$CellContext`\[Alpha], \
-$CellContext`\[Beta], -$CellContext`\[Gamma]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[20]:=",ExpressionUUID->"4cda4850-ce5a-461b-a2db-3c9f37176dba"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Riemann tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"RiemannDownCDgS2", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}], ",", 
     RowBox[{"-", "\[Lambda]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Riemann tensor ", 
   $CellContext`RiemannDownCDgS2[-$CellContext`\[Alpha], \
-$CellContext`\[Beta], -$CellContext`\[Gamma], -$CellContext`\[Lambda]], ". ",
    ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[20]:=",ExpressionUUID->"07fa30af-4af8-435f-8872-79a691765ede"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Riemann tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"RiemannCDgS2", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}], ",", "\[Lambda]"}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Antisymmetric only in the first pair.\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Riemann tensor ", 
   $CellContext`RiemannCDgS2[-$CellContext`\[Alpha], -$CellContext`\[Beta], \
-$CellContext`\[Gamma], $CellContext`\[Lambda]], ". ", 
   "Antisymmetric only in the first pair."],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[20]:=",ExpressionUUID->"4f9c9191-abc9-4993-994e-6cdb4420be01"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Ricci tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"RicciCDgS2", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "symmetric Ricci tensor ", 
   $CellContext`RicciCDgS2[-$CellContext`\[Alpha], -$CellContext`\[Beta]], 
   ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[20]:=",ExpressionUUID->"6f9efeaf-7793-4c2a-ad17-d7d34da76946"],

Cell[BoxData["\<\"** DefCovD:  Contractions of Riemann automatically replaced \
by Ricci.\"\>"], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[20]:=",ExpressionUUID->"8fbd5c3d-9d76-406e-9784-b57cec2f5dfc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Ricci scalar \"\>", "\[InvisibleSpace]", 
   RowBox[{"RicciScalarCDgS2", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Ricci scalar ", 
   $CellContext`RicciScalarCDgS2[], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[20]:=",ExpressionUUID->"e2b2184c-ac5a-4d49-9e64-474caf2b4e20"],

Cell[BoxData["\<\"** DefCovD:  Contractions of Ricci automatically replaced \
by RicciScalar.\"\>"], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[20]:=",ExpressionUUID->"a55ec099-8277-4556-b5b7-8d89bb2bb781"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Einstein tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"EinsteinCDgS2", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "symmetric Einstein tensor ", 
   $CellContext`EinsteinCDgS2[-$CellContext`\[Alpha], -$CellContext`\[Beta]], 
   ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[20]:=",ExpressionUUID->"f47433d6-e753-4dc3-be47-5c0c6e932573"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Weyl tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"WeylCDgS2", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}], ",", 
     RowBox[{"-", "\[Lambda]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "Weyl tensor ", 
   $CellContext`WeylCDgS2[-$CellContext`\[Alpha], -$CellContext`\[Beta], \
-$CellContext`\[Gamma], -$CellContext`\[Lambda]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[20]:=",ExpressionUUID->"d45736da-f0e6-4ac1-a1bf-9d7a10917e03"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric TFRicci tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"TFRicciCDgS2", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "symmetric TFRicci tensor ", 
   $CellContext`TFRicciCDgS2[-$CellContext`\[Alpha], -$CellContext`\[Beta]], 
   ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[20]:=",ExpressionUUID->"bfc6c778-7d8a-4580-bc42-b7c4c3e62910"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Kretschmann scalar \"\>", "\[InvisibleSpace]", 
   RowBox[{"KretschmannCDgS2", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Kretschmann scalar ", 
   $CellContext`KretschmannCDgS2[], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[20]:=",ExpressionUUID->"64ffb286-59a2-432d-b2f3-2c428e1d8778"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** DefCovD:  Computing RiemannToWeylRules for dim \"\>", 
   "\[InvisibleSpace]", "4"}],
  SequenceForm["** DefCovD:  Computing RiemannToWeylRules for dim ", 4],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[20]:=",ExpressionUUID->"417f9cb6-4950-4542-b9db-cbe99e846023"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** DefCovD:  Computing RicciToEinsteinRules for dim \"\>", 
   "\[InvisibleSpace]", "4"}],
  SequenceForm["** DefCovD:  Computing RicciToEinsteinRules for dim ", 4],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[20]:=",ExpressionUUID->"e5b572cd-fe72-417e-a8e8-abe9a9f5a24c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"weight +2 density \"\>", "\[InvisibleSpace]", 
   RowBox[{"DetgS2", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Determinant.\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "weight +2 density ", 
   $CellContext`DetgS2[], ". ", "Determinant."],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[20]:=",ExpressionUUID->"c59403cb-987e-403c-ada4-c4454f20d02f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefInertHead", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"inert head \"\>", "\[InvisibleSpace]", 
   RowBox[{"ConformalFrame", "[", "gS2", "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefInertHead, ": Defining ", "inert head ", 
   xAct`xConf`ConformalFrame[$CellContext`gS2], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[20]:=",ExpressionUUID->"963e5373-632a-4c88-9d39-e0f4476b3aeb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefInertHead", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"inert head \"\>", "\[InvisibleSpace]", 
   RowBox[{"ConformalFrame", "[", "g", "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefInertHead, ": Defining ", "inert head ", 
   xAct`xConf`ConformalFrame[$CellContext`g], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[20]:=",ExpressionUUID->"7634ddf4-f6b5-4a7e-ac20-333adf42e152"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Choosing color \"\>", "\[InvisibleSpace]", 
   TemplateBox[<|"color" -> RGBColor[0, 0, 1]|>,
    "RGBColorSwatchTemplate"], 
   "\[InvisibleSpace]", "\<\" for this conformal frame.\"\>"}],
  SequenceForm["Choosing color ", 
   RGBColor[0, 0, 1], " for this conformal frame."],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[20]:=",ExpressionUUID->"59f89446-8e36-4108-91fe-ef3d3ed98a79"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"s", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`s[], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[20]:=",ExpressionUUID->"98b5f764-4468-4a08-a06e-92098de9c4bc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric metric tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"gs2", "[", 
    RowBox[{
     RowBox[{"-", "\[Sigma]$8605"}], ",", 
     RowBox[{"-", "\[Sigma]$8606"}]}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "symmetric metric tensor ", 
   $CellContext`gs2[-$CellContext`\[Sigma]$8605, -$CellContext`\[Sigma]$8606],
    ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[20]:=",ExpressionUUID->"8ea0b658-df06-45dc-9323-a782aafd5bbc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"inverse metric tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"Invgs2", "[", 
    RowBox[{"\[Sigma]$8605", ",", "\[Sigma]$8606"}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Metric is frozen!\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "inverse metric tensor ", 
   $CellContext`Invgs2[$CellContext`\[Sigma]$8605, \
$CellContext`\[Sigma]$8606], ". ", "Metric is frozen!"],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[20]:=",ExpressionUUID->"68e37d47-c3bd-4895-ad90-caa24fbdfb63"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"antisymmetric tensor \"\>", "\[InvisibleSpace]", 
   
   RowBox[{"epsilongs2", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}], ",", 
     RowBox[{"-", "\[Lambda]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "antisymmetric tensor ", 
   $CellContext`epsilongs2[-$CellContext`\[Alpha], -$CellContext`\[Beta], \
-$CellContext`\[Gamma], -$CellContext`\[Lambda]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[20]:=",ExpressionUUID->"0ab5d24b-6945-4db4-a47a-2728f75dc472"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tetrametric \"\>", "\[InvisibleSpace]", 
   RowBox[{"Tetrags2", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}], ",", 
     RowBox[{"-", "\[Lambda]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tetrametric ", 
   $CellContext`Tetrags2[-$CellContext`\[Alpha], -$CellContext`\[Beta], \
-$CellContext`\[Gamma], -$CellContext`\[Lambda]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[20]:=",ExpressionUUID->"f6434b2b-d63d-46cc-9d2e-b301620c7be6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tetrametric \"\>", "\[InvisibleSpace]", 
   RowBox[{"Tetrags2\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}], ",", 
     RowBox[{"-", "\[Lambda]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tetrametric ", 
   $CellContext`Tetrags2\[Dagger][-$CellContext`\[Alpha], -$CellContext`\
\[Beta], -$CellContext`\[Gamma], -$CellContext`\[Lambda]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[20]:=",ExpressionUUID->"32d27634-8e1f-4bb8-8fbc-7d23ddfb1cff"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefCovD", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"covariant derivative \"\>", "\[InvisibleSpace]", 
   
   RowBox[{"CDgs2", "[", 
    RowBox[{"-", "\[Sigma]$8605"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefCovD, ": Defining ", "covariant derivative ", 
   $CellContext`CDgs2[-$CellContext`\[Sigma]$8605], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[20]:=",ExpressionUUID->"170a9d93-c463-4656-b520-2feef2d21665"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing torsion tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"TorsionCDgs2", "[", 
    RowBox[{"\[Alpha]", ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "vanishing torsion tensor ", 
   $CellContext`TorsionCDgs2[$CellContext`\[Alpha], -$CellContext`\[Beta], \
-$CellContext`\[Gamma]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[20]:=",ExpressionUUID->"02aa0102-355e-4ad2-b504-3b0c0ccd9180"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Christoffel tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"ChristoffelCDgs2", "[", 
    RowBox[{"\[Alpha]", ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "symmetric Christoffel tensor ", 
   $CellContext`ChristoffelCDgs2[$CellContext`\[Alpha], \
-$CellContext`\[Beta], -$CellContext`\[Gamma]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[20]:=",ExpressionUUID->"1152bdde-5683-47e1-81ae-e3649e9ded99"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Riemann tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"RiemannDownCDgs2", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}], ",", 
     RowBox[{"-", "\[Lambda]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Riemann tensor ", 
   $CellContext`RiemannDownCDgs2[-$CellContext`\[Alpha], \
-$CellContext`\[Beta], -$CellContext`\[Gamma], -$CellContext`\[Lambda]], ". ",
    ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[20]:=",ExpressionUUID->"70a51b58-fe2c-4c8e-a619-9303ee15f34b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Riemann tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"RiemannCDgs2", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}], ",", "\[Lambda]"}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Antisymmetric only in the first pair.\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Riemann tensor ", 
   $CellContext`RiemannCDgs2[-$CellContext`\[Alpha], -$CellContext`\[Beta], \
-$CellContext`\[Gamma], $CellContext`\[Lambda]], ". ", 
   "Antisymmetric only in the first pair."],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[20]:=",ExpressionUUID->"c5a5e9f7-224b-4fbe-ba00-d44e7b0ceca1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Ricci tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"RicciCDgs2", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "symmetric Ricci tensor ", 
   $CellContext`RicciCDgs2[-$CellContext`\[Alpha], -$CellContext`\[Beta]], 
   ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[20]:=",ExpressionUUID->"ed6738d8-889c-4dae-9e55-c87bac50a8b5"],

Cell[BoxData["\<\"** DefCovD:  Contractions of Riemann automatically replaced \
by Ricci.\"\>"], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[20]:=",ExpressionUUID->"1c160c1e-54d3-4332-bb78-88ee43282d0c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Ricci scalar \"\>", "\[InvisibleSpace]", 
   RowBox[{"RicciScalarCDgs2", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Ricci scalar ", 
   $CellContext`RicciScalarCDgs2[], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[20]:=",ExpressionUUID->"826455c0-dbda-4fc5-9abb-5008773c6c48"],

Cell[BoxData["\<\"** DefCovD:  Contractions of Ricci automatically replaced \
by RicciScalar.\"\>"], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[20]:=",ExpressionUUID->"30dc68df-0f8f-4274-ba6d-3d47bf653b81"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Einstein tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"EinsteinCDgs2", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "symmetric Einstein tensor ", 
   $CellContext`EinsteinCDgs2[-$CellContext`\[Alpha], -$CellContext`\[Beta]], 
   ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[20]:=",ExpressionUUID->"bc78fac0-3e98-4b74-a362-68c84ba2c266"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Weyl tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"WeylCDgs2", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}], ",", 
     RowBox[{"-", "\[Lambda]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "Weyl tensor ", 
   $CellContext`WeylCDgs2[-$CellContext`\[Alpha], -$CellContext`\[Beta], \
-$CellContext`\[Gamma], -$CellContext`\[Lambda]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[20]:=",ExpressionUUID->"396464d4-dee9-4c08-a9b3-4b018a49da09"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric TFRicci tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"TFRicciCDgs2", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "symmetric TFRicci tensor ", 
   $CellContext`TFRicciCDgs2[-$CellContext`\[Alpha], -$CellContext`\[Beta]], 
   ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[20]:=",ExpressionUUID->"48201495-7afd-4e35-aca7-f96fd7359d46"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Kretschmann scalar \"\>", "\[InvisibleSpace]", 
   RowBox[{"KretschmannCDgs2", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Kretschmann scalar ", 
   $CellContext`KretschmannCDgs2[], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[20]:=",ExpressionUUID->"108d22f8-5607-457e-9817-1efc59cca779"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** DefCovD:  Computing RiemannToWeylRules for dim \"\>", 
   "\[InvisibleSpace]", "4"}],
  SequenceForm["** DefCovD:  Computing RiemannToWeylRules for dim ", 4],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[20]:=",ExpressionUUID->"65b1c269-bfcb-4bee-9ede-458e11df6e8b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** DefCovD:  Computing RicciToEinsteinRules for dim \"\>", 
   "\[InvisibleSpace]", "4"}],
  SequenceForm["** DefCovD:  Computing RicciToEinsteinRules for dim ", 4],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[20]:=",ExpressionUUID->"8d7e842b-8351-41ca-862a-3f58ad9c18c1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"weight +2 density \"\>", "\[InvisibleSpace]", 
   RowBox[{"Detgs2", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Determinant.\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "weight +2 density ", 
   $CellContext`Detgs2[], ". ", "Determinant."],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[20]:=",ExpressionUUID->"3ba05ce8-0d0a-4a2c-9b82-6d8ba0a156f1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefInertHead", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"inert head \"\>", "\[InvisibleSpace]", 
   RowBox[{"ConformalFrame", "[", "gs2", "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefInertHead, ": Defining ", "inert head ", 
   xAct`xConf`ConformalFrame[$CellContext`gs2], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[20]:=",ExpressionUUID->"6a31786e-1c8c-4d94-908f-4ac95e5f6b52"]
}, Open  ]],

Cell["\<\
The conformal relations have been defined among these 3 metrics\
\>", "Text",
 CellTags->{
  "S5.18.1", "1.2"},ExpressionUUID->"2da69e64-a7d9-497e-8e11-004cb48dc902"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"ConformalRules", "[", 
  RowBox[{"g", ",", "gS2"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"ConformalRules", "[", 
  RowBox[{"g", ",", "gs2"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"ConformalRules", "[", 
  RowBox[{"gS2", ",", "gs2"}], "]"}]}], "Input",
 CellLabel->"In[22]:=",ExpressionUUID->"9baf6758-80d8-4ae4-bc12-2868fd155c14"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {
             UnderscriptBox[
              UnderscriptBox["\[Alpha]", "_"], "_"], 
             UnderscriptBox[
              UnderscriptBox["\[Beta]", "_"], "_"]},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[
      PatternTest[
       Pattern[$CellContext`\[Alpha], 
        Blank[]], xAct`xTensor`DownIndexQ], 
      PatternTest[
       Pattern[$CellContext`\[Beta], 
        Blank[]], xAct`xTensor`DownIndexQ]],
     Editable->False], "\[Rule]", 
    FractionBox[
     InterpretationBox[
      StyleBox[GridBox[{
         {"gS2", 
          StyleBox[GridBox[{
             {"\[Alpha]", "\[Beta]"},
             {" ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->9]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`gS2[$CellContext`\[Alpha], $CellContext`\[Beta]],
      Editable->False], 
     SuperscriptBox[
      InterpretationBox[
       StyleBox["S",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`S[],
       Editable->False], "2"]]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {
             UnderscriptBox[
              UnderscriptBox["\[Alpha]", "_"], "_"], 
             UnderscriptBox[
              UnderscriptBox["\[Beta]", "_"], "_"]},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[
      PatternTest[
       Pattern[$CellContext`\[Alpha], 
        Blank[]], xAct`xTensor`UpIndexQ], 
      PatternTest[
       Pattern[$CellContext`\[Beta], 
        Blank[]], xAct`xTensor`UpIndexQ]],
     Editable->False], "\[Rule]", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"igS2", 
          StyleBox[GridBox[{
             {"\[Alpha]", "\[Beta]"},
             {" ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->9]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`InvgS2[$CellContext`\[Alpha], $CellContext`\[Beta]],
      Editable->False], " ", 
     SuperscriptBox[
      InterpretationBox[
       StyleBox["S",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`S[],
       Editable->False], "2"]}]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      OverscriptBox["g", 
       OverscriptBox[
        StyleBox["~",
         FontColor->RGBColor[0, 0, 0]], 
        StyleBox["~",
         FontColor->RGBColor[0, 0, 0]]]],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`Detg[],
     Editable->False], "\[Rule]", 
    FractionBox[
     InterpretationBox[
      StyleBox[
       OverscriptBox["gS2", 
        OverscriptBox[
         StyleBox["~",
          FontColor->RGBColor[0, 0, 0]], 
         StyleBox["~",
          FontColor->RGBColor[0, 0, 0]]]],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`DetgS2[],
      Editable->False], 
     SuperscriptBox[
      InterpretationBox[
       StyleBox["S",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`S[],
       Editable->False], "8"]]}]}], "}"}]], "Output",
 CellLabel->"Out[22]=",ExpressionUUID->"89a9627f-1f58-4b47-84b5-94305870bde3"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {
             UnderscriptBox[
              UnderscriptBox["\[Alpha]", "_"], "_"], 
             UnderscriptBox[
              UnderscriptBox["\[Beta]", "_"], "_"]},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[
      PatternTest[
       Pattern[$CellContext`\[Alpha], 
        Blank[]], xAct`xTensor`DownIndexQ], 
      PatternTest[
       Pattern[$CellContext`\[Beta], 
        Blank[]], xAct`xTensor`DownIndexQ]],
     Editable->False], "\[Rule]", 
    FractionBox[
     InterpretationBox[
      StyleBox[GridBox[{
         {
          RowBox[{"[", 
           RowBox[{"g", 
            SuperscriptBox["s", "2"]}], "]"}], 
          StyleBox[GridBox[{
             {"\[Alpha]", "\[Beta]"},
             {" ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->9]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`gs2[$CellContext`\[Alpha], $CellContext`\[Beta]],
      Editable->False], 
     SuperscriptBox[
      InterpretationBox[
       StyleBox["s",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`s[],
       Editable->False], "2"]]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {
             UnderscriptBox[
              UnderscriptBox["\[Alpha]", "_"], "_"], 
             UnderscriptBox[
              UnderscriptBox["\[Beta]", "_"], "_"]},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[
      PatternTest[
       Pattern[$CellContext`\[Alpha], 
        Blank[]], xAct`xTensor`UpIndexQ], 
      PatternTest[
       Pattern[$CellContext`\[Beta], 
        Blank[]], xAct`xTensor`UpIndexQ]],
     Editable->False], "\[Rule]", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {
          RowBox[{"i", "[", 
           RowBox[{"g", 
            SuperscriptBox["s", "2"]}], "]"}], 
          StyleBox[GridBox[{
             {"\[Alpha]", "\[Beta]"},
             {" ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->9]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`Invgs2[$CellContext`\[Alpha], $CellContext`\[Beta]],
      Editable->False], " ", 
     SuperscriptBox[
      InterpretationBox[
       StyleBox["s",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`s[],
       Editable->False], "2"]}]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      OverscriptBox["g", 
       OverscriptBox[
        StyleBox["~",
         FontColor->RGBColor[0, 0, 0]], 
        StyleBox["~",
         FontColor->RGBColor[0, 0, 0]]]],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`Detg[],
     Editable->False], "\[Rule]", 
    FractionBox[
     InterpretationBox[
      StyleBox[
       OverscriptBox[
        RowBox[{"[", 
         RowBox[{"g", 
          SuperscriptBox["s", "2"]}], "]"}], 
        OverscriptBox[
         StyleBox["~",
          FontColor->RGBColor[0, 0, 0]], 
         StyleBox["~",
          FontColor->RGBColor[0, 0, 0]]]],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`Detgs2[],
      Editable->False], 
     SuperscriptBox[
      InterpretationBox[
       StyleBox["s",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`s[],
       Editable->False], "8"]]}]}], "}"}]], "Output",
 CellLabel->"Out[23]=",ExpressionUUID->"c9bf796e-57ac-4052-80f3-6fc5a7690b16"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"gS2", 
         StyleBox[GridBox[{
            {
             UnderscriptBox["\[Alpha]", "_"], 
             UnderscriptBox["\[Beta]", "_"]},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`gS2[
      Pattern[$CellContext`\[Alpha], 
       Blank[]], 
      Pattern[$CellContext`\[Beta], 
       Blank[]]],
     Editable->False], "\[Rule]", 
    FractionBox[
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"[", 
            RowBox[{"g", 
             SuperscriptBox["s", "2"]}], "]"}], 
           StyleBox[GridBox[{
              {"\[Alpha]", "\[Beta]"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`gs2[$CellContext`\[Alpha], $CellContext`\[Beta]],
       Editable->False], " ", 
      SuperscriptBox[
       InterpretationBox[
        StyleBox["S",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`S[],
        Editable->False], "2"]}], 
     SuperscriptBox[
      InterpretationBox[
       StyleBox["s",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`s[],
       Editable->False], "2"]]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"igS2", 
         StyleBox[GridBox[{
            {
             UnderscriptBox["\[Alpha]", "_"], 
             UnderscriptBox["\[Beta]", "_"]},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`InvgS2[
      Pattern[$CellContext`\[Alpha], 
       Blank[]], 
      Pattern[$CellContext`\[Beta], 
       Blank[]]],
     Editable->False], "\[Rule]", 
    FractionBox[
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"i", "[", 
            RowBox[{"g", 
             SuperscriptBox["s", "2"]}], "]"}], 
           StyleBox[GridBox[{
              {"\[Alpha]", "\[Beta]"},
              {" ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->9]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`Invgs2[$CellContext`\[Alpha], $CellContext`\[Beta]],
       Editable->False], " ", 
      SuperscriptBox[
       InterpretationBox[
        StyleBox["s",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`s[],
        Editable->False], "2"]}], 
     SuperscriptBox[
      InterpretationBox[
       StyleBox["S",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`S[],
       Editable->False], "2"]]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      OverscriptBox["gS2", 
       OverscriptBox[
        StyleBox["~",
         FontColor->RGBColor[0, 0, 0]], 
        StyleBox["~",
         FontColor->RGBColor[0, 0, 0]]]],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`DetgS2[],
     Editable->False], "\[Rule]", 
    FractionBox[
     RowBox[{
      InterpretationBox[
       StyleBox[
        OverscriptBox[
         RowBox[{"[", 
          RowBox[{"g", 
           SuperscriptBox["s", "2"]}], "]"}], 
         OverscriptBox[
          StyleBox["~",
           FontColor->RGBColor[0, 0, 0]], 
          StyleBox["~",
           FontColor->RGBColor[0, 0, 0]]]],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`Detgs2[],
       Editable->False], " ", 
      SuperscriptBox[
       InterpretationBox[
        StyleBox["S",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`S[],
        Editable->False], "8"]}], 
     SuperscriptBox[
      InterpretationBox[
       StyleBox["s",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`s[],
       Editable->False], "8"]]}]}], "}"}]], "Output",
 CellLabel->
  "Out[24]=",ExpressionUUID->"8ed31b34-0b9e-4e84-a032-d0a4c62d66c1"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["ConformalFrame inert head", \
"Subsection",ExpressionUUID->"2413d355-a850-4aa1-96ee-fb4b49803911"],

Cell["\<\
ConformalFrame[metric][tensor[indices]] represents the transformation of \
tensor[indices] in a given conformal frame. \
\>", "Text",
 CellTags->{
  "S5.18.1", "1.2"},ExpressionUUID->"3d1fc3ea-b162-427a-9478-cc5ed2166dfa"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "ConformalFrame"}]], "Input",
 CellLabel->"In[25]:=",ExpressionUUID->"082fc624-2cb9-4e28-bea1-5778bfdf4c0b"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = False, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox[
             TagBox[
              TooltipBox[
               StyleBox["\<\" Symbol\"\>", "InformationRowLabel",
                StripOnInput->False],
               "\"Symbol\"",
               TooltipStyle->"TextStyling"],
              Annotation[#, "Symbol", "Tooltip"]& ], "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"Formal scalar head ConformalFrame[metric][expr] \
which indicates that expr (which must be of the form tens[inds]) is in fact \
the transformation of that quantity from the ambient frame to the frame \
associated with metric. Hence if metric is the first metric \
ConformalFrame[firstmetric][expr] = expr. \"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[
           TagBox[GridBox[{
              {
               StyleBox[
                TagBox[
                 TooltipBox[
                  
                  StyleBox["\<\" UpValue Definitions\"\>", 
                   "InformationRowLabel",
                   StripOnInput->False],
                  "\"UpValues\"",
                  TooltipStyle->"TextStyling"],
                 Annotation[#, "UpValues", "Tooltip"]& ], "DialogStyle",
                StripOnInput->False]},
              {
               TemplateBox[{"\"\[ThinSpace]\"", 
                 GridBox[{{
                    RowBox[{"ConformalFrame", "/:", 
                    RowBox[{"ContractThroughQ", "[", 
                    RowBox[{
                    RowBox[{"ConformalFrame", "[", "g", "]"}], ",", "delta"}],
                     "]"}], "=", "True"}]}, {" "}, {
                    RowBox[{"ConformalFrame", "/:", 
                    RowBox[{"ContractThroughQ", "[", 
                    RowBox[{
                    RowBox[{"ConformalFrame", "[", "gs2", "]"}], ",", 
                    "delta"}], "]"}], "=", "True"}]}, {" "}, {
                    RowBox[{"ConformalFrame", "/:", 
                    RowBox[{"ContractThroughQ", "[", 
                    RowBox[{
                    RowBox[{"ConformalFrame", "[", "gS2", "]"}], ",", 
                    "delta"}], "]"}], "=", "True"}]}, {" "}, {
                    RowBox[{
                    RowBox[{"DefInfo", "[", 
                    RowBox[{"ConformalFrame", "[", "g", "]"}], "]"}], "^=", 
                    RowBox[{"{", 
                    RowBox[{"\"inert head\"", ",", "\"\""}], "}"}]}]}, {" "}, {
                    RowBox[{
                    RowBox[{"DefInfo", "[", 
                    RowBox[{"ConformalFrame", "[", "gs2", "]"}], "]"}], "^=", 
                    
                    RowBox[{"{", 
                    RowBox[{"\"inert head\"", ",", "\"\""}], "}"}]}]}, {" "}, {
                    RowBox[{
                    RowBox[{"DefInfo", "[", 
                    RowBox[{"ConformalFrame", "[", "gS2", "]"}], "]"}], "^=", 
                    
                    RowBox[{"{", 
                    RowBox[{"\"inert head\"", ",", "\"\""}], "}"}]}]}, {" "}, {
                    RowBox[{
                    RowBox[{"InertHeadQ", "[", 
                    RowBox[{"ConformalFrame", "[", "g", "]"}], "]"}], "^=", 
                    "True"}]}, {" "}, {
                    RowBox[{
                    RowBox[{"InertHeadQ", "[", 
                    RowBox[{"ConformalFrame", "[", "gs2", "]"}], "]"}], "^=", 
                    "True"}]}, {" "}, {
                    RowBox[{
                    RowBox[{"InertHeadQ", "[", 
                    RowBox[{"ConformalFrame", "[", "gS2", "]"}], "]"}], "^=", 
                    "True"}]}, {" "}, {
                    RowBox[{
                    RowBox[{"LinearQ", "[", 
                    RowBox[{"ConformalFrame", "[", "g", "]"}], "]"}], "^=", 
                    "False"}]}, {" "}, {
                    RowBox[{
                    RowBox[{"LinearQ", "[", 
                    RowBox[{"ConformalFrame", "[", "gs2", "]"}], "]"}], "^=", 
                    "False"}]}, {" "}, {
                    RowBox[{
                    RowBox[{"LinearQ", "[", 
                    RowBox[{"ConformalFrame", "[", "gS2", "]"}], "]"}], "^=", 
                    "False"}]}, {" "}, {
                    RowBox[{
                    RowBox[{"PrintAs", "[", 
                    RowBox[{"ConformalFrame", "[", "g", "]"}], "]"}], "^=", 
                    "\"ConformalFrame[g]\""}]}, {" "}, {
                    RowBox[{
                    RowBox[{"PrintAs", "[", 
                    RowBox[{"ConformalFrame", "[", "gs2", "]"}], "]"}], "^=", 
                    "\"ConformalFrame[gs2]\""}]}, {" "}, {
                    RowBox[{
                    RowBox[{"PrintAs", "[", 
                    RowBox[{"ConformalFrame", "[", "gS2", "]"}], "]"}], "^=", 
                    "\"ConformalFrame[gS2]\""}]}, {" "}}, 
                  GridBoxAlignment -> {"Columns" -> {{Left}}}, 
                  DefaultBaseStyle -> "Column", 
                  GridBoxItemSize -> {
                   "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}]},
                "RowDefault"]},
              {
               StyleBox[
                TagBox[
                 TooltipBox[
                  
                  StyleBox["\<\" SubValue Definitions\"\>", 
                   "InformationRowLabel",
                   StripOnInput->False],
                  "\"SubValues\"",
                  TooltipStyle->"TextStyling"],
                 Annotation[#, "SubValues", "Tooltip"]& ], "DialogStyle",
                StripOnInput->False]},
              {
               TemplateBox[{"\"\[ThinSpace]\"", 
                 GridBox[{{
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["[", FontColor -> GrayLevel[0]], 
                    InterpretationBox[
                    StyleBox[
                    "\!\([g\!\(s\^2\)]\&\*StyleBox[\"~\",FontColor->RGBColor[\
0, 0, 0]]\&\*StyleBox[\"~\",FontColor->RGBColor[0, 0, 0]]\)", AutoSpacing -> 
                    False, ShowAutoStyles -> False], 
                    $CellContext`Detgs2[], Editable -> False], 
                    StyleBox["]", FontColor -> GrayLevel[0]]}], AutoSpacing -> 
                    False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`g][
                    $CellContext`Detgs2[]], Editable -> False], ":=", 
                    InterpretationBox[
                    StyleBox[
                    "\!\(g\&\*StyleBox[\"~\",FontColor->RGBColor[0, 0, \
0]]\&\*StyleBox[\"~\",FontColor->RGBColor[0, 0, 0]]\)", AutoSpacing -> False, 
                    ShowAutoStyles -> False], 
                    $CellContext`Detg[], Editable -> False]}]}, {" "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["[", FontColor -> GrayLevel[0]], 
                    InterpretationBox[
                    StyleBox[
                    "\!\(gS2\&\*StyleBox[\"~\",FontColor->RGBColor[0, 0, \
0]]\&\*StyleBox[\"~\",FontColor->RGBColor[0, 0, 0]]\)", AutoSpacing -> False, 
                    ShowAutoStyles -> False], 
                    $CellContext`DetgS2[], Editable -> False], 
                    StyleBox["]", FontColor -> GrayLevel[0]]}], AutoSpacing -> 
                    False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`g][
                    $CellContext`DetgS2[]], Editable -> False], ":=", 
                    InterpretationBox[
                    StyleBox[
                    "\!\(g\&\*StyleBox[\"~\",FontColor->RGBColor[0, 0, \
0]]\&\*StyleBox[\"~\",FontColor->RGBColor[0, 0, 0]]\)", AutoSpacing -> False, 
                    ShowAutoStyles -> False], 
                    $CellContext`Detg[], Editable -> False]}]}, {" "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["[", FontColor -> GrayLevel[0]], 
                    InterpretationBox[
                    StyleBox[
                    "R[\[Del]gs2]", AutoSpacing -> False, ShowAutoStyles -> 
                    False], 
                    $CellContext`RicciScalarCDgs2[], Editable -> False], 
                    StyleBox["]", FontColor -> GrayLevel[0]]}], AutoSpacing -> 
                    False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`g][
                    $CellContext`RicciScalarCDgs2[]], Editable -> False], 
                    ":=", 
                    InterpretationBox[
                    StyleBox[
                    "R[\[Del]]", AutoSpacing -> False, ShowAutoStyles -> 
                    False], 
                    $CellContext`RicciScalarCD[], Editable -> False]}]}, {
                   " "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["[", FontColor -> GrayLevel[0]], 
                    InterpretationBox[
                    StyleBox[
                    "R[\[Del]gS2]", AutoSpacing -> False, ShowAutoStyles -> 
                    False], 
                    $CellContext`RicciScalarCDgS2[], Editable -> False], 
                    StyleBox["]", FontColor -> GrayLevel[0]]}], AutoSpacing -> 
                    False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`g][
                    $CellContext`RicciScalarCDgS2[]], Editable -> False], 
                    ":=", 
                    InterpretationBox[
                    StyleBox[
                    "R[\[Del]]", AutoSpacing -> False, ShowAutoStyles -> 
                    False], 
                    $CellContext`RicciScalarCD[], Editable -> False]}]}, {
                   " "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["[", FontColor -> RGBColor[0, 0, 1]], 
                    InterpretationBox[
                    StyleBox[
                    "\!\(g\&\*StyleBox[\"~\",FontColor->RGBColor[0, 0, \
0]]\&\*StyleBox[\"~\",FontColor->RGBColor[0, 0, 0]]\)", AutoSpacing -> False, 
                    ShowAutoStyles -> False], 
                    $CellContext`Detg[], Editable -> False], 
                    StyleBox["]", FontColor -> RGBColor[0, 0, 1]]}], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`gs2][
                    $CellContext`Detg[]], Editable -> False], ":=", 
                    InterpretationBox[
                    StyleBox[
                    "\!\([g\!\(s\^2\)]\&\*StyleBox[\"~\",FontColor->RGBColor[\
0, 0, 0]]\&\*StyleBox[\"~\",FontColor->RGBColor[0, 0, 0]]\)", AutoSpacing -> 
                    False, ShowAutoStyles -> False], 
                    $CellContext`Detgs2[], Editable -> False]}]}, {" "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["[", FontColor -> RGBColor[0, 0, 1]], 
                    InterpretationBox[
                    StyleBox[
                    "\!\(gS2\&\*StyleBox[\"~\",FontColor->RGBColor[0, 0, \
0]]\&\*StyleBox[\"~\",FontColor->RGBColor[0, 0, 0]]\)", AutoSpacing -> False, 
                    ShowAutoStyles -> False], 
                    $CellContext`DetgS2[], Editable -> False], 
                    StyleBox["]", FontColor -> RGBColor[0, 0, 1]]}], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`gs2][
                    $CellContext`DetgS2[]], Editable -> False], ":=", 
                    InterpretationBox[
                    StyleBox[
                    "\!\([g\!\(s\^2\)]\&\*StyleBox[\"~\",FontColor->RGBColor[\
0, 0, 0]]\&\*StyleBox[\"~\",FontColor->RGBColor[0, 0, 0]]\)", AutoSpacing -> 
                    False, ShowAutoStyles -> False], 
                    $CellContext`Detgs2[], Editable -> False]}]}, {" "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["[", FontColor -> RGBColor[0, 0, 1]], 
                    InterpretationBox[
                    StyleBox[
                    "R[\[Del]]", AutoSpacing -> False, ShowAutoStyles -> 
                    False], 
                    $CellContext`RicciScalarCD[], Editable -> False], 
                    StyleBox["]", FontColor -> RGBColor[0, 0, 1]]}], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`gs2][
                    $CellContext`RicciScalarCD[]], Editable -> False], ":=", 
                    InterpretationBox[
                    StyleBox[
                    "R[\[Del]gs2]", AutoSpacing -> False, ShowAutoStyles -> 
                    False], 
                    $CellContext`RicciScalarCDgs2[], Editable -> False]}]}, {
                   " "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["[", FontColor -> RGBColor[0, 0, 1]], 
                    InterpretationBox[
                    StyleBox[
                    "R[\[Del]gS2]", AutoSpacing -> False, ShowAutoStyles -> 
                    False], 
                    $CellContext`RicciScalarCDgS2[], Editable -> False], 
                    StyleBox["]", FontColor -> RGBColor[0, 0, 1]]}], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`gs2][
                    $CellContext`RicciScalarCDgS2[]], Editable -> False], 
                    ":=", 
                    InterpretationBox[
                    StyleBox[
                    "R[\[Del]gs2]", AutoSpacing -> False, ShowAutoStyles -> 
                    False], 
                    $CellContext`RicciScalarCDgs2[], Editable -> False]}]}, {
                   " "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["[", FontColor -> RGBColor[1, 0, 0]], 
                    InterpretationBox[
                    StyleBox[
                    "\!\(g\&\*StyleBox[\"~\",FontColor->RGBColor[0, 0, \
0]]\&\*StyleBox[\"~\",FontColor->RGBColor[0, 0, 0]]\)", AutoSpacing -> False, 
                    ShowAutoStyles -> False], 
                    $CellContext`Detg[], Editable -> False], 
                    StyleBox["]", FontColor -> RGBColor[1, 0, 0]]}], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`gS2][
                    $CellContext`Detg[]], Editable -> False], ":=", 
                    InterpretationBox[
                    StyleBox[
                    "\!\(gS2\&\*StyleBox[\"~\",FontColor->RGBColor[0, 0, \
0]]\&\*StyleBox[\"~\",FontColor->RGBColor[0, 0, 0]]\)", AutoSpacing -> False, 
                    ShowAutoStyles -> False], 
                    $CellContext`DetgS2[], Editable -> False]}]}, {" "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["[", FontColor -> RGBColor[1, 0, 0]], 
                    InterpretationBox[
                    StyleBox[
                    "\!\([g\!\(s\^2\)]\&\*StyleBox[\"~\",FontColor->RGBColor[\
0, 0, 0]]\&\*StyleBox[\"~\",FontColor->RGBColor[0, 0, 0]]\)", AutoSpacing -> 
                    False, ShowAutoStyles -> False], 
                    $CellContext`Detgs2[], Editable -> False], 
                    StyleBox["]", FontColor -> RGBColor[1, 0, 0]]}], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`gS2][
                    $CellContext`Detgs2[]], Editable -> False], ":=", 
                    InterpretationBox[
                    StyleBox[
                    "\!\(gS2\&\*StyleBox[\"~\",FontColor->RGBColor[0, 0, \
0]]\&\*StyleBox[\"~\",FontColor->RGBColor[0, 0, 0]]\)", AutoSpacing -> False, 
                    ShowAutoStyles -> False], 
                    $CellContext`DetgS2[], Editable -> False]}]}, {" "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["[", FontColor -> RGBColor[1, 0, 0]], 
                    InterpretationBox[
                    StyleBox[
                    "R[\[Del]]", AutoSpacing -> False, ShowAutoStyles -> 
                    False], 
                    $CellContext`RicciScalarCD[], Editable -> False], 
                    StyleBox["]", FontColor -> RGBColor[1, 0, 0]]}], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`gS2][
                    $CellContext`RicciScalarCD[]], Editable -> False], ":=", 
                    InterpretationBox[
                    StyleBox[
                    "R[\[Del]gS2]", AutoSpacing -> False, ShowAutoStyles -> 
                    False], 
                    $CellContext`RicciScalarCDgS2[], Editable -> False]}]}, {
                   " "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["[", FontColor -> RGBColor[1, 0, 0]], 
                    InterpretationBox[
                    StyleBox[
                    "R[\[Del]gs2]", AutoSpacing -> False, ShowAutoStyles -> 
                    False], 
                    $CellContext`RicciScalarCDgs2[], Editable -> False], 
                    StyleBox["]", FontColor -> RGBColor[1, 0, 0]]}], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`gS2][
                    $CellContext`RicciScalarCDgs2[]], Editable -> False], 
                    ":=", 
                    InterpretationBox[
                    StyleBox[
                    "R[\[Del]gS2]", AutoSpacing -> False, ShowAutoStyles -> 
                    False], 
                    $CellContext`RicciScalarCDgS2[], Editable -> False]}]}, {
                   " "}, {
                    RowBox[{
                    RowBox[{
                    RowBox[{"ConformalFrame", "[", "_", "]"}], "[", 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"\[Delta]", 
                    StyleBox[
                    
                    GridBox[{{"\!\(xAct`xConf`Private`\[Mu]\+_\)", 
                    "\!\(xAct`xConf`Private`\[Nu]\+_\)"}, {" ", " "}}, 
                    RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 9]}}, 
                    ColumnSpacings -> 0.05, RowAlignments -> Center], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    xAct`xTensor`delta[
                    Pattern[xAct`xConf`Private`\[Mu], 
                    Blank[]], 
                    Pattern[xAct`xConf`Private`\[Nu], 
                    Blank[]]], Editable -> False], "]"}], ":=", 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"\[Delta]", 
                    StyleBox[
                    
                    GridBox[{{"xAct`xConf`Private`\[Mu]", 
                    "xAct`xConf`Private`\[Nu]"}, {" ", " "}}, RowSpacings -> 
                    0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 9]}}, 
                    ColumnSpacings -> 0.05, RowAlignments -> Center], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    xAct`xTensor`delta[
                    xAct`xConf`Private`\[Mu], xAct`xConf`Private`\[Nu]], 
                    Editable -> False]}]}, {" "}, {
                    RowBox[{
                    RowBox[{
                    RowBox[{"ConformalFrame", "[", 
                    RowBox[{"xAct`xConf`Private`g1_", "?", "MetricQ"}], "]"}],
                     "[", 
                    
                    RowBox[{
                    "xAct`xConf`Private`val_Real", "|", 
                    "xAct`xConf`Private`val_Complex", "|", 
                    "xAct`xConf`Private`val_Rational", "|", 
                    "xAct`xConf`Private`val_Integer"}], "]"}], ":=", 
                    "xAct`xConf`Private`val"}]}, {" "}, {
                    RowBox[{
                    RowBox[{
                    RowBox[{"ConformalFrame", "[", 
                    RowBox[{"xAct`xConf`Private`g1_", "?", "MetricQ"}], "]"}],
                     "[", 
                    
                    RowBox[{
                    "xAct`xConf`Private`val_", "?", "ConstantSymbolQ"}], 
                    "]"}], ":=", "xAct`xConf`Private`val"}]}, {" "}, {
                    RowBox[{
                    RowBox[{
                    RowBox[{"ConformalFrame", "[", 
                    RowBox[{"xAct`xConf`Private`g1_", "?", "MetricQ"}], "]"}],
                     "[", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"xAct`xConf`Private`S_", "?", "ScalarQ"}], ")"}], 
                    "xAct`xConf`Private`n_Integer"], "]"}], ":=", 
                    SuperscriptBox[
                    RowBox[{
                    
                    RowBox[{
                    "ConformalFrame", "[", "xAct`xConf`Private`g1", "]"}], 
                    "[", "xAct`xConf`Private`S", "]"}], 
                    "xAct`xConf`Private`n"]}]}, {" "}, {
                    RowBox[{
                    RowBox[{
                    RowBox[{"ConformalFrame", "[", 
                    RowBox[{"xAct`xConf`Private`g1_", "?", "MetricQ"}], "]"}],
                     "[", "xAct`xConf`Private`product_Times", "]"}], ":=", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"ConformalFrame", "[", "xAct`xConf`Private`g1", 
                    "]"}], "[", "#1", "]"}], "&"}], ")"}], "/@", 
                    "xAct`xConf`Private`product"}]}]}, {" "}, {
                    RowBox[{
                    RowBox[{
                    RowBox[{"ConformalFrame", "[", 
                    RowBox[{"xAct`xConf`Private`g1_", "?", "MetricQ"}], "]"}],
                     "[", "xAct`xConf`Private`sum_Plus", "]"}], ":=", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"ConformalFrame", "[", "xAct`xConf`Private`g1", 
                    "]"}], "[", "#1", "]"}], "&"}], ")"}], "/@", 
                    "xAct`xConf`Private`sum"}]}]}, {" "}, {
                    RowBox[{
                    RowBox[{
                    RowBox[{"ConformalFrame", "[", 
                    RowBox[{"xAct`xConf`Private`g1_", "?", "MetricQ"}], "]"}],
                     "[", 
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["(", FontColor -> RGBColor[1, 0, 0]], 
                    "xAct`xConf`Private`expr_", 
                    StyleBox[")", FontColor -> RGBColor[1, 0, 0]]}], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    xAct`xTensor`Scalar[
                    Pattern[xAct`xConf`Private`expr, 
                    Blank[]]], Editable -> False], "]"}], ":=", 
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["(", FontColor -> RGBColor[1, 0, 0]], 
                    RowBox[{
                    
                    RowBox[{"ConformalFrame", "[", "xAct`xConf`Private`g1", 
                    "]"}], "[", "xAct`xConf`Private`expr", "]"}], 
                    StyleBox[")", FontColor -> RGBColor[1, 0, 0]]}], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    xAct`xTensor`Scalar[
                    xAct`xConf`ConformalFrame[xAct`xConf`Private`g1][
                    xAct`xConf`Private`expr]], Editable -> False]}]}, {" "}, {
                   
                    RowBox[{
                    RowBox[{
                    RowBox[{"ConformalFrame", "[", 
                    RowBox[{"xAct`xConf`Private`g1_", "?", "MetricQ"}], "]"}],
                     "[", 
                    RowBox[{
                    RowBox[{"xAct`xConf`Private`f_", "?", "ScalarFunctionQ"}],
                     "[", "xAct`xConf`Private`expr_", "]"}], "]"}], ":=", 
                    RowBox[{"xAct`xConf`Private`f", "[", 
                    RowBox[{
                    
                    RowBox[{
                    "ConformalFrame", "[", "xAct`xConf`Private`g1", "]"}], 
                    "[", "xAct`xConf`Private`expr", "]"}], "]"}]}]}, {" "}, {
                    RowBox[{
                    RowBox[{
                    RowBox[{"ConformalFrame", "[", 
                    RowBox[{"xAct`xConf`Private`g1_", "?", "MetricQ"}], "]"}],
                     "[", 
                    RowBox[{
                    RowBox[{"xAct`xConf`Private`S_", "?", "ScalarQ"}], "[", 
                    "]"}], "]"}], ":=", 
                    RowBox[{
                    RowBox[{"xAct`xConf`Private`S", "[", "]"}], "/;", 
                    RowBox[{
                    
                    RowBox[{
                    "ConformalWeight", "[", "xAct`xConf`Private`S", "]"}], 
                    "===", "0"}]}]}]}, {" "}, {
                    RowBox[{
                    RowBox[{
                    RowBox[{"ConformalFrame", "[", 
                    RowBox[{"xAct`xConf`Private`g1_", "?", "MetricQ"}], "]"}],
                     "[", 
                    RowBox[{
                    RowBox[{"ConformalFrame", "[", 
                    RowBox[{"xAct`xConf`Private`g2_", "?", "MetricQ"}], "]"}],
                     "[", "xAct`xConf`Private`expr_", "]"}], "]"}], ":=", 
                    RowBox[{
                    
                    RowBox[{
                    "ConformalFrame", "[", "xAct`xConf`Private`g1", "]"}], 
                    "[", "xAct`xConf`Private`expr", "]"}]}]}, {" "}, {
                    RowBox[{
                    RowBox[{
                    RowBox[{"ConformalFrame", "[", "_", "]"}], "[", 
                    InterpretationBox[
                    StyleBox[
                    "S", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`S[], Editable -> False], "]"}], ":=", 
                    InterpretationBox[
                    StyleBox[
                    "S", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`S[], Editable -> False]}]}, {" "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["[", FontColor -> RGBColor[1, 0, 0]], 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"g", 
                    StyleBox[
                    
                    GridBox[{{"\!\(\!\(xAct`xConf`Private`i1$\+_\)\+_\)", 
                    "\!\(\!\(xAct`xConf`Private`i2$\+_\)\+_\)"}, {" ", " "}}, 
                    RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 9]}}, 
                    ColumnSpacings -> 0.05, RowAlignments -> Center], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`g[
                    PatternTest[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], xAct`xTensor`DownIndexQ]], Editable -> False], 
                    StyleBox["]", FontColor -> RGBColor[1, 0, 0]]}], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`gS2][
                    $CellContext`g[
                    PatternTest[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], xAct`xTensor`DownIndexQ]]], Editable -> False], 
                    ":=", 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"gS2", 
                    StyleBox[
                    
                    GridBox[{{"xAct`xConf`Private`i1$", 
                    "xAct`xConf`Private`i2$"}, {" ", " "}}, RowSpacings -> 0, 
                    ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 9]}}, 
                    ColumnSpacings -> 0.05, RowAlignments -> Center], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`gS2[
                    xAct`xConf`Private`i1$, xAct`xConf`Private`i2$], Editable -> 
                    False]}]}, {" "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["[", FontColor -> RGBColor[1, 0, 0]], 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"g", 
                    StyleBox[
                    
                    GridBox[{{"\!\(\!\(xAct`xConf`Private`i1$\+_\)\+_\)", 
                    "\!\(\!\(xAct`xConf`Private`i2$\+_\)\+_\)"}, {" ", " "}}, 
                    RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 9]}}, 
                    ColumnSpacings -> 0.05, RowAlignments -> Center], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`g[
                    PatternTest[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], xAct`xTensor`UpIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], xAct`xTensor`UpIndexQ]], Editable -> False], 
                    StyleBox["]", FontColor -> RGBColor[1, 0, 0]]}], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`gS2][
                    $CellContext`g[
                    PatternTest[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], xAct`xTensor`UpIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], xAct`xTensor`UpIndexQ]]], Editable -> False], 
                    ":=", 
                    RowBox[{
                    RowBox[{"Inv", "[", "gS2", "]"}], "[", 
                    
                    RowBox[{
                    "xAct`xConf`Private`i1$", ",", "xAct`xConf`Private`i2$"}],
                     "]"}]}]}, {" "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["[", FontColor -> RGBColor[1, 0, 0]], 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"R[\[Del]]", 
                    StyleBox[
                    
                    GridBox[{{"\!\(\!\(xAct`xConf`Private`i1$\+_\)\+_\)", 
                    "\!\(\!\(xAct`xConf`Private`i2$\+_\)\+_\)", 
                    "\!\(\!\(xAct`xConf`Private`i3$\+_\)\+_\)", 
                    "\!\(\!\(xAct`xConf`Private`i4$\+_\)\+_\)"}, {
                    " ", " ", " ", " "}}, RowSpacings -> 0, ColumnSpacings -> 
                    0.05, GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 
                    9]}}, ColumnSpacings -> 0.05, RowAlignments -> Center], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`RiemannCD[
                    PatternTest[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i3$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i4$, 
                    Blank[]], xAct`xTensor`UpIndexQ]], Editable -> False], 
                    StyleBox["]", FontColor -> RGBColor[1, 0, 0]]}], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`gS2][
                    $CellContext`RiemannCD[
                    PatternTest[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i3$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i4$, 
                    Blank[]], xAct`xTensor`UpIndexQ]]], Editable -> False], 
                    ":=", 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"R[\[Del]gS2]", 
                    StyleBox[
                    
                    GridBox[{{"xAct`xConf`Private`i1$", 
                    "xAct`xConf`Private`i2$", "xAct`xConf`Private`i3$", 
                    "xAct`xConf`Private`i4$"}, {" ", " ", " ", " "}}, 
                    RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 9]}}, 
                    ColumnSpacings -> 0.05, RowAlignments -> Center], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`RiemannCDgS2[
                    xAct`xConf`Private`i1$, xAct`xConf`Private`i2$, 
                    xAct`xConf`Private`i3$, xAct`xConf`Private`i4$], Editable -> 
                    False]}]}, {" "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["[", FontColor -> RGBColor[1, 0, 0]], 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"R[\[Del]]", 
                    StyleBox[
                    
                    GridBox[{{"\!\(xAct`xConf`Private`i1$\+_\)", 
                    "\!\(xAct`xConf`Private`i2$\+_\)", 
                    "\!\(xAct`xConf`Private`i3$\+_\)", 
                    "\!\(xAct`xConf`Private`i4$\+_\)"}, {" ", " ", " ", " "}},
                     RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 9]}}, 
                    ColumnSpacings -> 0.05, RowAlignments -> Center], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`RiemannCD[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], 
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], 
                    Pattern[xAct`xConf`Private`i3$, 
                    Blank[]], 
                    Pattern[xAct`xConf`Private`i4$, 
                    Blank[]]], Editable -> False], 
                    StyleBox["]", FontColor -> RGBColor[1, 0, 0]]}], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`gS2][
                    $CellContext`RiemannCD[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], 
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], 
                    Pattern[xAct`xConf`Private`i3$, 
                    Blank[]], 
                    Pattern[xAct`xConf`Private`i4$, 
                    Blank[]]]], Editable -> False], ":=", 
                    RowBox[{
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    "S", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`S[], Editable -> False], 
                    RowBox[{
                    RowBox[{"xAct`xConf`Private`WeightOfIndicesList", "[", 
                    RowBox[{"{", 
                    
                    RowBox[{"xAct`xConf`Private`i1$", ",", 
                    "xAct`xConf`Private`i2$", ",", "xAct`xConf`Private`i3$", 
                    ",", "xAct`xConf`Private`i4$"}], "}"}], "]"}], "-", 
                    "2"}]], " ", 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"R[\[Del]gS2]", 
                    StyleBox[
                    
                    GridBox[{{"xAct`xConf`Private`i1$", 
                    "xAct`xConf`Private`i2$", "xAct`xConf`Private`i3$", 
                    "xAct`xConf`Private`i4$"}, {" ", " ", " ", " "}}, 
                    RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 9]}}, 
                    ColumnSpacings -> 0.05, RowAlignments -> Center], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`RiemannCDgS2[
                    xAct`xConf`Private`i1$, xAct`xConf`Private`i2$, 
                    xAct`xConf`Private`i3$, xAct`xConf`Private`i4$], Editable -> 
                    False]}]}]}, {" "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["[", FontColor -> RGBColor[1, 0, 0]], 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"R[\[Del]]", 
                    StyleBox[
                    
                    GridBox[{{"\!\(\!\(xAct`xConf`Private`i1$\+_\)\+_\)", 
                    "\!\(\!\(xAct`xConf`Private`i2$\+_\)\+_\)"}, {" ", " "}}, 
                    RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 9]}}, 
                    ColumnSpacings -> 0.05, RowAlignments -> Center], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`RicciCD[
                    PatternTest[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], xAct`xTensor`DownIndexQ]], Editable -> False], 
                    StyleBox["]", FontColor -> RGBColor[1, 0, 0]]}], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`gS2][
                    $CellContext`RicciCD[
                    PatternTest[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], xAct`xTensor`DownIndexQ]]], Editable -> False], 
                    ":=", 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"R[\[Del]gS2]", 
                    StyleBox[
                    
                    GridBox[{{"xAct`xConf`Private`i1$", 
                    "xAct`xConf`Private`i2$"}, {" ", " "}}, RowSpacings -> 0, 
                    ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 9]}}, 
                    ColumnSpacings -> 0.05, RowAlignments -> Center], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`RicciCDgS2[
                    xAct`xConf`Private`i1$, xAct`xConf`Private`i2$], Editable -> 
                    False]}]}, {" "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["[", FontColor -> RGBColor[1, 0, 0]], 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"R[\[Del]]", 
                    StyleBox[
                    
                    GridBox[{{"\!\(xAct`xConf`Private`i1$\+_\)", 
                    "\!\(xAct`xConf`Private`i2$\+_\)"}, {" ", " "}}, 
                    RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 9]}}, 
                    ColumnSpacings -> 0.05, RowAlignments -> Center], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`RicciCD[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], 
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]]], Editable -> False], 
                    StyleBox["]", FontColor -> RGBColor[1, 0, 0]]}], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`gS2][
                    $CellContext`RicciCD[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], 
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]]]], Editable -> False], ":=", 
                    RowBox[{
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    "S", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`S[], Editable -> False], 
                    RowBox[{
                    RowBox[{"xAct`xConf`Private`WeightOfIndicesList", "[", 
                    RowBox[{"{", 
                    
                    RowBox[{"xAct`xConf`Private`i1$", ",", 
                    "xAct`xConf`Private`i2$"}], "}"}], "]"}], "-", "2"}]], 
                    " ", 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"R[\[Del]gS2]", 
                    StyleBox[
                    
                    GridBox[{{"xAct`xConf`Private`i1$", 
                    "xAct`xConf`Private`i2$"}, {" ", " "}}, RowSpacings -> 0, 
                    ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 9]}}, 
                    ColumnSpacings -> 0.05, RowAlignments -> Center], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`RicciCDgS2[
                    xAct`xConf`Private`i1$, xAct`xConf`Private`i2$], Editable -> 
                    False]}]}]}, {" "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"ConformalFrame[gS2]", "[", 
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    SuperscriptBox[
                    "\[Del]", "\!\(xAct`xConf`Private`i1$\+_\)"], 
                    "xAct`xConf`Private`ex$_"}], AutoSpacing -> False, 
                    ShowAutoStyles -> False], 
                    $CellContext`CD[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]]][
                    Pattern[xAct`xConf`Private`ex$, 
                    Blank[]]], Editable -> False], "]"}], AutoSpacing -> 
                    False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`gS2][
                    $CellContext`CD[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]]][
                    Pattern[xAct`xConf`Private`ex$, 
                    Blank[]]]], Editable -> False], ":=", 
                    RowBox[{
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    "S", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`S[], Editable -> False], 
                    RowBox[{
                    RowBox[{"xAct`xConf`Private`WeightOfIndicesList", "[", 
                    RowBox[{"{", "xAct`xConf`Private`i1$", "}"}], "]"}], "-", 
                    "1"}]], " ", 
                    RowBox[{"(", 
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    SuperscriptBox["\[Del]gS2", "xAct`xConf`Private`i1$"], 
                    "ConformalFrame[gS2]", "[", "xAct`xConf`Private`ex$", 
                    "]"}], AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`CDgS2[xAct`xConf`Private`i1$][
                    xAct`xConf`ConformalFrame[$CellContext`gS2][
                    xAct`xConf`Private`ex$]], Editable -> False], 
                    ")"}]}]}]}, {" "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["[", FontColor -> RGBColor[1, 0, 0]], 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"\[Epsilon]g", 
                    StyleBox[
                    
                    GridBox[{{"\!\(\!\(xAct`xConf`Private`inds$\+_\)\+_\)"}, {
                    " "}}, RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 9]}}, 
                    ColumnSpacings -> 0.05, RowAlignments -> Center], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`epsilong[
                    PatternTest[
                    Pattern[xAct`xConf`Private`inds$, 
                    BlankSequence[]], And[
                    xAct`xTensor`DownIndexQ[#]]& ]], Editable -> False], 
                    StyleBox["]", FontColor -> RGBColor[1, 0, 0]]}], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`gS2][
                    $CellContext`epsilong[
                    PatternTest[
                    Pattern[xAct`xConf`Private`inds$, 
                    BlankSequence[]], And[
                    xAct`xTensor`DownIndexQ[#]]& ]]], Editable -> False], 
                    ":=", 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"\[Epsilon]gS2", 
                    StyleBox[
                    
                    GridBox[{{"xAct`xConf`Private`inds$"}, {" "}}, 
                    RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 9]}}, 
                    ColumnSpacings -> 0.05, RowAlignments -> Center], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`epsilongS2[xAct`xConf`Private`inds$], 
                    Editable -> False]}]}, {" "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["[", FontColor -> GrayLevel[0]], 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"gS2", 
                    StyleBox[
                    
                    GridBox[{{"\!\(\!\(xAct`xConf`Private`i1$\+_\)\+_\)", 
                    "\!\(\!\(xAct`xConf`Private`i2$\+_\)\+_\)"}, {" ", " "}}, 
                    RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 9]}}, 
                    ColumnSpacings -> 0.05, RowAlignments -> Center], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`gS2[
                    PatternTest[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], xAct`xTensor`DownIndexQ]], Editable -> False], 
                    StyleBox["]", FontColor -> GrayLevel[0]]}], AutoSpacing -> 
                    False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`g][
                    $CellContext`gS2[
                    PatternTest[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], xAct`xTensor`DownIndexQ]]], Editable -> False], 
                    ":=", 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"g", 
                    StyleBox[
                    
                    GridBox[{{"xAct`xConf`Private`i1$", 
                    "xAct`xConf`Private`i2$"}, {" ", " "}}, RowSpacings -> 0, 
                    ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 9]}}, 
                    ColumnSpacings -> 0.05, RowAlignments -> Center], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`g[
                    xAct`xConf`Private`i1$, xAct`xConf`Private`i2$], Editable -> 
                    False]}]}, {" "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["[", FontColor -> GrayLevel[0]], 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"igS2", 
                    StyleBox[
                    
                    GridBox[{{"\!\(\!\(xAct`xConf`Private`i1$\+_\)\+_\)", 
                    "\!\(\!\(xAct`xConf`Private`i2$\+_\)\+_\)"}, {" ", " "}}, 
                    RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 9]}}, 
                    ColumnSpacings -> 0.05, RowAlignments -> Center], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`InvgS2[
                    PatternTest[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], xAct`xTensor`UpIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], xAct`xTensor`UpIndexQ]], Editable -> False], 
                    StyleBox["]", FontColor -> GrayLevel[0]]}], AutoSpacing -> 
                    False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`g][
                    $CellContext`InvgS2[
                    PatternTest[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], xAct`xTensor`UpIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], xAct`xTensor`UpIndexQ]]], Editable -> False], 
                    ":=", 
                    RowBox[{
                    RowBox[{"Inv", "[", "g", "]"}], "[", 
                    
                    RowBox[{
                    "xAct`xConf`Private`i1$", ",", "xAct`xConf`Private`i2$"}],
                     "]"}]}]}, {" "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["[", FontColor -> GrayLevel[0]], 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"R[\[Del]gS2]", 
                    StyleBox[
                    
                    GridBox[{{"\!\(\!\(xAct`xConf`Private`i1$\+_\)\+_\)", 
                    "\!\(\!\(xAct`xConf`Private`i2$\+_\)\+_\)", 
                    "\!\(\!\(xAct`xConf`Private`i3$\+_\)\+_\)", 
                    "\!\(\!\(xAct`xConf`Private`i4$\+_\)\+_\)"}, {
                    " ", " ", " ", " "}}, RowSpacings -> 0, ColumnSpacings -> 
                    0.05, GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 
                    9]}}, ColumnSpacings -> 0.05, RowAlignments -> Center], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`RiemannCDgS2[
                    PatternTest[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i3$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i4$, 
                    Blank[]], xAct`xTensor`UpIndexQ]], Editable -> False], 
                    StyleBox["]", FontColor -> GrayLevel[0]]}], AutoSpacing -> 
                    False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`g][
                    $CellContext`RiemannCDgS2[
                    PatternTest[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i3$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i4$, 
                    Blank[]], xAct`xTensor`UpIndexQ]]], Editable -> False], 
                    ":=", 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"R[\[Del]]", 
                    StyleBox[
                    
                    GridBox[{{"xAct`xConf`Private`i1$", 
                    "xAct`xConf`Private`i2$", "xAct`xConf`Private`i3$", 
                    "xAct`xConf`Private`i4$"}, {" ", " ", " ", " "}}, 
                    RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 9]}}, 
                    ColumnSpacings -> 0.05, RowAlignments -> Center], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`RiemannCD[
                    xAct`xConf`Private`i1$, xAct`xConf`Private`i2$, 
                    xAct`xConf`Private`i3$, xAct`xConf`Private`i4$], Editable -> 
                    False]}]}, {" "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["[", FontColor -> GrayLevel[0]], 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"R[\[Del]gS2]", 
                    StyleBox[
                    
                    GridBox[{{"\!\(xAct`xConf`Private`i1$\+_\)", 
                    "\!\(xAct`xConf`Private`i2$\+_\)", 
                    "\!\(xAct`xConf`Private`i3$\+_\)", 
                    "\!\(xAct`xConf`Private`i4$\+_\)"}, {" ", " ", " ", " "}},
                     RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 9]}}, 
                    ColumnSpacings -> 0.05, RowAlignments -> Center], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`RiemannCDgS2[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], 
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], 
                    Pattern[xAct`xConf`Private`i3$, 
                    Blank[]], 
                    Pattern[xAct`xConf`Private`i4$, 
                    Blank[]]], Editable -> False], 
                    StyleBox["]", FontColor -> GrayLevel[0]]}], AutoSpacing -> 
                    False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`g][
                    $CellContext`RiemannCDgS2[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], 
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], 
                    Pattern[xAct`xConf`Private`i3$, 
                    Blank[]], 
                    Pattern[xAct`xConf`Private`i4$, 
                    Blank[]]]], Editable -> False], ":=", 
                    RowBox[{
                    SuperscriptBox[
                    RowBox[{"(", 
                    FractionBox["1", 
                    InterpretationBox[
                    StyleBox[
                    "S", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`S[], Editable -> False]], ")"}], 
                    RowBox[{
                    RowBox[{"xAct`xConf`Private`WeightOfIndicesList", "[", 
                    RowBox[{"{", 
                    
                    RowBox[{"xAct`xConf`Private`i1$", ",", 
                    "xAct`xConf`Private`i2$", ",", "xAct`xConf`Private`i3$", 
                    ",", "xAct`xConf`Private`i4$"}], "}"}], "]"}], "-", 
                    "2"}]], " ", 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"R[\[Del]]", 
                    StyleBox[
                    
                    GridBox[{{"xAct`xConf`Private`i1$", 
                    "xAct`xConf`Private`i2$", "xAct`xConf`Private`i3$", 
                    "xAct`xConf`Private`i4$"}, {" ", " ", " ", " "}}, 
                    RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 9]}}, 
                    ColumnSpacings -> 0.05, RowAlignments -> Center], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`RiemannCD[
                    xAct`xConf`Private`i1$, xAct`xConf`Private`i2$, 
                    xAct`xConf`Private`i3$, xAct`xConf`Private`i4$], Editable -> 
                    False]}]}]}, {" "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["[", FontColor -> GrayLevel[0]], 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"R[\[Del]gS2]", 
                    StyleBox[
                    
                    GridBox[{{"\!\(\!\(xAct`xConf`Private`i1$\+_\)\+_\)", 
                    "\!\(\!\(xAct`xConf`Private`i2$\+_\)\+_\)"}, {" ", " "}}, 
                    RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 9]}}, 
                    ColumnSpacings -> 0.05, RowAlignments -> Center], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`RicciCDgS2[
                    PatternTest[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], xAct`xTensor`DownIndexQ]], Editable -> False], 
                    StyleBox["]", FontColor -> GrayLevel[0]]}], AutoSpacing -> 
                    False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`g][
                    $CellContext`RicciCDgS2[
                    PatternTest[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], xAct`xTensor`DownIndexQ]]], Editable -> False], 
                    ":=", 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"R[\[Del]]", 
                    StyleBox[
                    
                    GridBox[{{"xAct`xConf`Private`i1$", 
                    "xAct`xConf`Private`i2$"}, {" ", " "}}, RowSpacings -> 0, 
                    ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 9]}}, 
                    ColumnSpacings -> 0.05, RowAlignments -> Center], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`RicciCD[
                    xAct`xConf`Private`i1$, xAct`xConf`Private`i2$], Editable -> 
                    False]}]}, {" "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["[", FontColor -> GrayLevel[0]], 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"R[\[Del]gS2]", 
                    StyleBox[
                    
                    GridBox[{{"\!\(xAct`xConf`Private`i1$\+_\)", 
                    "\!\(xAct`xConf`Private`i2$\+_\)"}, {" ", " "}}, 
                    RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 9]}}, 
                    ColumnSpacings -> 0.05, RowAlignments -> Center], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`RicciCDgS2[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], 
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]]], Editable -> False], 
                    StyleBox["]", FontColor -> GrayLevel[0]]}], AutoSpacing -> 
                    False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`g][
                    $CellContext`RicciCDgS2[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], 
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]]]], Editable -> False], ":=", 
                    RowBox[{
                    SuperscriptBox[
                    RowBox[{"(", 
                    FractionBox["1", 
                    InterpretationBox[
                    StyleBox[
                    "S", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`S[], Editable -> False]], ")"}], 
                    RowBox[{
                    RowBox[{"xAct`xConf`Private`WeightOfIndicesList", "[", 
                    RowBox[{"{", 
                    
                    RowBox[{"xAct`xConf`Private`i1$", ",", 
                    "xAct`xConf`Private`i2$"}], "}"}], "]"}], "-", "2"}]], 
                    " ", 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"R[\[Del]]", 
                    StyleBox[
                    
                    GridBox[{{"xAct`xConf`Private`i1$", 
                    "xAct`xConf`Private`i2$"}, {" ", " "}}, RowSpacings -> 0, 
                    ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 9]}}, 
                    ColumnSpacings -> 0.05, RowAlignments -> Center], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`RicciCD[
                    xAct`xConf`Private`i1$, xAct`xConf`Private`i2$], Editable -> 
                    False]}]}]}, {" "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"ConformalFrame[g]", "[", 
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    SuperscriptBox[
                    "\[Del]gS2", "\!\(xAct`xConf`Private`i1$\+_\)"], 
                    "xAct`xConf`Private`ex$_"}], AutoSpacing -> False, 
                    ShowAutoStyles -> False], 
                    $CellContext`CDgS2[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]]][
                    Pattern[xAct`xConf`Private`ex$, 
                    Blank[]]], Editable -> False], "]"}], AutoSpacing -> 
                    False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`g][
                    $CellContext`CDgS2[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]]][
                    Pattern[xAct`xConf`Private`ex$, 
                    Blank[]]]], Editable -> False], ":=", 
                    RowBox[{
                    SuperscriptBox[
                    RowBox[{"(", 
                    FractionBox["1", 
                    InterpretationBox[
                    StyleBox[
                    "S", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`S[], Editable -> False]], ")"}], 
                    RowBox[{
                    RowBox[{"xAct`xConf`Private`WeightOfIndicesList", "[", 
                    RowBox[{"{", "xAct`xConf`Private`i1$", "}"}], "]"}], "-", 
                    "1"}]], " ", 
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    SuperscriptBox["\[Del]", "xAct`xConf`Private`i1$"], 
                    "ConformalFrame[g]", "[", "xAct`xConf`Private`ex$", "]"}],
                     AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`CD[xAct`xConf`Private`i1$][
                    xAct`xConf`ConformalFrame[$CellContext`g][
                    xAct`xConf`Private`ex$]], Editable -> False]}]}]}, {" "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["[", FontColor -> GrayLevel[0]], 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"\[Epsilon]gS2", 
                    StyleBox[
                    
                    GridBox[{{"\!\(\!\(xAct`xConf`Private`inds$\+_\)\+_\)"}, {
                    " "}}, RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 9]}}, 
                    ColumnSpacings -> 0.05, RowAlignments -> Center], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`epsilongS2[
                    PatternTest[
                    Pattern[xAct`xConf`Private`inds$, 
                    BlankSequence[]], And[
                    xAct`xTensor`DownIndexQ[#]]& ]], Editable -> False], 
                    StyleBox["]", FontColor -> GrayLevel[0]]}], AutoSpacing -> 
                    False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`g][
                    $CellContext`epsilongS2[
                    PatternTest[
                    Pattern[xAct`xConf`Private`inds$, 
                    BlankSequence[]], And[
                    xAct`xTensor`DownIndexQ[#]]& ]]], Editable -> False], 
                    ":=", 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"\[Epsilon]g", 
                    StyleBox[
                    
                    GridBox[{{"xAct`xConf`Private`inds$"}, {" "}}, 
                    RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 9]}}, 
                    ColumnSpacings -> 0.05, RowAlignments -> Center], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`epsilong[xAct`xConf`Private`inds$], Editable -> 
                    False]}]}, {" "}, {
                    RowBox[{
                    RowBox[{
                    RowBox[{"ConformalFrame", "[", "_", "]"}], "[", 
                    InterpretationBox[
                    StyleBox[
                    "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`s[], Editable -> False], "]"}], ":=", 
                    InterpretationBox[
                    StyleBox[
                    "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`s[], Editable -> False]}]}, {" "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["[", FontColor -> RGBColor[0, 0, 1]], 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"g", 
                    StyleBox[
                    
                    GridBox[{{"\!\(\!\(xAct`xConf`Private`i1$\+_\)\+_\)", 
                    "\!\(\!\(xAct`xConf`Private`i2$\+_\)\+_\)"}, {" ", " "}}, 
                    RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 9]}}, 
                    ColumnSpacings -> 0.05, RowAlignments -> Center], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`g[
                    PatternTest[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], xAct`xTensor`DownIndexQ]], Editable -> False], 
                    StyleBox["]", FontColor -> RGBColor[0, 0, 1]]}], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`gs2][
                    $CellContext`g[
                    PatternTest[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], xAct`xTensor`DownIndexQ]]], Editable -> False], 
                    ":=", 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"[g\!\(s\^2\)]", 
                    StyleBox[
                    
                    GridBox[{{"xAct`xConf`Private`i1$", 
                    "xAct`xConf`Private`i2$"}, {" ", " "}}, RowSpacings -> 0, 
                    ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 9]}}, 
                    ColumnSpacings -> 0.05, RowAlignments -> Center], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`gs2[
                    xAct`xConf`Private`i1$, xAct`xConf`Private`i2$], Editable -> 
                    False]}]}, {" "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["[", FontColor -> RGBColor[0, 0, 1]], 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"g", 
                    StyleBox[
                    
                    GridBox[{{"\!\(\!\(xAct`xConf`Private`i1$\+_\)\+_\)", 
                    "\!\(\!\(xAct`xConf`Private`i2$\+_\)\+_\)"}, {" ", " "}}, 
                    RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 9]}}, 
                    ColumnSpacings -> 0.05, RowAlignments -> Center], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`g[
                    PatternTest[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], xAct`xTensor`UpIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], xAct`xTensor`UpIndexQ]], Editable -> False], 
                    StyleBox["]", FontColor -> RGBColor[0, 0, 1]]}], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`gs2][
                    $CellContext`g[
                    PatternTest[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], xAct`xTensor`UpIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], xAct`xTensor`UpIndexQ]]], Editable -> False], 
                    ":=", 
                    RowBox[{
                    RowBox[{"Inv", "[", "gs2", "]"}], "[", 
                    
                    RowBox[{
                    "xAct`xConf`Private`i1$", ",", "xAct`xConf`Private`i2$"}],
                     "]"}]}]}, {" "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["[", FontColor -> RGBColor[0, 0, 1]], 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"R[\[Del]]", 
                    StyleBox[
                    
                    GridBox[{{"\!\(\!\(xAct`xConf`Private`i1$\+_\)\+_\)", 
                    "\!\(\!\(xAct`xConf`Private`i2$\+_\)\+_\)", 
                    "\!\(\!\(xAct`xConf`Private`i3$\+_\)\+_\)", 
                    "\!\(\!\(xAct`xConf`Private`i4$\+_\)\+_\)"}, {
                    " ", " ", " ", " "}}, RowSpacings -> 0, ColumnSpacings -> 
                    0.05, GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 
                    9]}}, ColumnSpacings -> 0.05, RowAlignments -> Center], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`RiemannCD[
                    PatternTest[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i3$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i4$, 
                    Blank[]], xAct`xTensor`UpIndexQ]], Editable -> False], 
                    StyleBox["]", FontColor -> RGBColor[0, 0, 1]]}], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`gs2][
                    $CellContext`RiemannCD[
                    PatternTest[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i3$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i4$, 
                    Blank[]], xAct`xTensor`UpIndexQ]]], Editable -> False], 
                    ":=", 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"R[\[Del]gs2]", 
                    StyleBox[
                    
                    GridBox[{{"xAct`xConf`Private`i1$", 
                    "xAct`xConf`Private`i2$", "xAct`xConf`Private`i3$", 
                    "xAct`xConf`Private`i4$"}, {" ", " ", " ", " "}}, 
                    RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 9]}}, 
                    ColumnSpacings -> 0.05, RowAlignments -> Center], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`RiemannCDgs2[
                    xAct`xConf`Private`i1$, xAct`xConf`Private`i2$, 
                    xAct`xConf`Private`i3$, xAct`xConf`Private`i4$], Editable -> 
                    False]}]}, {" "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["[", FontColor -> RGBColor[0, 0, 1]], 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"R[\[Del]]", 
                    StyleBox[
                    
                    GridBox[{{"\!\(xAct`xConf`Private`i1$\+_\)", 
                    "\!\(xAct`xConf`Private`i2$\+_\)", 
                    "\!\(xAct`xConf`Private`i3$\+_\)", 
                    "\!\(xAct`xConf`Private`i4$\+_\)"}, {" ", " ", " ", " "}},
                     RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 9]}}, 
                    ColumnSpacings -> 0.05, RowAlignments -> Center], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`RiemannCD[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], 
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], 
                    Pattern[xAct`xConf`Private`i3$, 
                    Blank[]], 
                    Pattern[xAct`xConf`Private`i4$, 
                    Blank[]]], Editable -> False], 
                    StyleBox["]", FontColor -> RGBColor[0, 0, 1]]}], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`gs2][
                    $CellContext`RiemannCD[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], 
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], 
                    Pattern[xAct`xConf`Private`i3$, 
                    Blank[]], 
                    Pattern[xAct`xConf`Private`i4$, 
                    Blank[]]]], Editable -> False], ":=", 
                    RowBox[{
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`s[], Editable -> False], 
                    RowBox[{
                    RowBox[{"xAct`xConf`Private`WeightOfIndicesList", "[", 
                    RowBox[{"{", 
                    
                    RowBox[{"xAct`xConf`Private`i1$", ",", 
                    "xAct`xConf`Private`i2$", ",", "xAct`xConf`Private`i3$", 
                    ",", "xAct`xConf`Private`i4$"}], "}"}], "]"}], "-", 
                    "2"}]], " ", 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"R[\[Del]gs2]", 
                    StyleBox[
                    
                    GridBox[{{"xAct`xConf`Private`i1$", 
                    "xAct`xConf`Private`i2$", "xAct`xConf`Private`i3$", 
                    "xAct`xConf`Private`i4$"}, {" ", " ", " ", " "}}, 
                    RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 9]}}, 
                    ColumnSpacings -> 0.05, RowAlignments -> Center], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`RiemannCDgs2[
                    xAct`xConf`Private`i1$, xAct`xConf`Private`i2$, 
                    xAct`xConf`Private`i3$, xAct`xConf`Private`i4$], Editable -> 
                    False]}]}]}, {" "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["[", FontColor -> RGBColor[0, 0, 1]], 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"R[\[Del]]", 
                    StyleBox[
                    
                    GridBox[{{"\!\(\!\(xAct`xConf`Private`i1$\+_\)\+_\)", 
                    "\!\(\!\(xAct`xConf`Private`i2$\+_\)\+_\)"}, {" ", " "}}, 
                    RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 9]}}, 
                    ColumnSpacings -> 0.05, RowAlignments -> Center], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`RicciCD[
                    PatternTest[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], xAct`xTensor`DownIndexQ]], Editable -> False], 
                    StyleBox["]", FontColor -> RGBColor[0, 0, 1]]}], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`gs2][
                    $CellContext`RicciCD[
                    PatternTest[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], xAct`xTensor`DownIndexQ]]], Editable -> False], 
                    ":=", 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"R[\[Del]gs2]", 
                    StyleBox[
                    
                    GridBox[{{"xAct`xConf`Private`i1$", 
                    "xAct`xConf`Private`i2$"}, {" ", " "}}, RowSpacings -> 0, 
                    ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 9]}}, 
                    ColumnSpacings -> 0.05, RowAlignments -> Center], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`RicciCDgs2[
                    xAct`xConf`Private`i1$, xAct`xConf`Private`i2$], Editable -> 
                    False]}]}, {" "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["[", FontColor -> RGBColor[0, 0, 1]], 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"R[\[Del]]", 
                    StyleBox[
                    
                    GridBox[{{"\!\(xAct`xConf`Private`i1$\+_\)", 
                    "\!\(xAct`xConf`Private`i2$\+_\)"}, {" ", " "}}, 
                    RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 9]}}, 
                    ColumnSpacings -> 0.05, RowAlignments -> Center], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`RicciCD[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], 
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]]], Editable -> False], 
                    StyleBox["]", FontColor -> RGBColor[0, 0, 1]]}], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`gs2][
                    $CellContext`RicciCD[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], 
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]]]], Editable -> False], ":=", 
                    RowBox[{
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`s[], Editable -> False], 
                    RowBox[{
                    RowBox[{"xAct`xConf`Private`WeightOfIndicesList", "[", 
                    RowBox[{"{", 
                    
                    RowBox[{"xAct`xConf`Private`i1$", ",", 
                    "xAct`xConf`Private`i2$"}], "}"}], "]"}], "-", "2"}]], 
                    " ", 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"R[\[Del]gs2]", 
                    StyleBox[
                    
                    GridBox[{{"xAct`xConf`Private`i1$", 
                    "xAct`xConf`Private`i2$"}, {" ", " "}}, RowSpacings -> 0, 
                    ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 9]}}, 
                    ColumnSpacings -> 0.05, RowAlignments -> Center], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`RicciCDgs2[
                    xAct`xConf`Private`i1$, xAct`xConf`Private`i2$], Editable -> 
                    False]}]}]}, {" "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"ConformalFrame[gs2]", "[", 
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    SuperscriptBox[
                    "\[Del]", "\!\(xAct`xConf`Private`i1$\+_\)"], 
                    "xAct`xConf`Private`ex$_"}], AutoSpacing -> False, 
                    ShowAutoStyles -> False], 
                    $CellContext`CD[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]]][
                    Pattern[xAct`xConf`Private`ex$, 
                    Blank[]]], Editable -> False], "]"}], AutoSpacing -> 
                    False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`gs2][
                    $CellContext`CD[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]]][
                    Pattern[xAct`xConf`Private`ex$, 
                    Blank[]]]], Editable -> False], ":=", 
                    RowBox[{
                    SuperscriptBox[
                    InterpretationBox[
                    StyleBox[
                    "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`s[], Editable -> False], 
                    RowBox[{
                    RowBox[{"xAct`xConf`Private`WeightOfIndicesList", "[", 
                    RowBox[{"{", "xAct`xConf`Private`i1$", "}"}], "]"}], "-", 
                    "1"}]], " ", 
                    RowBox[{"(", 
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    SuperscriptBox["\[Del]gs2", "xAct`xConf`Private`i1$"], 
                    "ConformalFrame[gs2]", "[", "xAct`xConf`Private`ex$", 
                    "]"}], AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`CDgs2[xAct`xConf`Private`i1$][
                    xAct`xConf`ConformalFrame[$CellContext`gs2][
                    xAct`xConf`Private`ex$]], Editable -> False], 
                    ")"}]}]}]}, {" "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["[", FontColor -> RGBColor[0, 0, 1]], 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"\[Epsilon]g", 
                    StyleBox[
                    
                    GridBox[{{"\!\(\!\(xAct`xConf`Private`inds$\+_\)\+_\)"}, {
                    " "}}, RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 9]}}, 
                    ColumnSpacings -> 0.05, RowAlignments -> Center], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`epsilong[
                    PatternTest[
                    Pattern[xAct`xConf`Private`inds$, 
                    BlankSequence[]], And[
                    xAct`xTensor`DownIndexQ[#]]& ]], Editable -> False], 
                    StyleBox["]", FontColor -> RGBColor[0, 0, 1]]}], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`gs2][
                    $CellContext`epsilong[
                    PatternTest[
                    Pattern[xAct`xConf`Private`inds$, 
                    BlankSequence[]], And[
                    xAct`xTensor`DownIndexQ[#]]& ]]], Editable -> False], 
                    ":=", 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"\[Epsilon][g\!\(s\^2\)]", 
                    StyleBox[
                    
                    GridBox[{{"xAct`xConf`Private`inds$"}, {" "}}, 
                    RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 9]}}, 
                    ColumnSpacings -> 0.05, RowAlignments -> Center], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`epsilongs2[xAct`xConf`Private`inds$], 
                    Editable -> False]}]}, {" "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["[", FontColor -> GrayLevel[0]], 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"[g\!\(s\^2\)]", 
                    StyleBox[
                    
                    GridBox[{{"\!\(\!\(xAct`xConf`Private`i1$\+_\)\+_\)", 
                    "\!\(\!\(xAct`xConf`Private`i2$\+_\)\+_\)"}, {" ", " "}}, 
                    RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 9]}}, 
                    ColumnSpacings -> 0.05, RowAlignments -> Center], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`gs2[
                    PatternTest[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], xAct`xTensor`DownIndexQ]], Editable -> False], 
                    StyleBox["]", FontColor -> GrayLevel[0]]}], AutoSpacing -> 
                    False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`g][
                    $CellContext`gs2[
                    PatternTest[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], xAct`xTensor`DownIndexQ]]], Editable -> False], 
                    ":=", 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"g", 
                    StyleBox[
                    
                    GridBox[{{"xAct`xConf`Private`i1$", 
                    "xAct`xConf`Private`i2$"}, {" ", " "}}, RowSpacings -> 0, 
                    ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 9]}}, 
                    ColumnSpacings -> 0.05, RowAlignments -> Center], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`g[
                    xAct`xConf`Private`i1$, xAct`xConf`Private`i2$], Editable -> 
                    False]}]}, {" "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["[", FontColor -> GrayLevel[0]], 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"i[g\!\(s\^2\)]", 
                    StyleBox[
                    
                    GridBox[{{"\!\(\!\(xAct`xConf`Private`i1$\+_\)\+_\)", 
                    "\!\(\!\(xAct`xConf`Private`i2$\+_\)\+_\)"}, {" ", " "}}, 
                    RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 9]}}, 
                    ColumnSpacings -> 0.05, RowAlignments -> Center], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`Invgs2[
                    PatternTest[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], xAct`xTensor`UpIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], xAct`xTensor`UpIndexQ]], Editable -> False], 
                    StyleBox["]", FontColor -> GrayLevel[0]]}], AutoSpacing -> 
                    False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`g][
                    $CellContext`Invgs2[
                    PatternTest[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], xAct`xTensor`UpIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], xAct`xTensor`UpIndexQ]]], Editable -> False], 
                    ":=", 
                    RowBox[{
                    RowBox[{"Inv", "[", "g", "]"}], "[", 
                    
                    RowBox[{
                    "xAct`xConf`Private`i1$", ",", "xAct`xConf`Private`i2$"}],
                     "]"}]}]}, {" "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["[", FontColor -> GrayLevel[0]], 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"R[\[Del]gs2]", 
                    StyleBox[
                    
                    GridBox[{{"\!\(\!\(xAct`xConf`Private`i1$\+_\)\+_\)", 
                    "\!\(\!\(xAct`xConf`Private`i2$\+_\)\+_\)", 
                    "\!\(\!\(xAct`xConf`Private`i3$\+_\)\+_\)", 
                    "\!\(\!\(xAct`xConf`Private`i4$\+_\)\+_\)"}, {
                    " ", " ", " ", " "}}, RowSpacings -> 0, ColumnSpacings -> 
                    0.05, GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 
                    9]}}, ColumnSpacings -> 0.05, RowAlignments -> Center], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`RiemannCDgs2[
                    PatternTest[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i3$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i4$, 
                    Blank[]], xAct`xTensor`UpIndexQ]], Editable -> False], 
                    StyleBox["]", FontColor -> GrayLevel[0]]}], AutoSpacing -> 
                    False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`g][
                    $CellContext`RiemannCDgs2[
                    PatternTest[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i3$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i4$, 
                    Blank[]], xAct`xTensor`UpIndexQ]]], Editable -> False], 
                    ":=", 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"R[\[Del]]", 
                    StyleBox[
                    
                    GridBox[{{"xAct`xConf`Private`i1$", 
                    "xAct`xConf`Private`i2$", "xAct`xConf`Private`i3$", 
                    "xAct`xConf`Private`i4$"}, {" ", " ", " ", " "}}, 
                    RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 9]}}, 
                    ColumnSpacings -> 0.05, RowAlignments -> Center], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`RiemannCD[
                    xAct`xConf`Private`i1$, xAct`xConf`Private`i2$, 
                    xAct`xConf`Private`i3$, xAct`xConf`Private`i4$], Editable -> 
                    False]}]}, {" "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["[", FontColor -> GrayLevel[0]], 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"R[\[Del]gs2]", 
                    StyleBox[
                    
                    GridBox[{{"\!\(xAct`xConf`Private`i1$\+_\)", 
                    "\!\(xAct`xConf`Private`i2$\+_\)", 
                    "\!\(xAct`xConf`Private`i3$\+_\)", 
                    "\!\(xAct`xConf`Private`i4$\+_\)"}, {" ", " ", " ", " "}},
                     RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 9]}}, 
                    ColumnSpacings -> 0.05, RowAlignments -> Center], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`RiemannCDgs2[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], 
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], 
                    Pattern[xAct`xConf`Private`i3$, 
                    Blank[]], 
                    Pattern[xAct`xConf`Private`i4$, 
                    Blank[]]], Editable -> False], 
                    StyleBox["]", FontColor -> GrayLevel[0]]}], AutoSpacing -> 
                    False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`g][
                    $CellContext`RiemannCDgs2[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], 
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], 
                    Pattern[xAct`xConf`Private`i3$, 
                    Blank[]], 
                    Pattern[xAct`xConf`Private`i4$, 
                    Blank[]]]], Editable -> False], ":=", 
                    RowBox[{
                    SuperscriptBox[
                    RowBox[{"(", 
                    FractionBox["1", 
                    InterpretationBox[
                    StyleBox[
                    "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`s[], Editable -> False]], ")"}], 
                    RowBox[{
                    RowBox[{"xAct`xConf`Private`WeightOfIndicesList", "[", 
                    RowBox[{"{", 
                    
                    RowBox[{"xAct`xConf`Private`i1$", ",", 
                    "xAct`xConf`Private`i2$", ",", "xAct`xConf`Private`i3$", 
                    ",", "xAct`xConf`Private`i4$"}], "}"}], "]"}], "-", 
                    "2"}]], " ", 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"R[\[Del]]", 
                    StyleBox[
                    
                    GridBox[{{"xAct`xConf`Private`i1$", 
                    "xAct`xConf`Private`i2$", "xAct`xConf`Private`i3$", 
                    "xAct`xConf`Private`i4$"}, {" ", " ", " ", " "}}, 
                    RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 9]}}, 
                    ColumnSpacings -> 0.05, RowAlignments -> Center], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`RiemannCD[
                    xAct`xConf`Private`i1$, xAct`xConf`Private`i2$, 
                    xAct`xConf`Private`i3$, xAct`xConf`Private`i4$], Editable -> 
                    False]}]}]}, {" "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["[", FontColor -> GrayLevel[0]], 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"R[\[Del]gs2]", 
                    StyleBox[
                    
                    GridBox[{{"\!\(\!\(xAct`xConf`Private`i1$\+_\)\+_\)", 
                    "\!\(\!\(xAct`xConf`Private`i2$\+_\)\+_\)"}, {" ", " "}}, 
                    RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 9]}}, 
                    ColumnSpacings -> 0.05, RowAlignments -> Center], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`RicciCDgs2[
                    PatternTest[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], xAct`xTensor`DownIndexQ]], Editable -> False], 
                    StyleBox["]", FontColor -> GrayLevel[0]]}], AutoSpacing -> 
                    False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`g][
                    $CellContext`RicciCDgs2[
                    PatternTest[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], xAct`xTensor`DownIndexQ]]], Editable -> False], 
                    ":=", 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"R[\[Del]]", 
                    StyleBox[
                    
                    GridBox[{{"xAct`xConf`Private`i1$", 
                    "xAct`xConf`Private`i2$"}, {" ", " "}}, RowSpacings -> 0, 
                    ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 9]}}, 
                    ColumnSpacings -> 0.05, RowAlignments -> Center], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`RicciCD[
                    xAct`xConf`Private`i1$, xAct`xConf`Private`i2$], Editable -> 
                    False]}]}, {" "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["[", FontColor -> GrayLevel[0]], 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"R[\[Del]gs2]", 
                    StyleBox[
                    
                    GridBox[{{"\!\(xAct`xConf`Private`i1$\+_\)", 
                    "\!\(xAct`xConf`Private`i2$\+_\)"}, {" ", " "}}, 
                    RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 9]}}, 
                    ColumnSpacings -> 0.05, RowAlignments -> Center], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`RicciCDgs2[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], 
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]]], Editable -> False], 
                    StyleBox["]", FontColor -> GrayLevel[0]]}], AutoSpacing -> 
                    False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`g][
                    $CellContext`RicciCDgs2[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], 
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]]]], Editable -> False], ":=", 
                    RowBox[{
                    SuperscriptBox[
                    RowBox[{"(", 
                    FractionBox["1", 
                    InterpretationBox[
                    StyleBox[
                    "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`s[], Editable -> False]], ")"}], 
                    RowBox[{
                    RowBox[{"xAct`xConf`Private`WeightOfIndicesList", "[", 
                    RowBox[{"{", 
                    
                    RowBox[{"xAct`xConf`Private`i1$", ",", 
                    "xAct`xConf`Private`i2$"}], "}"}], "]"}], "-", "2"}]], 
                    " ", 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"R[\[Del]]", 
                    StyleBox[
                    
                    GridBox[{{"xAct`xConf`Private`i1$", 
                    "xAct`xConf`Private`i2$"}, {" ", " "}}, RowSpacings -> 0, 
                    ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 9]}}, 
                    ColumnSpacings -> 0.05, RowAlignments -> Center], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`RicciCD[
                    xAct`xConf`Private`i1$, xAct`xConf`Private`i2$], Editable -> 
                    False]}]}]}, {" "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"ConformalFrame[g]", "[", 
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    SuperscriptBox[
                    "\[Del]gs2", "\!\(xAct`xConf`Private`i1$\+_\)"], 
                    "xAct`xConf`Private`ex$_"}], AutoSpacing -> False, 
                    ShowAutoStyles -> False], 
                    $CellContext`CDgs2[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]]][
                    Pattern[xAct`xConf`Private`ex$, 
                    Blank[]]], Editable -> False], "]"}], AutoSpacing -> 
                    False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`g][
                    $CellContext`CDgs2[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]]][
                    Pattern[xAct`xConf`Private`ex$, 
                    Blank[]]]], Editable -> False], ":=", 
                    RowBox[{
                    SuperscriptBox[
                    RowBox[{"(", 
                    FractionBox["1", 
                    InterpretationBox[
                    StyleBox[
                    "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`s[], Editable -> False]], ")"}], 
                    RowBox[{
                    RowBox[{"xAct`xConf`Private`WeightOfIndicesList", "[", 
                    RowBox[{"{", "xAct`xConf`Private`i1$", "}"}], "]"}], "-", 
                    "1"}]], " ", 
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    SuperscriptBox["\[Del]", "xAct`xConf`Private`i1$"], 
                    "ConformalFrame[g]", "[", "xAct`xConf`Private`ex$", "]"}],
                     AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`CD[xAct`xConf`Private`i1$][
                    xAct`xConf`ConformalFrame[$CellContext`g][
                    xAct`xConf`Private`ex$]], Editable -> False]}]}]}, {" "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["[", FontColor -> GrayLevel[0]], 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"\[Epsilon][g\!\(s\^2\)]", 
                    StyleBox[
                    
                    GridBox[{{"\!\(\!\(xAct`xConf`Private`inds$\+_\)\+_\)"}, {
                    " "}}, RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 9]}}, 
                    ColumnSpacings -> 0.05, RowAlignments -> Center], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`epsilongs2[
                    PatternTest[
                    Pattern[xAct`xConf`Private`inds$, 
                    BlankSequence[]], And[
                    xAct`xTensor`DownIndexQ[#]]& ]], Editable -> False], 
                    StyleBox["]", FontColor -> GrayLevel[0]]}], AutoSpacing -> 
                    False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`g][
                    $CellContext`epsilongs2[
                    PatternTest[
                    Pattern[xAct`xConf`Private`inds$, 
                    BlankSequence[]], And[
                    xAct`xTensor`DownIndexQ[#]]& ]]], Editable -> False], 
                    ":=", 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"\[Epsilon]g", 
                    StyleBox[
                    
                    GridBox[{{"xAct`xConf`Private`inds$"}, {" "}}, 
                    RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 9]}}, 
                    ColumnSpacings -> 0.05, RowAlignments -> Center], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`epsilong[xAct`xConf`Private`inds$], Editable -> 
                    False]}]}, {" "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["[", FontColor -> RGBColor[0, 0, 1]], 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"gS2", 
                    StyleBox[
                    
                    GridBox[{{"\!\(\!\(xAct`xConf`Private`i1$\+_\)\+_\)", 
                    "\!\(\!\(xAct`xConf`Private`i2$\+_\)\+_\)"}, {" ", " "}}, 
                    RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 9]}}, 
                    ColumnSpacings -> 0.05, RowAlignments -> Center], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`gS2[
                    PatternTest[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], xAct`xTensor`DownIndexQ]], Editable -> False], 
                    StyleBox["]", FontColor -> RGBColor[0, 0, 1]]}], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`gs2][
                    $CellContext`gS2[
                    PatternTest[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], xAct`xTensor`DownIndexQ]]], Editable -> False], 
                    ":=", 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"[g\!\(s\^2\)]", 
                    StyleBox[
                    
                    GridBox[{{"xAct`xConf`Private`i1$", 
                    "xAct`xConf`Private`i2$"}, {" ", " "}}, RowSpacings -> 0, 
                    ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 9]}}, 
                    ColumnSpacings -> 0.05, RowAlignments -> Center], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`gs2[
                    xAct`xConf`Private`i1$, xAct`xConf`Private`i2$], Editable -> 
                    False]}]}, {" "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["[", FontColor -> RGBColor[0, 0, 1]], 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"igS2", 
                    StyleBox[
                    
                    GridBox[{{"\!\(\!\(xAct`xConf`Private`i1$\+_\)\+_\)", 
                    "\!\(\!\(xAct`xConf`Private`i2$\+_\)\+_\)"}, {" ", " "}}, 
                    RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 9]}}, 
                    ColumnSpacings -> 0.05, RowAlignments -> Center], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`InvgS2[
                    PatternTest[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], xAct`xTensor`UpIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], xAct`xTensor`UpIndexQ]], Editable -> False], 
                    StyleBox["]", FontColor -> RGBColor[0, 0, 1]]}], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`gs2][
                    $CellContext`InvgS2[
                    PatternTest[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], xAct`xTensor`UpIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], xAct`xTensor`UpIndexQ]]], Editable -> False], 
                    ":=", 
                    RowBox[{
                    RowBox[{"Inv", "[", "gs2", "]"}], "[", 
                    
                    RowBox[{
                    "xAct`xConf`Private`i1$", ",", "xAct`xConf`Private`i2$"}],
                     "]"}]}]}, {" "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["[", FontColor -> RGBColor[0, 0, 1]], 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"R[\[Del]gS2]", 
                    StyleBox[
                    
                    GridBox[{{"\!\(\!\(xAct`xConf`Private`i1$\+_\)\+_\)", 
                    "\!\(\!\(xAct`xConf`Private`i2$\+_\)\+_\)", 
                    "\!\(\!\(xAct`xConf`Private`i3$\+_\)\+_\)", 
                    "\!\(\!\(xAct`xConf`Private`i4$\+_\)\+_\)"}, {
                    " ", " ", " ", " "}}, RowSpacings -> 0, ColumnSpacings -> 
                    0.05, GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 
                    9]}}, ColumnSpacings -> 0.05, RowAlignments -> Center], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`RiemannCDgS2[
                    PatternTest[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i3$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i4$, 
                    Blank[]], xAct`xTensor`UpIndexQ]], Editable -> False], 
                    StyleBox["]", FontColor -> RGBColor[0, 0, 1]]}], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`gs2][
                    $CellContext`RiemannCDgS2[
                    PatternTest[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i3$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i4$, 
                    Blank[]], xAct`xTensor`UpIndexQ]]], Editable -> False], 
                    ":=", 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"R[\[Del]gs2]", 
                    StyleBox[
                    
                    GridBox[{{"xAct`xConf`Private`i1$", 
                    "xAct`xConf`Private`i2$", "xAct`xConf`Private`i3$", 
                    "xAct`xConf`Private`i4$"}, {" ", " ", " ", " "}}, 
                    RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 9]}}, 
                    ColumnSpacings -> 0.05, RowAlignments -> Center], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`RiemannCDgs2[
                    xAct`xConf`Private`i1$, xAct`xConf`Private`i2$, 
                    xAct`xConf`Private`i3$, xAct`xConf`Private`i4$], Editable -> 
                    False]}]}, {" "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["[", FontColor -> RGBColor[0, 0, 1]], 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"R[\[Del]gS2]", 
                    StyleBox[
                    
                    GridBox[{{"\!\(xAct`xConf`Private`i1$\+_\)", 
                    "\!\(xAct`xConf`Private`i2$\+_\)", 
                    "\!\(xAct`xConf`Private`i3$\+_\)", 
                    "\!\(xAct`xConf`Private`i4$\+_\)"}, {" ", " ", " ", " "}},
                     RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 9]}}, 
                    ColumnSpacings -> 0.05, RowAlignments -> Center], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`RiemannCDgS2[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], 
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], 
                    Pattern[xAct`xConf`Private`i3$, 
                    Blank[]], 
                    Pattern[xAct`xConf`Private`i4$, 
                    Blank[]]], Editable -> False], 
                    StyleBox["]", FontColor -> RGBColor[0, 0, 1]]}], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`gs2][
                    $CellContext`RiemannCDgS2[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], 
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], 
                    Pattern[xAct`xConf`Private`i3$, 
                    Blank[]], 
                    Pattern[xAct`xConf`Private`i4$, 
                    Blank[]]]], Editable -> False], ":=", 
                    RowBox[{
                    SuperscriptBox[
                    RowBox[{"(", 
                    FractionBox[
                    InterpretationBox[
                    StyleBox[
                    "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`s[], Editable -> False], 
                    InterpretationBox[
                    StyleBox[
                    "S", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`S[], Editable -> False]], ")"}], 
                    RowBox[{
                    RowBox[{"xAct`xConf`Private`WeightOfIndicesList", "[", 
                    RowBox[{"{", 
                    
                    RowBox[{"xAct`xConf`Private`i1$", ",", 
                    "xAct`xConf`Private`i2$", ",", "xAct`xConf`Private`i3$", 
                    ",", "xAct`xConf`Private`i4$"}], "}"}], "]"}], "-", 
                    "2"}]], " ", 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"R[\[Del]gs2]", 
                    StyleBox[
                    
                    GridBox[{{"xAct`xConf`Private`i1$", 
                    "xAct`xConf`Private`i2$", "xAct`xConf`Private`i3$", 
                    "xAct`xConf`Private`i4$"}, {" ", " ", " ", " "}}, 
                    RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 9]}}, 
                    ColumnSpacings -> 0.05, RowAlignments -> Center], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`RiemannCDgs2[
                    xAct`xConf`Private`i1$, xAct`xConf`Private`i2$, 
                    xAct`xConf`Private`i3$, xAct`xConf`Private`i4$], Editable -> 
                    False]}]}]}, {" "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["[", FontColor -> RGBColor[0, 0, 1]], 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"R[\[Del]gS2]", 
                    StyleBox[
                    
                    GridBox[{{"\!\(\!\(xAct`xConf`Private`i1$\+_\)\+_\)", 
                    "\!\(\!\(xAct`xConf`Private`i2$\+_\)\+_\)"}, {" ", " "}}, 
                    RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 9]}}, 
                    ColumnSpacings -> 0.05, RowAlignments -> Center], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`RicciCDgS2[
                    PatternTest[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], xAct`xTensor`DownIndexQ]], Editable -> False], 
                    StyleBox["]", FontColor -> RGBColor[0, 0, 1]]}], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`gs2][
                    $CellContext`RicciCDgS2[
                    PatternTest[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], xAct`xTensor`DownIndexQ]]], Editable -> False], 
                    ":=", 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"R[\[Del]gs2]", 
                    StyleBox[
                    
                    GridBox[{{"xAct`xConf`Private`i1$", 
                    "xAct`xConf`Private`i2$"}, {" ", " "}}, RowSpacings -> 0, 
                    ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 9]}}, 
                    ColumnSpacings -> 0.05, RowAlignments -> Center], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`RicciCDgs2[
                    xAct`xConf`Private`i1$, xAct`xConf`Private`i2$], Editable -> 
                    False]}]}, {" "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["[", FontColor -> RGBColor[0, 0, 1]], 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"R[\[Del]gS2]", 
                    StyleBox[
                    
                    GridBox[{{"\!\(xAct`xConf`Private`i1$\+_\)", 
                    "\!\(xAct`xConf`Private`i2$\+_\)"}, {" ", " "}}, 
                    RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 9]}}, 
                    ColumnSpacings -> 0.05, RowAlignments -> Center], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`RicciCDgS2[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], 
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]]], Editable -> False], 
                    StyleBox["]", FontColor -> RGBColor[0, 0, 1]]}], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`gs2][
                    $CellContext`RicciCDgS2[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], 
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]]]], Editable -> False], ":=", 
                    RowBox[{
                    SuperscriptBox[
                    RowBox[{"(", 
                    FractionBox[
                    InterpretationBox[
                    StyleBox[
                    "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`s[], Editable -> False], 
                    InterpretationBox[
                    StyleBox[
                    "S", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`S[], Editable -> False]], ")"}], 
                    RowBox[{
                    RowBox[{"xAct`xConf`Private`WeightOfIndicesList", "[", 
                    RowBox[{"{", 
                    
                    RowBox[{"xAct`xConf`Private`i1$", ",", 
                    "xAct`xConf`Private`i2$"}], "}"}], "]"}], "-", "2"}]], 
                    " ", 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"R[\[Del]gs2]", 
                    StyleBox[
                    
                    GridBox[{{"xAct`xConf`Private`i1$", 
                    "xAct`xConf`Private`i2$"}, {" ", " "}}, RowSpacings -> 0, 
                    ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 9]}}, 
                    ColumnSpacings -> 0.05, RowAlignments -> Center], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`RicciCDgs2[
                    xAct`xConf`Private`i1$, xAct`xConf`Private`i2$], Editable -> 
                    False]}]}]}, {" "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"ConformalFrame[gs2]", "[", 
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    SuperscriptBox[
                    "\[Del]gS2", "\!\(xAct`xConf`Private`i1$\+_\)"], 
                    "xAct`xConf`Private`ex$_"}], AutoSpacing -> False, 
                    ShowAutoStyles -> False], 
                    $CellContext`CDgS2[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]]][
                    Pattern[xAct`xConf`Private`ex$, 
                    Blank[]]], Editable -> False], "]"}], AutoSpacing -> 
                    False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`gs2][
                    $CellContext`CDgS2[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]]][
                    Pattern[xAct`xConf`Private`ex$, 
                    Blank[]]]], Editable -> False], ":=", 
                    RowBox[{
                    SuperscriptBox[
                    RowBox[{"(", 
                    FractionBox[
                    InterpretationBox[
                    StyleBox[
                    "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`s[], Editable -> False], 
                    InterpretationBox[
                    StyleBox[
                    "S", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`S[], Editable -> False]], ")"}], 
                    RowBox[{
                    RowBox[{"xAct`xConf`Private`WeightOfIndicesList", "[", 
                    RowBox[{"{", "xAct`xConf`Private`i1$", "}"}], "]"}], "-", 
                    "1"}]], " ", 
                    RowBox[{"(", 
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    SuperscriptBox["\[Del]gs2", "xAct`xConf`Private`i1$"], 
                    "ConformalFrame[gs2]", "[", "xAct`xConf`Private`ex$", 
                    "]"}], AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`CDgs2[xAct`xConf`Private`i1$][
                    xAct`xConf`ConformalFrame[$CellContext`gs2][
                    xAct`xConf`Private`ex$]], Editable -> False], 
                    ")"}]}]}]}, {" "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["[", FontColor -> RGBColor[0, 0, 1]], 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"\[Epsilon]gS2", 
                    StyleBox[
                    
                    GridBox[{{"\!\(\!\(xAct`xConf`Private`inds$\+_\)\+_\)"}, {
                    " "}}, RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 9]}}, 
                    ColumnSpacings -> 0.05, RowAlignments -> Center], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`epsilongS2[
                    PatternTest[
                    Pattern[xAct`xConf`Private`inds$, 
                    BlankSequence[]], And[
                    xAct`xTensor`DownIndexQ[#]]& ]], Editable -> False], 
                    StyleBox["]", FontColor -> RGBColor[0, 0, 1]]}], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`gs2][
                    $CellContext`epsilongS2[
                    PatternTest[
                    Pattern[xAct`xConf`Private`inds$, 
                    BlankSequence[]], And[
                    xAct`xTensor`DownIndexQ[#]]& ]]], Editable -> False], 
                    ":=", 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"\[Epsilon][g\!\(s\^2\)]", 
                    StyleBox[
                    
                    GridBox[{{"xAct`xConf`Private`inds$"}, {" "}}, 
                    RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 9]}}, 
                    ColumnSpacings -> 0.05, RowAlignments -> Center], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`epsilongs2[xAct`xConf`Private`inds$], 
                    Editable -> False]}]}, {" "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["[", FontColor -> RGBColor[1, 0, 0]], 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"[g\!\(s\^2\)]", 
                    StyleBox[
                    
                    GridBox[{{"\!\(\!\(xAct`xConf`Private`i1$\+_\)\+_\)", 
                    "\!\(\!\(xAct`xConf`Private`i2$\+_\)\+_\)"}, {" ", " "}}, 
                    RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 9]}}, 
                    ColumnSpacings -> 0.05, RowAlignments -> Center], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`gs2[
                    PatternTest[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], xAct`xTensor`DownIndexQ]], Editable -> False], 
                    StyleBox["]", FontColor -> RGBColor[1, 0, 0]]}], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`gS2][
                    $CellContext`gs2[
                    PatternTest[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], xAct`xTensor`DownIndexQ]]], Editable -> False], 
                    ":=", 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"gS2", 
                    StyleBox[
                    
                    GridBox[{{"xAct`xConf`Private`i1$", 
                    "xAct`xConf`Private`i2$"}, {" ", " "}}, RowSpacings -> 0, 
                    ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 9]}}, 
                    ColumnSpacings -> 0.05, RowAlignments -> Center], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`gS2[
                    xAct`xConf`Private`i1$, xAct`xConf`Private`i2$], Editable -> 
                    False]}]}, {" "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["[", FontColor -> RGBColor[1, 0, 0]], 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"i[g\!\(s\^2\)]", 
                    StyleBox[
                    
                    GridBox[{{"\!\(\!\(xAct`xConf`Private`i1$\+_\)\+_\)", 
                    "\!\(\!\(xAct`xConf`Private`i2$\+_\)\+_\)"}, {" ", " "}}, 
                    RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 9]}}, 
                    ColumnSpacings -> 0.05, RowAlignments -> Center], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`Invgs2[
                    PatternTest[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], xAct`xTensor`UpIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], xAct`xTensor`UpIndexQ]], Editable -> False], 
                    StyleBox["]", FontColor -> RGBColor[1, 0, 0]]}], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`gS2][
                    $CellContext`Invgs2[
                    PatternTest[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], xAct`xTensor`UpIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], xAct`xTensor`UpIndexQ]]], Editable -> False], 
                    ":=", 
                    RowBox[{
                    RowBox[{"Inv", "[", "gS2", "]"}], "[", 
                    
                    RowBox[{
                    "xAct`xConf`Private`i1$", ",", "xAct`xConf`Private`i2$"}],
                     "]"}]}]}, {" "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["[", FontColor -> RGBColor[1, 0, 0]], 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"R[\[Del]gs2]", 
                    StyleBox[
                    
                    GridBox[{{"\!\(\!\(xAct`xConf`Private`i1$\+_\)\+_\)", 
                    "\!\(\!\(xAct`xConf`Private`i2$\+_\)\+_\)", 
                    "\!\(\!\(xAct`xConf`Private`i3$\+_\)\+_\)", 
                    "\!\(\!\(xAct`xConf`Private`i4$\+_\)\+_\)"}, {
                    " ", " ", " ", " "}}, RowSpacings -> 0, ColumnSpacings -> 
                    0.05, GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 
                    9]}}, ColumnSpacings -> 0.05, RowAlignments -> Center], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`RiemannCDgs2[
                    PatternTest[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i3$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i4$, 
                    Blank[]], xAct`xTensor`UpIndexQ]], Editable -> False], 
                    StyleBox["]", FontColor -> RGBColor[1, 0, 0]]}], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`gS2][
                    $CellContext`RiemannCDgs2[
                    PatternTest[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i3$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i4$, 
                    Blank[]], xAct`xTensor`UpIndexQ]]], Editable -> False], 
                    ":=", 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"R[\[Del]gS2]", 
                    StyleBox[
                    
                    GridBox[{{"xAct`xConf`Private`i1$", 
                    "xAct`xConf`Private`i2$", "xAct`xConf`Private`i3$", 
                    "xAct`xConf`Private`i4$"}, {" ", " ", " ", " "}}, 
                    RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 9]}}, 
                    ColumnSpacings -> 0.05, RowAlignments -> Center], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`RiemannCDgS2[
                    xAct`xConf`Private`i1$, xAct`xConf`Private`i2$, 
                    xAct`xConf`Private`i3$, xAct`xConf`Private`i4$], Editable -> 
                    False]}]}, {" "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["[", FontColor -> RGBColor[1, 0, 0]], 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"R[\[Del]gs2]", 
                    StyleBox[
                    
                    GridBox[{{"\!\(xAct`xConf`Private`i1$\+_\)", 
                    "\!\(xAct`xConf`Private`i2$\+_\)", 
                    "\!\(xAct`xConf`Private`i3$\+_\)", 
                    "\!\(xAct`xConf`Private`i4$\+_\)"}, {" ", " ", " ", " "}},
                     RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 9]}}, 
                    ColumnSpacings -> 0.05, RowAlignments -> Center], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`RiemannCDgs2[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], 
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], 
                    Pattern[xAct`xConf`Private`i3$, 
                    Blank[]], 
                    Pattern[xAct`xConf`Private`i4$, 
                    Blank[]]], Editable -> False], 
                    StyleBox["]", FontColor -> RGBColor[1, 0, 0]]}], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`gS2][
                    $CellContext`RiemannCDgs2[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], 
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], 
                    Pattern[xAct`xConf`Private`i3$, 
                    Blank[]], 
                    Pattern[xAct`xConf`Private`i4$, 
                    Blank[]]]], Editable -> False], ":=", 
                    RowBox[{
                    SuperscriptBox[
                    RowBox[{"(", 
                    FractionBox[
                    InterpretationBox[
                    StyleBox[
                    "S", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`S[], Editable -> False], 
                    InterpretationBox[
                    StyleBox[
                    "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`s[], Editable -> False]], ")"}], 
                    RowBox[{
                    RowBox[{"xAct`xConf`Private`WeightOfIndicesList", "[", 
                    RowBox[{"{", 
                    
                    RowBox[{"xAct`xConf`Private`i1$", ",", 
                    "xAct`xConf`Private`i2$", ",", "xAct`xConf`Private`i3$", 
                    ",", "xAct`xConf`Private`i4$"}], "}"}], "]"}], "-", 
                    "2"}]], " ", 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"R[\[Del]gS2]", 
                    StyleBox[
                    
                    GridBox[{{"xAct`xConf`Private`i1$", 
                    "xAct`xConf`Private`i2$", "xAct`xConf`Private`i3$", 
                    "xAct`xConf`Private`i4$"}, {" ", " ", " ", " "}}, 
                    RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 9]}}, 
                    ColumnSpacings -> 0.05, RowAlignments -> Center], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`RiemannCDgS2[
                    xAct`xConf`Private`i1$, xAct`xConf`Private`i2$, 
                    xAct`xConf`Private`i3$, xAct`xConf`Private`i4$], Editable -> 
                    False]}]}]}, {" "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["[", FontColor -> RGBColor[1, 0, 0]], 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"R[\[Del]gs2]", 
                    StyleBox[
                    
                    GridBox[{{"\!\(\!\(xAct`xConf`Private`i1$\+_\)\+_\)", 
                    "\!\(\!\(xAct`xConf`Private`i2$\+_\)\+_\)"}, {" ", " "}}, 
                    RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 9]}}, 
                    ColumnSpacings -> 0.05, RowAlignments -> Center], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`RicciCDgs2[
                    PatternTest[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], xAct`xTensor`DownIndexQ]], Editable -> False], 
                    StyleBox["]", FontColor -> RGBColor[1, 0, 0]]}], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`gS2][
                    $CellContext`RicciCDgs2[
                    PatternTest[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], xAct`xTensor`DownIndexQ], 
                    PatternTest[
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]], xAct`xTensor`DownIndexQ]]], Editable -> False], 
                    ":=", 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"R[\[Del]gS2]", 
                    StyleBox[
                    
                    GridBox[{{"xAct`xConf`Private`i1$", 
                    "xAct`xConf`Private`i2$"}, {" ", " "}}, RowSpacings -> 0, 
                    ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 9]}}, 
                    ColumnSpacings -> 0.05, RowAlignments -> Center], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`RicciCDgS2[
                    xAct`xConf`Private`i1$, xAct`xConf`Private`i2$], Editable -> 
                    False]}]}, {" "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["[", FontColor -> RGBColor[1, 0, 0]], 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"R[\[Del]gs2]", 
                    StyleBox[
                    
                    GridBox[{{"\!\(xAct`xConf`Private`i1$\+_\)", 
                    "\!\(xAct`xConf`Private`i2$\+_\)"}, {" ", " "}}, 
                    RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 9]}}, 
                    ColumnSpacings -> 0.05, RowAlignments -> Center], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`RicciCDgs2[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], 
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]]], Editable -> False], 
                    StyleBox["]", FontColor -> RGBColor[1, 0, 0]]}], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`gS2][
                    $CellContext`RicciCDgs2[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]], 
                    Pattern[xAct`xConf`Private`i2$, 
                    Blank[]]]], Editable -> False], ":=", 
                    RowBox[{
                    SuperscriptBox[
                    RowBox[{"(", 
                    FractionBox[
                    InterpretationBox[
                    StyleBox[
                    "S", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`S[], Editable -> False], 
                    InterpretationBox[
                    StyleBox[
                    "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`s[], Editable -> False]], ")"}], 
                    RowBox[{
                    RowBox[{"xAct`xConf`Private`WeightOfIndicesList", "[", 
                    RowBox[{"{", 
                    
                    RowBox[{"xAct`xConf`Private`i1$", ",", 
                    "xAct`xConf`Private`i2$"}], "}"}], "]"}], "-", "2"}]], 
                    " ", 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"R[\[Del]gS2]", 
                    StyleBox[
                    
                    GridBox[{{"xAct`xConf`Private`i1$", 
                    "xAct`xConf`Private`i2$"}, {" ", " "}}, RowSpacings -> 0, 
                    ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 9]}}, 
                    ColumnSpacings -> 0.05, RowAlignments -> Center], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`RicciCDgS2[
                    xAct`xConf`Private`i1$, xAct`xConf`Private`i2$], Editable -> 
                    False]}]}]}, {" "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"ConformalFrame[gS2]", "[", 
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    SuperscriptBox[
                    "\[Del]gs2", "\!\(xAct`xConf`Private`i1$\+_\)"], 
                    "xAct`xConf`Private`ex$_"}], AutoSpacing -> False, 
                    ShowAutoStyles -> False], 
                    $CellContext`CDgs2[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]]][
                    Pattern[xAct`xConf`Private`ex$, 
                    Blank[]]], Editable -> False], "]"}], AutoSpacing -> 
                    False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`gS2][
                    $CellContext`CDgs2[
                    Pattern[xAct`xConf`Private`i1$, 
                    Blank[]]][
                    Pattern[xAct`xConf`Private`ex$, 
                    Blank[]]]], Editable -> False], ":=", 
                    RowBox[{
                    SuperscriptBox[
                    RowBox[{"(", 
                    FractionBox[
                    InterpretationBox[
                    StyleBox[
                    "S", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`S[], Editable -> False], 
                    InterpretationBox[
                    StyleBox[
                    "s", AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`s[], Editable -> False]], ")"}], 
                    RowBox[{
                    RowBox[{"xAct`xConf`Private`WeightOfIndicesList", "[", 
                    RowBox[{"{", "xAct`xConf`Private`i1$", "}"}], "]"}], "-", 
                    "1"}]], " ", 
                    RowBox[{"(", 
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    SuperscriptBox["\[Del]gS2", "xAct`xConf`Private`i1$"], 
                    "ConformalFrame[gS2]", "[", "xAct`xConf`Private`ex$", 
                    "]"}], AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`CDgS2[xAct`xConf`Private`i1$][
                    xAct`xConf`ConformalFrame[$CellContext`gS2][
                    xAct`xConf`Private`ex$]], Editable -> False], 
                    ")"}]}]}]}, {" "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    StyleBox["[", FontColor -> RGBColor[1, 0, 0]], 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"\[Epsilon][g\!\(s\^2\)]", 
                    StyleBox[
                    
                    GridBox[{{"\!\(\!\(xAct`xConf`Private`inds$\+_\)\+_\)"}, {
                    " "}}, RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 9]}}, 
                    ColumnSpacings -> 0.05, RowAlignments -> Center], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`epsilongs2[
                    PatternTest[
                    Pattern[xAct`xConf`Private`inds$, 
                    BlankSequence[]], And[
                    xAct`xTensor`DownIndexQ[#]]& ]], Editable -> False], 
                    StyleBox["]", FontColor -> RGBColor[1, 0, 0]]}], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    xAct`xConf`ConformalFrame[$CellContext`gS2][
                    $CellContext`epsilongs2[
                    PatternTest[
                    Pattern[xAct`xConf`Private`inds$, 
                    BlankSequence[]], And[
                    xAct`xTensor`DownIndexQ[#]]& ]]], Editable -> False], 
                    ":=", 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"\[Epsilon]gS2", 
                    StyleBox[
                    
                    GridBox[{{"xAct`xConf`Private`inds$"}, {" "}}, 
                    RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 9]}}, 
                    ColumnSpacings -> 0.05, RowAlignments -> Center], 
                    AutoSpacing -> False, ShowAutoStyles -> False], 
                    $CellContext`epsilongS2[xAct`xConf`Private`inds$], 
                    Editable -> False]}]}, {" "}}, 
                  GridBoxAlignment -> {"Columns" -> {{Left}}}, 
                  DefaultBaseStyle -> "Column", 
                  GridBoxItemSize -> {
                   "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}]},
                "RowDefault"]}
             },
             DefaultBaseStyle->"Column",
             GridBoxAlignment->{"Columns" -> {{Left}}},
             
             GridBoxItemSize->{
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
            "Column"],
           FrameMargins->{{6, 0}, {3, 6}}], "\<\"\"\>"},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"xAct`xConf`ConformalFrame\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->{{6, 6}, {6, 3}}], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox[
             TagBox[
              TooltipBox[
               StyleBox["\<\" Symbol\"\>", "InformationRowLabel",
                StripOnInput->False],
               "\"Symbol\"",
               TooltipStyle->"TextStyling"],
              Annotation[#, "Symbol", "Tooltip"]& ], "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"Formal scalar head ConformalFrame[metric][expr] \
which indicates that expr (which must be of the form tens[inds]) is in fact \
the transformation of that quantity from the ambient frame to the frame \
associated with metric. Hence if metric is the first metric \
ConformalFrame[firstmetric][expr] = expr. \"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"],
               ImageSizeCache->{10., {3., 7.}}], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"],
               ImageSizeCache->{10., {3., 7.}}]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[<|
   "ObjectType" -> "Symbol", "Usage" -> 
    "Formal scalar head ConformalFrame[metric][expr] which indicates that \
expr (which must be of the form tens[inds]) is in fact the transformation of \
that quantity from the ambient frame to the frame associated with metric. \
Hence if metric is the first metric ConformalFrame[firstmetric][expr] = expr. \
", "Documentation" -> None, "OwnValues" -> None, "UpValues" -> 
    Information`InformationValueForm[
     UpValues, xAct`xConf`ConformalFrame, {xAct`xTensor`ContractThroughQ[
         xAct`xConf`ConformalFrame[$CellContext`g], xAct`xTensor`delta] -> 
       True, xAct`xTensor`ContractThroughQ[
         xAct`xConf`ConformalFrame[$CellContext`gs2], xAct`xTensor`delta] -> 
       True, xAct`xTensor`ContractThroughQ[
         xAct`xConf`ConformalFrame[$CellContext`gS2], xAct`xTensor`delta] -> 
       True, xAct`xTensor`DefInfo[
         xAct`xConf`ConformalFrame[$CellContext`g]] -> {"inert head", ""}, 
       xAct`xTensor`DefInfo[
         xAct`xConf`ConformalFrame[$CellContext`gs2]] -> {"inert head", ""}, 
       xAct`xTensor`DefInfo[
         xAct`xConf`ConformalFrame[$CellContext`gS2]] -> {"inert head", ""}, 
       xAct`xTensor`InertHeadQ[
         xAct`xConf`ConformalFrame[$CellContext`g]] -> True, 
       xAct`xTensor`InertHeadQ[
         xAct`xConf`ConformalFrame[$CellContext`gs2]] -> True, 
       xAct`xTensor`InertHeadQ[
         xAct`xConf`ConformalFrame[$CellContext`gS2]] -> True, 
       xAct`xTensor`LinearQ[
         xAct`xConf`ConformalFrame[$CellContext`g]] -> False, 
       xAct`xTensor`LinearQ[
         xAct`xConf`ConformalFrame[$CellContext`gs2]] -> False, 
       xAct`xTensor`LinearQ[
         xAct`xConf`ConformalFrame[$CellContext`gS2]] -> False, 
       xAct`xTensor`PrintAs[
         xAct`xConf`ConformalFrame[$CellContext`g]] -> "ConformalFrame[g]", 
       xAct`xTensor`PrintAs[
         xAct`xConf`ConformalFrame[$CellContext`gs2]] -> 
       "ConformalFrame[gs2]", xAct`xTensor`PrintAs[
         xAct`xConf`ConformalFrame[$CellContext`gS2]] -> 
       "ConformalFrame[gS2]"}], "DownValues" -> None, "SubValues" -> 
    Information`InformationValueForm[
     SubValues, xAct`xConf`ConformalFrame, {
      xAct`xConf`ConformalFrame[$CellContext`g][
         $CellContext`Detgs2[]] :> $CellContext`Detg[], 
       xAct`xConf`ConformalFrame[$CellContext`g][
         $CellContext`DetgS2[]] :> $CellContext`Detg[], 
       xAct`xConf`ConformalFrame[$CellContext`g][
         $CellContext`RicciScalarCDgs2[]] :> $CellContext`RicciScalarCD[], 
       xAct`xConf`ConformalFrame[$CellContext`g][
         $CellContext`RicciScalarCDgS2[]] :> $CellContext`RicciScalarCD[], 
       xAct`xConf`ConformalFrame[$CellContext`gs2][
         $CellContext`Detg[]] :> $CellContext`Detgs2[], 
       xAct`xConf`ConformalFrame[$CellContext`gs2][
         $CellContext`DetgS2[]] :> $CellContext`Detgs2[], 
       xAct`xConf`ConformalFrame[$CellContext`gs2][
         $CellContext`RicciScalarCD[]] :> $CellContext`RicciScalarCDgs2[], 
       xAct`xConf`ConformalFrame[$CellContext`gs2][
         $CellContext`RicciScalarCDgS2[]] :> $CellContext`RicciScalarCDgs2[], 
       xAct`xConf`ConformalFrame[$CellContext`gS2][
         $CellContext`Detg[]] :> $CellContext`DetgS2[], 
       xAct`xConf`ConformalFrame[$CellContext`gS2][
         $CellContext`Detgs2[]] :> $CellContext`DetgS2[], 
       xAct`xConf`ConformalFrame[$CellContext`gS2][
         $CellContext`RicciScalarCD[]] :> $CellContext`RicciScalarCDgS2[], 
       xAct`xConf`ConformalFrame[$CellContext`gS2][
         $CellContext`RicciScalarCDgs2[]] :> $CellContext`RicciScalarCDgS2[], 
       xAct`xConf`ConformalFrame[
         Blank[]][
         xAct`xTensor`delta[
          Pattern[xAct`xConf`Private`\[Mu], 
           Blank[]], 
          Pattern[xAct`xConf`Private`\[Nu], 
           Blank[]]]] :> 
       xAct`xTensor`delta[xAct`xConf`Private`\[Mu], xAct`xConf`Private`\[Nu]],
        xAct`xConf`ConformalFrame[
         PatternTest[
          Pattern[xAct`xConf`Private`g1, 
           Blank[]], xAct`xTensor`MetricQ]][
         Alternatives[
          Pattern[xAct`xConf`Private`val, 
           Blank[Real]], 
          Pattern[xAct`xConf`Private`val, 
           Blank[Complex]], 
          Pattern[xAct`xConf`Private`val, 
           Blank[Rational]], 
          Pattern[xAct`xConf`Private`val, 
           Blank[Integer]]]] :> xAct`xConf`Private`val, 
       xAct`xConf`ConformalFrame[
         PatternTest[
          Pattern[xAct`xConf`Private`g1, 
           Blank[]], xAct`xTensor`MetricQ]][
         PatternTest[
          Pattern[xAct`xConf`Private`val, 
           Blank[]], xAct`xTensor`ConstantSymbolQ]] :> xAct`xConf`Private`val,
        xAct`xConf`ConformalFrame[
         PatternTest[
          Pattern[xAct`xConf`Private`g1, 
           Blank[]], xAct`xTensor`MetricQ]][PatternTest[
           Pattern[xAct`xConf`Private`S, 
            Blank[]], xAct`xTensor`ScalarQ]^Pattern[xAct`xConf`Private`n, 
           Blank[Integer]]] :> 
       xAct`xConf`ConformalFrame[xAct`xConf`Private`g1][xAct`xConf`Private`S]^
        xAct`xConf`Private`n, xAct`xConf`ConformalFrame[
         PatternTest[
          Pattern[xAct`xConf`Private`g1, 
           Blank[]], xAct`xTensor`MetricQ]][
         Pattern[xAct`xConf`Private`product, 
          Blank[Times]]] :> 
       Map[xAct`xConf`ConformalFrame[xAct`xConf`Private`g1][#]& , 
         xAct`xConf`Private`product], xAct`xConf`ConformalFrame[
         PatternTest[
          Pattern[xAct`xConf`Private`g1, 
           Blank[]], xAct`xTensor`MetricQ]][
         Pattern[xAct`xConf`Private`sum, 
          Blank[Plus]]] :> 
       Map[xAct`xConf`ConformalFrame[xAct`xConf`Private`g1][#]& , 
         xAct`xConf`Private`sum], xAct`xConf`ConformalFrame[
         PatternTest[
          Pattern[xAct`xConf`Private`g1, 
           Blank[]], xAct`xTensor`MetricQ]][
         xAct`xTensor`Scalar[
          Pattern[xAct`xConf`Private`expr, 
           Blank[]]]] :> xAct`xTensor`Scalar[
         xAct`xConf`ConformalFrame[xAct`xConf`Private`g1][
         xAct`xConf`Private`expr]], xAct`xConf`ConformalFrame[
         PatternTest[
          Pattern[xAct`xConf`Private`g1, 
           Blank[]], xAct`xTensor`MetricQ]][
         PatternTest[
          Pattern[xAct`xConf`Private`f, 
           Blank[]], xAct`xTensor`ScalarFunctionQ][
          Pattern[xAct`xConf`Private`expr, 
           Blank[]]]] :> xAct`xConf`Private`f[
         xAct`xConf`ConformalFrame[xAct`xConf`Private`g1][
         xAct`xConf`Private`expr]], xAct`xConf`ConformalFrame[
         PatternTest[
          Pattern[xAct`xConf`Private`g1, 
           Blank[]], xAct`xTensor`MetricQ]][
         PatternTest[
          Pattern[xAct`xConf`Private`S, 
           Blank[]], xAct`xTensor`ScalarQ][]] :> Condition[
         xAct`xConf`Private`S[], 
         xAct`xConf`ConformalWeight[xAct`xConf`Private`S] === 0], 
       xAct`xConf`ConformalFrame[
         PatternTest[
          Pattern[xAct`xConf`Private`g1, 
           Blank[]], xAct`xTensor`MetricQ]][
         xAct`xConf`ConformalFrame[
          PatternTest[
           Pattern[xAct`xConf`Private`g2, 
            Blank[]], xAct`xTensor`MetricQ]][
          Pattern[xAct`xConf`Private`expr, 
           Blank[]]]] :> 
       xAct`xConf`ConformalFrame[xAct`xConf`Private`g1][
        xAct`xConf`Private`expr], xAct`xConf`ConformalFrame[
         Blank[]][
         $CellContext`S[]] :> $CellContext`S[], 
       xAct`xConf`ConformalFrame[$CellContext`gS2][
         $CellContext`g[
          PatternTest[
           Pattern[xAct`xConf`Private`i1$, 
            Blank[]], xAct`xTensor`DownIndexQ], 
          PatternTest[
           Pattern[xAct`xConf`Private`i2$, 
            Blank[]], xAct`xTensor`DownIndexQ]]] :> $CellContext`gS2[
        xAct`xConf`Private`i1$, xAct`xConf`Private`i2$], 
       xAct`xConf`ConformalFrame[$CellContext`gS2][
         $CellContext`g[
          PatternTest[
           Pattern[xAct`xConf`Private`i1$, 
            Blank[]], xAct`xTensor`UpIndexQ], 
          PatternTest[
           Pattern[xAct`xConf`Private`i2$, 
            Blank[]], xAct`xTensor`UpIndexQ]]] :> 
       xAct`xTensor`Inv[$CellContext`gS2][
        xAct`xConf`Private`i1$, xAct`xConf`Private`i2$], 
       xAct`xConf`ConformalFrame[$CellContext`gS2][
         $CellContext`RiemannCD[
          PatternTest[
           Pattern[xAct`xConf`Private`i1$, 
            Blank[]], xAct`xTensor`DownIndexQ], 
          PatternTest[
           Pattern[xAct`xConf`Private`i2$, 
            Blank[]], xAct`xTensor`DownIndexQ], 
          PatternTest[
           Pattern[xAct`xConf`Private`i3$, 
            Blank[]], xAct`xTensor`DownIndexQ], 
          PatternTest[
           Pattern[xAct`xConf`Private`i4$, 
            Blank[]], xAct`xTensor`UpIndexQ]]] :> $CellContext`RiemannCDgS2[
        xAct`xConf`Private`i1$, xAct`xConf`Private`i2$, 
         xAct`xConf`Private`i3$, xAct`xConf`Private`i4$], 
       xAct`xConf`ConformalFrame[$CellContext`gS2][
         $CellContext`RiemannCD[
          Pattern[xAct`xConf`Private`i1$, 
           Blank[]], 
          Pattern[xAct`xConf`Private`i2$, 
           Blank[]], 
          Pattern[xAct`xConf`Private`i3$, 
           Blank[]], 
          Pattern[xAct`xConf`Private`i4$, 
           Blank[]]]] :> $CellContext`S[]^(
          xAct`xConf`Private`WeightOfIndicesList[{
            xAct`xConf`Private`i1$, xAct`xConf`Private`i2$, 
             xAct`xConf`Private`i3$, xAct`xConf`Private`i4$}] - 
          2) $CellContext`RiemannCDgS2[
         xAct`xConf`Private`i1$, xAct`xConf`Private`i2$, 
          xAct`xConf`Private`i3$, xAct`xConf`Private`i4$], 
       xAct`xConf`ConformalFrame[$CellContext`gS2][
         $CellContext`RicciCD[
          PatternTest[
           Pattern[xAct`xConf`Private`i1$, 
            Blank[]], xAct`xTensor`DownIndexQ], 
          PatternTest[
           Pattern[xAct`xConf`Private`i2$, 
            Blank[]], xAct`xTensor`DownIndexQ]]] :> $CellContext`RicciCDgS2[
        xAct`xConf`Private`i1$, xAct`xConf`Private`i2$], 
       xAct`xConf`ConformalFrame[$CellContext`gS2][
         $CellContext`RicciCD[
          Pattern[xAct`xConf`Private`i1$, 
           Blank[]], 
          Pattern[xAct`xConf`Private`i2$, 
           Blank[]]]] :> $CellContext`S[]^(
          xAct`xConf`Private`WeightOfIndicesList[{
            xAct`xConf`Private`i1$, xAct`xConf`Private`i2$}] - 
          2) $CellContext`RicciCDgS2[
         xAct`xConf`Private`i1$, xAct`xConf`Private`i2$], 
       xAct`xConf`ConformalFrame[$CellContext`gS2][
         $CellContext`CD[
          Pattern[xAct`xConf`Private`i1$, 
           Blank[]]][
          Pattern[xAct`xConf`Private`ex$, 
           Blank[]]]] :> $CellContext`S[]^(
          xAct`xConf`Private`WeightOfIndicesList[{xAct`xConf`Private`i1$}] - 
          1) $CellContext`CDgS2[xAct`xConf`Private`i1$][
          xAct`xConf`ConformalFrame[$CellContext`gS2][
          xAct`xConf`Private`ex$]], 
       xAct`xConf`ConformalFrame[$CellContext`gS2][
         $CellContext`epsilong[
          PatternTest[
           Pattern[xAct`xConf`Private`inds$, 
            BlankSequence[]], And[
            xAct`xTensor`DownIndexQ[#]]& ]]] :> $CellContext`epsilongS2[
        xAct`xConf`Private`inds$], xAct`xConf`ConformalFrame[$CellContext`g][
         $CellContext`gS2[
          PatternTest[
           Pattern[xAct`xConf`Private`i1$, 
            Blank[]], xAct`xTensor`DownIndexQ], 
          PatternTest[
           Pattern[xAct`xConf`Private`i2$, 
            Blank[]], xAct`xTensor`DownIndexQ]]] :> $CellContext`g[
        xAct`xConf`Private`i1$, xAct`xConf`Private`i2$], 
       xAct`xConf`ConformalFrame[$CellContext`g][
         $CellContext`InvgS2[
          PatternTest[
           Pattern[xAct`xConf`Private`i1$, 
            Blank[]], xAct`xTensor`UpIndexQ], 
          PatternTest[
           Pattern[xAct`xConf`Private`i2$, 
            Blank[]], xAct`xTensor`UpIndexQ]]] :> 
       xAct`xTensor`Inv[$CellContext`g][
        xAct`xConf`Private`i1$, xAct`xConf`Private`i2$], 
       xAct`xConf`ConformalFrame[$CellContext`g][
         $CellContext`RiemannCDgS2[
          PatternTest[
           Pattern[xAct`xConf`Private`i1$, 
            Blank[]], xAct`xTensor`DownIndexQ], 
          PatternTest[
           Pattern[xAct`xConf`Private`i2$, 
            Blank[]], xAct`xTensor`DownIndexQ], 
          PatternTest[
           Pattern[xAct`xConf`Private`i3$, 
            Blank[]], xAct`xTensor`DownIndexQ], 
          PatternTest[
           Pattern[xAct`xConf`Private`i4$, 
            Blank[]], xAct`xTensor`UpIndexQ]]] :> $CellContext`RiemannCD[
        xAct`xConf`Private`i1$, xAct`xConf`Private`i2$, 
         xAct`xConf`Private`i3$, xAct`xConf`Private`i4$], 
       xAct`xConf`ConformalFrame[$CellContext`g][
         $CellContext`RiemannCDgS2[
          Pattern[xAct`xConf`Private`i1$, 
           Blank[]], 
          Pattern[xAct`xConf`Private`i2$, 
           Blank[]], 
          Pattern[xAct`xConf`Private`i3$, 
           Blank[]], 
          Pattern[xAct`xConf`Private`i4$, 
           Blank[]]]] :> ($CellContext`S[]^(-1))^(
          xAct`xConf`Private`WeightOfIndicesList[{
            xAct`xConf`Private`i1$, xAct`xConf`Private`i2$, 
             xAct`xConf`Private`i3$, xAct`xConf`Private`i4$}] - 
          2) $CellContext`RiemannCD[
         xAct`xConf`Private`i1$, xAct`xConf`Private`i2$, 
          xAct`xConf`Private`i3$, xAct`xConf`Private`i4$], 
       xAct`xConf`ConformalFrame[$CellContext`g][
         $CellContext`RicciCDgS2[
          PatternTest[
           Pattern[xAct`xConf`Private`i1$, 
            Blank[]], xAct`xTensor`DownIndexQ], 
          PatternTest[
           Pattern[xAct`xConf`Private`i2$, 
            Blank[]], xAct`xTensor`DownIndexQ]]] :> $CellContext`RicciCD[
        xAct`xConf`Private`i1$, xAct`xConf`Private`i2$], 
       xAct`xConf`ConformalFrame[$CellContext`g][
         $CellContext`RicciCDgS2[
          Pattern[xAct`xConf`Private`i1$, 
           Blank[]], 
          Pattern[xAct`xConf`Private`i2$, 
           Blank[]]]] :> ($CellContext`S[]^(-1))^(
          xAct`xConf`Private`WeightOfIndicesList[{
            xAct`xConf`Private`i1$, xAct`xConf`Private`i2$}] - 
          2) $CellContext`RicciCD[
         xAct`xConf`Private`i1$, xAct`xConf`Private`i2$], 
       xAct`xConf`ConformalFrame[$CellContext`g][
         $CellContext`CDgS2[
          Pattern[xAct`xConf`Private`i1$, 
           Blank[]]][
          Pattern[xAct`xConf`Private`ex$, 
           Blank[]]]] :> ($CellContext`S[]^(-1))^(
          xAct`xConf`Private`WeightOfIndicesList[{xAct`xConf`Private`i1$}] - 
          1) $CellContext`CD[xAct`xConf`Private`i1$][
          xAct`xConf`ConformalFrame[$CellContext`g][xAct`xConf`Private`ex$]], 
       xAct`xConf`ConformalFrame[$CellContext`g][
         $CellContext`epsilongS2[
          PatternTest[
           Pattern[xAct`xConf`Private`inds$, 
            BlankSequence[]], And[
            xAct`xTensor`DownIndexQ[#]]& ]]] :> $CellContext`epsilong[
        xAct`xConf`Private`inds$], xAct`xConf`ConformalFrame[
         Blank[]][
         $CellContext`s[]] :> $CellContext`s[], 
       xAct`xConf`ConformalFrame[$CellContext`gs2][
         $CellContext`g[
          PatternTest[
           Pattern[xAct`xConf`Private`i1$, 
            Blank[]], xAct`xTensor`DownIndexQ], 
          PatternTest[
           Pattern[xAct`xConf`Private`i2$, 
            Blank[]], xAct`xTensor`DownIndexQ]]] :> $CellContext`gs2[
        xAct`xConf`Private`i1$, xAct`xConf`Private`i2$], 
       xAct`xConf`ConformalFrame[$CellContext`gs2][
         $CellContext`g[
          PatternTest[
           Pattern[xAct`xConf`Private`i1$, 
            Blank[]], xAct`xTensor`UpIndexQ], 
          PatternTest[
           Pattern[xAct`xConf`Private`i2$, 
            Blank[]], xAct`xTensor`UpIndexQ]]] :> 
       xAct`xTensor`Inv[$CellContext`gs2][
        xAct`xConf`Private`i1$, xAct`xConf`Private`i2$], 
       xAct`xConf`ConformalFrame[$CellContext`gs2][
         $CellContext`RiemannCD[
          PatternTest[
           Pattern[xAct`xConf`Private`i1$, 
            Blank[]], xAct`xTensor`DownIndexQ], 
          PatternTest[
           Pattern[xAct`xConf`Private`i2$, 
            Blank[]], xAct`xTensor`DownIndexQ], 
          PatternTest[
           Pattern[xAct`xConf`Private`i3$, 
            Blank[]], xAct`xTensor`DownIndexQ], 
          PatternTest[
           Pattern[xAct`xConf`Private`i4$, 
            Blank[]], xAct`xTensor`UpIndexQ]]] :> $CellContext`RiemannCDgs2[
        xAct`xConf`Private`i1$, xAct`xConf`Private`i2$, 
         xAct`xConf`Private`i3$, xAct`xConf`Private`i4$], 
       xAct`xConf`ConformalFrame[$CellContext`gs2][
         $CellContext`RiemannCD[
          Pattern[xAct`xConf`Private`i1$, 
           Blank[]], 
          Pattern[xAct`xConf`Private`i2$, 
           Blank[]], 
          Pattern[xAct`xConf`Private`i3$, 
           Blank[]], 
          Pattern[xAct`xConf`Private`i4$, 
           Blank[]]]] :> $CellContext`s[]^(
          xAct`xConf`Private`WeightOfIndicesList[{
            xAct`xConf`Private`i1$, xAct`xConf`Private`i2$, 
             xAct`xConf`Private`i3$, xAct`xConf`Private`i4$}] - 
          2) $CellContext`RiemannCDgs2[
         xAct`xConf`Private`i1$, xAct`xConf`Private`i2$, 
          xAct`xConf`Private`i3$, xAct`xConf`Private`i4$], 
       xAct`xConf`ConformalFrame[$CellContext`gs2][
         $CellContext`RicciCD[
          PatternTest[
           Pattern[xAct`xConf`Private`i1$, 
            Blank[]], xAct`xTensor`DownIndexQ], 
          PatternTest[
           Pattern[xAct`xConf`Private`i2$, 
            Blank[]], xAct`xTensor`DownIndexQ]]] :> $CellContext`RicciCDgs2[
        xAct`xConf`Private`i1$, xAct`xConf`Private`i2$], 
       xAct`xConf`ConformalFrame[$CellContext`gs2][
         $CellContext`RicciCD[
          Pattern[xAct`xConf`Private`i1$, 
           Blank[]], 
          Pattern[xAct`xConf`Private`i2$, 
           Blank[]]]] :> $CellContext`s[]^(
          xAct`xConf`Private`WeightOfIndicesList[{
            xAct`xConf`Private`i1$, xAct`xConf`Private`i2$}] - 
          2) $CellContext`RicciCDgs2[
         xAct`xConf`Private`i1$, xAct`xConf`Private`i2$], 
       xAct`xConf`ConformalFrame[$CellContext`gs2][
         $CellContext`CD[
          Pattern[xAct`xConf`Private`i1$, 
           Blank[]]][
          Pattern[xAct`xConf`Private`ex$, 
           Blank[]]]] :> $CellContext`s[]^(
          xAct`xConf`Private`WeightOfIndicesList[{xAct`xConf`Private`i1$}] - 
          1) $CellContext`CDgs2[xAct`xConf`Private`i1$][
          xAct`xConf`ConformalFrame[$CellContext`gs2][
          xAct`xConf`Private`ex$]], 
       xAct`xConf`ConformalFrame[$CellContext`gs2][
         $CellContext`epsilong[
          PatternTest[
           Pattern[xAct`xConf`Private`inds$, 
            BlankSequence[]], And[
            xAct`xTensor`DownIndexQ[#]]& ]]] :> $CellContext`epsilongs2[
        xAct`xConf`Private`inds$], xAct`xConf`ConformalFrame[$CellContext`g][
         $CellContext`gs2[
          PatternTest[
           Pattern[xAct`xConf`Private`i1$, 
            Blank[]], xAct`xTensor`DownIndexQ], 
          PatternTest[
           Pattern[xAct`xConf`Private`i2$, 
            Blank[]], xAct`xTensor`DownIndexQ]]] :> $CellContext`g[
        xAct`xConf`Private`i1$, xAct`xConf`Private`i2$], 
       xAct`xConf`ConformalFrame[$CellContext`g][
         $CellContext`Invgs2[
          PatternTest[
           Pattern[xAct`xConf`Private`i1$, 
            Blank[]], xAct`xTensor`UpIndexQ], 
          PatternTest[
           Pattern[xAct`xConf`Private`i2$, 
            Blank[]], xAct`xTensor`UpIndexQ]]] :> 
       xAct`xTensor`Inv[$CellContext`g][
        xAct`xConf`Private`i1$, xAct`xConf`Private`i2$], 
       xAct`xConf`ConformalFrame[$CellContext`g][
         $CellContext`RiemannCDgs2[
          PatternTest[
           Pattern[xAct`xConf`Private`i1$, 
            Blank[]], xAct`xTensor`DownIndexQ], 
          PatternTest[
           Pattern[xAct`xConf`Private`i2$, 
            Blank[]], xAct`xTensor`DownIndexQ], 
          PatternTest[
           Pattern[xAct`xConf`Private`i3$, 
            Blank[]], xAct`xTensor`DownIndexQ], 
          PatternTest[
           Pattern[xAct`xConf`Private`i4$, 
            Blank[]], xAct`xTensor`UpIndexQ]]] :> $CellContext`RiemannCD[
        xAct`xConf`Private`i1$, xAct`xConf`Private`i2$, 
         xAct`xConf`Private`i3$, xAct`xConf`Private`i4$], 
       xAct`xConf`ConformalFrame[$CellContext`g][
         $CellContext`RiemannCDgs2[
          Pattern[xAct`xConf`Private`i1$, 
           Blank[]], 
          Pattern[xAct`xConf`Private`i2$, 
           Blank[]], 
          Pattern[xAct`xConf`Private`i3$, 
           Blank[]], 
          Pattern[xAct`xConf`Private`i4$, 
           Blank[]]]] :> ($CellContext`s[]^(-1))^(
          xAct`xConf`Private`WeightOfIndicesList[{
            xAct`xConf`Private`i1$, xAct`xConf`Private`i2$, 
             xAct`xConf`Private`i3$, xAct`xConf`Private`i4$}] - 
          2) $CellContext`RiemannCD[
         xAct`xConf`Private`i1$, xAct`xConf`Private`i2$, 
          xAct`xConf`Private`i3$, xAct`xConf`Private`i4$], 
       xAct`xConf`ConformalFrame[$CellContext`g][
         $CellContext`RicciCDgs2[
          PatternTest[
           Pattern[xAct`xConf`Private`i1$, 
            Blank[]], xAct`xTensor`DownIndexQ], 
          PatternTest[
           Pattern[xAct`xConf`Private`i2$, 
            Blank[]], xAct`xTensor`DownIndexQ]]] :> $CellContext`RicciCD[
        xAct`xConf`Private`i1$, xAct`xConf`Private`i2$], 
       xAct`xConf`ConformalFrame[$CellContext`g][
         $CellContext`RicciCDgs2[
          Pattern[xAct`xConf`Private`i1$, 
           Blank[]], 
          Pattern[xAct`xConf`Private`i2$, 
           Blank[]]]] :> ($CellContext`s[]^(-1))^(
          xAct`xConf`Private`WeightOfIndicesList[{
            xAct`xConf`Private`i1$, xAct`xConf`Private`i2$}] - 
          2) $CellContext`RicciCD[
         xAct`xConf`Private`i1$, xAct`xConf`Private`i2$], 
       xAct`xConf`ConformalFrame[$CellContext`g][
         $CellContext`CDgs2[
          Pattern[xAct`xConf`Private`i1$, 
           Blank[]]][
          Pattern[xAct`xConf`Private`ex$, 
           Blank[]]]] :> ($CellContext`s[]^(-1))^(
          xAct`xConf`Private`WeightOfIndicesList[{xAct`xConf`Private`i1$}] - 
          1) $CellContext`CD[xAct`xConf`Private`i1$][
          xAct`xConf`ConformalFrame[$CellContext`g][xAct`xConf`Private`ex$]], 
       xAct`xConf`ConformalFrame[$CellContext`g][
         $CellContext`epsilongs2[
          PatternTest[
           Pattern[xAct`xConf`Private`inds$, 
            BlankSequence[]], And[
            xAct`xTensor`DownIndexQ[#]]& ]]] :> $CellContext`epsilong[
        xAct`xConf`Private`inds$], xAct`xConf`ConformalFrame[$CellContext`gs2][
         $CellContext`gS2[
          PatternTest[
           Pattern[xAct`xConf`Private`i1$, 
            Blank[]], xAct`xTensor`DownIndexQ], 
          PatternTest[
           Pattern[xAct`xConf`Private`i2$, 
            Blank[]], xAct`xTensor`DownIndexQ]]] :> $CellContext`gs2[
        xAct`xConf`Private`i1$, xAct`xConf`Private`i2$], 
       xAct`xConf`ConformalFrame[$CellContext`gs2][
         $CellContext`InvgS2[
          PatternTest[
           Pattern[xAct`xConf`Private`i1$, 
            Blank[]], xAct`xTensor`UpIndexQ], 
          PatternTest[
           Pattern[xAct`xConf`Private`i2$, 
            Blank[]], xAct`xTensor`UpIndexQ]]] :> 
       xAct`xTensor`Inv[$CellContext`gs2][
        xAct`xConf`Private`i1$, xAct`xConf`Private`i2$], 
       xAct`xConf`ConformalFrame[$CellContext`gs2][
         $CellContext`RiemannCDgS2[
          PatternTest[
           Pattern[xAct`xConf`Private`i1$, 
            Blank[]], xAct`xTensor`DownIndexQ], 
          PatternTest[
           Pattern[xAct`xConf`Private`i2$, 
            Blank[]], xAct`xTensor`DownIndexQ], 
          PatternTest[
           Pattern[xAct`xConf`Private`i3$, 
            Blank[]], xAct`xTensor`DownIndexQ], 
          PatternTest[
           Pattern[xAct`xConf`Private`i4$, 
            Blank[]], xAct`xTensor`UpIndexQ]]] :> $CellContext`RiemannCDgs2[
        xAct`xConf`Private`i1$, xAct`xConf`Private`i2$, 
         xAct`xConf`Private`i3$, xAct`xConf`Private`i4$], 
       xAct`xConf`ConformalFrame[$CellContext`gs2][
         $CellContext`RiemannCDgS2[
          Pattern[xAct`xConf`Private`i1$, 
           Blank[]], 
          Pattern[xAct`xConf`Private`i2$, 
           Blank[]], 
          Pattern[xAct`xConf`Private`i3$, 
           Blank[]], 
          Pattern[xAct`xConf`Private`i4$, 
           Blank[]]]] :> ($CellContext`s[]/$CellContext`S[])^(
          xAct`xConf`Private`WeightOfIndicesList[{
            xAct`xConf`Private`i1$, xAct`xConf`Private`i2$, 
             xAct`xConf`Private`i3$, xAct`xConf`Private`i4$}] - 
          2) $CellContext`RiemannCDgs2[
         xAct`xConf`Private`i1$, xAct`xConf`Private`i2$, 
          xAct`xConf`Private`i3$, xAct`xConf`Private`i4$], 
       xAct`xConf`ConformalFrame[$CellContext`gs2][
         $CellContext`RicciCDgS2[
          PatternTest[
           Pattern[xAct`xConf`Private`i1$, 
            Blank[]], xAct`xTensor`DownIndexQ], 
          PatternTest[
           Pattern[xAct`xConf`Private`i2$, 
            Blank[]], xAct`xTensor`DownIndexQ]]] :> $CellContext`RicciCDgs2[
        xAct`xConf`Private`i1$, xAct`xConf`Private`i2$], 
       xAct`xConf`ConformalFrame[$CellContext`gs2][
         $CellContext`RicciCDgS2[
          Pattern[xAct`xConf`Private`i1$, 
           Blank[]], 
          Pattern[xAct`xConf`Private`i2$, 
           Blank[]]]] :> ($CellContext`s[]/$CellContext`S[])^(
          xAct`xConf`Private`WeightOfIndicesList[{
            xAct`xConf`Private`i1$, xAct`xConf`Private`i2$}] - 
          2) $CellContext`RicciCDgs2[
         xAct`xConf`Private`i1$, xAct`xConf`Private`i2$], 
       xAct`xConf`ConformalFrame[$CellContext`gs2][
         $CellContext`CDgS2[
          Pattern[xAct`xConf`Private`i1$, 
           Blank[]]][
          Pattern[xAct`xConf`Private`ex$, 
           Blank[]]]] :> ($CellContext`s[]/$CellContext`S[])^(
          xAct`xConf`Private`WeightOfIndicesList[{xAct`xConf`Private`i1$}] - 
          1) $CellContext`CDgs2[xAct`xConf`Private`i1$][
          xAct`xConf`ConformalFrame[$CellContext`gs2][
          xAct`xConf`Private`ex$]], 
       xAct`xConf`ConformalFrame[$CellContext`gs2][
         $CellContext`epsilongS2[
          PatternTest[
           Pattern[xAct`xConf`Private`inds$, 
            BlankSequence[]], And[
            xAct`xTensor`DownIndexQ[#]]& ]]] :> $CellContext`epsilongs2[
        xAct`xConf`Private`inds$], xAct`xConf`ConformalFrame[$CellContext`gS2][
         $CellContext`gs2[
          PatternTest[
           Pattern[xAct`xConf`Private`i1$, 
            Blank[]], xAct`xTensor`DownIndexQ], 
          PatternTest[
           Pattern[xAct`xConf`Private`i2$, 
            Blank[]], xAct`xTensor`DownIndexQ]]] :> $CellContext`gS2[
        xAct`xConf`Private`i1$, xAct`xConf`Private`i2$], 
       xAct`xConf`ConformalFrame[$CellContext`gS2][
         $CellContext`Invgs2[
          PatternTest[
           Pattern[xAct`xConf`Private`i1$, 
            Blank[]], xAct`xTensor`UpIndexQ], 
          PatternTest[
           Pattern[xAct`xConf`Private`i2$, 
            Blank[]], xAct`xTensor`UpIndexQ]]] :> 
       xAct`xTensor`Inv[$CellContext`gS2][
        xAct`xConf`Private`i1$, xAct`xConf`Private`i2$], 
       xAct`xConf`ConformalFrame[$CellContext`gS2][
         $CellContext`RiemannCDgs2[
          PatternTest[
           Pattern[xAct`xConf`Private`i1$, 
            Blank[]], xAct`xTensor`DownIndexQ], 
          PatternTest[
           Pattern[xAct`xConf`Private`i2$, 
            Blank[]], xAct`xTensor`DownIndexQ], 
          PatternTest[
           Pattern[xAct`xConf`Private`i3$, 
            Blank[]], xAct`xTensor`DownIndexQ], 
          PatternTest[
           Pattern[xAct`xConf`Private`i4$, 
            Blank[]], xAct`xTensor`UpIndexQ]]] :> $CellContext`RiemannCDgS2[
        xAct`xConf`Private`i1$, xAct`xConf`Private`i2$, 
         xAct`xConf`Private`i3$, xAct`xConf`Private`i4$], 
       xAct`xConf`ConformalFrame[$CellContext`gS2][
         $CellContext`RiemannCDgs2[
          Pattern[xAct`xConf`Private`i1$, 
           Blank[]], 
          Pattern[xAct`xConf`Private`i2$, 
           Blank[]], 
          Pattern[xAct`xConf`Private`i3$, 
           Blank[]], 
          Pattern[xAct`xConf`Private`i4$, 
           Blank[]]]] :> ($CellContext`s[]^(-1) $CellContext`S[])^(
          xAct`xConf`Private`WeightOfIndicesList[{
            xAct`xConf`Private`i1$, xAct`xConf`Private`i2$, 
             xAct`xConf`Private`i3$, xAct`xConf`Private`i4$}] - 
          2) $CellContext`RiemannCDgS2[
         xAct`xConf`Private`i1$, xAct`xConf`Private`i2$, 
          xAct`xConf`Private`i3$, xAct`xConf`Private`i4$], 
       xAct`xConf`ConformalFrame[$CellContext`gS2][
         $CellContext`RicciCDgs2[
          PatternTest[
           Pattern[xAct`xConf`Private`i1$, 
            Blank[]], xAct`xTensor`DownIndexQ], 
          PatternTest[
           Pattern[xAct`xConf`Private`i2$, 
            Blank[]], xAct`xTensor`DownIndexQ]]] :> $CellContext`RicciCDgS2[
        xAct`xConf`Private`i1$, xAct`xConf`Private`i2$], 
       xAct`xConf`ConformalFrame[$CellContext`gS2][
         $CellContext`RicciCDgs2[
          Pattern[xAct`xConf`Private`i1$, 
           Blank[]], 
          Pattern[xAct`xConf`Private`i2$, 
           Blank[]]]] :> ($CellContext`s[]^(-1) $CellContext`S[])^(
          xAct`xConf`Private`WeightOfIndicesList[{
            xAct`xConf`Private`i1$, xAct`xConf`Private`i2$}] - 
          2) $CellContext`RicciCDgS2[
         xAct`xConf`Private`i1$, xAct`xConf`Private`i2$], 
       xAct`xConf`ConformalFrame[$CellContext`gS2][
         $CellContext`CDgs2[
          Pattern[xAct`xConf`Private`i1$, 
           Blank[]]][
          Pattern[xAct`xConf`Private`ex$, 
           Blank[]]]] :> ($CellContext`s[]^(-1) $CellContext`S[])^(
          xAct`xConf`Private`WeightOfIndicesList[{xAct`xConf`Private`i1$}] - 
          1) $CellContext`CDgS2[xAct`xConf`Private`i1$][
          xAct`xConf`ConformalFrame[$CellContext`gS2][
          xAct`xConf`Private`ex$]], 
       xAct`xConf`ConformalFrame[$CellContext`gS2][
         $CellContext`epsilongs2[
          PatternTest[
           Pattern[xAct`xConf`Private`inds$, 
            BlankSequence[]], And[
            xAct`xTensor`DownIndexQ[#]]& ]]] :> $CellContext`epsilongS2[
        xAct`xConf`Private`inds$]}], "DefaultValues" -> None, "NValues" -> 
    None, "FormatValues" -> None, "Options" -> None, "Attributes" -> {}, 
    "FullName" -> "xAct`xConf`ConformalFrame"|>, False]]], "Output",
 CellLabel->
  "Out[25]=",ExpressionUUID->"f67f06a1-7307-48ee-84ec-921279ae30b1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ConformalFrame", "[", "gS2", "]"}], "[", 
  RowBox[{"MT2", "[", 
   RowBox[{
    RowBox[{"-", "\[Alpha]"}], ",", 
    RowBox[{"-", "\[Beta]"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[26]:=",ExpressionUUID->"b5f9c6be-3f51-4957-a6cd-9ea5ea81d72a"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    StyleBox["[",
     FontColor->RGBColor[1, 0, 0]], 
    InterpretationBox[
     StyleBox[GridBox[{
        {"M", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Alpha]", "\[Beta]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`MT2[-$CellContext`\[Alpha], -$CellContext`\[Beta]],
     Editable->False], 
    StyleBox["]",
     FontColor->RGBColor[1, 0, 0]]}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xConf`ConformalFrame[$CellContext`gS2][
   $CellContext`MT2[-$CellContext`\[Alpha], -$CellContext`\[Beta]]],
  Editable->False]], "Output",
 CellLabel->
  "Out[26]=",ExpressionUUID->"64c265d9-9dce-480b-a499-162869b96282"]
}, Open  ]],

Cell["\<\
The formatting depends on the global option $FormatConformal which can either \
be \[OpenCurlyDoubleQuote]Default\[CloseCurlyDoubleQuote] or \
\[OpenCurlyDoubleQuote]Color\[CloseCurlyDoubleQuote]. The user choses what \
he/she finds most convenient to read.\
\>", "Text",
 CellTags->{
  "S5.18.1", "1.2"},ExpressionUUID->"f129219a-1eba-4504-9443-da36b309a298"],

Cell[BoxData[
 RowBox[{
  RowBox[{"$FormatConformal", " ", "=", " ", "\"\<Default\>\""}], 
  ";"}]], "Input",
 CellLabel->"In[27]:=",ExpressionUUID->"53f7ea34-4726-4d0a-b553-115ec7aedce5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ConformalFrame", "[", "gS2", "]"}], "[", 
  RowBox[{"MT2", "[", 
   RowBox[{
    RowBox[{"-", "\[Alpha]"}], ",", 
    RowBox[{"-", "\[Beta]"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[28]:=",ExpressionUUID->"9295ed03-2d67-45e2-a475-2a946ba77819"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    StyleBox[
     OverscriptBox["\[Null]", "gS2"],
     FontSize->8], "[", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"M", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Alpha]", "\[Beta]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`MT2[-$CellContext`\[Alpha], -$CellContext`\[Beta]],
     Editable->False], "]"}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xConf`ConformalFrame[$CellContext`gS2][
   $CellContext`MT2[-$CellContext`\[Alpha], -$CellContext`\[Beta]]],
  Editable->False]], "Output",
 CellLabel->
  "Out[28]=",ExpressionUUID->"0c482104-60c2-43ce-a973-ddd70cf92dfa"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"$FormatConformal", " ", "=", " ", "\"\<Color\>\""}], 
  ";"}]], "Input",
 CellLabel->"In[29]:=",ExpressionUUID->"e89c038d-1742-451e-8663-e195fb882ebc"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ConformalFrame", "[", "gS2", "]"}], "[", 
  RowBox[{"MT2", "[", 
   RowBox[{
    RowBox[{"-", "\[Alpha]"}], ",", 
    RowBox[{"-", "\[Beta]"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[30]:=",ExpressionUUID->"1b25ae45-1830-46eb-a660-656692a7d215"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    StyleBox["[",
     FontColor->RGBColor[1, 0, 0]], 
    InterpretationBox[
     StyleBox[GridBox[{
        {"M", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Alpha]", "\[Beta]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`MT2[-$CellContext`\[Alpha], -$CellContext`\[Beta]],
     Editable->False], 
    StyleBox["]",
     FontColor->RGBColor[1, 0, 0]]}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xConf`ConformalFrame[$CellContext`gS2][
   $CellContext`MT2[-$CellContext`\[Alpha], -$CellContext`\[Beta]]],
  Editable->False]], "Output",
 CellLabel->
  "Out[30]=",ExpressionUUID->"5b1ba2c5-4542-48a1-a37e-d65acdae5216"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["ToMetric", \
"Subsection",ExpressionUUID->"9e2f9781-3e47-4700-97b1-fffbed998356"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "ToMetric"}]], "Input",
 CellLabel->"In[31]:=",ExpressionUUID->"6651b12e-a9a9-422d-bdee-c82141802c17"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = False, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox[
             TagBox[
              TooltipBox[
               StyleBox["\<\" Symbol\"\>", "InformationRowLabel",
                StripOnInput->False],
               "\"Symbol\"",
               TooltipStyle->"TextStyling"],
              Annotation[#, "Symbol", "Tooltip"]& ], "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"ToMetric[metric][expr] formulates 'expr' in terms \
of conformal frame 'metric', and its associated covariant derivative and \
curvature tensors. It is a passive transformation.\"\>", 
             "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[
           TagBox[GridBox[{
              {
               StyleBox[
                TagBox[
                 TooltipBox[
                  
                  StyleBox["\<\" SubValue Definitions\"\>", 
                   "InformationRowLabel",
                   StripOnInput->False],
                  "\"SubValues\"",
                  TooltipStyle->"TextStyling"],
                 Annotation[#, "SubValues", "Tooltip"]& ], "DialogStyle",
                StripOnInput->False]},
              {
               TemplateBox[{"\"\[ThinSpace]\"", 
                 GridBox[{{
                    RowBox[{
                    RowBox[{
                    RowBox[{"ToMetric", "[", 
                    RowBox[{"xAct`xConf`Private`metric1_", "?", "MetricQ"}], 
                    "]"}], "[", "xAct`xConf`Private`expr_", "]"}], ":=", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"xAct`xConf`Private`res1", ",", 
                    "xAct`xConf`Private`res2", ",", "xAct`xConf`Private`res3",
                     ",", "xAct`xConf`Private`res4", ",", 
                    "xAct`xConf`Private`res5", ",", "xAct`xConf`Private`res6",
                     ",", "xAct`xConf`Private`res7", ",", 
                    "xAct`xConf`Private`res8", ",", "xAct`xConf`Private`res9",
                     ",", "xAct`xConf`Private`res10", ",", 
                    "xAct`xConf`Private`res11"}], "}"}], ",", 
                    RowBox[{"With", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"xAct`xConf`Private`cd1", "=", 
                    
                    RowBox[{"CovDOfMetric", "[", "xAct`xConf`Private`metric1",
                     "]"}]}], ",", 
                    RowBox[{"xAct`xConf`Private`M", "=", 
                    RowBox[{"ManifoldOfCovD", "[", 
                    
                    RowBox[{"CovDOfMetric", "[", "xAct`xConf`Private`metric1",
                     "]"}], "]"}]}], ",", 
                    RowBox[{"xAct`xConf`Private`$CovDsRelatedTocd1", "=", 
                    RowBox[{"Select", "[", 
                    RowBox[{
                    RowBox[{"Rest", "[", "$CovDs", "]"}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ConformalRules", "[", 
                    RowBox[{"xAct`xConf`Private`metric1", ",", 
                    RowBox[{"MetricOfCovD", "[", "#1", "]"}]}], "]"}], "=!=", 
                    
                    RowBox[{"{", "}"}]}], "&"}]}], "]"}]}], ",", 
                    RowBox[{"xAct`xConf`Private`firstmetric", "=", 
                    RowBox[{"First", "[", "$Metrics", "]"}]}]}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"xAct`xConf`Private`res1", "=", 
                    RowBox[{
                    RowBox[{"SeparateMetric", "[", "]"}], "[", 
                    RowBox[{"WeylToRiemann", "[", 
                    
                    RowBox[{"EinsteinToRicci", "[", "xAct`xConf`Private`expr",
                     "]"}], "]"}], "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{"$Debug", ",", 
                    RowBox[{
                    RowBox[{"Print", "[", 
                    RowBox[{"\"res1 = \"", ",", "xAct`xConf`Private`res1"}], 
                    "]"}], ";"}]}], "]"}], ";", 
                    RowBox[{"xAct`xConf`Private`res2", "=", 
                    
                    RowBox[{"xAct`xConf`Private`res1", "/.", 
                    "\[VeryThinSpace]", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"xAct`xConf`Private`tens_", "?", 
                    "TensorNotMetricRelated"}], "[", 
                    "xAct`xConf`Private`inds___", "]"}], "\[RuleDelayed]", 
                    RowBox[{
                    
                    RowBox[{"ConformalFrame", "[", 
                    "xAct`xConf`Private`firstmetric", "]"}], "[", 
                    
                    RowBox[{"xAct`xConf`Private`tens", "[", 
                    "xAct`xConf`Private`inds", "]"}], "]"}]}]}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{"$Debug", ",", 
                    RowBox[{
                    RowBox[{"Print", "[", 
                    RowBox[{"\"res2  = \"", ",", "xAct`xConf`Private`res2"}], 
                    "]"}], ";"}]}], "]"}], ";", 
                    RowBox[{"xAct`xConf`Private`res3", "=", 
                    
                    RowBox[{"xAct`xConf`Private`res2", "/.", 
                    "\[VeryThinSpace]", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ConformalFrame", "[", 
                    RowBox[{"xAct`xConf`Private`frame_", "?", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"#1", "=!=", "xAct`xConf`Private`metric1"}], "&&", 
                    RowBox[{"MetricQ", "[", "#1", "]"}]}], "&"}], ")"}]}], 
                    "]"}], "[", 
                    RowBox[{
                    RowBox[{"xAct`xConf`Private`tens_", "?", "xTensorQ"}], 
                    "[", "xAct`xConf`Private`inds___", "]"}], "]"}], 
                    "\[RuleDelayed]", 
                    RowBox[{
                    SuperscriptBox[
                    RowBox[{"SqrtConformalFactor", "[", 
                    
                    RowBox[{"xAct`xConf`Private`frame", ",", 
                    "xAct`xConf`Private`metric1"}], "]"}], 
                    RowBox[{"ConformalWeight", "[", 
                    
                    RowBox[{"xAct`xConf`Private`tens", "[", 
                    "xAct`xConf`Private`inds", "]"}], "]"}]], " ", 
                    RowBox[{
                    
                    RowBox[{"ConformalFrame", "[", 
                    "xAct`xConf`Private`metric1", "]"}], "[", 
                    
                    RowBox[{"xAct`xConf`Private`tens", "[", 
                    "xAct`xConf`Private`inds", "]"}], "]"}]}]}]}]}], ";", 
                    RowBox[{"xAct`xConf`Private`res4", "=", 
                    
                    RowBox[{"xAct`xConf`Private`res3", "/.", 
                    "\[VeryThinSpace]", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"ConformalFrame", "[", 
                    "xAct`xConf`Private`firstmetric", "]"}], "[", 
                    RowBox[{
                    RowBox[{"xAct`xConf`Private`tens_", "?", "xTensorQ"}], 
                    "[", "xAct`xConf`Private`inds___", "]"}], "]"}], 
                    "\[RuleDelayed]", 
                    
                    RowBox[{"xAct`xConf`Private`tens", "[", 
                    "xAct`xConf`Private`inds", "]"}]}]}]}], ";", 
                    RowBox[{"xAct`xConf`Private`res5", "=", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"ChangeCurvature", "[", 
                    
                    RowBox[{"#1", ",", "$CovDs", ",", 
                    "xAct`xConf`Private`cd1"}], "]"}], "&"}], ")"}], "[", 
                    "xAct`xConf`Private`res4", "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{"$Debug", ",", 
                    RowBox[{
                    RowBox[{"Print", "[", 
                    RowBox[{"\"res5 = \"", ",", "xAct`xConf`Private`res5"}], 
                    "]"}], ";"}]}], "]"}], ";", 
                    RowBox[{"xAct`xConf`Private`res6", "=", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"ChangeCovD", "[", 
                    
                    RowBox[{"#1", ",", "$CovDs", ",", 
                    "xAct`xConf`Private`cd1"}], "]"}], "&"}], ")"}], "[", 
                    "xAct`xConf`Private`res5", "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{"$Debug", ",", 
                    RowBox[{
                    RowBox[{"Print", "[", 
                    RowBox[{"\"res6 = \"", ",", "xAct`xConf`Private`res6"}], 
                    "]"}], ";"}]}], "]"}], ";", 
                    RowBox[{"xAct`xConf`Private`res7", "=", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"xAct`xConf`Private`ChangeChristoffel", "[", 
                    
                    RowBox[{"#1", ",", 
                    "xAct`xConf`Private`$CovDsRelatedTocd1", ",", 
                    "xAct`xConf`Private`cd1"}], "]"}], "&"}], ")"}], "[", 
                    "xAct`xConf`Private`res6", "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{"$Debug", ",", 
                    RowBox[{
                    RowBox[{"Print", "[", 
                    RowBox[{"\"res7 = \"", ",", "xAct`xConf`Private`res7"}], 
                    "]"}], ";"}]}], "]"}], ";", 
                    RowBox[{"xAct`xConf`Private`res8", "=", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"ChristoffelToGradConformal", "[", 
                    
                    RowBox[{"#1", ",", 
                    "xAct`xConf`Private`$CovDsRelatedTocd1", ",", 
                    "xAct`xConf`Private`cd1"}], "]"}], "&"}], ")"}], "[", 
                    "xAct`xConf`Private`res7", "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{"$Debug", ",", 
                    RowBox[{
                    RowBox[{"Print", "[", 
                    RowBox[{"\"res8 = \"", ",", "xAct`xConf`Private`res8"}], 
                    "]"}], ";"}]}], "]"}], ";", 
                    RowBox[{"xAct`xConf`Private`res9", "=", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"ChangeCovD", "[", 
                    
                    RowBox[{"#1", ",", "$CovDs", ",", 
                    "xAct`xConf`Private`cd1"}], "]"}], "&"}], ")"}], "[", 
                    "xAct`xConf`Private`res8", "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{"$Debug", ",", 
                    RowBox[{
                    RowBox[{"Print", "[", 
                    RowBox[{"\"res9 = \"", ",", "xAct`xConf`Private`res9"}], 
                    "]"}], ";"}]}], "]"}], ";", 
                    RowBox[{"xAct`xConf`Private`res10", "=", 
                    RowBox[{"Fold", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"#1", "/.", "\[VeryThinSpace]", 
                    RowBox[{"ConformalRules", "[", 
                    RowBox[{
                    RowBox[{"MetricOfCovD", "[", "#2", "]"}], ",", 
                    "xAct`xConf`Private`metric1"}], "]"}]}], "&"}], ",", 
                    "xAct`xConf`Private`res9", ",", 
                    "xAct`xConf`Private`$CovDsRelatedTocd1"}], "]"}]}], ";", 
                    RowBox[{"xAct`xConf`Private`res11", "=", 
                    RowBox[{"Fold", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"#1", "/.", "\[VeryThinSpace]", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"epsilon", "[", 
                    RowBox[{"MetricOfCovD", "[", "#2", "]"}], "]"}], "[", 
                    "xAct`xConf`Private`inds__", "]"}], "\[RuleDelayed]", 
                    RowBox[{
                    SuperscriptBox[
                    RowBox[{"SqrtConformalFactor", "[", 
                    RowBox[{
                    RowBox[{"MetricOfCovD", "[", "#2", "]"}], ",", 
                    "xAct`xConf`Private`metric1"}], "]"}], 
                    RowBox[{"xAct`xConf`Private`WeightOfIndicesList", "[", 
                    RowBox[{"{", "xAct`xConf`Private`inds", "}"}], "]"}]], 
                    " ", 
                    RowBox[{
                    
                    RowBox[{"epsilon", "[", "xAct`xConf`Private`metric1", 
                    "]"}], "[", "xAct`xConf`Private`inds", "]"}]}]}]}], "&"}],
                     ",", "xAct`xConf`Private`res10", ",", 
                    "xAct`xConf`Private`$CovDsRelatedTocd1"}], "]"}]}], ";", 
                    
                    RowBox[{"xAct`xConf`Private`SafeArrange", "[", 
                    "xAct`xConf`Private`res11", "]"}]}]}], "]"}]}], 
                    "]"}]}]}, {" "}, {
                    RowBox[{
                    RowBox[{
                    RowBox[{"ToMetric", "[", "]"}], "[", 
                    "xAct`xConf`Private`expr_", "]"}], ":=", 
                    RowBox[{
                    RowBox[{"ToMetric", "[", 
                    RowBox[{"First", "[", "$Metrics", "]"}], "]"}], "[", 
                    "xAct`xConf`Private`expr", "]"}]}]}, {" "}}, 
                  GridBoxAlignment -> {"Columns" -> {{Left}}}, 
                  DefaultBaseStyle -> "Column", 
                  GridBoxItemSize -> {
                   "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}]},
                "RowDefault"]}
             },
             DefaultBaseStyle->"Column",
             GridBoxAlignment->{"Columns" -> {{Left}}},
             
             GridBoxItemSize->{
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
            "Column"],
           FrameMargins->{{6, 0}, {3, 6}}], "\<\"\"\>"},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Attributes\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"Attributes\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "Attributes", "Tooltip"]& ], 
                   RowBox[{"{", "Protected", "}"}]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"xAct`xConf`ToMetric\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->{{6, 6}, {6, 3}}], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox[
             TagBox[
              TooltipBox[
               StyleBox["\<\" Symbol\"\>", "InformationRowLabel",
                StripOnInput->False],
               "\"Symbol\"",
               TooltipStyle->"TextStyling"],
              Annotation[#, "Symbol", "Tooltip"]& ], "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"ToMetric[metric][expr] formulates 'expr' in terms \
of conformal frame 'metric', and its associated covariant derivative and \
curvature tensors. It is a passive transformation.\"\>", 
             "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"],
               ImageSizeCache->{10., {3., 7.}}], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"],
               ImageSizeCache->{10., {3., 7.}}]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[<|
   "ObjectType" -> "Symbol", "Usage" -> 
    "ToMetric[metric][expr] formulates 'expr' in terms of conformal frame \
'metric', and its associated covariant derivative and curvature tensors. It \
is a passive transformation.", "Documentation" -> None, "OwnValues" -> None, 
    "UpValues" -> None, "DownValues" -> None, "SubValues" -> 
    Information`InformationValueForm[
     SubValues, xAct`xConf`ToMetric, {xAct`xConf`ToMetric[
         PatternTest[
          Pattern[xAct`xConf`Private`metric1, 
           Blank[]], xAct`xTensor`MetricQ]][
         Pattern[xAct`xConf`Private`expr, 
          Blank[]]] :> 
       Module[{xAct`xConf`Private`res1, xAct`xConf`Private`res2, 
          xAct`xConf`Private`res3, xAct`xConf`Private`res4, 
          xAct`xConf`Private`res5, xAct`xConf`Private`res6, 
          xAct`xConf`Private`res7, xAct`xConf`Private`res8, 
          xAct`xConf`Private`res9, xAct`xConf`Private`res10, 
          xAct`xConf`Private`res11}, 
         With[{
          xAct`xConf`Private`cd1 = 
           xAct`xTensor`CovDOfMetric[xAct`xConf`Private`metric1], 
           xAct`xConf`Private`M = xAct`xTensor`ManifoldOfCovD[
             xAct`xTensor`CovDOfMetric[xAct`xConf`Private`metric1]], 
           xAct`xConf`Private`$CovDsRelatedTocd1 = Select[
             Rest[xAct`xTensor`$CovDs], 
             xAct`xTensor`ConformalRules[xAct`xConf`Private`metric1, 
               xAct`xTensor`MetricOfCovD[#]] =!= {}& ], 
           xAct`xConf`Private`firstmetric = First[xAct`xTensor`$Metrics]}, 
          xAct`xConf`Private`res1 = xAct`xTensor`SeparateMetric[][
             xAct`xTensor`WeylToRiemann[
              xAct`xTensor`EinsteinToRicci[xAct`xConf`Private`expr]]]; 
          If[xAct`xConf`$Debug, Print["res1 = ", xAct`xConf`Private`res1]; 
            Null]; xAct`xConf`Private`res2 = 
           ReplaceAll[xAct`xConf`Private`res1, PatternTest[
               Pattern[xAct`xConf`Private`tens, 
                Blank[]], xAct`xConf`TensorNotMetricRelated][
               Pattern[xAct`xConf`Private`inds, 
                BlankNullSequence[]]] :> 
             xAct`xConf`ConformalFrame[xAct`xConf`Private`firstmetric][
               xAct`xConf`Private`tens[xAct`xConf`Private`inds]]]; 
          If[xAct`xConf`$Debug, Print["res2  = ", xAct`xConf`Private`res2]; 
            Null]; xAct`xConf`Private`res3 = 
           ReplaceAll[xAct`xConf`Private`res2, xAct`xConf`ConformalFrame[
               PatternTest[
                Pattern[xAct`xConf`Private`frame, 
                 Blank[]], And[# =!= xAct`xConf`Private`metric1, 
                 xAct`xTensor`MetricQ[#]]& ]][
               PatternTest[
                Pattern[xAct`xConf`Private`tens, 
                 Blank[]], xAct`xTensor`xTensorQ][
                Pattern[xAct`xConf`Private`inds, 
                 BlankNullSequence[]]]] :> 
             xAct`xConf`SqrtConformalFactor[
                xAct`xConf`Private`frame, xAct`xConf`Private`metric1]^
               xAct`xConf`ConformalWeight[
                 xAct`xConf`Private`tens[xAct`xConf`Private`inds]] 
              xAct`xConf`ConformalFrame[xAct`xConf`Private`metric1][
                xAct`xConf`Private`tens[xAct`xConf`Private`inds]]]; 
          xAct`xConf`Private`res4 = 
           ReplaceAll[
            xAct`xConf`Private`res3, 
             xAct`xConf`ConformalFrame[xAct`xConf`Private`firstmetric][
               PatternTest[
                Pattern[xAct`xConf`Private`tens, 
                 Blank[]], xAct`xTensor`xTensorQ][
                Pattern[xAct`xConf`Private`inds, 
                 BlankNullSequence[]]]] :> 
             xAct`xConf`Private`tens[xAct`xConf`Private`inds]]; 
          xAct`xConf`Private`res5 = (
            xAct`xTensor`ChangeCurvature[#, xAct`xTensor`$CovDs, 
             xAct`xConf`Private`cd1]& )[xAct`xConf`Private`res4]; 
          If[xAct`xConf`$Debug, Print["res5 = ", xAct`xConf`Private`res5]; 
            Null]; xAct`xConf`Private`res6 = (
            xAct`xTensor`ChangeCovD[#, xAct`xTensor`$CovDs, 
             xAct`xConf`Private`cd1]& )[xAct`xConf`Private`res5]; 
          If[xAct`xConf`$Debug, Print["res6 = ", xAct`xConf`Private`res6]; 
            Null]; xAct`xConf`Private`res7 = (
            xAct`xConf`Private`ChangeChristoffel[#, 
             xAct`xConf`Private`$CovDsRelatedTocd1, 
             xAct`xConf`Private`cd1]& )[xAct`xConf`Private`res6]; 
          If[xAct`xConf`$Debug, Print["res7 = ", xAct`xConf`Private`res7]; 
            Null]; xAct`xConf`Private`res8 = (
            xAct`xTensor`ChristoffelToGradConformal[#, 
             xAct`xConf`Private`$CovDsRelatedTocd1, 
             xAct`xConf`Private`cd1]& )[xAct`xConf`Private`res7]; 
          If[xAct`xConf`$Debug, Print["res8 = ", xAct`xConf`Private`res8]; 
            Null]; xAct`xConf`Private`res9 = (
            xAct`xTensor`ChangeCovD[#, xAct`xTensor`$CovDs, 
             xAct`xConf`Private`cd1]& )[xAct`xConf`Private`res8]; 
          If[xAct`xConf`$Debug, Print["res9 = ", xAct`xConf`Private`res9]; 
            Null]; xAct`xConf`Private`res10 = Fold[ReplaceAll[#, 
              xAct`xTensor`ConformalRules[
               xAct`xTensor`MetricOfCovD[#2], xAct`xConf`Private`metric1]]& , 
             xAct`xConf`Private`res9, xAct`xConf`Private`$CovDsRelatedTocd1]; 
          xAct`xConf`Private`res11 = Fold[ReplaceAll[#, xAct`xTensor`epsilon[
                xAct`xTensor`MetricOfCovD[#2]][
                Pattern[xAct`xConf`Private`inds, 
                 BlankSequence[]]] :> xAct`xConf`SqrtConformalFactor[
                  xAct`xTensor`MetricOfCovD[#2], xAct`xConf`Private`metric1]^
                xAct`xConf`Private`WeightOfIndicesList[{
                  xAct`xConf`Private`inds}] 
               xAct`xTensor`epsilon[xAct`xConf`Private`metric1][
                xAct`xConf`Private`inds]]& , xAct`xConf`Private`res10, 
             xAct`xConf`Private`$CovDsRelatedTocd1]; 
          xAct`xConf`Private`SafeArrange[xAct`xConf`Private`res11]]], 
       xAct`xConf`ToMetric[][
         Pattern[xAct`xConf`Private`expr, 
          Blank[]]] :> xAct`xConf`ToMetric[
         First[xAct`xTensor`$Metrics]][xAct`xConf`Private`expr]}], 
    "DefaultValues" -> None, "NValues" -> None, "FormatValues" -> None, 
    "Options" -> None, "Attributes" -> {Protected}, "FullName" -> 
    "xAct`xConf`ToMetric"|>, False]]], "Output",
 CellLabel->
  "Out[31]=",ExpressionUUID->"58a51498-b294-483b-baf6-7c5c7fd094e0"]
}, Open  ]],

Cell["\<\
ToMetric[metric][expr] performs a passive transformation. It expresses a \
given expression expr with tensors evaluated in a given frame metric.\
\>", "Text",
 CellTags->{
  "S5.18.1", "1.2"},ExpressionUUID->"8d1e8a2c-0b69-45d5-9a29-5f6f2e7df2ca"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ToMetric", "[", "gS2", "]"}], "[", 
  RowBox[{"g", "[", 
   RowBox[{
    RowBox[{"-", "\[Mu]"}], ",", 
    RowBox[{"-", "\[Nu]"}]}], "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ToMetric", "[", "gS2", "]"}], "[", 
  RowBox[{"g", "[", 
   RowBox[{"\[Mu]", ",", "\[Nu]"}], "]"}], "]"}]}], "Input",
 CellLabel->"In[32]:=",ExpressionUUID->"7cea5067-32cd-49cf-913e-15cbddcd9e5c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"ChristoffelCDCDgS2", "[", 
    RowBox[{"\[Alpha]", ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`ChristoffelCDCDgS2[$CellContext`\[Alpha], -$CellContext`\
\[Beta], -$CellContext`\[Gamma]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[32]:=",ExpressionUUID->"23da36a4-3741-432b-94f4-aebe27469c5c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"ChristoffelCDgs2CDgS2", "[", 
    RowBox[{"\[Alpha]", ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`ChristoffelCDgs2CDgS2[$CellContext`\[Alpha], -$CellContext`\
\[Beta], -$CellContext`\[Gamma]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[32]:=",ExpressionUUID->"5a75e0db-893d-4140-acae-412ae85e4659"],

Cell[BoxData[
 FractionBox[
  InterpretationBox[
   StyleBox[GridBox[{
      {"gS2", 
       StyleBox[GridBox[{
          {" ", " "},
          {"\[Mu]", "\[Nu]"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->9]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`gS2[-$CellContext`\[Mu], -$CellContext`\[Nu]],
   Editable->False], 
  SuperscriptBox[
   InterpretationBox[
    StyleBox["S",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S[],
    Editable->False], "2"]]], "Output",
 CellLabel->"Out[32]=",ExpressionUUID->"ee27f9ae-ffc8-475c-98f6-40f1fbf4fe00"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"igS2", 
       StyleBox[GridBox[{
          {"\[Mu]", "\[Nu]"},
          {" ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->9]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`InvgS2[$CellContext`\[Mu], $CellContext`\[Nu]],
   Editable->False], " ", 
  SuperscriptBox[
   InterpretationBox[
    StyleBox["S",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S[],
    Editable->False], "2"]}]], "Output",
 CellLabel->
  "Out[33]=",ExpressionUUID->"a7795b4f-054a-47a2-8f74-7ed587e2d78b"]
}, Open  ]],

Cell["\<\
When applied on covariant derivatives it changes the derivative appearing in \
the expression\
\>", "Text",
 CellTags->{
  "S5.18.1", "1.2"},ExpressionUUID->"32c82ae2-ecb8-42bd-a62f-2b98cada7f21"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ToMetric", "[", "gS2", "]"}], "[", 
   RowBox[{
    RowBox[{"CD", "[", 
     RowBox[{"-", "\[Mu]"}], "]"}], "[", 
    RowBox[{"k", "[", 
     RowBox[{"-", "\[Nu]"}], "]"}], "]"}], "]"}], "//", "NoScalar"}]], "Input",
 CellLabel->"In[34]:=",ExpressionUUID->"240e122d-ad0d-454e-83cf-fe3837119380"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[
    RowBox[{
     SubscriptBox[
      RowBox[{"\[Del]", "gS2"}], "\[Mu]"], 
     StyleBox["[",
      FontColor->RGBColor[1, 0, 0]], 
     InterpretationBox[
      StyleBox[GridBox[{
         {"k", 
          StyleBox[GridBox[{
             {" "},
             {"\[Nu]"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->9]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`k[-$CellContext`\[Nu]],
      Editable->False], 
     StyleBox["]",
      FontColor->RGBColor[1, 0, 0]]}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`CDgS2[-$CellContext`\[Mu]][
    xAct`xConf`ConformalFrame[$CellContext`gS2][
     $CellContext`k[-$CellContext`\[Nu]]]],
   Editable->False], "-", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"gS2", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Mu]", "\[Nu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`gS2[-$CellContext`\[Mu], -$CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"igS2", 
         StyleBox[GridBox[{
            {"\[Alpha]", "\[Beta]"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`InvgS2[$CellContext`\[Alpha], $CellContext`\[Beta]],
     Editable->False], " ", 
    RowBox[{"(", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SubscriptBox[
         RowBox[{"\[Del]", "gS2"}], "\[Beta]"], "S"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`CDgS2[-$CellContext`\[Beta]][
       $CellContext`S[]],
      Editable->False], ")"}], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       StyleBox["[",
        FontColor->RGBColor[1, 0, 0]], 
       InterpretationBox[
        StyleBox[GridBox[{
           {"k", 
            StyleBox[GridBox[{
               {" "},
               {"\[Alpha]"}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->9]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`k[-$CellContext`\[Alpha]],
        Editable->False], 
       StyleBox["]",
        FontColor->RGBColor[1, 0, 0]]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xConf`ConformalFrame[$CellContext`gS2][
      $CellContext`k[-$CellContext`\[Alpha]]],
     Editable->False]}], 
   InterpretationBox[
    StyleBox["S",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S[],
    Editable->False]], "+", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SubscriptBox[
         RowBox[{"\[Del]", "gS2"}], "\[Nu]"], "S"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`CDgS2[-$CellContext`\[Nu]][
       $CellContext`S[]],
      Editable->False], ")"}], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       StyleBox["[",
        FontColor->RGBColor[1, 0, 0]], 
       InterpretationBox[
        StyleBox[GridBox[{
           {"k", 
            StyleBox[GridBox[{
               {" "},
               {"\[Mu]"}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->9]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`k[-$CellContext`\[Mu]],
        Editable->False], 
       StyleBox["]",
        FontColor->RGBColor[1, 0, 0]]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xConf`ConformalFrame[$CellContext`gS2][
      $CellContext`k[-$CellContext`\[Mu]]],
     Editable->False]}], 
   InterpretationBox[
    StyleBox["S",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S[],
    Editable->False]], "+", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SubscriptBox[
         RowBox[{"\[Del]", "gS2"}], "\[Mu]"], "S"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`CDgS2[-$CellContext`\[Mu]][
       $CellContext`S[]],
      Editable->False], ")"}], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       StyleBox["[",
        FontColor->RGBColor[1, 0, 0]], 
       InterpretationBox[
        StyleBox[GridBox[{
           {"k", 
            StyleBox[GridBox[{
               {" "},
               {"\[Nu]"}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "Rows" -> {{
                   Offset[0.]}}}],
             FontSize->9]}
          },
          GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`k[-$CellContext`\[Nu]],
        Editable->False], 
       StyleBox["]",
        FontColor->RGBColor[1, 0, 0]]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xConf`ConformalFrame[$CellContext`gS2][
      $CellContext`k[-$CellContext`\[Nu]]],
     Editable->False]}], 
   InterpretationBox[
    StyleBox["S",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S[],
    Editable->False]]}]], "Output",
 CellLabel->
  "Out[34]=",ExpressionUUID->"0cb1f019-b616-4011-82f0-fe03ca54e9dd"]
}, Open  ]],

Cell["\<\
When applied on curvature tensors  it changes the curvature tensors appearing \
in the expression\
\>", "Text",
 CellTags->{
  "S5.18.1", "1.2"},ExpressionUUID->"03f2a824-66e8-4387-8820-1b99c646a88c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ToMetric", "[", "gS2", "]"}], "[", 
  RowBox[{"RicciCD", "[", 
   RowBox[{
    RowBox[{"-", "\[Mu]"}], ",", 
    RowBox[{"-", "\[Nu]"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[35]:=",ExpressionUUID->"afda9eac-2ba7-41d4-add6-f0c694f984d7"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {
       RowBox[{"R", "[", 
        RowBox[{"\[Del]", "gS2"}], "]"}], 
       StyleBox[GridBox[{
          {" ", " "},
          {"\[Mu]", "\[Nu]"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->9]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`RicciCDgS2[-$CellContext`\[Mu], -$CellContext`\[Nu]],
   Editable->False], "-", 
  FractionBox[
   RowBox[{"3", " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"gS2", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Mu]", "\[Nu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`gS2[-$CellContext`\[Mu], -$CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       StyleBox["(",
        FontColor->RGBColor[1, 0, 0]], 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"igS2", 
             StyleBox[GridBox[{
                {"\[Alpha]", "\[Beta]"},
                {" ", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->9]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`InvgS2[$CellContext`\[Alpha], $CellContext`\[Beta]],
         Editable->False], " ", 
        RowBox[{"(", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SubscriptBox[
             RowBox[{"\[Del]", "gS2"}], "\[Alpha]"], "S"}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CDgS2[-$CellContext`\[Alpha]][
           $CellContext`S[]],
          Editable->False], ")"}], " ", 
        RowBox[{"(", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SubscriptBox[
             RowBox[{"\[Del]", "gS2"}], "\[Beta]"], "S"}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CDgS2[-$CellContext`\[Beta]][
           $CellContext`S[]],
          Editable->False], ")"}]}], 
       StyleBox[")",
        FontColor->RGBColor[1, 0, 0]]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`Scalar[($CellContext`InvgS2[$CellContext`\[Alpha], \
$CellContext`\[Beta]] $CellContext`CDgS2[-$CellContext`\[Alpha]][
         $CellContext`S[]]) $CellContext`CDgS2[-$CellContext`\[Beta]][
        $CellContext`S[]]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[],
     Editable->False], "2"]], "+", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"gS2", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Mu]", "\[Nu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`gS2[-$CellContext`\[Mu], -$CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       StyleBox["(",
        FontColor->RGBColor[1, 0, 0]], 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"igS2", 
             StyleBox[GridBox[{
                {"\[Alpha]", "\[Beta]"},
                {" ", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->9]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`InvgS2[$CellContext`\[Alpha], $CellContext`\[Beta]],
         Editable->False], " ", 
        RowBox[{"(", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SubscriptBox[
             RowBox[{"\[Del]", "gS2"}], "\[Beta]"], 
            SubscriptBox[
             RowBox[{"\[Del]", "gS2"}], "\[Alpha]"], "S"}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CDgS2[-$CellContext`\[Beta]][
           $CellContext`CDgS2[-$CellContext`\[Alpha]][
            $CellContext`S[]]],
          Editable->False], ")"}]}], 
       StyleBox[")",
        FontColor->RGBColor[1, 0, 0]]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`Scalar[$CellContext`InvgS2[$CellContext`\[Alpha], \
$CellContext`\[Beta]] $CellContext`CDgS2[-$CellContext`\[Beta]][
        $CellContext`CDgS2[-$CellContext`\[Alpha]][
         $CellContext`S[]]]],
     Editable->False]}], 
   InterpretationBox[
    StyleBox["S",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S[],
    Editable->False]], "+", 
  FractionBox[
   RowBox[{"2", " ", 
    RowBox[{"(", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SubscriptBox[
         RowBox[{"\[Del]", "gS2"}], "\[Nu]"], 
        SubscriptBox[
         RowBox[{"\[Del]", "gS2"}], "\[Mu]"], "S"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`CDgS2[-$CellContext`\[Nu]][
       $CellContext`CDgS2[-$CellContext`\[Mu]][
        $CellContext`S[]]],
      Editable->False], ")"}]}], 
   InterpretationBox[
    StyleBox["S",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S[],
    Editable->False]]}]], "Output",
 CellLabel->
  "Out[35]=",ExpressionUUID->"8a8e3d4d-bc98-48da-97ed-bda7ddd60de6"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["ConformalTransformation", \
"Subsection",ExpressionUUID->"019d7665-70c9-4482-846e-69242ee19633"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "ConformalTransformation"}]], "Input",
 CellLabel->"In[36]:=",ExpressionUUID->"9ef7ca90-c400-4681-a8c8-5e3f4fb89630"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = False, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox[
             TagBox[
              TooltipBox[
               StyleBox["\<\" Symbol\"\>", "InformationRowLabel",
                StripOnInput->False],
               "\"Symbol\"",
               TooltipStyle->"TextStyling"],
              Annotation[#, "Symbol", "Tooltip"]& ], "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"ConformalTransformation[metric1,metric2][expr] \
performs a conformal transformation. More precisely it is a Weyl \
transformation, but we call it conformal transformation as in appendix D of \
Wald's book on General Relativity (1984)).\\n\\nThe expression 'expr' is \
transformed actively from the frame 'metric1' to the frame 'metric2'. \\nThe \
two metrics 'metric1' and 'metric2' have to be conformally related by \
DefConformalMetric. \\n\\nThe Option FinalFrame is by default set to \
'Automatic' and in that case all quantities in the result are expressed in \
the metric1 frame.\\nThe use can specifiy FinalFrame->targetframe, where \
targetframe is a metric name, to express the results in terms of quantities \
in the targetframe conformal frame. \"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[
           TagBox[GridBox[{
              {
               StyleBox[
                TagBox[
                 TooltipBox[
                  
                  StyleBox["\<\" SubValue Definitions\"\>", 
                   "InformationRowLabel",
                   StripOnInput->False],
                  "\"SubValues\"",
                  TooltipStyle->"TextStyling"],
                 Annotation[#, "SubValues", "Tooltip"]& ], "DialogStyle",
                StripOnInput->False]},
              {
               TemplateBox[{"\"\[ThinSpace]\"", 
                 GridBox[{{
                    RowBox[{
                    RowBox[{
                    RowBox[{"ConformalTransformation", "[", 
                    RowBox[{
                    
                    RowBox[{"xAct`xConf`Private`metricbase_", "?", 
                    "MetricQ"}], ",", 
                    
                    RowBox[{"xAct`xConf`Private`metrictarget_", "?", 
                    "MetricQ"}], ",", 
                    RowBox[{"xAct`xConf`Private`options", ":", 
                    RowBox[{"OptionsPattern", "[", "]"}]}]}], "]"}], "[", 
                    "xAct`xConf`Private`expr_", "]"}], ":=", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"xAct`xConf`Private`Tometricinitialexpression", 
                    ",", "xAct`xConf`Private`transformedexpression", ",", 
                    "xAct`xConf`Private`finalframe"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", "xAct`xConf`Private`finalframe", "}"}], "=", 
                    
                    RowBox[{"OptionValue", "[", 
                    RowBox[{"{", "FinalFrame", "}"}], "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    
                    RowBox[{"xAct`xConf`Private`finalframe", "===", 
                    "Automatic"}], ",", 
                    RowBox[{
                    
                    RowBox[{"xAct`xConf`Private`finalframe", "=", 
                    "xAct`xConf`Private`metricbase"}], ";"}]}], "]"}], ";", 
                    RowBox[{"With", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"xAct`xConf`Private`firstmetric", "=", 
                    RowBox[{"First", "[", "$Metrics", "]"}]}], "}"}], ",", 
                    RowBox[{
                    
                    RowBox[{"xAct`xConf`Private`Tometricinitialexpression", 
                    "=", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"ToMetric", "[", "xAct`xConf`Private`metricbase", 
                    "]"}], "[", "xAct`xConf`Private`expr", "]"}], "/.", 
                    "\[VeryThinSpace]", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"xAct`xConf`Private`tens_", "?", 
                    "TensorNotMetricRelated"}], "[", 
                    "xAct`xConf`Private`inds___", "]"}], "\[RuleDelayed]", 
                    RowBox[{
                    
                    RowBox[{"ConformalFrame", "[", 
                    "xAct`xConf`Private`firstmetric", "]"}], "[", 
                    
                    RowBox[{"xAct`xConf`Private`tens", "[", 
                    "xAct`xConf`Private`inds", "]"}], "]"}]}]}]}], ";", 
                    RowBox[{"xAct`xConf`Private`transformedexpression", "=", 
                    RowBox[{
                    
                    RowBox[{"ConformalFrame", "[", 
                    "xAct`xConf`Private`metrictarget", "]"}], "[", 
                    "xAct`xConf`Private`Tometricinitialexpression", "]"}]}], 
                    ";", 
                    RowBox[{
                    
                    RowBox[{"ToMetric", "[", "xAct`xConf`Private`finalframe", 
                    "]"}], "[", "xAct`xConf`Private`transformedexpression", 
                    "]"}]}]}], "]"}]}]}], "]"}]}]}, {" "}, {
                    RowBox[{
                    RowBox[{
                    RowBox[{"ConformalTransformation", "[", 
                    
                    RowBox[{
                    "xAct`xConf`Private`metrictarget_", "?", "MetricQ"}], 
                    "]"}], "[", "xAct`xConf`Private`expr_", "]"}], ":=", 
                    RowBox[{
                    RowBox[{"ConformalTransformation", "[", 
                    RowBox[{
                    RowBox[{"First", "[", "$Metrics", "]"}], ",", 
                    "xAct`xConf`Private`metrictarget"}], "]"}], "[", 
                    "xAct`xConf`Private`expr", "]"}]}]}, {" "}}, 
                  GridBoxAlignment -> {"Columns" -> {{Left}}}, 
                  DefaultBaseStyle -> "Column", 
                  GridBoxItemSize -> {
                   "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}]},
                "RowDefault"]}
             },
             DefaultBaseStyle->"Column",
             GridBoxAlignment->{"Columns" -> {{Left}}},
             
             GridBoxItemSize->{
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
            "Column"],
           FrameMargins->{{6, 0}, {3, 6}}], "\<\"\"\>"},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Options\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"Options\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "Options", "Tooltip"]& ], 
                   RowBox[{"FinalFrame", "\[Rule]", "Automatic"}]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], \
"\<\"xAct`xConf`ConformalTransformation\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->{{6, 6}, {6, 3}}], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox[
             TagBox[
              TooltipBox[
               StyleBox["\<\" Symbol\"\>", "InformationRowLabel",
                StripOnInput->False],
               "\"Symbol\"",
               TooltipStyle->"TextStyling"],
              Annotation[#, "Symbol", "Tooltip"]& ], "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"ConformalTransformation[metric1,metric2][expr] \
performs a conformal transformation. More precisely it is a Weyl \
transformation, but we call it conformal transformation as in appendix D of \
Wald's book on General Relativity (1984)).\\n\\nThe expression 'expr' is \
transformed actively from the frame 'metric1' to the frame 'metric2'. \\nThe \
two metrics 'metric1' and 'metric2' have to be conformally related by \
DefConformalMetric. \\n\\nThe Option FinalFrame is by default set to \
'Automatic' and in that case all quantities in the result are expressed in \
the metric1 frame.\\nThe use can specifiy FinalFrame->targetframe, where \
targetframe is a metric name, to express the results in terms of quantities \
in the targetframe conformal frame. \"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"],
               ImageSizeCache->{10., {3., 7.}}], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"],
               ImageSizeCache->{10., {3., 7.}}]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[<|
   "ObjectType" -> "Symbol", "Usage" -> 
    "ConformalTransformation[metric1,metric2][expr] performs a conformal \
transformation. More precisely it is a Weyl transformation, but we call it \
conformal transformation as in appendix D of Wald's book on General \
Relativity (1984)).\n\nThe expression 'expr' is transformed actively from the \
frame 'metric1' to the frame 'metric2'. \nThe two metrics 'metric1' and \
'metric2' have to be conformally related by DefConformalMetric. \n\nThe \
Option FinalFrame is by default set to 'Automatic' and in that case all \
quantities in the result are expressed in the metric1 frame.\nThe use can \
specifiy FinalFrame->targetframe, where targetframe is a metric name, to \
express the results in terms of quantities in the targetframe conformal \
frame. ", "Documentation" -> None, "OwnValues" -> None, "UpValues" -> None, 
    "DownValues" -> None, "SubValues" -> 
    Information`InformationValueForm[
     SubValues, xAct`xConf`ConformalTransformation, {
      xAct`xConf`ConformalTransformation[
         PatternTest[
          Pattern[xAct`xConf`Private`metricbase, 
           Blank[]], xAct`xTensor`MetricQ], 
         PatternTest[
          Pattern[xAct`xConf`Private`metrictarget, 
           Blank[]], xAct`xTensor`MetricQ], 
         Pattern[xAct`xConf`Private`options, 
          OptionsPattern[]]][
         Pattern[xAct`xConf`Private`expr, 
          Blank[]]] :> 
       Module[{xAct`xConf`Private`Tometricinitialexpression, 
          xAct`xConf`Private`transformedexpression, 
          xAct`xConf`Private`finalframe}, {xAct`xConf`Private`finalframe} = 
          OptionValue[{xAct`xConf`FinalFrame}]; 
         If[xAct`xConf`Private`finalframe === Automatic, 
           xAct`xConf`Private`finalframe = xAct`xConf`Private`metricbase; 
           Null]; With[{
           xAct`xConf`Private`firstmetric = First[xAct`xTensor`$Metrics]}, 
           xAct`xConf`Private`Tometricinitialexpression = ReplaceAll[
              xAct`xConf`ToMetric[xAct`xConf`Private`metricbase][
              xAct`xConf`Private`expr], PatternTest[
                Pattern[xAct`xConf`Private`tens, 
                 Blank[]], xAct`xConf`TensorNotMetricRelated][
                Pattern[xAct`xConf`Private`inds, 
                 BlankNullSequence[]]] :> 
              xAct`xConf`ConformalFrame[xAct`xConf`Private`firstmetric][
                xAct`xConf`Private`tens[xAct`xConf`Private`inds]]]; 
           xAct`xConf`Private`transformedexpression = 
            xAct`xConf`ConformalFrame[xAct`xConf`Private`metrictarget][
             xAct`xConf`Private`Tometricinitialexpression]; 
           xAct`xConf`ToMetric[xAct`xConf`Private`finalframe][
            xAct`xConf`Private`transformedexpression]]], 
       xAct`xConf`ConformalTransformation[
         PatternTest[
          Pattern[xAct`xConf`Private`metrictarget, 
           Blank[]], xAct`xTensor`MetricQ]][
         Pattern[xAct`xConf`Private`expr, 
          Blank[]]] :> xAct`xConf`ConformalTransformation[
         First[xAct`xTensor`$Metrics], xAct`xConf`Private`metrictarget][
        xAct`xConf`Private`expr]}], "DefaultValues" -> None, "NValues" -> 
    None, "FormatValues" -> None, 
    "Options" -> {xAct`xConf`FinalFrame -> Automatic}, "Attributes" -> {}, 
    "FullName" -> "xAct`xConf`ConformalTransformation"|>, False]]], "Output",
 CellLabel->
  "Out[36]=",ExpressionUUID->"5bd1c6fd-9343-43e2-a583-81ed408405a1"]
}, Open  ]],

Cell["\<\
It is an active transfromation of an expression going from frame metric1 to \
frame metric2. 
It uses ToMetric[metric1] to first express everything in terms of quantities \
in frame metric1, then it applies ConformalFrame[metric2] on the expression \
to actively change the expression.
The rules built by RulesChangeConformalFrame[metric1,metric2] then replace \
all metric related quantites by their value in frame metric2 (it is automatic).
Finally ToMetric[finalframe] is applied to the result. By default finalframe \
= metric1.
\
\>", "Text",
 CellTags->{
  "S5.18.1", "1.2"},ExpressionUUID->"9554d611-602d-4694-b06e-6630cde3879d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ConformalTransformation", "[", 
   RowBox[{"g", ",", "gS2"}], "]"}], "[", 
  RowBox[{
   RowBox[{"CD", "[", "\[Mu]", "]"}], "[", 
   RowBox[{"k", "[", "\[Nu]", "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[37]:=",ExpressionUUID->"e05e1e8b-b7be-499b-9ff7-24965e4f37f2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"ChristoffelCDCDgs2", "[", 
    RowBox[{"\[Alpha]", ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`ChristoffelCDCDgs2[$CellContext`\[Alpha], -$CellContext`\
\[Beta], -$CellContext`\[Gamma]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[37]:=",ExpressionUUID->"0dfa6e78-8792-4531-a334-93139d847c21"],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"\[Mu]", "\[Nu]"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[$CellContext`\[Mu], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       StyleBox["(",
        FontColor->RGBColor[1, 0, 0]], 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"g", 
             StyleBox[GridBox[{
                {"\[Alpha]", "\[Beta]"},
                {" ", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->9]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`g[$CellContext`\[Alpha], $CellContext`\[Beta]],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"k", 
             StyleBox[GridBox[{
                {" "},
                {"\[Alpha]"}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->9]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`k[-$CellContext`\[Alpha]],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          RowBox[{
           SubscriptBox["\[Del]", "\[Beta]"], "S"}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`CD[-$CellContext`\[Beta]][
          $CellContext`S[]],
         Editable->False]}], 
       StyleBox[")",
        FontColor->RGBColor[1, 0, 0]]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`Scalar[($CellContext`g[$CellContext`\[Alpha], $CellContext`\
\[Beta]] $CellContext`k[-$CellContext`\[Alpha]]) \
$CellContext`CD[-$CellContext`\[Beta]][
        $CellContext`S[]]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[],
     Editable->False], "5"]], "+", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"\[Mu]", "\[Beta]"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[$CellContext`\[Mu], $CellContext`\[Beta]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"\[Nu]", "\[Alpha]"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[$CellContext`\[Nu], $CellContext`\[Alpha]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Beta]"], GridBox[{
         {"k", 
          StyleBox[GridBox[{
             {" "},
             {"\[Alpha]"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->9]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Beta]][
      $CellContext`k[-$CellContext`\[Alpha]]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[],
     Editable->False], "4"]], "-", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"\[Mu]", "\[Beta]"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[$CellContext`\[Mu], $CellContext`\[Beta]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"\[Nu]", "\[Alpha]"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[$CellContext`\[Nu], $CellContext`\[Alpha]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"k", 
         StyleBox[GridBox[{
            {" "},
            {"\[Alpha]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`k[-$CellContext`\[Alpha]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Beta]"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Beta]][
      $CellContext`S[]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[],
     Editable->False], "5"]], "-", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"\[Mu]", "\[Alpha]"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[$CellContext`\[Mu], $CellContext`\[Alpha]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"\[Nu]", "\[Beta]"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[$CellContext`\[Nu], $CellContext`\[Beta]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"k", 
         StyleBox[GridBox[{
            {" "},
            {"\[Alpha]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`k[-$CellContext`\[Alpha]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Beta]"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Beta]][
      $CellContext`S[]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[],
     Editable->False], "5"]]}]], "Output",
 CellLabel->
  "Out[37]=",ExpressionUUID->"5d142590-03c4-46f9-9b2f-cbbf24aa887d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ConformalTransformation", "[", 
   RowBox[{"g", ",", "gS2"}], "]"}], "[", 
  RowBox[{"RicciCD", "[", 
   RowBox[{"\[Mu]", ",", "\[Nu]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[38]:=",ExpressionUUID->"50a805f2-a476-4871-9336-6723838fdafa"],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"\[Mu]", "\[Alpha]"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[$CellContext`\[Mu], $CellContext`\[Alpha]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"\[Nu]", "\[Beta]"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[$CellContext`\[Nu], $CellContext`\[Beta]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{"R", "[", "\[Del]", "]"}], 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Alpha]", "\[Beta]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`RicciCD[-$CellContext`\[Alpha], -$CellContext`\[Beta]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[],
     Editable->False], "4"]], "-", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"\[Mu]", "\[Nu]"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[$CellContext`\[Mu], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       StyleBox["(",
        FontColor->RGBColor[1, 0, 0]], 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"g", 
             StyleBox[GridBox[{
                {"\[Alpha]", "\[Beta]"},
                {" ", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->9]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`g[$CellContext`\[Alpha], $CellContext`\[Beta]],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          RowBox[{
           SubscriptBox["\[Del]", "\[Alpha]"], "S"}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`CD[-$CellContext`\[Alpha]][
          $CellContext`S[]],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          RowBox[{
           SubscriptBox["\[Del]", "\[Beta]"], "S"}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`CD[-$CellContext`\[Beta]][
          $CellContext`S[]],
         Editable->False]}], 
       StyleBox[")",
        FontColor->RGBColor[1, 0, 0]]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`Scalar[($CellContext`g[$CellContext`\[Alpha], $CellContext`\
\[Beta]] $CellContext`CD[-$CellContext`\[Alpha]][
         $CellContext`S[]]) $CellContext`CD[-$CellContext`\[Beta]][
        $CellContext`S[]]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[],
     Editable->False], "6"]], "-", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"\[Mu]", "\[Nu]"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[$CellContext`\[Mu], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       StyleBox["(",
        FontColor->RGBColor[1, 0, 0]], 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"g", 
             StyleBox[GridBox[{
                {"\[Alpha]", "\[Beta]"},
                {" ", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->9]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`g[$CellContext`\[Alpha], $CellContext`\[Beta]],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          RowBox[{
           SubscriptBox["\[Del]", "\[Beta]"], 
           SubscriptBox["\[Del]", "\[Alpha]"], "S"}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`CD[-$CellContext`\[Beta]][
          $CellContext`CD[-$CellContext`\[Alpha]][
           $CellContext`S[]]],
         Editable->False]}], 
       StyleBox[")",
        FontColor->RGBColor[1, 0, 0]]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`Scalar[$CellContext`g[$CellContext`\[Alpha], $CellContext`\
\[Beta]] $CellContext`CD[-$CellContext`\[Beta]][
        $CellContext`CD[-$CellContext`\[Alpha]][
         $CellContext`S[]]]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[],
     Editable->False], "5"]], "+", 
  FractionBox[
   RowBox[{"4", " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"\[Mu]", "\[Alpha]"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[$CellContext`\[Mu], $CellContext`\[Alpha]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"\[Nu]", "\[Beta]"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[$CellContext`\[Nu], $CellContext`\[Beta]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Alpha]"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Alpha]][
      $CellContext`S[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Beta]"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Beta]][
      $CellContext`S[]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[],
     Editable->False], "6"]], "-", 
  FractionBox[
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"\[Mu]", "\[Alpha]"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[$CellContext`\[Mu], $CellContext`\[Alpha]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"\[Nu]", "\[Beta]"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->9]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[$CellContext`\[Nu], $CellContext`\[Beta]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Beta]"], 
       SubscriptBox["\[Del]", "\[Alpha]"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Beta]][
      $CellContext`CD[-$CellContext`\[Alpha]][
       $CellContext`S[]]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[],
     Editable->False], "5"]]}]], "Output",
 CellLabel->
  "Out[38]=",ExpressionUUID->"f8aa5f8c-723c-42ee-b2c8-cbbde91eeccd"]
}, Open  ]],

Cell["\<\
The result is then expressed by default in the frame metric1, but this can be \
modified by the option FinalFrame->metricfinal.
If the metricfinal=metric2, then formally we have replaced all expressions in \
metric1 by their counterpart in the frame metric2 and the transformation is \
trivial\
\>", "Text",
 CellTags->{
  "S5.18.1", "1.2"},ExpressionUUID->"af13ec27-c70e-45c9-8508-3ebea0a7bb4c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ConformalTransformation", "[", 
   RowBox[{"g", ",", "gS2", ",", 
    RowBox[{"FinalFrame", "->", "gS2"}]}], "]"}], "[", 
  RowBox[{
   RowBox[{"CD", "[", "\[Mu]", "]"}], "[", 
   RowBox[{"k", "[", "\[Nu]", "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[39]:=",ExpressionUUID->"42a2df55-10ea-4369-a8cf-c6da1e76ff80"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"igS2", 
       StyleBox[GridBox[{
          {"\[Mu]", "\[Beta]"},
          {" ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->9]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`InvgS2[$CellContext`\[Mu], $CellContext`\[Beta]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"igS2", 
       StyleBox[GridBox[{
          {"\[Nu]", "\[Alpha]"},
          {" ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->9]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`InvgS2[$CellContext`\[Nu], $CellContext`\[Alpha]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[
    RowBox[{
     SubscriptBox[
      RowBox[{"\[Del]", "gS2"}], "\[Beta]"], 
     StyleBox["[",
      FontColor->RGBColor[1, 0, 0]], 
     InterpretationBox[
      StyleBox[GridBox[{
         {"k", 
          StyleBox[GridBox[{
             {" "},
             {"\[Alpha]"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->9]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`k[-$CellContext`\[Alpha]],
      Editable->False], 
     StyleBox["]",
      FontColor->RGBColor[1, 0, 0]]}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`CDgS2[-$CellContext`\[Beta]][
    xAct`xConf`ConformalFrame[$CellContext`gS2][
     $CellContext`k[-$CellContext`\[Alpha]]]],
   Editable->False]}]], "Output",
 CellLabel->
  "Out[39]=",ExpressionUUID->"0cd66d96-48ab-421a-9b73-c0c349d6508a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ConformalTransformation", "[", 
   RowBox[{"g", ",", "gS2", ",", 
    RowBox[{"FinalFrame", "->", "gS2"}]}], "]"}], "[", 
  RowBox[{"RicciCD", "[", 
   RowBox[{"\[Mu]", ",", "\[Nu]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[40]:=",ExpressionUUID->"f27e21a2-f475-47ad-8483-550cf951ec59"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"igS2", 
       StyleBox[GridBox[{
          {"\[Mu]", "\[Alpha]"},
          {" ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->9]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`InvgS2[$CellContext`\[Mu], $CellContext`\[Alpha]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"igS2", 
       StyleBox[GridBox[{
          {"\[Nu]", "\[Beta]"},
          {" ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->9]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`InvgS2[$CellContext`\[Nu], $CellContext`\[Beta]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {
       RowBox[{"R", "[", 
        RowBox[{"\[Del]", "gS2"}], "]"}], 
       StyleBox[GridBox[{
          {" ", " "},
          {"\[Alpha]", "\[Beta]"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->9]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`RicciCDgS2[-$CellContext`\[Alpha], -$CellContext`\[Beta]],
   Editable->False]}]], "Output",
 CellLabel->
  "Out[40]=",ExpressionUUID->"c096f44d-2102-448c-a2ea-45fac107f465"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Simple examples", \
"Subsection",ExpressionUUID->"2e2c9b77-f739-48f7-9b9b-39d482b16b42"],

Cell["We can check that the Weyl tensor is invariant.", "Text",
 CellTags->{
  "S5.18.1", "1.2"},ExpressionUUID->"0277738a-f96b-44b1-bf23-5914ac884362"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ConformalTransformation", "[", 
   RowBox[{"g", ",", "gS2"}], "]"}], "[", 
  RowBox[{"WeylCD", "[", 
   RowBox[{
    RowBox[{"-", "\[Mu]"}], ",", 
    RowBox[{"-", "\[Nu]"}], ",", 
    RowBox[{"-", "\[Alpha]"}], ",", "\[Beta]"}], "]"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"%", "//", "RiemannToWeyl"}], "//", "ContractMetric"}], "//", 
  "ToCanonical"}]}], "Input",
 CellLabel->"In[41]:=",ExpressionUUID->"95bb011f-6210-46df-a8c6-c4d67d120938"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", "2"]}], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Delta]", 
        StyleBox[GridBox[{
           {"\[Beta]", " "},
           {" ", "\[Nu]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`delta[$CellContext`\[Beta], -$CellContext`\[Nu]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"R", "[", "\[Del]", "]"}], 
        StyleBox[GridBox[{
           {" ", " "},
           {"\[Alpha]", "\[Mu]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`RicciCD[-$CellContext`\[Alpha], -$CellContext`\[Mu]],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Delta]", 
        StyleBox[GridBox[{
           {"\[Beta]", " "},
           {" ", "\[Mu]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`delta[$CellContext`\[Beta], -$CellContext`\[Mu]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"R", "[", "\[Del]", "]"}], 
        StyleBox[GridBox[{
           {" ", " "},
           {"\[Alpha]", "\[Nu]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`RicciCD[-$CellContext`\[Alpha], -$CellContext`\[Nu]],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {" ", " "},
           {"\[Alpha]", "\[Nu]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`g[-$CellContext`\[Alpha], -$CellContext`\[Nu]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {"\[Beta]", "\[Gamma]"},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`g[$CellContext`\[Beta], $CellContext`\[Gamma]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"R", "[", "\[Del]", "]"}], 
        StyleBox[GridBox[{
           {" ", " "},
           {"\[Mu]", "\[Gamma]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`RicciCD[-$CellContext`\[Mu], -$CellContext`\[Gamma]],
    Editable->False]}], "-", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {" ", " "},
           {"\[Alpha]", "\[Mu]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`g[-$CellContext`\[Alpha], -$CellContext`\[Mu]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {"\[Beta]", "\[Gamma]"},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`g[$CellContext`\[Beta], $CellContext`\[Gamma]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"R", "[", "\[Del]", "]"}], 
        StyleBox[GridBox[{
           {" ", " "},
           {"\[Nu]", "\[Gamma]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`RicciCD[-$CellContext`\[Nu], -$CellContext`\[Gamma]],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "6"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Delta]", 
        StyleBox[GridBox[{
           {"\[Beta]", " "},
           {" ", "\[Nu]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`delta[$CellContext`\[Beta], -$CellContext`\[Nu]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {" ", " "},
           {"\[Alpha]", "\[Mu]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`g[-$CellContext`\[Alpha], -$CellContext`\[Mu]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"R", "[", "\[Del]", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`RicciScalarCD[],
    Editable->False]}], "-", 
  RowBox[{
   FractionBox["1", "6"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Delta]", 
        StyleBox[GridBox[{
           {"\[Beta]", " "},
           {" ", "\[Mu]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTensor`delta[$CellContext`\[Beta], -$CellContext`\[Mu]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {" ", " "},
           {"\[Alpha]", "\[Nu]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`g[-$CellContext`\[Alpha], -$CellContext`\[Nu]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"R", "[", "\[Del]", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`RicciScalarCD[],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {"\[Beta]", "\[Gamma]"},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`g[$CellContext`\[Beta], $CellContext`\[Gamma]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {" ", " "},
           {"\[Nu]", "\[Lambda]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`g[-$CellContext`\[Nu], -$CellContext`\[Lambda]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"R", "[", "\[Del]", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", "\[Lambda]"},
           {"\[Alpha]", "\[Gamma]", "\[Mu]", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->9]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`RiemannCD[-$CellContext`\[Alpha], -$CellContext`\[Gamma], \
-$CellContext`\[Mu], $CellContext`\[Lambda]],
    Editable->False]}]}]], "Output",
 CellLabel->"Out[41]=",ExpressionUUID->"fbd6fe27-a4d3-44c2-a89f-355fd64f2d0e"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      RowBox[{"W", "[", "\[Del]", "]"}], 
      StyleBox[GridBox[{
         {" ", "\[Beta]", " ", " "},
         {"\[Alpha]", " ", "\[Mu]", "\[Nu]"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "Rows" -> {{
             Offset[0.]}}}],
       FontSize->9]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`WeylCD[-$CellContext`\[Alpha], $CellContext`\[Beta], \
-$CellContext`\[Mu], -$CellContext`\[Nu]],
  Editable->False]], "Output",
 CellLabel->
  "Out[42]=",ExpressionUUID->"3c743649-aa4f-4896-ae9c-63ec7c209928"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Summary of public functions and variables", \
"Section",ExpressionUUID->"6b8fee3b-a7db-48f4-8572-e62a33eee839"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  RowBox[{"xAct`xConf`", "*"}]}]], "Input",
 CellLabel->"In[43]:=",ExpressionUUID->"56704adc-f89f-4587-abbf-a2bd7ed426cf"],

Cell[BoxData[
 StyleBox[
  FrameBox[GridBox[{
     {
      DynamicModuleBox[{Typeset`open$$ = True}, 
       PaneSelectorBox[{False->
        ButtonBox[
         RowBox[{
          
          DynamicBox[FEPrivate`FrontEndResource[
           "FEBitmaps", "RightPointerOpener"]], " ", 
          StyleBox["xAct`xConf`", "InformationGridGroupHeader"]}],
         Appearance->None,
         BaseStyle->"InformationGridLink",
         ButtonFunction:>FEPrivate`Set[Typeset`open$$, True],
         Evaluator->Automatic,
         Method->"Preemptive"], True->
        PaneBox[GridBox[{
           {
            ButtonBox[
             RowBox[{
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"],
               ImageSizeCache->{10., {3., 7.}}], " ", 
              StyleBox["xAct`xConf`", "InformationGridGroupHeader"]}],
             Appearance->None,
             BaseStyle->"InformationGridLink",
             ButtonFunction:>FEPrivate`Set[Typeset`open$$, False],
             Evaluator->Automatic,
             Method->"Preemptive"]},
           {
            PaneBox[GridBox[{
               {
                ButtonBox[
                 StyleBox["ConformalFrame", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-a476a0bd-c993-4931-b782-1c0e598fbeda", {
                   "ConformalFrame", "xAct`xConf`"}, False},
                 ButtonNote->"xAct`xConf`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["DefConformalMetric", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-a476a0bd-c993-4931-b782-1c0e598fbeda", {
                   "DefConformalMetric", "xAct`xConf`"}, False},
                 ButtonNote->"xAct`xConf`",
                 Evaluator->Automatic], 
                ButtonBox[
                 
                 StyleBox["RulesChangeConformalFrame", 
                  "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-a476a0bd-c993-4931-b782-1c0e598fbeda", {
                   "RulesChangeConformalFrame", "xAct`xConf`"}, False},
                 ButtonNote->"xAct`xConf`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["$Debug", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-a476a0bd-c993-4931-b782-1c0e598fbeda", {
                   "$Debug", "xAct`xConf`"}, False},
                 ButtonNote->"xAct`xConf`",
                 Evaluator->Automatic]},
               {
                ButtonBox[
                 StyleBox["ConformalMetricName", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 ButtonData:>{
                  "Info-a476a0bd-c993-4931-b782-1c0e598fbeda", {
                   "ConformalMetricName", "xAct`xConf`"}, False},
                 ButtonNote->"xAct`xConf`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["Disclaimer", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-a476a0bd-c993-4931-b782-1c0e598fbeda", {
                   "Disclaimer", "xAct`xConf`"}, False},
                 ButtonNote->"xAct`xConf`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["SqrtConformalFactor", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-a476a0bd-c993-4931-b782-1c0e598fbeda", {
                   "SqrtConformalFactor", "xAct`xConf`"}, False},
                 ButtonNote->"xAct`xConf`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["$FormatConformal", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-a476a0bd-c993-4931-b782-1c0e598fbeda", {
                   "$FormatConformal", "xAct`xConf`"}, False},
                 ButtonNote->"xAct`xConf`",
                 Evaluator->Automatic]},
               {
                ButtonBox[
                 StyleBox["ConformalTransformation", "InformationGridButton"],
                 
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-a476a0bd-c993-4931-b782-1c0e598fbeda", {
                   "ConformalTransformation", "xAct`xConf`"}, False},
                 ButtonNote->"xAct`xConf`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["FinalFrame", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-a476a0bd-c993-4931-b782-1c0e598fbeda", {
                   "FinalFrame", "xAct`xConf`"}, False},
                 ButtonNote->"xAct`xConf`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["TensorNotMetricRelated", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-a476a0bd-c993-4931-b782-1c0e598fbeda", {
                   "TensorNotMetricRelated", "xAct`xConf`"}, False},
                 ButtonNote->"xAct`xConf`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["$Version", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-a476a0bd-c993-4931-b782-1c0e598fbeda", {
                   "$Version", "xAct`xConf`"}, False},
                 ButtonNote->"xAct`xConf`",
                 Evaluator->Automatic]},
               {
                ButtonBox[
                 StyleBox["ConformalWeight", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-a476a0bd-c993-4931-b782-1c0e598fbeda", {
                   "ConformalWeight", "xAct`xConf`"}, False},
                 ButtonNote->"xAct`xConf`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["FrameColor", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-a476a0bd-c993-4931-b782-1c0e598fbeda", {
                   "FrameColor", "xAct`xConf`"}, False},
                 ButtonNote->"xAct`xConf`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["ToMetric", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-a476a0bd-c993-4931-b782-1c0e598fbeda", {
                   "ToMetric", "xAct`xConf`"}, False},
                 ButtonNote->"xAct`xConf`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["$xTensorVersionExpected", "InformationGridButton"],
                 
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-a476a0bd-c993-4931-b782-1c0e598fbeda", {
                   "$xTensorVersionExpected", "xAct`xConf`"}, False},
                 ButtonNote->"xAct`xConf`",
                 Evaluator->Automatic]}
              },
              DefaultBaseStyle->"Text",
              
              GridBoxAlignment->{
               "Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
              GridBoxItemSize->{"Columns" -> {{
                   Scaled[0.2375]}}}],
             ImageMargins->{{10, 0}, {0, 2}}]}
          },
          GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}}],
         FrameMargins->{{0, 0}, {8, 0}}]}, Dynamic[Typeset`open$$],
        ImageSize->Automatic]]}
    },
    GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
    GridBoxDividers->{"ColumnsIndexed" -> {{False}}, "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.5599999999999999]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.8]}, 
        Offset[0.2]}}],
   BaseStyle->"InformationTitleFrame"], "InformationGridPlain"]], "Output",
 CellLabel->
  "Out[43]=",ExpressionUUID->"c194d58e-5359-49cf-a4ac-e901962e9b00"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
AutoGeneratedPackage->Automatic,
ScreenStyleEnvironment->"Brackets",
WindowSize->{1399.5, 782.25},
WindowMargins->{{Automatic, -3000.75}, {Automatic, 40.5}},
DockedCells->{
  Cell[
   BoxData[
    TemplateBox[{
      ButtonBox[
      "\"\[Dagger]\"", ButtonFunction :> Exit[], Appearance -> Automatic, 
       Evaluator -> Automatic, Method -> "Preemptive"], 
      ButtonBox[
      "\"\[RightTriangle]\"", ButtonFunction :> FrontEnd`FrontEndExecute[
         FrontEnd`FrontEndToken["EvaluatorStart"]], Evaluator -> None, 
       Appearance -> Automatic, Method -> "Preemptive"], 
      ButtonBox[
      "\"\[RightTriangle]\[RightTriangle]\"", ButtonFunction :> 
       FrontEnd`FrontEndExecute[
         FrontEnd`FrontEndToken["EvaluateNotebook"]], Evaluator -> None, 
       Appearance -> Automatic, Method -> "Preemptive"], 
      ButtonBox["\"EvalInit\"", ButtonFunction :> FrontEnd`FrontEndExecute[
         FrontEnd`FrontEndToken["EvaluateInitialization"]], Evaluator -> None,
        Appearance -> Automatic, Method -> "Preemptive"], 
      ButtonBox[
      "\"Init\"", 
       ButtonFunction :> (Module[{Utility`Toolbar`cell = NotebookSelection[
             SelectedNotebook[]], Utility`Toolbar`isInit}, 
          Utility`Toolbar`isInit = ReplaceAll[InitializationCell, 
             Options[Utility`Toolbar`cell, InitializationCell]]; If[
            TrueQ[
             Or[
             Utility`Toolbar`isInit == True, Utility`Toolbar`isInit == On]], 
            SetOptions[Utility`Toolbar`cell, InitializationCell -> False], 
            SetOptions[Utility`Toolbar`cell, InitializationCell -> True]]]; 
        Null), Appearance -> Automatic, Evaluator -> Automatic, Method -> 
       "Preemptive"], 
      ButtonBox["\"DeInit\"", ButtonFunction :> SetOptions[
         NotebookSelection[
          SelectedNotebook[]], InitializationCell -> False], Appearance -> 
       Automatic, Evaluator -> Automatic, Method -> "Preemptive"], 
      ButtonBox["\"\[DeleteKey]\"", ButtonFunction :> FrontEnd`FrontEndExecute[
         FrontEnd`FrontEndToken["DeleteGeneratedCells"]], Evaluator -> None, 
       Appearance -> Automatic, Method -> "Preemptive"]}, "Row", 
     DisplayFunction -> (
      RowBox[{#, "\[InvisibleSpace]", #2, "\[InvisibleSpace]", #3, 
        "\[InvisibleSpace]", #4, "\[InvisibleSpace]", #5, 
        "\[InvisibleSpace]", #6, "\[InvisibleSpace]", #7}]& ), 
     InterpretationFunction -> (RowBox[{"Row", "[", 
        RowBox[{"{", 
          RowBox[{#, ",", #2, ",", #3, ",", #4, ",", #5, ",", #6, ",", #7}], 
          "}"}], "]"}]& )]], "DockedCell"]},
PrintingCopies->1,
PrintingPageRange->{1, Automatic},
PrivateNotebookOptions->{"FileOutlineCache"->False},
ShowSelection->True,
CellLabelAutoDelete->False,
TrackCellChangeTimes->False,
FrontEndVersion->"13.3 for Linux x86 (64-bit) (July 24, 2023)",
StyleDefinitions->"HelpBrowser.nb",
ExpressionUUID->"db8d1d72-d760-468a-a3c6-523ea19eb394"
]

